//Wave water from alt_ext
//https://www.shadertoy.com/view/4dBcRD

#if defined GBUFFERS_TRANSLUCENT || defined GBUFFERS_SHADOW
    float waves(waves_settings ws, vec3 position, const int steps){      
        float t = frameTimeCounter * ws.speed;

        vec2 p = position.xz * ws.scale;

        float h = 0.0;
        float g = 0.0;

        float w0 = 0.0;
        float w1 = 1.0;

        for (int i = 0; i < steps; ++i){
            vec2 d = sincos(g);

            float x = ws.phase * dot(d, p) - t;
            float w = exp2(sin(x) - 1.0);
            float u = w * cos(x);

            h += u * w1;
            p += normalize(d) * w1 * -u * 0.02;

            w0 += w1;
            w1 = mix(w1, 0.0, 0.24);

            g += 12.0;

            ws.phase *= 1.18;
            ws.speed *= 1.07;
        }
        
        return h / w0;
    }

    #if defined GBUFFERS_TRANSLUCENT
        vec3 wave_parallax(waves_settings ws, vec3 position, vec3 tangent_vector, float depth, const int steps){
            float wave = waves(ws, position, steps) * depth - depth;

            vec3 step_size = vec3(ws.parallax_height, ws.parallax_height, 1.1);
            vec3 sample_increment = inversesqrt(ws.steps2) * (tangent_vector * step_size) / -tangent_vector.z;
            vec3 sample_position = -wave * sample_increment;

            wave = waves(ws, position + vec3(sample_position.x, 0.0, sample_position.y), steps) * depth - depth; 

            for(int i = 0; i < ws.steps2 && wave < sample_position.z; i++){
                sample_position += (sample_position.z - wave) * sample_increment;
                wave = waves(ws, position + vec3(sample_position.x, 0.0, sample_position.y), steps) * depth - depth; 
            }
            
            return position + vec3(sample_position.x, 0.0, sample_position.y);
        }
    #endif
    
    vec3 water_normal(vec3 position0, vec3 position1, inout float roughness){
        waves_settings ws = swaves();

        #if defined GBUFFERS_TRANSLUCENT
            vec3 tangent_vector = tbn * (position0 + gbufferModelViewInverse[3].xyz);
                 tangent_vector = normalize(tangent_vector);

            #ifdef PARALLAX_WATER
                position1 = wave_parallax(ws, position1, -tangent_vector, ws.mult, ws.steps1);
            #endif
        #endif

        float dist = 1.0 - 1.0 / (length(position1) * (1.0 - 0.021));

        roughness = dist;

        float normal0 = waves(ws, position1, ws.steps0) * ws.mult;
        float normal1 = waves(ws, position1 + vec3(ws.delta, 0.0, 0.0), ws.steps0) * ws.mult;
        float normal2 = waves(ws, position1 + vec3(0.0, 0.0, ws.delta), ws.steps0) * ws.mult;

        vec3 n;
             n.x = (normal0 - normal1) / ws.delta;
             n.y = (normal0 - normal2) / ws.delta;
             n.z = dist; 

        return normalize(n);
        //return vec3(0.0, 0.0, 1.0);
    }
#endif