#if defined GBUFFERS_TERRAIN
    vec2 wrap_coord(vec2 coord, vec2 size, vec2 position){
        return round((position - coord) / size) * size + coord;
    }

    float normal_depth(vec2 coord, vec2 mid_coord, vec2 size, mat2 tex_grad, float depth){
        return texture_grad(normals, wrap_coord(coord, size, mid_coord), tex_grad[0], tex_grad[1]).w * depth - depth;
    }

    vec2 parallax_occlusion_mapping(vec2 coord, vec2 mid_coord, vec3 position, vec3 view_position, mat3 tbn, mat2 tex_grad){
        int steps = 64;

        vec2 resolution = textureSize2D(tex, 0);
        vec2 size = vertex_pom;

        float dist = 1.0 - distance(position.xy, position.xy);
        float depth = length(size) * (0.1 + PARALLAX_DEPTH);
        float sum = 1.0;

        tbn[0] *= resolution.y / resolution.x;

        vec3 tangent_vector = normalize(view_position);

        if(dist > 0.0){
            #ifdef PARALLAX
            vec3 ray_increment = inversesqrt(steps) * tangent_vector * dist / -tangent_vector.z;
            vec3 ray_position = vec3(coord, 0.0);

            float height = normal_depth(ray_position.xy, mid_coord, size, tex_grad, depth); 

            for(int i = 0; i < steps && height < ray_position.z; i++){
                ray_position += (ray_position.z - height) * ray_increment;
                height = normal_depth(ray_position.xy, mid_coord, size, tex_grad, depth);
                sum = 0.0;
                
                //if(height == 0.0) break;
            }

            coord = wrap_coord(ray_position.xy, size, mid_coord);

            vec3 view_space = screen_to_viewspace(gl_FragCoord.xyz) + sum * ray_position * inverse(tbn);
            vec3 screen_space = proj_mad(gbufferProjection, view_space) / -view_space.z * 0.5 + 0.5;
            
            //gl_FragDepth = screen_space.z;
            #endif
        }

        return coord;
    }
#endif