//huge thanks to niemand for helping me with depth aware blur
uniform float far, near;

float GetLinearDepth(float depth) {
   return (2.0 * near) / (far + near - depth * (far - near));
}

vec2 direction(bool pass){
    if (pass) return vec2(0.0, 1.0);
    else return vec2(1.0, 0.0);
}

vec2 vogelOffsets[128] = vec2[128](
   vec2(0.0663717288408725, -0.0013834293391071473),
   vec2(-0.07595079370610941, 0.07174054001593103),
   vec2(0.01608984530645411, -0.1406025646260119),
   vec2(0.10448284847446448, 0.12984595992288336),
   vec2(-0.18076204965577036, -0.03404254503522808),
   vec2(0.1787729618263991, -0.11264127715283463),
   vec2(-0.054629310699971526, 0.2162375217952921),
   vec2(-0.10769609808818306, -0.21620049103190728),
   vec2(0.24592928641190032, 0.08701560245846723),
   vec2(-0.24794882541635205, 0.10256443477355368),
   vec2(0.12526587604780554, -0.26079567080797356),
   vec2(0.09357891581109577, 0.284617218572553),
   vec2(-0.26650677420701185, -0.15807329847424045),
   vec2(0.3210564905494301, -0.07111560942753943),
   vec2(-0.18970119374354508, 0.27395413373961097),
   vec2(-0.04084809859072364, -0.3464832511798149),
   vec2(0.27840760740397325, 0.22999569975767717),
   vec2(-0.3655675068138925, 0.013894042926387594),
   vec2(0.27334929144700043, -0.2695495965784895),
   vec2(-0.014157364124171045, 0.38851232827676874),
   vec2(-0.25253703711299613, -0.3086468256980197),
   vec2(0.4100515255479846, 0.053267487825832176),
   vec2(-0.3402835914128429, 0.2380708784965685),
   vec2(0.09791475751438991, -0.41941412050652843),
   vec2(0.22138836163818915, 0.3782120981062479),
   vec2(-0.4213524763303703, -0.13704154865558862),
   vec2(0.4169229294039292, -0.1922235606360057),
   vec2(-0.1750723720198253, 0.42619435161677505),
   vec2(-0.15583193830129546, -0.44540030818645854),
   vec2(0.42882604653886824, 0.2219606502104319),
   vec2(-0.46814559427413643, 0.12303882220514525),
   vec2(0.2721696329659735, -0.41864831480405745),
   vec2(0.08921887628752824, 0.4952271972313669),
   vec2(-0.4005988709418946, -0.3146281961132203),
   vec2(0.5212631254064987, -0.04424824894529297),
   vec2(-0.35375478872674765, 0.3852003570933512),
   vec2(0.006476729988070731, -0.5353773094248466),
   vec2(0.36754024321057777, 0.3995080293577968),
   vec2(-0.542223207878615, -0.0519953853311339),
   vec2(0.44637017778921256, -0.33722397584639424),
   vec2(-0.09680653666400772, 0.5520333546988624),
   vec2(-0.29939501415200226, -0.4833046185334542),
   vec2(0.5596011843818348, 0.1509189745951235),
   vec2(-0.5147808571281486, 0.26478051462710167),
   vec2(0.20883488566029573, -0.5542363522278412),
   vec2(0.22866908434076613, 0.5508256786627931),
   vec2(-0.5407871145385125, -0.2595074195620819),
   vec2(0.5860067920083645, -0.18086189108585835),
   vec2(-0.30736593848152494, 0.5296884720449828),
   vec2(-0.1266907583446624, -0.6093901619826914),
   vec2(0.5159424480728841, 0.3623676235874931),
   vec2(-0.6255645775356298, 0.07706200529609625),
   vec2(0.41898177852462715, -0.4890717485057145),
   vec2(0.027432455831161814, 0.6446921406553703),
   vec2(-0.45414039483729524, -0.46614804133513105),
   vec2(0.6614910274222918, 0.032241087509198955),
   vec2(-0.5083020565411538, 0.42180005754033856),
   vec2(0.0964852676297621, -0.6651917468773848),
   vec2(0.3872684835471157, 0.5554272911761508),
   vec2(-0.6605604664806174, -0.15426772487094212),
   vec2(0.6020393414453297, -0.34028128597305507),
   vec2(-0.21002234293038552, 0.6579481079477967),
   vec2(-0.2861107074822046, -0.6371439476352124),
   vec2(0.6522715831040163, 0.2737008831753178),
   vec2(-0.6652622751135028, 0.2356101038047024),
   vec2(0.3397573613737368, -0.6329684132153847),
   vec2(0.1841905597170904, 0.6964821517232016),
   vec2(-0.6050183182298694, -0.39710638871623194),
   vec2(0.7254416154649453, -0.12177092336287425),
   vec2(-0.45014903629822983, 0.5789904973861583),
   vec2(-0.053794887255024446, -0.7412859981872281),
   vec2(0.5500229885821982, 0.5088249119127415),
   vec2(-0.7486921122201893, -0.008726121449014926),
   vec2(0.5675967989341455, -0.5077753678100256),
   vec2(-0.07023781394610165, 0.7579182403995453),
   vec2(-0.45744839298930007, -0.6154090763560658),
   vec2(0.7637862945741366, 0.14069437605788096),
   vec2(-0.656713477836827, 0.4098293315506553),
   vec2(0.21454262641179686, -0.7556373805496136),
   vec2(0.36026937695710076, 0.7015208788118822),
   vec2(-0.7383543496199366, -0.28068022211104154),
   vec2(0.7443854632051411, -0.29863443306808585),
   vec2(-0.34348147387975525, 0.7224100512613486),
   vec2(-0.23032288796555528, -0.7743624920949431),
   vec2(0.7028476670342306, 0.4128494614683644),
   vec2(-0.7960332370050228, 0.16630913345088935),
   vec2(0.48320080015941314, -0.6692343793188953),
   vec2(0.10211925170659499, 0.8195557731909884),
   vec2(-0.6266819713189401, -0.5434242776289469),
   vec2(0.839647992213555, -0.027780163659783332),
   vec2(-0.5979069183510588, 0.5858930896737415),
   vec2(0.051164124496432734, -0.8455440653042995),
   vec2(0.5421395668481722, 0.656586163094272),
   vec2(-0.8420179306636936, -0.12361040648919945),
   vec2(0.7139345127041803, -0.4852140742679803),
   vec2(-0.19392185846495172, 0.8394325117685132),
   vec2(-0.4204487200571126, -0.7589178553865392),
   vec2(0.8327210388300782, 0.27198001249322223),
   vec2(-0.7960210362439597, 0.35875934008010707),
   vec2(0.3521694740750743, -0.8113417187989848),
   vec2(0.2956218966152538, 0.8352993597773058),
   vec2(-0.7802993418734316, -0.4233366042943169),
   vec2(0.8713623792816834, -0.22102227243790618),
   vec2(-0.4898157243847507, 0.7501925472112333),
   vec2(-0.1404730904953662, -0.8933311986231547),
   vec2(0.7161931362879647, 0.5614815300362244),
   vec2(-0.9058628529093994, 0.06505632357778653),
   vec2(0.6327340635903044, -0.6679986961411009),
   vec2(-0.009601876744475782, 0.9192004679524599),
   vec2(-0.6108521377052276, -0.6924574614793783),
   vec2(0.9281555629938579, 0.09338283007560376),
   vec2(-0.7450460329935666, 0.555586889447176),
   vec2(0.18065981280216364, -0.9220637339884982),
   vec2(0.4976041523666884, 0.8004563576254236),
   vec2(-0.9058072969449353, -0.26025660300795816),
   vec2(0.8531917506909307, -0.4268234961929668),
   vec2(-0.33647364470405444, 0.8898636052739477),
   vec2(-0.3487004193922513, -0.8922603177419213),
   vec2(0.8692854206244577, 0.4191405201257309),
   vec2(-0.922200158608347, 0.27426963027794127),
   vec2(0.5026010788472942, -0.8336545903450451),
   vec2(0.19912047190109702, 0.953130414632473),
   vec2(-0.7881026276127884, -0.575672440830542),
   vec2(0.9797345166178452, -0.1133457865497118),
   vec2(-0.6426714284056454, 0.743356925293099),
   vec2(-0.022557857722768027, -0.9912168632834627),
   vec2(0.6947190005470241, 0.7134671125059463),
   vec2(-0.992326501717018, -0.062069798758671524)
);

uniform sampler2D colortex10;

vec3 NormalAwareBlur(sampler2D colortex) {
    vec3 blur = vec3(0.0);
    vec3 albedo = texture2D(colortex10, texCoord).rgb;
    vec3 normal = normalize(DecodeNormal(texture2D(colortex6, texCoord).xy));
    vec2 pixelSize = 1.0 / vec2(viewWidth, viewHeight);

	float centerDepth = texture2D(depthtex0, texCoord.xy).x;
	float centerDepthLinear = GetLinearDepth(centerDepth);

    float luminanceFactor = 1.0 - float(length(albedo) > 0.75);
    float totalWeight = 0.0;

    for(int i = 0; i < DENOISE_QUALITY; i++){
        float weight = 1.0;
        vec2 offset = vogelOffsets[i] * pixelSize * DENOISE_STRENGTH * luminanceFactor * float(centerDepth > 0.56);

		vec3 currentNormal = normalize(DecodeNormal(texture2D(colortex6, texCoord + offset).xy));

        float currentDepth = texture2D(depthtex0, texCoord.xy + offset).x;
        float currentDepthLinear = GetLinearDepth(currentDepth);

        float depthDifference = exp2(1.0 - abs(currentDepthLinear - centerDepthLinear));
        float normalDifference = dot(normal, currentNormal);

        weight *= pow(clamp(depthDifference * normalDifference, 0.001, 1.0), 32.0);

        blur += weight * texture2D(colortex, texCoord + offset).rgb;
        totalWeight += weight;
    }
    
    return blur / totalWeight;
}