#version 330 compatibility

out vec4 color;
out vec4 texcoord;
out vec4 vertexPos;

out vec3 normal;
out vec2 blockLight;
out float materialIDs;

out vec3 viewPos;

attribute vec4 mc_Entity;








#include "Uniforms.inc"
#include "Common.inc"


void main() {



	texcoord = gl_MultiTexCoord0;

	vec4 lmcoord = gl_TextureMatrix[1] * gl_MultiTexCoord1;


	blockLight.x = clamp((lmcoord.x * 33.05f / 32.0f) - 1.05f / 32.0f, 0.0f, 1.0f);
	blockLight.y = clamp((lmcoord.y * 33.75f / 32.0f) - 1.05f / 32.0f, 0.0f, 1.0f);



	vec4 viewpos = gbufferModelViewInverse * gl_ModelViewMatrix * gl_Vertex;
	vec4 position = viewpos;



	materialIDs = 5;

	
	//Entity checker
	// if (mc_Entity.x == 1920.0f)
	// {
	// 	texcoord.st = vec2(0.2f);
	// }


	vec4 locposition = gl_ModelViewMatrix * gl_Vertex;

	viewPos = locposition.xyz;
	


	gl_Position = gbufferModelView * position;

	//Temporal jitter

	color = gl_Color;


	//color.rgb *= float(mod(entityId, 8)) / 8.0;

	// float colorDiff = abs(color.r - color.g);
	// 	  colorDiff += abs(color.r - color.b);
	// 	  colorDiff += abs(color.g - color.b);

	// if (colorDiff < 0.001f && mc_Entity.x != -1.0f && mc_Entity.x != 63 && mc_Entity.x != 68 && mc_Entity.x != 323) {

	// 	float lum = color.r + color.g + color.b;
	// 		  lum /= 3.0f;

	// 	if (lum < 0.92f) {
	// 		color.rgb = vec3(1.0f);
	// 	}

	// }	
	
	gl_FogFragCoord = gl_Position.z;


	
	
	normal = normalize(gl_NormalMatrix * gl_Normal);

	vertexPos = gl_Vertex;	



	gl_Position = gl_ProjectionMatrix * gl_Position;
	gl_Position.xyz /= gl_Position.w;
	TemporalJitterProjPos(gl_Position);
	gl_Position.xyz *= gl_Position.w;
}


