#version 330 compatibility

/*
 _______ _________ _______  _______  _ 
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _ 
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/



////////////////////////////////////////////////////ADJUSTABLE VARIABLES/////////////////////////////////////////////////////////

#define TEXTURE_RESOLUTION 128 // Resolution of current resource pack. This needs to be set properly for POM! [16 32 64 128 256 512]

//#define PARALLAX // 3D effect for resource packs with heightmaps. Make sure Texture Resolution is set properly!

#define PARALLAX_SHADOW // Self-shadowing for parallax occlusion mapping. 

#define FORCE_WET_EFFECT // Make all surfaces get wet during rain regardless of specular texture values

#define RAIN_SPLASH_EFFECT // Rain ripples/splashes on water and wet blocks.

//#define RAIN_SPLASH_BILATERAL // Bilateral filter for rain splash/ripples. When enabled, ripple texture is smoothed (no hard pixel edges) at the cost of performance.

#define PARALLAX_DEPTH 1.0 // Depth of parallax effect. [0.5 0.75 1.0 1.25 1.5 1.75 2.0 2.5 3.0]

#define PARALLAX_HQ // Enables better precision of Parallax Occlusion Mapping at the cost of performance. 

// #define AUTO_NORMAL_SPEC // Enables automatic generation of normal and specular data from base color textures. Only works well for lower resolution resource packs. Make sure to set Surface Options > Texture Resolution properly according to your resource pack!

#define AUTO_NORMAL_STRENGTH 1.0 // Strength of automatically generated normal maps. [0.5 0.75 1.0 1.25 1.5 1.75 2.0 2.5 3.0 4.0]

///////////////////////////////////////////////////END OF ADJUSTABLE VARIABLES///////////////////////////////////////////////////






/* DRAWBUFFERS:012 */




in vec4 color;
in vec4 texcoord;
in vec4 lmcoord;
in vec3 worldPosition;
in vec4 vertexPos;
in mat3 tbnMatrix;
in vec3 viewPos;

in vec3 normal;
in vec3 tangent;
in vec3 binormal;
in vec3 worldNormal;

in vec2 blockLight;

in float materialIDs;

in float distance;
in float blockAO;

in vec4 autoMaterialProperties;

in vec4 originalNDCPos;

#include "Uniforms.inc"
#include "Common.inc"
#include "GBufferData.inc"

// layout(location = 0) out vec4 fragout0;
// layout(location = 1) out vec4 fragout1;


float CurveBlockLightTorch2(float blockLight)
{

	float falloff = 10.0;

	blockLight = exp(-(1.0 - blockLight) * falloff);
	blockLight = max(0.0, blockLight - exp(-falloff));

	return blockLight;
}

vec4 GetTexture(in sampler2D tex, in vec2 coord)
{
	#ifdef PARALLAX
		vec4 t = vec4(0.0f);
		if (distance < 20.0f)
		{
			t = texture2DLod(tex, coord, 0);
		}
		else
		{
			t = texture2D(tex, coord);
		}
		return t;
	#else
		return texture2D(tex, coord);
	#endif
}

vec2 OffsetCoord(in vec2 coord, in vec2 offset, in int level)
{
	int tileResolution = TEXTURE_RESOLUTION;
	ivec2 atlasTiles = textureSize(texture, 0) / TEXTURE_RESOLUTION;
	ivec2 atlasResolution = tileResolution * atlasTiles;

	coord *= atlasResolution;

	vec2 offsetCoord = coord + mod(offset.xy * atlasResolution, vec2(tileResolution));

	vec2 minCoord = vec2(coord.x - mod(coord.x, tileResolution), coord.y - mod(coord.y, tileResolution));
	vec2 maxCoord = minCoord + tileResolution;

	if (offsetCoord.x > maxCoord.x) {
		offsetCoord.x -= tileResolution;
	} else if (offsetCoord.x < minCoord.x) {
		offsetCoord.x += tileResolution;
	}

	if (offsetCoord.y > maxCoord.y) {
		offsetCoord.y -= tileResolution;
	} else if (offsetCoord.y < minCoord.y) {
		offsetCoord.y += tileResolution;
	}

	offsetCoord /= atlasResolution;

	return offsetCoord;
}

vec2 CalculateParallaxCoord(in vec2 coord, in vec3 viewVector, out vec3 rayOffset, in vec2 texGradX, in vec2 texGradY)
{
	vec2 parallaxCoord = coord.st;
	const int maxSteps = 112;
	vec3 stepSize = vec3(0.001f, 0.001f, 0.15f);

	float parallaxDepth = PARALLAX_DEPTH;




	const float gradThreshold = 0.004;
	float absoluteTexGrad = dot(abs(texGradX) + abs(texGradY), vec2(1.0));

	parallaxDepth *= saturate((1.0 - saturate(absoluteTexGrad / gradThreshold)) * 1.0);
	if (absoluteTexGrad > gradThreshold)
	{
		// parallaxDepth *= 0.1;
		//pCoord = vec3(0.2, 0.0, 1.0);
		return texcoord.st;
	}

	float parallaxStepSize = 0.5;

	stepSize.xy *= parallaxDepth;
	stepSize *= parallaxStepSize;

	float heightmap = textureGrad(normals, coord.st, texGradX, texGradY).a;

	vec3 pCoord = vec3(0.0f, 0.0f, 1.0f);




	// if (heightmap < 1.0f)
	// {
	// 	vec3 step = viewVector * stepSize;
	// 	float distAngleWeight = ((distance * 0.6f) * (2.1f - viewVector.z)) / 16.0;
	// 		 step *= distAngleWeight;
	// 		 step *= 1.0f;

	// 	float sampleHeight = heightmap;

	// 	for (int i = 0; sampleHeight < pCoord.z && i < 240; ++i)
	// 	{
	// 		//if (heightmap < pCoord.z)
	// 		pCoord.xy = mix(pCoord.xy, pCoord.xy + step.xy, clamp((pCoord.z - sampleHeight) / (stepSize.z * 0.25 * distAngleWeight / (-viewVector.z + 0.05)), 0.0, 1.0));
	// 		pCoord.z += step.z;
	// 		//pCoord += step;
	// 		//sampleHeight = GetTexture(normals, OffsetCoord(coord.st, pCoord.st, 0)).a;
	// 		sampleHeight = textureGrad(normals, OffsetCoord(coord.st, pCoord.st, 0), texGradX, texGradY).a;

	// 	}


	// 	parallaxCoord.xy = OffsetCoord(coord.st, pCoord.st, 0);
	// }

	int numRefinements = 0;
	const int maxRefinements = 4;

	if (heightmap < 1.0f)
	{
		#ifdef PARALLAX_HQ
		vec3 step = viewVector * stepSize * 2.0;
		#else
		vec3 step = viewVector * stepSize * 8.0;
		#endif

		float distAngleWeight = ((distance * 0.6) * (2.1 - viewVector.z)) / 16.0;
		step *= distAngleWeight;

		float sampleHeight = heightmap;

		#ifdef PARALLAX_HQ
		for (int i = 0; i < 64; i++)
		#else
		for (int i = 0; i < 16; i++)
		#endif
		{
			vec3 prevPCoord = pCoord;
			pCoord += step;
			// pCoord.xy = mix(pCoord.xy, pCoord.xy + step.xy, clamp((pCoord.z - sampleHeight) / (stepSize.z * 0.25 * distAngleWeight / (-viewVector.z + 0.05)), 0.0, 1.0));
			// pCoord.z += step.z;

	 		sampleHeight = textureGrad(normals, OffsetCoord(coord.st, pCoord.st, 0), texGradX, texGradY).a;

	 		if (sampleHeight > pCoord.z)
	 		{
	 			if (numRefinements < maxRefinements)
	 			{
	 				//pCoord -= step;

	 				pCoord = prevPCoord;

	 				step *= 0.5;
	 				numRefinements++;
	 			}
	 			else
	 			{
	 				break;
	 			}
	 		}
		}

		parallaxCoord.xy = OffsetCoord(coord.st, pCoord.st, 0);
	}






	rayOffset = pCoord;


	return parallaxCoord;
}

float GetParallaxShadow(in vec2 texcoord, in vec3 lightVector, float baseHeight, in vec2 texGradX, in vec2 texGradY)
{
	float sunVis = 1.0;



	//lightVector = normalize(tbnMatrix * lightVector);


	// lightVector.z *= TEXTURE_RESOLUTION * 0.5;
	lightVector.z *= 64.0;
	lightVector.z /= PARALLAX_DEPTH * 0.5;




	float shadowStrength = 1.0;

	const float gradThreshold = 0.003;
	float absoluteTexGrad = dot(abs(texGradX) + abs(texGradY), vec2(1.0));

	shadowStrength *= saturate((1.0 - saturate(absoluteTexGrad / gradThreshold)) * 1.0);
	if (absoluteTexGrad > gradThreshold)
	{
		// parallaxDepth *= 0.1;
		//pCoord = vec3(0.2, 0.0, 1.0);
		return 1.0;
	}




	// lightVector = normalize(vec3(1.0, 1.0, 0.5));

	vec3 currCoord = vec3(texcoord, baseHeight);

	float stepSize = 0.0005;

	ivec2 texSize = textureSize(texture, 0);
	currCoord.xy = (floor(currCoord.xy * texSize) + 0.5) / texSize;


	float allTexGrad = dot(abs(texGradX), vec2(1.0)) + dot(abs(texGradY), vec2(1.0));


	// stepSize *= allTexGrad * 500.0 + 1.0;

	for (int i = 0; i < 12; i++)
	{
		currCoord = vec3(OffsetCoord(currCoord.xy, lightVector.xy * stepSize, 0), currCoord.z + lightVector.z * stepSize);
		//float heightSample = GetTexture(normals, currCoord.xy).a;
		float heightSample = textureGrad(normals, currCoord.xy, texGradX, texGradY).a;



		// if (sin(frameTimeCounter) > 0.0)
		// {
		// 	if (heightSample > currCoord.z + 0.015)
		// 	{
		// 		sunVis *= 0.05;
		// 	}
		// }
		// else
		// {
			//float shadowBias = 0.0015 + allTexGrad * 7.0 * (sin(frameTimeCounter) > 0.0 ? 1.0 : 0.0);
			float shadowBias = 0.0015;
			sunVis *= mix(1.0, saturate((currCoord.z - heightSample + shadowBias) / 0.01), shadowStrength);
			// sunVis *= saturate((currCoord.z - heightSample + shadowBias + 0.04) / 0.08);
		// }

	}

	// sunVis = mix(1.0, sunVis, shadowStrength);

	return sunVis;
}


float GetModulatedRainSpecular(in vec3 pos)
{
	if (rainStrength < 0.01)
	{
		return 0.0;
	}

	//pos.y += frameTimeCounter * 3.0f;
	pos.xz *= 1.0f;
	pos.y *= 0.2f;

	// pos.y += Get3DNoise(pos.xyz * vec3(1.0f, 0.0f, 1.0f)).x * 2.0f;

	vec3 p = pos;

	float n = Get3DNoise(p);
		  n += Get3DNoise(p / 2.0f) * 2.0f;
		  n += Get3DNoise(p / 4.0f) * 4.0f;

		  n /= 7.0f;


	n = saturate(n * 0.8 + 0.5) * 0.97;


	return n;
}


vec3 GetRainAnimationTex(sampler2D tex, vec2 uv, float wet)
{
	//float frame = mod(floor(float(frameCounter) * 1.0), 60.0);
	// frame = 0.0;

	float frame = mod(floor(frameTimeCounter * 60.0), 60.0);
	vec2 coord = vec2(uv.x, mod(uv.y / 60.0, 1.0) - frame / 60.0);

	vec3 n = texture2D(tex, coord).rgb * 2.0 - 1.0;
	n.y *= -1.0;

	n.xy = pow(abs(n.xy) * 1.0, vec2(2.0 - wet * wet * wet * 1.2)) * sign(n.xy);
	// n.xy = pow(abs(n.xy) * 1.0, vec2(1.0)) * sign(n.xy);

	return n;
}

vec3 BilateralRainTex(sampler2D tex, vec2 uv, float wet)
{
	vec3 n = GetRainAnimationTex(tex, uv.xy, wet);
	vec3 nR = GetRainAnimationTex(tex, uv.xy + vec2(1.0, 0.0) / 128.0, wet);
	vec3 nU = GetRainAnimationTex(tex, uv.xy + vec2(0.0, 1.0) / 128.0, wet);
	vec3 nUR = GetRainAnimationTex(tex, uv.xy + vec2(1.0, 1.0) / 128.0, wet);

	vec2 fractCoord = fract(uv.xy * 128.0);

	vec3 lerpX = mix(n, nR, fractCoord.x);
	vec3 lerpX2 = mix(nU, nUR, fractCoord.x);
	vec3 lerpY = mix(lerpX, lerpX2, fractCoord.y);

	return lerpY;
}

vec3 GetRainNormal(in vec3 pos, inout float wet)
{
	if (rainStrength < 0.01)
	{
		return vec3(0.0, 0.0, 1.0);
	}

	pos.xyz *= 0.5;

	#ifdef RAIN_SPLASH_BILATERAL
	vec3 n1 = BilateralRainTex(gaux1, pos.xz, wet);
	vec3 n2 = BilateralRainTex(gaux2, pos.xz, wet);
	vec3 n3 = BilateralRainTex(gaux3, pos.xz, wet);
	#else
	vec3 n1 = GetRainAnimationTex(gaux1, pos.xz, wet);
	vec3 n2 = GetRainAnimationTex(gaux2, pos.xz, wet);
	vec3 n3 = GetRainAnimationTex(gaux3, pos.xz, wet);
	#endif

	pos.x -= frameTimeCounter * 1.5;
	float downfall = texture2D(noisetex, pos.xz * 0.0025).x;
	downfall = saturate(downfall * 1.5 - 0.25);


	vec3 n = n1 * 2.0;
	n += n2 * saturate(downfall * 2.0) * 2.0;
	n += n3 * saturate(downfall * 2.0 - 1.0) * 2.0;
	// n = n3 * 3.0;

	n *= 0.3;

	float lod = dot(abs(fwidth(pos.xyz)), vec3(1.0));

	n.xy *= 1.0 / (1.0 + lod * 5.0);

	// n.xy /= wet + 0.1;
	// n.x = downfall;

	wet = saturate(wet * 1.0 + downfall * (1.0 - wet) * 0.95);
	// wet = downfall * 0.2 + 0.8;

	n.xy *= rainStrength;

	return n;
}

float NormalWeight(vec4 color)
{
	float weight = Luminance(color.rgb);
	weight += color.a * 0.0;

	return weight;
}

void AutoNormalSpec(vec2 textureCoordinate, vec2 texGradX, vec2 texGradY, out vec3 normalTex, out vec3 specTex)
{
	float normalStrength = autoMaterialProperties.z;
	float smoothnessStrength = autoMaterialProperties.x;
	float smoothnessVariance = autoMaterialProperties.y;
	float metalness = autoMaterialProperties.w;



	int tileResolution = TEXTURE_RESOLUTION;
	ivec2 atlasTiles = textureSize(texture, 0) / TEXTURE_RESOLUTION;
	ivec2 atlasResolution = tileResolution * atlasTiles;


	normalStrength *= AUTO_NORMAL_STRENGTH;


	/*
	vec2 coordC = OffsetCoord(textureCoordinate, vec2(0.0, 0.0) / atlasResolution, 0);
	vec2 coordU = OffsetCoord(textureCoordinate, vec2(0.0, -1.0) / atlasResolution, 0);
	vec2 coordR = OffsetCoord(textureCoordinate, vec2(1.0, 0.0) / atlasResolution, 0);

	float lumC = Luminance(texture2D(texture, coordC).rgb);
	float lumU = Luminance(texture2D(texture, coordU).rgb);
	float lumR = Luminance(texture2D(texture, coordR).rgb);


	vec3 n = vec3(0.0);
	n.x = lumC - lumR;
	n.y = -lumC + lumU;
	n.z = 0.3 / (normalStrength + 0.00001);

	n = normalize(n);

	normalTex = n * 0.5 + 0.5;
	*/

	float s = 1.0;

	vec2 coordC = textureCoordinate;
	vec2 coord1 = OffsetCoord(textureCoordinate, (vec2(1.0, 1.0) 	* s)	/ atlasResolution, 0);
	vec2 coord2 = OffsetCoord(textureCoordinate, (vec2(1.0, -1.0) 	* s)	/ atlasResolution, 0);
	vec2 coord3 = OffsetCoord(textureCoordinate, (vec2(-1.0, 1.0) 	* s)	/ atlasResolution, 0);
	vec2 coord4 = OffsetCoord(textureCoordinate, (vec2(-1.0, -1.0) 	* s)	/ atlasResolution, 0);
	vec2 coord5 = OffsetCoord(textureCoordinate, (vec2(1.0, 0.0) 	* s)	/ atlasResolution, 0);
	vec2 coord6 = OffsetCoord(textureCoordinate, (vec2(-1.0, 0.0) 	* s)	/ atlasResolution, 0);
	vec2 coord7 = OffsetCoord(textureCoordinate, (vec2(0.0, 1.0) 	* s)	/ atlasResolution, 0);
	vec2 coord8 = OffsetCoord(textureCoordinate, (vec2(0.0, -1.0) 	* s)	/ atlasResolution, 0);

	float lumC = NormalWeight(textureGrad(texture, coordC, texGradX, texGradY));
	float lum1 = NormalWeight(textureGrad(texture, coord1, texGradX, texGradY));
	float lum2 = NormalWeight(textureGrad(texture, coord2, texGradX, texGradY));
	float lum3 = NormalWeight(textureGrad(texture, coord3, texGradX, texGradY));
	float lum4 = NormalWeight(textureGrad(texture, coord4, texGradX, texGradY));
	float lum5 = NormalWeight(textureGrad(texture, coord5, texGradX, texGradY));
	float lum6 = NormalWeight(textureGrad(texture, coord6, texGradX, texGradY));
	float lum7 = NormalWeight(textureGrad(texture, coord7, texGradX, texGradY));
	float lum8 = NormalWeight(textureGrad(texture, coord8, texGradX, texGradY));

	vec2 nSpace = vec2(1.0, 1.0);
	vec3 n = vec3(0.0);
	n.xy += (lumC - lum1) * vec2(1.0, 1.0)		* nSpace;
	n.xy += (lumC - lum2) * vec2(1.0, -1.0)		* nSpace;
	n.xy += (lumC - lum3) * vec2(-1.0, 1.0)		* nSpace;
	n.xy += (lumC - lum4) * vec2(-1.0, -1.0)	* nSpace;
	n.xy += (lumC - lum5) * vec2(1.0, 0.0)		* nSpace;
	n.xy += (lumC - lum6) * vec2(-1.0, 0.0)		* nSpace;
	n.xy += (lumC - lum7) * vec2(0.0, 1.0)		* nSpace;
	n.xy += (lumC - lum8) * vec2(0.0, -1.0)		* nSpace;


	//Fine
	//Flip fine x direction to better match sun angle
	if (sunAngle > 0.25 && sunAngle < 0.5
		|| sunAngle > 0.75 && sunAngle < 1.0)
	{
		n.xy += (lumC - lum6) * vec2(-1.0, 0.0) * nSpace * 2.0;
	}
	else
	{
		n.xy += (lumC - lum5) * vec2(1.0, 0.0) * nSpace * 2.0;
	}
	n.xy += (lumC - lum8) * vec2(0.0, -1.0) * nSpace * 2.0;



	n.z = 1.5 / (normalStrength + 0.00001);

	n = normalize(n);

	normalTex = n * 0.5 + 0.5;





	float lumBlur = NormalWeight(texture2DLod(texture, coordC, 2));
	float highpassLum = (lumC - lumBlur) * 1.0;


	float smoothness = saturate((highpassLum * 4.0) * 0.5 + 0.5) * 0.9 + 0.05;


	smoothness = pow(smoothness, smoothnessVariance);
	smoothness *= smoothnessStrength;




	// smoothness = 0.8;


	specTex = vec3(smoothness, metalness, 0.0);

}

vec3 ProceduralSnow(vec3 albedo, vec3 viewNormal, vec3 worldPosition)
{
	float upAngle = saturate(dot(viewNormal, normalize(upPosition)) * 0.5 + 0.5);

	if (worldNormal.y > 0.9)
	{
		// upAngle = saturate(dot(viewNormal, normalize(upPosition)) * 9.0 - 8.0);
	}

	float snowFactor = upAngle;
	snowFactor *= saturate(blockLight.y * 5.0 - 4.0);
	snowFactor *= saturate(blockAO * 2.0 - 1.0);
	snowFactor = smoothstep(0.0, 1.0, snowFactor);
	snowFactor = smoothstep(0.0, 1.0, snowFactor);
	snowFactor = smoothstep(0.0, 1.0, snowFactor);

	albedo = mix(albedo, vec3(1.0), vec3(snowFactor));

	return albedo;
}

void main() 
{	
	{
		vec3 spos = originalNDCPos.xyz / originalNDCPos.w;
		if (spos.STEREO_HALF_AXIS < -1.0 || spos.STEREO_HALF_AXIS > 1.0)
		{
			discard;
		}
	}


	vec2 texGradX = dFdx(texcoord.st);
	vec2 texGradY = dFdy(texcoord.st);

	// texGradX *= 0.5;
	// texGradY *= 0.5;


	vec2 textureCoordinate = texcoord.st;


	#ifdef PARALLAX

		vec3 viewVector = normalize(tbnMatrix * viewPos.xyz);
			 //viewVector.x /= 2.0f;
		int tileResolution = TEXTURE_RESOLUTION;
		ivec2 atlasTiles = atlasSize / TEXTURE_RESOLUTION;
		float atlasAspectRatio = atlasTiles.x / atlasTiles.y;
			viewVector.y *= atlasAspectRatio;


			 viewVector = normalize(viewVector);
		vec3 rayOffset;
		 textureCoordinate = CalculateParallaxCoord(texcoord.st, viewVector, rayOffset, texGradX, texGradY);
	#endif


	//vec4 albedo = texture2D(texture, textureCoordinate.st);
	vec4 albedo = textureGrad(texture, textureCoordinate.st, texGradX, texGradY);
	// vec3 avgAlbedo = texture2DLod(texture, textureCoordinate.st, 8).rgb;
	// albedo.rgb = mix(length(albedo.rgb), length(avgAlbedo.rgb), -0.5) * normalize(albedo.rgb + 0.0001);
	// albedo.rgb = mix(albedo.rgb, avgAlbedo.rgb, vec3(0.5));
	albedo.rgb *= color.rgb;

	// if (albedo.a < 0.5)
	// {
	// 	discard;
	// }

	// vec3 albedoAvg = texture2DLod(texture, textureCoordinate.st, 6).xyz;
	// albedo.rgb *= dot(albedoAvg.rgb, vec3(0.33333));

	// albedo.rgb = pow(length(albedo.rgb), 1.5) * normalize(albedo.rgb + 0.00001);


	// if (albedo.a < 0.2)
	// {
	// 	discard;
	// }


	//vec2 lightmap;
	// lightmap.x = clamp((lmcoord.x * 33.05f / 32.0f) - 1.05f / 32.0f, 0.0f, 1.0f);
	// lightmap.y = clamp((lmcoord.y * 33.05f / 32.0f) - 1.05f / 32.0f, 0.0f, 1.0f);


	// CurveLightmapSky(lightmap.y);

	vec4 specTex = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 normalTex = vec4(0.0, 1.0, 0.0, 1.0);
	vec3 viewNormal = normal;

		specTex = texture2D(specular, textureCoordinate.st);
		// specTex = textureGrad(specular, textureCoordinate.st, texGradX, texGradY);
		normalTex = texture2D(normals, textureCoordinate.st);
		// normalTex = textureGrad(normals, textureCoordinate.st, texGradX, texGradY);

	#ifdef AUTO_NORMAL_SPEC
	AutoNormalSpec(textureCoordinate.st, texGradX, texGradY, normalTex.xyz, specTex.xyz);
	#endif

	

	float smoothness = pow(specTex.r, 1.0);
	float metallic = specTex.g;
	float emissive = 0.0;



	float wet = GetModulatedRainSpecular(worldPosition.xyz + cameraPosition.xyz);
	#ifdef RAIN_SPLASH_EFFECT
		vec3 rainNormal = GetRainNormal(worldPosition.xyz + cameraPosition.xyz, wet);
	#else
		vec3 rainNormal = vec3(0.0, 0.0, 1.0);
	#endif
	wet *= 0.97;
	wet *= saturate(worldNormal.y * 10.5 + 0.1);
	wet *= saturate(abs(2.0 - materialIDs));
	wet *= clamp(blockLight.y * 1.05 - 0.9, 0.0, 0.1) / 0.1;
	wet *= wetness;

	#ifdef FORCE_WET_EFFECT

	#else
	wet *= specTex.b;
	#endif


	float darkFactor = clamp(wet, 0.0f, 0.2f) / 0.2f;

	albedo.rgb = pow(albedo.rgb, vec3(mix(1.0f, 1.15f, darkFactor)));


	smoothness = smoothness * (1.0 - saturate(wet)) + saturate(wet);



	vec3 normalMap = normalize(normalTex.xyz * 2.0 - 1.0);
	// normalMap = mix(normalMap, vec3(0.0, 0.0, 1.0), vec3(wet * wet));

	#ifdef RAIN_SPLASH_EFFECT
		normalMap = normalize(normalMap + rainNormal * wet * saturate(worldNormal.y) * vec3(1.0, 1.0, 0.0));
	#endif

	viewNormal = normalize(normalMap) * tbnMatrix;



	vec3 constructedNormal = normalize(cross(dFdx(viewPos), dFdy(viewPos)));

	if (dot(constructedNormal, normal) < 0.0)
	{
		viewNormal = constructedNormal;
	}









	float parallaxShadow = 1.0;

	#ifdef PARALLAX
		#ifdef PARALLAX_SHADOW

			float baseHeight = GetTexture(normals, textureCoordinate.st).a;

			if (dot(normalize(sunPosition), viewNormal) > 0.0 && baseHeight < 1.0)
			{
				vec3 lightVector = normalize(sunPosition.xyz);
				lightVector = normalize(tbnMatrix * lightVector);
				lightVector.y *= atlasAspectRatio;
				lightVector = normalize(lightVector);
				parallaxShadow = GetParallaxShadow(textureCoordinate.st, lightVector, baseHeight, texGradX, texGradY);
			}
		#endif
	#endif


	// if (abs(materialIDs - 3.0) < 0.5)
	// {
	// 	if (dot(normalize(-viewPos.xyz), normal) < 0.3)
	// 	{
	// 		discard;
	// 	}
	// }


	// #ifdef PARALLAX
	// 	vec3 worldPos = (gbufferModelViewInverse * vec4(viewPos.xyz, 0.0)).xyz;

	// 	float reliefDepth = 0.3;
	// 	float height = normalTex.a;
	// 	vec3 worldViewDir = normalize(worldPos.xyz);
	// 	float NdotV = dot(worldNormal.xyz, worldViewDir);

	// 	//float offsetDepth = (reliefDepth * 0.2 + (reliefDepth * 0.8) * NdotV) * (height);
	// 	float offsetDepth = reliefDepth * ((1.0 - height) - 0.0);
	// 	vec3 bottomPos = worldPos.xyz - worldNormal.xyz * offsetDepth;
	// 	float d1 = dot(worldNormal.xyz, bottomPos.xyz - worldPos.xyz);
	// 	float d2 = dot(worldViewDir, worldNormal.xyz);


	// 	vec3 parallaxWorldPos = worldPos.xyz;
	// 	if (d2 < 0.0)
	// 	{
	// 		parallaxWorldPos += worldViewDir * (d1 / d2);
	// 	}


	// 	parallaxWorldPos = (gbufferModelView * vec4(parallaxWorldPos.xyz, 0.0)).xyz;

	// 	vec4 projPos = gbufferProjection * vec4(parallaxWorldPos.xyz, 1.0);
	// 	projPos /= projPos.w;
	// 	projPos = projPos * 0.5 + 0.5;

	// 	gl_FragDepth = projPos.z;
	// #endif


	// albedo = vec4(1.0, 1.0, 1.0, 1.0);



	// vec4 vp = vec4(viewPos.xyz, 1.0);
	// vp.z -= (1.0 - normalTex.a) * 0.5;
	// vec4 projPos = gbufferProjection * vec4(vp);
	// projPos /= projPos.w;
	// projPos = projPos * 0.5 + 0.5;

	// gl_FragDepth = projPos.z;


	// vec3 worldPos = (gbufferModelViewInverse * vec4(viewPos.xyz, 0.0)).xyz;

	// float reliefDepth = 0.3;
	// float height = normalTex.a;
	// vec3 worldViewDir = normalize(worldPos.xyz);
	// float NdotV = dot(worldNormal.xyz, worldViewDir);

	// //float offsetDepth = (reliefDepth * 0.2 + (reliefDepth * 0.8) * NdotV) * (height);
	// float offsetDepth = reliefDepth * ((1.0 - height) - 0.0);
	// vec3 bottomPos = worldPos.xyz - worldNormal.xyz * offsetDepth;
	// float d1 = dot(worldNormal.xyz, bottomPos.xyz - worldPos.xyz);
	// float d2 = dot(worldViewDir, worldNormal.xyz);


	// vec3 parallaxWorldPos = worldPos.xyz;
	// if (d2 < 0.0)
	// {
	// 	parallaxWorldPos += worldViewDir * (d1 / d2);
	// }


	// parallaxWorldPos = (gbufferModelView * vec4(parallaxWorldPos.xyz, 0.0)).xyz;

	// vec4 projPos = gbufferProjection * vec4(parallaxWorldPos.xyz, 1.0);
	// projPos /= projPos.w;
	// projPos = projPos * 0.5 + 0.5;

	// gl_FragDepth = projPos.z;




	//Calculate torchlight average direction
	vec3 Q1 = dFdx(viewPos.xyz);
	vec3 Q2 = dFdy(viewPos.xyz);
	float st1 = dFdx(blockLight.x);
	float st2 = dFdy(blockLight.x);

	st1 /= dot(fwidth(viewPos.xyz), vec3(0.333333));
	st2 /= dot(fwidth(viewPos.xyz), vec3(0.333333));
	vec3 T = (Q1*st2 - Q2*st1);
	T = normalize(T + normal.xyz * 0.0002);
	T = -cross(T, normal.xyz);

	T = normalize(T + normal * 0.01);
	T = normalize(T + normal * 0.85 * (blockLight.x));


	float torchLambert = pow(saturate(dot(T, viewNormal.xyz) * 1.0 + 0.0), 1.0);
	torchLambert += pow(saturate(dot(T, viewNormal.xyz) * 0.4 + 0.6), 1.0) * 0.5;

	if (dot(T, normal.xyz) > 0.99)
	{
		torchLambert = pow(torchLambert, 2.0) * 0.45;
	}
	if (st1 < 0.001 && st2 < 0.001)
	{
		torchLambert = 1.0;
	}

	// albedo.rgb = texture2DLod(gaux1, worldPosition.xz, 0).rgb;

	// albedo.rgb = vec3(0.5);


	vec2 mcLightmap = blockLight;
	mcLightmap.x = CurveBlockLightTorch2(mcLightmap.x);
	mcLightmap.x = mcLightmap.x * torchLambert * 1.0;
	mcLightmap.x = pow(mcLightmap.x, 0.25);
	mcLightmap.x += rand(vertexPos.xy + sin(frameTimeCounter)).x * (1.5 / 255.0);


	// albedo.rgb = vec3(1.0);
	albedo.rgb *= blockAO;

	GBufferData data;

	data.albedo = albedo;
	data.normal = viewNormal;
	data.mcLightmap = mcLightmap;
	data.smoothness = smoothness;
	data.metalness = metallic;
	data.materialID = materialIDs;
	data.emissive = 0.0;
	data.parallaxShadow = parallaxShadow;

	vec4 fragout0, fragout1, fragout2;

	OutputGBufferDataSolid(data, fragout0, fragout1, fragout2);



	gl_FragData[0] = fragout0;
	gl_FragData[1] = fragout1;
	gl_FragData[2] = fragout2;


	// gl_FragData[0] = albedo;
	// gl_FragData[1] = vec4(mcLightmap.xy, emissive, parallaxShadow);
	// gl_FragData[2] = vec4(normalEnc.xy, blockLight.x, albedo.a);
	// gl_FragData[3] = vec4(smoothness, metallic, (materialIDs + 0.1) / 255.0, albedo.a);



}