#version 330 compatibility

/*
 _______ _________ _______  _______  _ 
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _ 
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/



////////////////////////////////////////////////////ADJUSTABLE VARIABLES/////////////////////////////////////////////////////////



///////////////////////////////////////////////////END OF ADJUSTABLE VARIABLES///////////////////////////////////////////////////




#define ENTITY_STATUS_COLOR // Enables vanilla Minecraft entity color changing (red when hurt, creeper flashing when exploding). 

/* DRAWBUFFERS:012 */

in vec4 color;
in vec4 texcoord;
in vec4 vertexPos;

in vec3 normal;

in vec2 blockLight;

in float materialIDs;

in vec3 viewPos;

in vec4 originalNDCPos;

#include "Uniforms.inc"
#include "Common.inc"
#include "GBufferData.inc"



float CurveBlockLightTorch2(float blockLight)
{

	float falloff = 10.0;

	blockLight = exp(-(1.0 - blockLight) * falloff);
	blockLight = max(0.0, blockLight - exp(-falloff));

	return blockLight;
}

void main() 
{	
	{
		vec3 spos = originalNDCPos.xyz / originalNDCPos.w;
		if (spos.STEREO_HALF_AXIS < -1.0 || spos.STEREO_HALF_AXIS > 1.0)
		{
			discard;
		}
	}

	vec4 albedo = texture2D(texture, texcoord.st);
	albedo *= color;

	// albedo.a = albedo.a > 0.5 ? 1.0 : 0.0;

	// if (albedo.a < 0.5)
	// {
	// 	discard;
	// }



#ifdef ENTITY_STATUS_COLOR
	albedo.rgb = mix(albedo.rgb, entityColor.rgb, vec3(entityColor.a));
#endif



	//Fix wrong normals on some entities
	vec3 constructedNormal = normalize(cross(dFdx(viewPos), dFdy(viewPos)));

	if (dot(constructedNormal, normal) > 0.1)
	{
		constructedNormal = normal;
	}



	vec4 specTex = texture2D(specular, texcoord.st);

	float smoothness = specTex.b;
	float metallic = specTex.g;
	float emissive = specTex.b;







	vec2 mcLightmap = blockLight.xy;

	mcLightmap.x = CurveBlockLightTorch2(mcLightmap.x);
	mcLightmap.x = pow(mcLightmap.x, 0.25);
	mcLightmap.x += rand(vertexPos.xy + sin(frameTimeCounter)).x * (1.5 / 255.0);

	

	// gl_FragData[0] = albedo;
	// gl_FragData[1] = vec4(mcLightmap.xy, emissive, albedo.a);
	// gl_FragData[2] = vec4(normalEnc.xy, 0.0, albedo.a);
	// gl_FragData[3] = vec4(smoothness, metallic, (materialIDs + 0.1) / 255.0, albedo.a);



	GBufferData data;

	data.albedo = albedo;
	data.normal = constructedNormal;
	data.mcLightmap = mcLightmap;
	data.smoothness = 0.0;
	data.metalness = 0.0;
	data.materialID = 9.0;
	data.emissive = 0.0;
	data.parallaxShadow = 1.0;

	vec4 fragout0, fragout1, fragout2;


	OutputGBufferDataSolid(data, fragout0, fragout1, fragout2);


	gl_FragData[0] = fragout0;
	gl_FragData[1] = fragout1;
	gl_FragData[2] = fragout2;



}