#version 330 compatibility

#define TORCHLIGHT_COLOR_TEMPERATURE 2300 // Color temperature of torch light in Kelvin. [2000 2300 2500 3000]


#include "Uniforms.inc"
#include "Common.inc"


out vec4 texcoord;

out vec3 lightVector;
out vec3 upVector;
out vec3 sunVector;

out float timeSunriseSunset;
out float timeNoon;
out float timeMidnight;
out float timeSkyDark;

out vec3 colorSunlight;
out vec3 colorSkylight;
out vec3 colorTorchlight;

out vec4 skySHR;
out vec4 skySHG;
out vec4 skySHB;

out vec3 worldLightVector;
out vec3 worldSunVector;


out float nightDarkness;

out float contextualFogFactor;
out float heldLightBlacklist;

out vec3 upperCloudSunlightColor;

out float cloudMieFill;

out CloudProperties cloudProperties;
out float globalCloudShadow;

float CubicSmooth(in float x)
{
	return x * x * (3.0f - 2.0f * x);
}

float clamp01(float x)
{
	return clamp(x, 0.0, 1.0);
}



void ContextualFog(inout vec3 color, in vec3 viewPos, in vec3 viewDir, in vec3 lightDir, in vec3 skyLightColor, in vec3 sunLightColor, float density)
{
	float dist = length(viewPos);

	float fogDensity = density * 0.019;
		  fogDensity *= 1.0 -  saturate(viewDir.y * 0.5 + 0.5) * 0.72;
	float fogFactor = pow(1.0 - exp(-dist * fogDensity), 2.0);
		  //fogFactor = 1.0 -  saturate(viewDir.y * 0.5 + 0.5);




	vec3 fogColor = pow(gl_Fog.color.rgb, vec3(2.2));


	float VdotL = dot(viewDir, lightDir);

	float g = 0.72;
				//float g = 0.9;
	float g2 = g * g;
	float theta = VdotL * 0.5 + 0.5;
	float anisoFactor = 1.5 * ((1.0 - g2) / (2.0 + g2)) * ((1.0 + theta * theta) / (1.0 + g2 - 2.0 * g * theta)) + g * theta;


	float skyFactor = pow(saturate(viewDir.y * 0.5 + 0.5), 1.5);
		  //skyFactor = skyFactor * (3.0 - 2.0 * skyFactor);

	fogColor = sunLightColor * anisoFactor * 1.0 + skyFactor * skyLightColor * 1.0;

	fogColor *= exp(-density * 1.5) * 2.0;

	color = mix(color, fogColor, fogFactor);

}

void DoNightEye(inout vec3 color)
{
	float luminance = Luminance(color);

	color = mix(color, luminance * vec3(0.2, 0.4, 0.9), vec3(0.8));
}

void main() 
{
	gl_Position = ftransform();
	
	texcoord = gl_MultiTexCoord0;


	heldLightBlacklist = 1.0;

	//Calculate ambient light from atmospheric scattering
	//worldSunVector = normalize((gbufferModelViewInverse * vec4(sunVector, 0.0)).xyz);
	//worldLightVector = normalize((gbufferModelViewInverse * vec4(lightVector, 0.0)).xyz);
	worldSunVector = normalize((shadowModelViewInverse * vec4(0.0, 0.0, 1.0, 0.0)).xyz);
	worldLightVector = worldSunVector;

	sunVector = normalize((gbufferModelView * vec4(worldSunVector.xyz, 0.0)).xyz);
	lightVector = sunVector;

	if (sunAngle < 0.5f) 
	{
		//lightVector = normalize(sunPosition);
	} 
	else 
	{
		//lightVector = normalize(moonPosition);
		//lightVector *= -1.0;
		//worldLightVector *= -1.0;
		worldSunVector *= -1.0;
		sunVector *= -1.0;
	}

	//sunVector = normalize(sunPosition);

	//upVector = normalize(upPosition);

	upVector = normalize((gbufferModelView * vec4(0.0, 1.0, 0.0, 0.0)).xyz);


	if (
		heldItemId == 344
		|| heldItemId == 423
		|| heldItemId == 413
		|| heldItemId == 411
		)
	{
		heldLightBlacklist = 0.0;
	}



	upperCloudSunlightColor = exp2(-(1.0 / (worldLightVector.y + 0.001)) * vec3(0.3, 0.55, 1.0) * 0.3);

	
	
	nightDarkness = 0.003 * (1.0 + 8.0 * nightVision);


	float timePow = 6.0f;

	float LdotUp = dot(upVector, sunVector);
	float LdotDown = dot(-upVector, sunVector);

	timeNoon = 1.0 - pow(1.0 - clamp01(LdotUp), timePow);
	timeSunriseSunset = 1.0 - timeNoon;
	timeMidnight = CubicSmooth(CubicSmooth(clamp01(LdotDown * 20.0f + 0.4)));
	timeMidnight = 1.0 - pow(1.0 - timeMidnight, 2.0);
	timeSunriseSunset *= 1.0 - timeMidnight;
	timeNoon *= 1.0 - timeMidnight;

	// timeSkyDark = clamp01(LdotDown);
	// timeSkyDark = pow(timeSkyDark, 3.0f);
	timeSkyDark = 0.0f;


	float horizonTime = CubicSmooth(clamp01((1.0 - abs(LdotUp)) * 7.0f - 6.0f));
	
	const float rayleigh = 0.02f;


	cloudMieFill = 1.0 / (worldLightVector.y + 0.001);


	// vec3 skyTint = vec3(1.0);
	// float skyTintAmount = abs(skyColor.r - (116.0 / 255.0)) + abs(skyColor.g - (172.0 / 255.0)) + abs(skyColor.b - (255.0 / 255.0));
	// //skyTint = mix(vec3(1.0), skyColor, saturate(skyTintAmount));
	// contextualFogFactor = clamp(skyTintAmount * 3.0, 0.0, 1.0) * 0.5;
	// contextualFogFactor = 0.0;

	//float randomFog = texture2D(noisetex, vec2(frameTimeCounter * 0.01, 0.0)).x;
	//randomFog = saturate(randomFog * 1.5 - 0.5);
	//randomFog = pow(randomFog, 1.0);
	//contextualFogFactor += randomFog;

	//contextualFogFactor = (sin(frameTimeCounter * 0.8) * 0.5 + 0.5) * 1.0;

	//contextualFogFactor *= 10.0;




	cloudProperties = GetGlobalCloudProperties();
	globalCloudShadow = CloudShadow(vec4(0.0), worldLightVector, cloudProperties);




	colorSunlight = AtmosphericScatteringSingle(worldSunVector, worldSunVector, 1.0) * 0.2;
	colorSunlight = normalize(colorSunlight + 0.001);

	colorSunlight *= pow(saturate(worldSunVector.y), 0.9);
	
	colorSunlight *= 1.0f - horizonTime;




	vec3 moonlight = AtmosphericScattering(-worldSunVector, -worldSunVector, 1.0);
	moonlight = normalize(moonlight + 0.0001);
	moonlight *= pow(saturate(-worldSunVector.y), 0.9);
	moonlight *= nightDarkness * 0.5;



	colorSkylight = vec3(0.0);

///*
	const int latSamples = 5;
	const int lonSamples = 5;

	vec4 shR = vec4(0.0);
	vec4 shG = vec4(0.0);
	vec4 shB = vec4(0.0);

	for (int i = 0; i < latSamples; i++)
	{
		float latitude = (float(i) / float(latSamples)) * 3.14159265;
			  latitude = latitude;
		for (int j = 0; j < lonSamples; j++)
		{
			float longitude = (float(j) / float(lonSamples)) * 3.14159265 * 2.0;
			//longitude = longitude * 0.5 + 0.5;

			vec3 kernel;
			kernel.x = cos(latitude) * cos(longitude);
			kernel.z = cos(latitude) * sin(longitude);
			kernel.y = sin(latitude);

			vec3 skyCol = AtmosphericScattering(normalize(kernel + vec3(0.0, 1.0, 0.0) * 0.1), worldSunVector, 0.0);


//void ContextualFog(inout vec3 color, in vec3 viewPos, in vec3 viewDir, in vec3 lightDir, in vec3 skyLightColor, in vec3 sunLightColor, float density)
			// ContextualFog(skyCol, kernel * 1670.0, kernel, worldSunVector, skyCol, colorSunlight * 1.0, contextualFogFactor);

			//skyCol = vec3(1.0, 1.0, 1.0);
			//skyCol *= skyTint;

			vec3 moonAtmosphere = AtmosphericScattering(kernel, -worldSunVector, 1.0);
			DoNightEye(moonAtmosphere);

			skyCol += moonAtmosphere * nightDarkness;

			colorSkylight += skyCol;

			//skyCol *= 0.5;

			shR += ToSH(skyCol.r, kernel);
			shG += ToSH(skyCol.g, kernel);
			shB += ToSH(skyCol.b, kernel);

			//shR += ToSH(skyCol.r, kernel * vec3(-1.0, 1.0, -1.0));
			//shG += ToSH(skyCol.g, kernel * vec3(-1.0, 1.0, -1.0));
			//shB += ToSH(skyCol.b, kernel * vec3(-1.0, 1.0, -1.0));


		}
	}

	colorSkylight /= latSamples * lonSamples;

	DoNightEye(moonlight);

	colorSunlight += moonlight;


	shR /= latSamples * lonSamples;
	shG /= latSamples * lonSamples;
	shB /= latSamples * lonSamples;

	//float ambientMie = 0.01;
	//shR += ToSH(colorSunlight.r * ambientMie, worldSunVector);
	//shG += ToSH(colorSunlight.g * ambientMie, worldSunVector);
	//shB += ToSH(colorSunlight.b * ambientMie, worldSunVector);

	skySHR = shR;
	skySHG = shG;
	skySHB = shB;
//*/


	

	
	//Torchlight color
	//colorTorchlight = vec3(1.00f, 0.30f, 0.00f);
	//colorTorchlight = vec3(1.0f, 0.5, 0.1);

	if (TORCHLIGHT_COLOR_TEMPERATURE == 2000)
		//2000k
		colorTorchlight = pow(vec3(255, 141, 11) / 255.0, vec3(2.2));
	else if (TORCHLIGHT_COLOR_TEMPERATURE == 2300)
		//2300k
		colorTorchlight = pow(vec3(255, 152, 54) / 255.0, vec3(2.2));
	else if (TORCHLIGHT_COLOR_TEMPERATURE == 2500)
		//2500k
		colorTorchlight = pow(vec3(255, 166, 69) / 255.0, vec3(2.2));
	else
		//3000k
		colorTorchlight = pow(vec3(255, 180, 107) / 255.0, vec3(2.2));



	//2000k
	//colorTorchlight = pow(vec3(255, 141, 11) / 255.0, vec3(2.2));

	//2200k
	//colorTorchlight = pow(vec3(255, 147, 44) / 255.0, vec3(2.2));

	//2500k
	//colorTorchlight = pow(vec3(255, 166, 69) / 255.0, vec3(2.2));

	//3000k
	//colorTorchlight = pow(vec3(255, 180, 107) / 255.0, vec3(2.2));




	//colorSkylight = vec3(0.1f);
	
}
