#version 330 compatibility

/*
 _______ _________ _______  _______  _
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/

/////////////////////////CONFIGURABLE VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////CONFIGURABLE VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////





#define SHADOW_MAP_BIAS 0.9

#define RAYLEIGH_AMOUNT 1.0 // Density of atmospheric scattering. [0.5 1.0 1.5 2.0 3.0 4.0]

#define SUNLIGHT_INTENSITY 1.0 // Intensity of sunlight. [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]


const int 		noiseTextureResolution  = 64;


/* DRAWBUFFERS:5 */


const bool gaux2MipmapEnabled = true;



in vec4 texcoord;
in vec3 lightVector;
in vec3 sunVector;

in float timeSunriseSunset;
in float timeNoon;
in float timeMidnight;

in vec3 colorSunlight;
in vec3 colorSkylight;
in vec3 colorTorchlight;

in vec3 worldSunVector;
in vec3 worldLightVector;

in vec4 skySHR;
in vec4 skySHG;
in vec4 skySHB;

in vec3 upperCloudSunlightColor;

in float cloudMieFill;

in float globalCloudShadow;

#include "Uniforms.inc"
#include "Common.inc"
#include "GBufferData.inc"

in CloudProperties cloudProperties;

#define ANIMATION_SPEED 1.0f


#define FRAME_TIME frameTimeCounter * ANIMATION_SPEED

/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////




vec3 	CalculateNoisePattern1(vec2 offset, float size) 
{
	vec2 coord = texcoord.st;

	coord *= vec2(viewWidth, viewHeight);
	coord = mod(coord + offset, vec2(size));
	coord /= noiseTextureResolution;

	return texture2D(noisetex, coord).xyz;
}

/////////////////////////STRUCTS///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////STRUCTS///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////STRUCT FUNCTIONS//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////STRUCT FUNCTIONS//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////




vec4 BilateralUpsample(const in float scale, in vec2 offset, in float depth, in vec3 normal)
{
	vec2 recipres = vec2(1.0f / viewWidth, 1.0f / viewHeight);

	vec4 light = vec4(0.0f);
	float weights = 0.0f;

	for (float i = -0.5f; i <= 0.5f; i += 1.0f)
	{
		for (float j = -0.5f; j <= 0.5f; j += 1.0f)
		{
			vec2 coord = vec2(i, j) * recipres * 2.0f;

			float sampleDepth = GetDepthLinear(texcoord.st + coord * 2.0f * (exp2(scale)));
			vec3 sampleNormal = GetNormals(texcoord.st + coord * 2.0f * (exp2(scale)));
			//float weight = 1.0f / (pow(abs(sampleDepth - depth) * 1000.0f, 2.0f) + 0.001f);
			float weight = clamp(1.0f - abs(sampleDepth - depth) / 2.0f, 0.0f, 1.0f);
				  weight *= max(0.0f, dot(sampleNormal, normal) * 2.0f - 1.0f);
			//weight = 1.0f;

			light +=	pow(texture2DLod(gaux2, (texcoord.st) * (1.0f / exp2(scale )) + 	offset + coord, 1), vec4(2.2f, 2.2f, 2.2f, 1.0f)) * weight;

			weights += weight;
		}
	}


	light /= max(0.00001f, weights);

	if (weights < 0.01f)
	{
		light =	pow(texture2DLod(gaux2, (texcoord.st) * (1.0f / exp2(scale 	)) + 	offset, 2), vec4(2.2f, 2.2f, 2.2f, 1.0f));
	}


	// vec3 light =	texture2DLod(gcolor, (texcoord.st) * (1.0f / pow(2.0f, 	scale 	)) + 	offset, 2).rgb;


	return light;
}




void FixNormals(inout vec3 normal, in vec3 viewPosition)
{
	vec3 V = normalize(viewPosition.xyz);
	vec3 N = normal;

	float NdotV = dot(N, V);

	N = normalize(mix(normal, -V, clamp(pow((NdotV * 1.0), 1.0), 0.0, 1.0)));
	N = normalize(N + -V * 0.1 * clamp(NdotV + 0.4, 0.0, 1.0));

	normal = N;
}

vec4 textureSmooth(in sampler2D tex, in vec2 coord)
{
	vec2 res = vec2(64.0f, 64.0f);

	coord *= res;
	coord += 0.5f;

	vec2 whole = floor(coord);
	vec2 part  = fract(coord);

	part.x = part.x * part.x * (3.0f - 2.0f * part.x);
	part.y = part.y * part.y * (3.0f - 2.0f * part.y);
	// part.x = 1.0f - (cos(part.x * 3.1415f) * 0.5f + 0.5f);
	// part.y = 1.0f - (cos(part.y * 3.1415f) * 0.5f + 0.5f);

	coord = whole + part;

	coord -= 0.5f;
	coord /= res;

	return texture2D(tex, coord);
}

float AlmostIdentity(in float x, in float m, in float n)
{
	if (x > m) return x;

	float a = 2.0f * n - m;
	float b = 2.0f * m - 3.0f * n;
	float t = x / m;

	return (a * t + b) * t * t + n;
}

float GetWaves(vec3 position, float frameTimeCounter) 
{
	float speed = 0.9f;

  vec2 p = position.xz / 20.0f;

  p.xy -= position.y / 20.0f;

  p.x = -p.x;

  p.x += (frameTimeCounter / 40.0f) * speed;
  p.y -= (frameTimeCounter / 40.0f) * speed;

  float weight = 1.0f;
  float weights = weight;

  float allwaves = 0.0f;

  float wave = textureSmooth(noisetex, (p * vec2(2.0f, 1.2f))  + vec2(0.0f,  p.x * 2.1f) ).x; 			p /= 2.1f; 	/*p *= pow(2.0f, 1.0f);*/ 	p.y -= (FRAME_TIME / 20.0f) * speed; p.x -= (FRAME_TIME / 30.0f) * speed;
  allwaves += wave;

  weight = 4.1f;
  weights += weight;
      wave = textureSmooth(noisetex, (p * vec2(2.0f, 1.4f))  + vec2(0.0f,  -p.x * 2.1f) ).x;	p /= 1.5f;/*p *= pow(2.0f, 2.0f);*/ 	p.x += (FRAME_TIME / 20.0f) * speed;
      wave *= weight;
  allwaves += wave;

  weight = 17.25f;
  weights += weight;
      wave = (textureSmooth(noisetex, (p * vec2(1.0f, 0.75f))  + vec2(0.0f,  p.x * 1.1f) ).x);		p /= 1.5f; 	p.x -= (FRAME_TIME / 55.0f) * speed;
      wave *= weight;
  allwaves += wave;

  weight = 15.25f;
  weights += weight;
      wave = (textureSmooth(noisetex, (p * vec2(1.0f, 0.75f))  + vec2(0.0f,  -p.x * 1.7f) ).x);		p /= 1.9f; 	p.x += (FRAME_TIME / 155.0f) * speed;
      wave *= weight;
  allwaves += wave;

  weight = 29.25f;
  weights += weight;
      wave = abs(textureSmooth(noisetex, (p * vec2(1.0f, 0.8f))  + vec2(0.0f,  -p.x * 1.7f) ).x * 2.0f - 1.0f);		p /= 2.0f; 	p.x += (FRAME_TIME / 155.0f) * speed;
      wave = 1.0f - AlmostIdentity(wave, 0.2f, 0.1f);
      wave *= weight;
  allwaves += wave;

  weight = 15.25f;
  weights += weight;
      wave = abs(textureSmooth(noisetex, (p * vec2(1.0f, 0.8f))  + vec2(0.0f,  p.x * 1.7f) ).x * 2.0f - 1.0f);
      wave = 1.0f - AlmostIdentity(wave, 0.2f, 0.1f);
      wave *= weight;
  allwaves += wave;

  allwaves /= weights;

  return allwaves;
}

vec3 GetWavesNormal2(vec3 position, float time) 
{

	float WAVE_HEIGHT = 1.0;

	const float sampleDistance = 11.0f;

	position -= vec3(0.005f, 0.0f, 0.005f) * sampleDistance;

	float wavesCenter = GetWaves(position, time);
	float wavesLeft = GetWaves(position + vec3(0.01f * sampleDistance, 0.0f, 0.0f), time);
	float wavesUp   = GetWaves(position + vec3(0.0f, 0.0f, 0.01f * sampleDistance), time);

	vec3 wavesNormal;
		 wavesNormal.r = wavesCenter - wavesLeft;
		 wavesNormal.g = wavesCenter - wavesUp;

		 wavesNormal.r *= 10.0f * WAVE_HEIGHT / sampleDistance;
		 wavesNormal.g *= 10.0f * WAVE_HEIGHT / sampleDistance;

		 wavesNormal.b = sqrt(1.0f - wavesNormal.r * wavesNormal.r - wavesNormal.g * wavesNormal.g);
		 wavesNormal.rgb = normalize(wavesNormal.rgb);



	return wavesNormal.rgb;
}

vec3 GetWavesNormal(vec3 position, float time) {

	vec2 coord = position.xz / 50.0;
	coord.xy -= position.y / 50.0;
	//coord -= floor(coord);

	coord = mod(coord, vec2(1.0));


	float texelScale = 1.0;

	//to fix color error with GL_CLAMP
	//coord.x = coord.x * ((viewWidth - 1 * texelScale) / viewWidth) + ((0.5 * texelScale) / viewWidth);
	//coord.y = coord.y * ((viewHeight - 1 * texelScale) / viewHeight) + ((0.5 * texelScale) / viewHeight);


	coord.xy = clamp(coord.xy, (0.5 / vec2(viewWidth, viewHeight)), 1.0 - (0.5 / vec2(viewWidth, viewHeight)));

	vec3 normal;
	//normal.xyz = ((texture2DLod(gaux4, coord, 0).xyz) * 2.0 - 1.0);
	normal.xyz = DecodeNormal(texture2DLod(gaux1, coord, 0).zw);

	return normal;
}


void WaterRefraction(inout vec3 color, MaterialMask mask, vec4 worldSpacePosition, float waterDepth, float opaqueDepth, out vec2 refractionCoord)
{
	refractionCoord = texcoord.st;

	if (mask.water > 0.5 || mask.ice > 0.5 || mask.stainedGlass > 0.5)
	{
		vec3 wavesNormal;
		if (mask.water > 0.5)
			 wavesNormal = GetWavesNormal(worldSpacePosition.xyz + cameraPosition.xyz, frameTimeCounter).xzy;
		else if (mask.ice > 0.5 || mask.stainedGlass > 0.5)
		{
			 wavesNormal = vec3(0.0, 1.0, 0.0);
		}

		if (mask.stainedGlass > 0.5)
		{
			if (texture2D(gaux2, texcoord.st).a >= 0.99)
			{
				return;
			}
		}


		float waterDeep = opaqueDepth - waterDepth;

		float refractAmount = saturate(waterDeep / 1.0) * 0.125;

		if (mask.ice > 0.5 || mask.stainedGlass > 0.5)
		{
			refractAmount *= 0.5;
		}

		if (isEyeInWater > 0)
		{
			refractAmount *= 2.0;
		}

		vec4 wnv = gbufferModelView * vec4(wavesNormal.xyz, 0.0);
		vec3 wavesNormalView = normalize(wnv.xyz);
		vec4 nv = gbufferModelView * vec4(0.0, 1.0, 0.0, 0.0);
			   nv.xyz = normalize(nv.xyz);
				 wavesNormalView.xy -= nv.xy;
		float aberration = 0.2;
		float refractionAmount = 1.82;
		vec2 refractCoord0 = texcoord.st - wavesNormalView.xy * refractAmount * (refractionAmount) / (waterDepth + 0.0001);
		vec2 refractCoord1 = texcoord.st - wavesNormalView.xy * refractAmount * (refractionAmount + aberration) / (waterDepth + 0.0001);
		vec2 refractCoord2 = texcoord.st - wavesNormalView.xy * refractAmount * (refractionAmount + aberration * 2.0) / (waterDepth + 0.0001);




		if (refractCoord0.x > 1.0 || refractCoord0.x < 0.0 || refractCoord0.y > 1.0 || refractCoord0.y < 0.0)
			refractCoord0 = texcoord.st;

		if (refractCoord1.x > 1.0 || refractCoord1.x < 0.0 || refractCoord1.y > 1.0 || refractCoord1.y < 0.0)
			refractCoord1 = texcoord.st;

		if (refractCoord2.x > 1.0 || refractCoord2.x < 0.0 || refractCoord2.y > 1.0 || refractCoord2.y < 0.0)
			refractCoord2 = texcoord.st;
		// vec2 refractCoord = texcoord.st - wavesNormal.xy * 1.72 / (surface.linearDepth + 0.0001);


		// vec3 fakeViewVector = vec3(texcoord.st * 2.0 - 1.0, 0.1);
		// vec3 fakeRefractCoord = refract(fakeViewVector, surface.normal.xyz, 1.0 / 1.00001);
		
		/*
		surface.color.r = pow(texture2DLod(gcolor, refractCoord0.xy, 1).r, (2.2));
		surface.color.g = pow(texture2DLod(gcolor, refractCoord1.xy, 1).g, (2.2));
		surface.color.b = pow(texture2DLod(gcolor, refractCoord2.xy, 1).b, (2.2));
		*/


		///*

		float fogDensity = 0.40;
		float visibility = 1.0f / (pow(exp(waterDeep * fogDensity), 1.0f));


		vec4 blendWeights = vec4(1.0, 0.5, 0.25, 0.125);
		blendWeights = pow(blendWeights, vec4(visibility));

		float blendWeightsTotal = dot(blendWeights, vec4(1.0));

		color.r = 
					(
					    pow(texture2DLod(gaux2, refractCoord0.xy, 1).r, (2.2)) * blendWeights.x
					  + pow(texture2DLod(gaux2, refractCoord0.xy, 2).r, (2.2)) * blendWeights.y
					  + pow(texture2DLod(gaux2, refractCoord0.xy, 3).r, (2.2)) * blendWeights.z
					  + pow(texture2DLod(gaux2, refractCoord0.xy, 4).r, (2.2)) * blendWeights.w
					) / blendWeightsTotal;

					color.g = 
					(
					    pow(texture2DLod(gaux2, refractCoord1.xy, 1).g, (2.2)) * blendWeights.x
					  + pow(texture2DLod(gaux2, refractCoord1.xy, 2).g, (2.2)) * blendWeights.y
					  + pow(texture2DLod(gaux2, refractCoord1.xy, 3).g, (2.2)) * blendWeights.z
					  + pow(texture2DLod(gaux2, refractCoord1.xy, 4).g, (2.2)) * blendWeights.w
					) / blendWeightsTotal;

					color.b = 
					(
					    pow(texture2DLod(gaux2, refractCoord2.xy, 1).b, (2.2)) * blendWeights.x
					  + pow(texture2DLod(gaux2, refractCoord2.xy, 2).b, (2.2)) * blendWeights.y
					  + pow(texture2DLod(gaux2, refractCoord2.xy, 3).b, (2.2)) * blendWeights.z
					  + pow(texture2DLod(gaux2, refractCoord2.xy, 4).b, (2.2)) * blendWeights.w
					) / blendWeightsTotal;
		//*/

		//color = vec3(refractAmount * 0.00001);

		refractionCoord = refractCoord0.xy;
	}
}

vec3 convertScreenSpaceToWorldSpace(vec2 co) {
    vec4 fragposition = gbufferProjectionInverse * vec4(vec3(co, texture2DLod(gdepthtex, co, 0).x) * 2.0 - 1.0, 1.0);
    fragposition /= fragposition.w;
    return fragposition.xyz;
}

vec3 convertCameraSpaceToScreenSpace(vec3 cameraSpace) {
    vec4 clipSpace = gbufferProjection * vec4(cameraSpace, 1.0);
    vec3 NDCSpace = clipSpace.xyz / clipSpace.w;
    vec3 screenSpace = 0.5 * NDCSpace + 0.5;
		 screenSpace.z = 0.1f;
    return screenSpace;
}

vec4 	ComputeRaytraceReflection(vec3 normal, bool edgeClamping)
{
    float initialStepAmount = 1.0 - clamp(0.1f / 100.0, 0.0, 0.99);


    vec2 screenSpacePosition2D = texcoord.st;
    vec3 cameraSpacePosition = convertScreenSpaceToWorldSpace(screenSpacePosition2D);


    //vec3 cameraSpaceNormal = normalize(normal + (rand(texcoord.st + sin(frameTimeCounter)).xyz * 2.0 - 1.0) * 0.05);
    vec3 cameraSpaceNormal = normal;

    vec3 cameraSpaceViewDir = normalize(cameraSpacePosition);
    vec3 cameraSpaceVector = initialStepAmount * normalize(reflect(cameraSpaceViewDir,cameraSpaceNormal));
    vec3 cameraSpaceVectorFar = far * normalize(reflect(cameraSpaceViewDir,cameraSpaceNormal));
	vec3 oldPosition = cameraSpacePosition;
    vec3 cameraSpaceVectorPosition = oldPosition + cameraSpaceVector;
    vec3 currentPosition = convertCameraSpaceToScreenSpace(cameraSpaceVectorPosition);

    const int maxRefinements = 5;
	int numRefinements = 0;
    int count = 0;
	vec2 finalSamplePos = vec2(0.0f);

	int numSteps = 0;

	float finalSampleDepth = 0.0;

    for (int i = 0; i < 40; i++)
    {
        if(
           
           
           -cameraSpaceVectorPosition.z > far * 1.4f ||
           -cameraSpaceVectorPosition.z < 0.0f)
        {
		   break;
		}

        vec2 samplePos = currentPosition.xy;
        float sampleDepth = convertScreenSpaceToWorldSpace(samplePos).z;

        float currentDepth = cameraSpaceVectorPosition.z;
        float diff = sampleDepth - currentDepth;
        float error = length(cameraSpaceVector / pow(2.0f, numRefinements));


        //If a collision was detected, refine raymarch
        if(diff >= 0 && diff <= error * 2.00f && numRefinements <= maxRefinements)
        {
        	//Step back
        	cameraSpaceVectorPosition -= cameraSpaceVector / pow(2.0f, numRefinements);
        	++numRefinements;
		//If refinements run out
		}
		else if (diff >= 0 && diff <= error * 4.0f && numRefinements > maxRefinements)
		{
			finalSamplePos = samplePos;
			finalSampleDepth = sampleDepth;
			break;
		}



        cameraSpaceVectorPosition += cameraSpaceVector / pow(2.0f, numRefinements);

        if (numSteps > 1)
        cameraSpaceVector *= 1.375f;	//Each step gets bigger

		currentPosition = convertCameraSpaceToScreenSpace(cameraSpaceVectorPosition);

		if (edgeClamping)
		{
			currentPosition = clamp(currentPosition, vec3(0.001), vec3(0.999));
		}
		else
		{
			if (currentPosition.x < 0 || currentPosition.x > 1 ||
				currentPosition.y < 0 || currentPosition.y > 1 ||
				currentPosition.z < 0 || currentPosition.z > 1)
			{
				break;
			}
		}



        count++;
        numSteps++;
    }

	vec4 color = vec4(1.0);
	color.rgb = pow(texture2DLod(gaux2, finalSamplePos, 0).rgb, vec3(2.2f));

	if (finalSamplePos.x == 0.0f || finalSamplePos.y == 0.0f) {
		color.a = 0.0f;
	}

	//if (-finalSampleDepth >= far * 0.5)
	//	color.a = 0.0;

	//if (GetSkyMask(finalSamplePos))
		//color.a = 0.0f;


    return color;
}

float RenderSunDisc(vec3 worldDir, vec3 sunDir)
{
	float d = dot(worldDir, sunDir);

	float disc = 0.0;

	//if (d > 0.99)
	//	disc = 1.0;

	float size = 0.00195;
	float hardness = 1000.0;

	disc = pow(curve(saturate((d - (1.0 - size)) * hardness)), 2.0);

	float visibility = curve(saturate(worldDir.y * 30.0));

	disc *= visibility;

	return disc;
}

vec4 ComputeFakeSkyReflection(vec3 dir, vec3 normal, MaterialMask mask, float metallic)
{
	float nightBrightness = 0.00025 * (1.0 + 32.0 * nightVision);


	vec3 worldDir = normalize((gbufferModelViewInverse * vec4(dir.xyz, 0.0)).xyz);

	vec3 sky = AtmosphericScattering(worldDir, worldSunVector, 1.0);
	sky = mix(sky, vec3(0.5) * Luminance(colorSkylight), vec3(rainStrength * 0.95));
	vec3 skyNight = AtmosphericScattering(worldDir, -worldSunVector, 1.0) * nightBrightness;
	skyNight = mix(skyNight, vec3(0.5) * nightBrightness, vec3(rainStrength * 0.95));

	float fresnel = pow(saturate(dot(-dir, normal) + 1.0), 5.0) * 0.98 + 0.02;


	vec3 sunDisc = vec3(RenderSunDisc(worldDir, worldSunVector));
	sunDisc *= normalize(sky + 0.001);
	sunDisc *= 10000.0 * pow(1.0 - rainStrength, 5.0);

	//if (mask.water > 0.5)

	sunDisc *= saturate(mask.water + metallic);
	sky += sunDisc;



	return vec4((sky + skyNight) * 0.0001, fresnel);
	//return vec4(vec3(0.0001), fresnel);
}

void 	CalculateSpecularReflections(inout vec3 color, vec3 normal, MaterialMask mask, vec3 albedo, float smoothness, float metallic, float skylight, vec3 viewVector, vec2 refractionCoord) {

	float specularity = smoothness * smoothness * smoothness;
	      specularity = max(0.0f, specularity * 1.15f - 0.15f);
	vec3 specularColor = vec3(1.0f);
	//surface.specularity = 1.0f;
	//surface.roughness *= surface.roughness;

	metallic = pow(metallic, 2.2);

	bool defaultItself = true;

	//surface.rDepth = 0.0f;

	if (mask.sky > 0.5)
		specularity = 0.0f;


	if (mask.water > 0.5 || mask.ice > 0.5)
	{
		defaultItself = false;
		specularity = 1.0f;
		metallic = 0.0;
		//surface.roughness = 0.0f;
		//surface.fresnelPower = 6.0f;
		//surface.baseSpecularity = 0.02f;
	}
	else
	{
		// skylight = CurveBlockLightSky(texture2D(gdepth, texcoord.st).g);
	}

	if (mask.stainedGlass > 0.5)
	{
		specularity = 0.0;
	}


	vec3 original = color.rgb;

	if (specularity > 0.00f) 
	{
		if (isEyeInWater > 0 && mask.water > 0.5)
		{
			float totalInternalReflectionMask = texture2D(gaux2, refractionCoord.st).a;
			vec4 reflection = ComputeRaytraceReflection(normal, true);
			reflection.a *= totalInternalReflectionMask;

			color.rgb = mix(color.rgb, reflection.rgb, vec3(reflection.a));

		}
		else
		{
			vec4 reflection = ComputeRaytraceReflection(normal, false);
			//vec4 reflection = vec4(0.0f);

			vec3 reflectVector = reflect(viewVector, normal);

			vec4 fakeSkyReflection = ComputeFakeSkyReflection(reflectVector, normal, mask, metallic);

			vec3 noSkyToReflect = vec3(0.0f);

			if (defaultItself)
			{
				noSkyToReflect = color.rgb;
			}

			fakeSkyReflection.rgb = mix(noSkyToReflect, fakeSkyReflection.rgb, clamp(skylight * 16 - 5, 0.0f, 1.0f));
			reflection.rgb = mix(reflection.rgb, fakeSkyReflection.rgb, pow(vec3(1.0f - reflection.a), vec3(10.1f)));
			reflection.a = fakeSkyReflection.a * specularity;


			//reflection.rgb *= specularColor;
			reflection.a = mix(reflection.a, 1.0, metallic);
			reflection.rgb *= mix(vec3(1.0), albedo.rgb, vec3(metallic));

			color.rgb = mix(color.rgb, reflection.rgb, vec3(reflection.a));
			reflection = reflection;
		}
	}

	//color.rgb = mix(color.rgb, original, vec3(surface.cloudAlpha));
}

void TransparentAbsorption(inout vec3 color, MaterialMask mask, vec4 worldSpacePosition, float waterDepth, float opaqueDepth)
{
	if (mask.stainedGlass > 0.5)
	{
		vec4 transparentAlbedo = texture2D(gaux2, texcoord.st);

		transparentAlbedo.rgb = GammaToLinear(transparentAlbedo.rgb);

		transparentAlbedo.rgb = pow(length(transparentAlbedo.rgb), 0.5) * normalize(transparentAlbedo.rgb + 0.00001);

		color *= transparentAlbedo.rgb * 2.0;
	}

}

// #define FADE_TO_ATMOSPHERE

void LandAtmosphericScattering(inout vec3 color, in vec3 viewPos, in vec3 viewDir, vec3 worldDir, float rayFactor)
{
	float dist = length(viewPos);

	#ifdef FADE_TO_ATMOSPHERE
		float depthFactor = length(viewPos) / far;
		depthFactor = pow(depthFactor, 6.0) * 0.07 + pow(depthFactor, 2.0) * 0.003;
	#else
		float depthFactor = length(viewPos) / 300.0;
		depthFactor = pow(depthFactor, 2.0) * 0.002;
	#endif

		depthFactor *= pow(eyeBrightnessSmooth.y / 240.0f, 6.0f);


	depthFactor = clamp(depthFactor, 0.0, 0.03);
	depthFactor /= saturate(worldDir.y) * 2.0 + 1.0;

	vec3 absorption = vec3(0.2, 0.45, 1.0);

	color *= exp(-depthFactor * absorption * 100.67);
	// color += max(vec3(0.0), vec3(1.0) - exp(-fogFactor * absorption)) * mix(colorSunlight, vec3(dot(colorSunlight, vec3(0.33333))), vec3(0.9)) * 7.0;

	// float VdotL = dot(viewDir, sunVector);

	// float g = 0.77;
	// 			//float g = 0.9;
	// float g2 = g * g;
	// float theta = VdotL * 0.5 + 0.5;
	// float anisoFactor = 1.5 * ((1.0 - g2) / (2.0 + g2)) * ((1.0 + theta * theta) / (1.0 + g2 - 2.0 * g * theta)) + g * theta;

	

	// color += colorSunlight * fogFactor * 0.2 * anisoFactor;

	// float depthFactor = length(viewPos) / far;
	// depthFactor = pow(depthFactor, 2.0) * 0.04;

	// depthFactor = min(depthFactor, 0.04);

	color += AtmosphericScattering(normalize(worldDir), worldSunVector, 1.0, depthFactor) * 0.9 * mix(rayFactor, 1.0, 0.5) * mix(1.0, 0.35, rainStrength);
}


//Optimize by not needing to do a dot product every time
float MiePhase(float g, vec3 dir, vec3 lightDir)
{
	float VdotL = dot(dir, lightDir);

	float g2 = g * g;
	float theta = VdotL * 0.5 + 0.5;
	float anisoFactor = 1.5 * ((1.0 - g2) / (2.0 + g2)) * ((1.0 + theta * theta) / (1.0 + g2 - 2.0 * g * theta)) + g * theta;

	return anisoFactor;
}

void RainFog(inout vec3 color, in vec3 worldPos, in vec3 worldDir, in float globalCloudShadow)
{

	float dist = length(worldPos);

	float fogDensity = 0.002;
		  fogDensity *= mix(0.0f, 1.0f, pow(eyeBrightnessSmooth.y / 240.0f, 6.0f));
		  fogDensity *= rainStrength;

	fogDensity /= saturate(worldDir.y) * 2.0 + 0.8;

	float fogFactor = pow(1.0 - exp(-dist * fogDensity), 2.0);

	// vec3 fogColor = vec3(dot(colorSkylight, vec3(0.48)));
	vec3 fogColor = mix(colorSkylight, colorSunlight * 4.0, vec3(0.5));

	fogColor *= saturate(worldDir.y * 0.3 + 0.7);

	fogColor += MiePhase(0.75, worldDir, worldLightVector) * colorSunlight * 1.0 * globalCloudShadow;



	color = mix(color, fogColor, vec3(fogFactor * 0.57 * rainStrength));
	// color += fogColor * fogFactor * 0.7 * rainStrength;


}

void BlindnessFog(inout vec3 color, in vec3 viewPos, in vec3 viewDir)
{
	if (blindness < 0.001)
	{
		return;
	}
	float dist = length(viewPos);

	float fogDensity = 1.0 * blindness;
	
	float fogFactor = pow(1.0 - exp(-dist * fogDensity), 2.0);

	vec3 fogColor = vec3(0.0);

	color = mix(color, fogColor, vec3(fogFactor));
}








vec3 WorldToShadowProjPos(vec3 worldPos)
{
	vec4 shadowPos = vec4(worldPos, 1.0);

	shadowPos = shadowModelView * shadowPos;	//Transform from world space to shadow space
	float comparedepth = -shadowPos.z;				//Surface distance from sun to be compared to the shadow map

	shadowPos = shadowProjection * shadowPos;
	shadowPos /= shadowPos.w;

	float dist = sqrt(shadowPos.x * shadowPos.x + shadowPos.y * shadowPos.y);
	float distortFactor = (1.0f - SHADOW_MAP_BIAS) + dist * SHADOW_MAP_BIAS;
	shadowPos.xy *= 0.95f / distortFactor;
	shadowPos.z = mix(shadowPos.z, 0.5, 0.8);
	shadowPos = shadowPos * 0.5f + 0.5f;		//Transform from shadow space to shadow map coordinates

	return shadowPos.xyz;
}


void CrepuscularRays(inout vec3 color, vec3 worldPos, vec3 worldDir, float rainMask, float globalCloudShadow, out float rayFactor)
{
	// float airMoisture = texture2D(noisetex, vec2(frameTimeCounter * 0.01)).x;'
	float airMoisture = 1.0;


	vec3 originPos = GetViewPosition(texcoord.st, 0.5).xyz;
	originPos = (gbufferModelViewInverse * vec4(originPos.xyz, 1.0)).xyz;

	vec3 camPos = (gbufferModelViewInverse * vec4(0.0, 0.0, 0.0, 1.0)).xyz;

	float sum = 0.0;

	float stepSize = 4.0;

	// float dither = dot(rand(texcoord.st + sin(frameTimeCounter)).xyz, vec3(0.33333)) * 4.0;
	float dither = BlueNoise(texcoord.st) * 5.0;
	dither = 0.0;
	// float dither = rand(texcoord.st + sin(frameTimeCounter)).x * 4.0;

	rayFactor = 0.0;

	float noiseSum = 0.0;


	// rainMask = 1.0;
	float sparkliness = mix(2.0, 3.0, dot(worldDir, worldLightVector) * 0.5 + 0.5);
	float sparkleNoise = Get3DNoise(worldDir * 170.0 * vec3(1.0, 0.1, 1.0) + vec3(frameTimeCounter * 310.0) * vec3(1.0, 0.5, 0.25));
	float rainSparkleSunlight = rainMask * 0.25 / (pow(sparkleNoise, sparkliness) * 40.0 + 0.001) * 1.0;


	#if 0

	for (int i = 0; i < 8; i++)
	{
		float step = (i + dither) * stepSize;
		vec3 rayPos = (originPos - camPos) * step + camPos;
		vec3 rayPosShadow = WorldToShadowProjPos(rayPos);

		float depthDiff = length(worldPos - camPos) - length(rayPos - camPos);
		float depthFade = 1.0;
		if (depthDiff < 0.0)
		{
			break;
		}

		float shadowSample = shadow2DLod(shadow, vec3(rayPosShadow.xy, rayPosShadow.z), 3).x;
		float noiseSample = 1.0;
		// float noiseSample = Get3DNoise((rayPos + cameraPosition + frameTimeCounter) * 0.5) * 1.0 + 0.0;
		// noiseSample += Get3DNoise((rayPos + cameraPosition + frameTimeCounter * 0.3) * 2.0) * 0.75;
		// noiseSample += Get3DNoise((rayPos + cameraPosition + frameTimeCounter * 0.3) * 0.15) * 10.0;

		// noiseSample += rainSparkleSunlight * 15.0;


		// float groundDensity = pow(saturate((85.0 - (rayPos + cameraPosition).y) * 0.025), 3.0) * 16.0;
		// noiseSample *= groundDensity;


		sum += shadowSample * noiseSample * stepSize * depthFade;
		rayFactor += shadowSample * stepSize * depthFade;
		noiseSum += noiseSample * stepSize * depthFade;

		stepSize *= 1.24;
	}

	sum /= 16 * 4.0;
	rayFactor /= 16 * 4.0;
	noiseSum /= 16 * 4.0;


	float anisoFactor = MiePhase(0.8, worldDir, worldLightVector) + MiePhase(0.5, worldDir, -worldLightVector) * 0.1;


	float density = 1.0;

	density *= airMoisture;
	// density += rainSparkleSunlight * 12.0;


	density *= globalCloudShadow * 0.9 + 0.1;


	// color += sum * colorSunlight * 1.1 * anisoFactor * density;
	color += rainSparkleSunlight * 12.0 * colorSunlight * sum * anisoFactor * 0.2 * globalCloudShadow;
	// color += noiseSum * FromSH(skySHR, skySHG, skySHB, vec3(0.0, 1.0, 0.0)) * 0.005 * density;
	#else
	color += rainSparkleSunlight * 6.0 * colorSunlight * (MiePhase(0.8, worldDir, worldLightVector) + MiePhase(0.5, worldDir, -worldLightVector)) * 0.1 * pow(globalCloudShadow, 0.3);
	#endif
}


















/////////////////////////MAIN//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////MAIN//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void main() 
{

	GBufferData gbuffer 						= GetGBufferData();
	GBufferDataTransparent gbufferTransparent	= GetGBufferDataTransparent();
	MaterialMask materialMask 					= CalculateMasks(gbuffer.materialID);
	MaterialMask materialMaskTransparent 		= CalculateMasks(gbufferTransparent.materialID);

	materialMask.water = materialMaskTransparent.water;
	materialMask.stainedGlass = materialMaskTransparent.stainedGlass;
	materialMask.ice = materialMaskTransparent.ice;

	vec4 viewPos 					= GetViewPosition(texcoord.st, gbufferTransparent.depth);
	vec4 worldPos					= gbufferModelViewInverse * vec4(viewPos.xyzw);
	vec4 worldPosZero				= gbufferModelViewInverse * vec4(viewPos.xyz, 0.0);
	vec3 viewDir 					= normalize(viewPos.xyz);

	vec3 worldDir 					= normalize(worldPosZero.xyz);
	vec3 worldNormal 				= normalize((gbufferModelViewInverse * vec4(gbuffer.normal, 0.0)).xyz);
	vec3 worldTransparentNormal 	= normalize((gbufferModelViewInverse * vec4(GetWaterNormals(texcoord.st), 0.0)).xyz);


	gbuffer.normal = normalize(gbuffer.normal - viewDir.xyz * (1.0 / (saturate(dot(gbuffer.normal, -viewDir.xyz)) + 0.01) ) * 0.0025);


	vec3 color = GammaToLinear(texture2D(gaux2, texcoord.st).rgb);


	color *= 1.0 - gbuffer.rainMask * 0.2;


	if (materialMask.water > 0.5 || materialMask.ice > 0.5)
	{
		gbuffer.mcLightmap = gbufferTransparent.mcLightmap;
	}


	if (materialMask.water > 0.5 || materialMask.ice > 0.5)
	{
		gbuffer.normal = gbufferTransparent.normal;

		FixNormals(gbuffer.normal, viewPos.xyz);
	}

	float opaqueDepth = ExpToLinearDepth(gbuffer.depth);
	float waterDepth = ExpToLinearDepth(gbufferTransparent.depth);

	vec2 refractionCoord;

	WaterRefraction(color, materialMask, worldPos, waterDepth, opaqueDepth, refractionCoord);

	TransparentAbsorption(color, materialMask, worldPos, waterDepth, opaqueDepth);


	{
		CalculateSpecularReflections(color, gbuffer.normal, materialMask, gbuffer.albedo.rgb, gbuffer.smoothness, gbuffer.metalness, gbuffer.mcLightmap.g, viewDir, refractionCoord);
	}

	color /= 0.0001;

	color += gbuffer.rainMask * colorSkylight * 0.025;

	float rayFactor = 1.0;
	// float rayFactor;

	//Push sky back
	if (gbuffer.depth > 0.99999)
	{
		worldPos.xyz *= 10000.0;
	}


	if (materialMask.sky < 0.5)
	{
		LandAtmosphericScattering(color, viewPos.xyz, viewDir.xyz, worldDir.xyz, rayFactor);
		if (isEyeInWater == 0)
		{
			RainFog(color, worldPos.xyz, worldDir.xyz, globalCloudShadow);
		}
	}






	// VolumetricClouds(color, worldPos.xyz, worldDir.xyz);


	CrepuscularRays(color, worldPos.xyz, worldDir.xyz, gbuffer.rainMask, globalCloudShadow, rayFactor);

	BlindnessFog(color, viewPos.xyz, viewDir);



	color *= 0.0001;







	color = LinearToGamma(color);



	gl_FragData[0] = vec4(color.rgb, 1.0);
}
