#version 330 compatibility

/*
 _______ _________ _______  _______  _
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/

/////////////////////////CONFIGURABLE VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////CONFIGURABLE VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////






#define SHADOW_MAP_BIAS 0.9

#define VARIABLE_PENUMBRA_SHADOWS	// Contact-hardening (area) shadows

#define GI_RENDER_RESOLUTION 1 // Render resolution of GI. 0 = High. 1 = Low. Set to 1 for faster but blurrier GI. [0 1]

#define RAYLEIGH_AMOUNT 1.0 // Density of atmospheric scattering. [0.5 1.0 1.5 2.0 3.0 4.0]

#define WATER_REFRACT_IOR 1.2

#define TORCHLIGHT_FILL 1.0 // Amount of fill/ambient light to add to torchlight falloff. Higher values makes torchlight dim less intensely based on distance. [0.5 1.0 2.0 4.0 8.0]

#define TORCHLIGHT_BRIGHTNESS 1.0 // Brightness of torch light. [0.5 1.0 2.0 3.0 4.0]

#define SUNLIGHT_INTENSITY 1.0 // Intensity of sunlight. [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.2 2.4 2.6 2.8 3.0]

#define COLORED_SHADOWS // Colored shadows from stained glass.

#define BIOME_FOREST 4

#define VC_MARCHING 1 // Volumetric Clouds marching technique. 1 provides long render distance but is not fly-through-able. 0 is shorter in render distance, but allows for flight through clouds. [1 0]


const int 		shadowMapResolution 	= 2048;	// Shadowmap resolution [1024 2048 4096]
const float 	shadowDistance 			= 120.0; // Shadow distance. Set lower if you prefer nicer close shadows. Set higher if you prefer nicer distant shadows. [80.0 120.0 180.0 240.0]
const float 	shadowIntervalSize 		= 4.0f;
const bool 		shadowHardwareFiltering0 = true;

const bool 		shadowtex0Mipmap = true;
const bool 		shadowtex1Mipmap = true;
const bool 		shadowtex1Nearest = false;
const bool 		shadowcolor0Mipmap = true;
const bool 		shadowcolor0Nearest = false;
const bool 		shadowcolor1Mipmap = true;
const bool 		shadowcolor1Nearest = false;

const float shadowDistanceRenderMul = 1.0f;

const int 		RGB8 					= 0;
const int 		RGBA8 					= 0;
const int 		RGBA16 					= 0;
const int 		RGBA32F 				= 0;
const int 		RG16 					= 0;
const int 		RGB16 					= 0;
const int 		gcolorFormat 			= RGBA16;
const int 		gdepthFormat 			= RGBA16;
const int 		gnormalFormat 			= RGBA16;
const int 		compositeFormat 		= RGBA16;
const int 		gaux1Format 			= RGBA16;
const int 		gaux2Format 			= RGBA16;
const int 		gaux3Format 			= RGBA16;
const int 		gaux4Format 			= RGBA16;


const int 		superSamplingLevel 		= 0;

const float		sunPathRotation 		= -40.0f;

const int 		noiseTextureResolution  = 64;

const float 	ambientOcclusionLevel 	= 0.005f;


const bool gaux2MipmapEnabled = true;

const bool gaux4Clear = false;
const bool gaux2Clear = false;

const float wetnessHalflife = 1.0;
const float drynessHalflife = 60.0;

/* DRAWBUFFERS:5 */



in vec4 texcoord;
in vec3 lightVector;
in vec3 sunVector;
in vec3 upVector;
in vec3 worldSunVector;
in vec3 worldLightVector;

in float timeSunriseSunset;
in float timeNoon;
in float timeMidnight;

in vec3 colorSunlight;
in vec3 colorSkylight;
in vec3 colorTorchlight;

in vec4 skySHR;
in vec4 skySHG;
in vec4 skySHB;

in float contextualFogFactor;
in float heldLightBlacklist;

in vec3 upperCloudSunlightColor;


#include "Uniforms.inc"
#include "Common.inc"
#include "GBufferData.inc"


in CloudProperties cloudProperties;

/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////







vec3 	CalculateNoisePattern1(vec2 offset, float size) 
{
	vec2 coord = texcoord.st;

	coord *= vec2(viewWidth, viewHeight);
	coord = mod(coord + offset, vec2(size));
	coord /= noiseTextureResolution;

	return texture2D(noisetex, coord).xyz;
}






vec3 CalculateSunlightVisibility(vec4 screenSpacePosition, MaterialMask mask) {				//Calculates shadows
	// if (rainStrength >= 0.99f)
	// 	return vec3(1.0f);



	//if (shadingStruct.direct > 0.0f) {
		float distance = sqrt(  screenSpacePosition.x * screenSpacePosition.x 	//Get surface distance in meters
							  + screenSpacePosition.y * screenSpacePosition.y
							  + screenSpacePosition.z * screenSpacePosition.z);

		vec4 ssp = screenSpacePosition;

		// if (isEyeInWater > 0.5)
		// {
		// 	ssp.xy *= 0.82;
		// }

		vec4 worldposition = vec4(0.0f);
			 worldposition = gbufferModelViewInverse * ssp;		//Transform from screen space to world space


		float yDistanceSquared  = worldposition.y * worldposition.y;

		worldposition = shadowModelView * worldposition;	//Transform from world space to shadow space
		float comparedepth = -worldposition.z;				//Surface distance from sun to be compared to the shadow map

		worldposition = shadowProjection * worldposition;
		worldposition /= worldposition.w;

		float dist = sqrt(worldposition.x * worldposition.x + worldposition.y * worldposition.y);
		float distortFactor = (1.0f - SHADOW_MAP_BIAS) + dist * SHADOW_MAP_BIAS;
		worldposition.xy *= 0.95f / distortFactor;
		worldposition.z = mix(worldposition.z, 0.5, 0.8);
		worldposition = worldposition * 0.5f + 0.5f;		//Transform from shadow space to shadow map coordinates

		float shadowMult = 0.0f;																			//Multiplier used to fade out shadows at distance
		float shading = 0.0f;

		float fademult = 0.15f;
			shadowMult = clamp((shadowDistance * 1.4f * fademult) - (distance * fademult), 0.0f, 1.0f);	//Calculate shadowMult to fade shadows out

		if (shadowMult > 0.0) 
		{

			float diffthresh = dist * 1.0f + 0.10f;
				  diffthresh *= 1.5f / (shadowMapResolution / 2048.0f);
				  //diffthresh /= shadingStruct.direct + 0.1f;


			#ifdef PIXEL_SHADOWS
				  //diffthresh += 1.5;
			#endif


			#ifdef ENABLE_SOFT_SHADOWS
			#ifndef VARIABLE_PENUMBRA_SHADOWS

				int count = 0;
				float spread = 1.0f / shadowMapResolution;

				vec3 noise = CalculateNoisePattern1(vec2(0.0), 64.0);

				for (float i = -0.5f; i <= 0.5f; i += 1.0f) 
				{
					for (float j = -0.5f; j <= 0.5f; j += 1.0f) 
					{
						float angle = noise.x * 3.14159 * 2.0;

						mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

						vec2 coord = vec2(i, j) * rot;

						shading += shadow2DLod(shadow, vec3(worldposition.st + coord * spread, worldposition.z - 0.0008f * diffthresh), 0).x;
						count += 1;
					}
				}
				shading /= count;

			#endif
			#endif

			#ifdef VARIABLE_PENUMBRA_SHADOWS

				float vpsSpread = 0.145 / distortFactor;

				float avgDepth = 0.0;
				float minDepth = 11.0;
				int c;

				for (int i = -1; i <= 1; i++)
				{
					for (int j = -1; j <= 1; j++)
					{
						vec2 lookupCoord = worldposition.xy + (vec2(i, j) / shadowMapResolution) * 8.0 * vpsSpread;
						//avgDepth += pow(texture2DLod(shadowtex1, lookupCoord, 2).x, 4.1);
						float depthSample = texture2DLod(shadowtex1, lookupCoord, 2).x;
						minDepth = min(minDepth, depthSample);
						avgDepth += pow(min(max(0.0, worldposition.z - depthSample) * 1.0, 0.025), 2.0);
						c++;
					}
				}

				avgDepth /= c;
				avgDepth = pow(avgDepth, 1.0 / 2.0);

				// float penumbraSize = min(abs(worldposition.z - minDepth), 0.15);
				float penumbraSize = avgDepth;

				// if (mask.leaves > 0.5)
				// {
				// 	penumbraSize = 0.02;
				// 	diffthresh *= 2.0;
				// }

				int count = 0;
				float spread = penumbraSize * 0.125 * vpsSpread + 0.25 / shadowMapResolution;
				spread += dist * 2.0 / shadowMapResolution;

				//vec3 noise = CalculateNoisePattern1(vec2(0.0 + sin(frameTimeCounter)), 64.0);
				#ifdef TAA_ENABLED
					vec2 noise = rand(texcoord.st + sin(frameTimeCounter)).xy;
					// vec2 noise = BlueNoiseXY(texcoord.st);
				#else
					// vec2 noise = BlueNoiseXY(texcoord.st);
					vec2 noise = rand(texcoord.st).xy;
				#endif

				// worldposition.z -= (1.0 / shadowMapResolution) * noise.x * dist;

				diffthresh *= 0.5 + avgDepth * 50.0;

				for (float i = -1.5f; i <= 1.5f; i += 1.0f) 
				{
					for (float j = -1.5f; j <= 1.5f; j += 1.0f) 
					{
						float angle = noise.x * 3.14159 * 2.0;

						mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

						vec2 coord = vec2(i + noise.y - 0.5, j + noise.y - 0.5) * rot;

						shading += shadow2DLod(shadow, vec3(worldposition.st + coord * spread, worldposition.z - 0.0012f * diffthresh), 0).x;
						count += 1;
					}
				}
				shading /= count;

				// float clampFactor = (1.0 / (penumbraSize * 2000.0 + 0.001)) + 1.0;
				// shading = saturate(((shading * 2.0 - 1.0) * clampFactor) * 0.5 + 0.5);

			#endif

			#ifndef VARIABLE_PENUMBRA_SHADOWS
			#ifndef ENABLE_SOFT_SHADOWS
				//diffthresh *= 2.0f;
				shading = shadow2DLod(shadow, vec3(worldposition.st, worldposition.z - 0.0006f * diffthresh), 0).x;
			#endif
			#endif

		}

		//shading = mix(1.0f, shading, shadowMult);

		//surface.shadow = shading;

		float clampFactor = max(0.0, dist - 0.1) * 5.0 + 1.0;
		shading = saturate(((shading * 2.0 - 1.0) * clampFactor) * 0.5 + 0.5);

		vec3 result = vec3(shading);


		///*
		#ifdef COLORED_SHADOWS

		float shadowNormalAlpha = texture2DLod(shadowcolor1, worldposition.st, 0).a;

		if (shadowNormalAlpha < 0.1)
		{
			#ifdef TAA_ENABLED
				vec2 noise = rand(texcoord.st + sin(frameTimeCounter)).xy;
			#else
				vec2 noise = rand(texcoord.st).xy;
			#endif

			float angle = noise.x * 3.14159 * 2.0;
			mat2 rot = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));

			float solidShadowSum = 0.0;
			vec3 shadowColorSampleSum = vec3(0.0);

			int c = 0;

			for (float i = -1.5f; i <= 1.5f; i += 1.0f) 
			{
				for (float j = -1.5f; j <= 1.5f; j += 1.0f) 
				{
					// worldposition.st += (vec2(i, j) * rot) * (0.5 / shadowMapResolution);
					worldposition.st += (vec2(i + noise.y - 0.5, j + noise.y - 0.5) * rot) * (0.5 / shadowMapResolution);

					vec4 shadowColorSample = texture2DLod(shadowcolor, worldposition.st, 0);
					float opacityCheck = 1.0 - saturate(pow(shadowColorSample.a * 1.1, 4.0));
					// result = mix(vec3(1.0), pow(shadowColorSample.rgb, vec3(1.6)) * (opacityCheck), vec3(1.0 - shading));
					shadowColorSampleSum += pow(shadowColorSample.rgb, vec3(1.6)) * (opacityCheck);
					float solidDepth = texture2DLod(shadowtex1, worldposition.st, 0).x;
					float solidShadow = 1.0 - clamp((worldposition.z - solidDepth) * 5200.0, 0.0, 1.0); 
					solidShadowSum += solidShadow;
					// result *= solidShadow;
					c++;
				}
			}

			solidShadowSum /= c;
			shadowColorSampleSum /= c;

			result = mix(vec3(1.0), shadowColorSampleSum.rgb, vec3(1.0 - shading));
			result *= solidShadowSum;
		}
		#endif
		//*/

		result = mix(vec3(1.0), result, shadowMult);

		//result = pow(result, vec3(0.1));
		//result = smoothstep(vec3(0.0), vec3(1.0), result);


		return result;
	//} else {
	//	return vec3(0.0f);
	//}
}

float RenderSunDisc(vec3 worldDir, vec3 sunDir)
{
	float d = dot(worldDir, sunDir);

	float disc = 0.0;

	//if (d > 0.99)
	//	disc = 1.0;

	float size = 0.00195;
	float hardness = 1000.0;

	disc = pow(curve(saturate((d - (1.0 - size)) * hardness)), 2.0);

	float visibility = curve(saturate(worldDir.y * 30.0));

	disc *= visibility;

	return disc;
}


vec4 BilateralUpsample(const in float scale, in vec2 offset, in float depth, in vec3 normal)
{
	vec2 recipres = vec2(1.0f / viewWidth, 1.0f / viewHeight);

	vec4 light = vec4(0.0f);
	float weights = 0.0f;

	for (float i = -0.5f; i <= 0.5f; i += 1.0f)
	{
		for (float j = -0.5f; j <= 0.5f; j += 1.0f)
		{
			vec2 coord = vec2(i, j) * recipres * 2.0f;

			float sampleDepth = GetDepthLinear(texcoord.st + coord * 2.0f * (exp2(scale)));
			vec3 sampleNormal = GetNormals(texcoord.st + coord * 2.0f * (exp2(scale)));
			//float weight = 1.0f / (pow(abs(sampleDepth - depth) * 1000.0f, 2.0f) + 0.001f);
			float weight = clamp(1.0f - abs(sampleDepth - depth) / 2.0f, 0.0f, 1.0f);
				  weight *= max(0.0f, dot(sampleNormal, normal) * 2.0f - 1.0f);
			//weight = 1.0f;

			light +=	pow(texture2DLod(gaux2, (texcoord.st) * (1.0f / exp2(scale )) + 	offset + coord, 1), vec4(2.2f, 2.2f, 2.2f, 1.0f)) * weight;

			weights += weight;
		}
	}


	light /= max(0.00001f, weights);

	if (weights < 0.01f)
	{
		light =	pow(texture2DLod(gaux2, (texcoord.st) * (1.0f / exp2(scale 	)) + 	offset, 2), vec4(2.2f, 2.2f, 2.2f, 1.0f));
	}


	// vec3 light =	texture2DLod(gcolor, (texcoord.st) * (1.0f / pow(2.0f, 	scale 	)) + 	offset, 2).rgb;


	return light;
}

vec4 GetGI(vec3 albedo, vec3 normal, float depth, float skylight)
{
	depth = ExpToLinearDepth(depth);

	vec4 indirectLight = BilateralUpsample(GI_RENDER_RESOLUTION, vec2(0.0f, 0.0f), 		depth, normal);

	float value = length(indirectLight.rgb);

	indirectLight.rgb = pow(value, 1.0) * normalize(indirectLight.rgb + 0.0001) * 0.8;
	//indirectLight.rgb = mix(indirectLight.rgb, vec3(dot(indirectLight.rgb, vec3(0.3333))), vec3(-0.5));


	indirectLight.rgb = indirectLight.rgb * albedo * colorSunlight;

	indirectLight.rgb *= 1.2f;

	indirectLight.rgb *= 3.0f * saturate(pow(skylight, 0.5) * 1.0);




	return indirectLight;
}

vec3 GetWavesNormal(vec3 position) {

	vec2 coord = position.xz / 50.0;
	coord.xy -= position.y / 50.0;
	//coord -= floor(coord);

	coord = mod(coord, vec2(1.0));


	float texelScale = 4.0;

	//to fix color error with GL_CLAMP
	coord.x = coord.x * ((viewWidth - 1 * texelScale) / viewWidth) + ((0.5 * texelScale) / viewWidth);
	coord.y = coord.y * ((viewHeight - 1 * texelScale) / viewHeight) + ((0.5 * texelScale) / viewHeight);


	vec3 normal;
	//normal.xyz = ((texture2DLod(gaux4, coord, 2).xyz) * 2.0 - 1.0);
	normal.xyz = DecodeNormal(texture2DLod(gaux1, coord, 2).zw);

	return normal;
}

vec3 FakeRefract(vec3 vector, vec3 normal, float ior)
{
	return refract(vector, normal, ior);
	//return vector + normal * 0.5;
}

float CalculateWaterCaustics(vec4 screenSpacePosition, MaterialMask mask)
{
	//if (shading.direct <= 0.0)
	//{
	//	return 0.0;
	//}
	if (isEyeInWater == 1)
	{
		if (mask.water > 0.5)
		{
			return 1.0;
		}
	}
	vec4 worldPos = gbufferModelViewInverse * screenSpacePosition;
	worldPos.xyz += cameraPosition.xyz;

	// vec2 dither = CalculateNoisePattern1(vec2(0.0), 2.0).xy;
	vec2 dither = BlueNoiseXY(texcoord.st).xy;
	// float waterPlaneHeight = worldPos.y + 8.0;
	float waterPlaneHeight = 63.0;

	// vec4 wlv = shadowModelViewInverse * vec4(0.0, 0.0, 1.0, 0.0);
	vec4 wlv = gbufferModelViewInverse * vec4(lightVector.xyz, 0.0);
	vec3 worldLightVector = -normalize(wlv.xyz);
	// worldLightVector = normalize(vec3(-1.0, 1.0, 0.0));

	float pointToWaterVerticalLength = min(abs(worldPos.y - waterPlaneHeight), 2.0);
	vec3 flatRefractVector = FakeRefract(worldLightVector, vec3(0.0, 1.0, 0.0), 1.0 / 1.3333);
	float pointToWaterLength = pointToWaterVerticalLength / -flatRefractVector.y;
	vec3 lookupCenter = worldPos.xyz - flatRefractVector * pointToWaterLength;


	const float distanceThreshold = 0.15;

	const int numSamples = 1;
	int c = 0;

	float caustics = 0.0;

	for (int i = -numSamples; i <= numSamples; i++)
	{
		for (int j = -numSamples; j <= numSamples; j++)
		{
			vec2 offset = vec2(i + dither.x, j + dither.y) * 0.2;
			vec3 lookupPoint = lookupCenter + vec3(offset.x, 0.0, offset.y);
			// vec3 wavesNormal = normalize(GetWavesNormal(lookupPoint).xzy + vec3(0.0, 1.0, 0.0) * 100.0);
			vec3 wavesNormal = GetWavesNormal(lookupPoint).xzy;
			vec3 refractVector = FakeRefract(worldLightVector.xyz, wavesNormal.xyz, 1.0 / 1.3333);
			float rayLength = pointToWaterVerticalLength / refractVector.y;
			vec3 collisionPoint = lookupPoint - refractVector * rayLength;

			//float dist = distance(collisionPoint, worldPos.xyz);
			float dist = dot(collisionPoint - worldPos.xyz, collisionPoint - worldPos.xyz) * 7.1;

			caustics += 1.0 - saturate(dist / distanceThreshold);

			c++;
		}
	}

	caustics /= c;

	caustics /= distanceThreshold;


	return pow(caustics, 1.0) * 2.0;
}




void WaterFog(inout vec3 color, in MaterialMask mask, float waterSkylight, vec4 viewSpacePositionSolid, vec4 viewSpacePosition)
{
	// return;
	if (mask.water > 0.5 || isEyeInWater > 0 || mask.ice > 0.5)
	{
		//float depth = texture2D(depthtex1, texcoord.st).x;
		//float depthSolid = texture2D(gdepthtex, texcoord.st).x;

		//vec4 viewSpacePosition = GetScreenSpacePosition(texcoord.st, depth);
		//vec4 viewSpacePositionSolid = GetScreenSpacePosition(texcoord.st, depthSolid);

		vec3 viewVector = normalize(viewSpacePosition.xyz);


		float waterDepth = distance(viewSpacePosition.xyz, viewSpacePositionSolid.xyz);
		if (isEyeInWater > 0)
		{
			waterDepth = length(viewSpacePosition.xyz) * 0.5;		
			if (mask.water > 0.5 || mask.ice > 0.5)
			{
				waterDepth = length(viewSpacePosition.xyz) * 0.5;		
			}	
		}


		float fogDensity = 0.20;



		vec3 waterNormal = normalize(GetWaterNormals(texcoord.st));

		// vec3 waterFogColor = vec3(1.0, 1.0, 0.1);	//murky water
		// vec3 waterFogColor = vec3(0.2, 0.95, 0.0) * 1.0; //green water
		// vec3 waterFogColor = vec3(0.4, 0.95, 0.05) * 2.0; //green water
		// vec3 waterFogColor = vec3(0.7, 0.95, 0.00) * 0.75; //green water
		// vec3 waterFogColor = vec3(0.2, 0.95, 0.4) * 5.0; //green water
		// vec3 waterFogColor = vec3(0.2, 0.95, 1.0) * 1.0; //clear water
		vec3 waterFogColor = vec3(0.05, 0.8, 1.0) * 1.0; //clear water
			if (mask.ice > 0.5)
			{
				waterFogColor = vec3(0.2, 0.6, 1.0) * 7.0;
				fogDensity = 0.7;
			}
			  waterFogColor *= 0.01 * dot(vec3(0.33333), colorSunlight);
			  // waterFogColor *= (1.0 - rainStrength * 0.95);
			  waterFogColor *= isEyeInWater * 2.0 + 1.0;



		if (isEyeInWater == 0)
		{
			waterFogColor *= waterSkylight;
		}
		else
		{
			waterFogColor *= 0.5;
			//waterFogColor *= pow(eyeBrightnessSmooth.y / 240.0f, 6.0f);


			vec3 waterSunlightVector = refract(-lightVector, upVector, 1.0 / WATER_REFRACT_IOR);

			//waterFogColor *= (dot(lightVector, viewVector) * 0.5 + 0.5) * 2.0 + 1.0;
			float scatter = 1.0 / (pow(saturate(dot(waterSunlightVector, viewVector) * 0.5 + 0.5) * 30.0, 1.0) + 0.1);
			vec3 waterSunlightScatter = colorSunlight * scatter * 1.0 * waterFogColor * 46.0;

			float eyeWaterDepth = eyeBrightnessSmooth.y / 240.0;


			waterFogColor *= dot(viewVector, upVector) * 0.5 + 0.5;
			waterFogColor = waterFogColor * pow(eyeWaterDepth, 1.0f) + waterSunlightScatter * pow(eyeWaterDepth, 1.0);
			//waterFogColor = waterFogColor + waterSunlightScatter;
		

			waterFogColor *= pow(vec3(0.4, 0.72, 1.0) * 0.99, vec3(0.2 + (1.0 - eyeWaterDepth)));

			fogDensity *= 0.5;
		}


		float visibility = 1.0f / (pow(exp(waterDepth * fogDensity), 1.0f));
		float visibility2 = 1.0f / (pow(exp(waterDepth * fogDensity), 1.0f));


		// float scatter = CalculateSunglow(surface);

		vec3 viewVectorRefracted = refract(viewVector, waterNormal, 1.0 / 1.3333);
		float scatter = 1.0 / (pow(saturate(dot(-lightVector, viewVectorRefracted) * 0.5 + 0.5) * 20.0, 2.0) + 0.1);
		//vec3 reflectedLightVector = reflect(lightVector, upVector);
			  //scatter += (1.0 / (pow(saturate(dot(-reflectedLightVector, viewVectorRefracted) * 0.5 + 0.5) * 30.0, 2.0) + 0.1)) * saturate(1.0 - dot(lightVector, upVector) * 1.4);

		// scatter += pow(saturate(dot(-lightVector, viewVectorRefracted) * 0.5 + 0.5), 3.0) * 0.02;
		if (isEyeInWater < 1)
		{
			waterFogColor = mix(waterFogColor, colorSunlight * 21.0 * waterFogColor, vec3(scatter));
		}



		// color *= pow(vec3(0.7, 0.88, 1.0) * 0.99, vec3(waterDepth * 0.45 + 0.2));
		// color *= pow(vec3(0.7, 0.88, 1.0) * 0.99, vec3(waterDepth * 0.45 + 1.0));
		color *= pow(vec3(0.4, 0.75, 1.0) * 0.99, vec3(waterDepth * 0.25 + 0.25));
		// color *= pow(vec3(0.7, 1.0, 0.2) * 0.8, vec3(waterDepth * 0.15 + 0.1));
		color = mix(waterFogColor * 40.0, color, saturate(visibility));





	}
}

float GetAO(vec2 coord, vec3 normal, float dither)
{
	const int numRays = 16;

	const float phi = 1.618033988;
	const float gAngle = phi * 3.14159265 * 1.0003;

	float depth = GetDepth(coord);
	float linDepth = ExpToLinearDepth(depth);
	vec3 origin = GetViewPosition(coord, depth).xyz;

	float aoAccum = 0.0;

	const float radius = 2.0;
	
	for (int i = 0; i < numRays; i++)
	{
		float fi = float(i) + dither;
		float fiN = fi / float(numRays);
		float lon = gAngle * fi * 6.0;
		float lat = asin(fiN * 2.0 - 1.0) * 1.0;

		vec3 kernel;
		kernel.x = cos(lat) * cos(lon);
		kernel.z = cos(lat) * sin(lon);
		kernel.y = sin(lat);

		kernel.xyz = normalize(kernel.xyz + normal.xyz);

		float sampleLength = radius * mod(fiN, 0.07) / 0.07;

		vec3 samplePos = origin + kernel * sampleLength;

		vec3 samplePosProj = ProjectBack(samplePos, texcoord.st);

		/*
		float sampleDepth = ExpToLinearDepth(GetDepth(samplePosProj.xy));

		float kernelAngle = dot(kernel, normal);

		if (sampleDepth < linDepth && kernelAngle > 0.0)
		{
			aoAccum += 1.0 * saturate(kernelAngle) * saturate(abs(sampleDepth - linDepth) * 50.0);
		}
		*/

		vec3 actualSamplePos = GetViewPosition(samplePosProj.xy, GetDepth(samplePosProj.xy)).xyz;

		float depthDiff = actualSamplePos.z - samplePos.z;

		if (depthDiff > 0.0 && depthDiff < 1.0)
		{
			//aoAccum += 1.0 * saturate(depthDiff * 100.0) * saturate(1.0 - depthDiff * 0.25 / (sampleLength + 0.001));
			aoAccum += 1.0;
		}
	}

	aoAccum /= numRays;

	float ao = 1.0 - aoAccum;
	ao = pow(ao, 2.5);

	return ao;
}

float ScreenSpaceShadow(vec3 origin, vec3 normal, MaterialMask mask)
{
	if (mask.sky > 0.5)
	{
		return 1.0;
	}

	// if (isEyeInWater > 0.5)
	// {
	// 	//origin.xy *=
	// }

	// if (isEyeInWater > 0.5)
	// {
	// 	origin.xy /= 0.82;
	// }

	vec3 viewDir = normalize(origin.xyz);


	float nearCutoff = 0.50;
	float traceBias = 0.0015;


	//Prevent self-intersection issues
	float viewDirDiff = dot(fwidth(viewDir), vec3(0.333333));


	vec3 rayPos = origin;
	vec3 rayDir = lightVector * 0.01;
	rayDir *= viewDirDiff * 1500.001;
	rayDir *= -origin.z * 0.28 + nearCutoff;


	rayPos += rayDir * -origin.z * 0.000037 * traceBias;


#ifdef TAA_ENABLED
	float randomness = rand(texcoord.st + sin(frameTimeCounter)).x;
	// randomness = 0.0;
#else
	float randomness = 0.0;
#endif

	rayPos += rayDir * randomness;



	float zThickness = 0.025 * -origin.z;

	float shadow = 1.0;

	float numSamplesf = 64.0;
	//numSamplesf /= -origin.z * 0.125 + nearCutoff;

	int numSamples = int(numSamplesf);


	float shadowStrength = 0.9;

	if (mask.grass > 0.5)
	{
		shadowStrength = 0.4;
	}
	if (mask.leaves > 0.5)
	{
		shadowStrength = 1.0 - exp(origin.z * 0.01);
	}

	// vec3 prevRayProjPos = ProjectBack(rayPos);

	for (int i = 0; i < 8; i++)
	{
		float fi = float(i) / float(8);

		rayPos += rayDir;

		vec3 rayProjPos = ProjectBack(rayPos, texcoord.st);


		// rayProjPos *= -1.0;
		rayProjPos.xy *= 2.0;
		TemporalJitterProjPos(rayProjPos);
		rayProjPos.xy /= 2.0;
		// rayProjPos *= -1.0;




		// vec2 pixelPos = floor(rayProjPos.xy * vec2(viewWidth, viewHeight));
		// vec2 pixelPosPrev = floor(prevRayProjPos.xy * vec2(viewWidth, viewHeight));
		// if (pixelPos.x == pixelPosPrev.x || pixelPos.y == pixelPosPrev.y)
		// {
		// 	continue;
		// }

		// prevRayProjPos = rayProjPos;

		/*
		float sampleDepth = GetDepthLinear(rayProjPos.xy);

		float depthDiff = -rayPos.z - sampleDepth;
		*/

		vec3 samplePos = GetViewPositionRaw(rayProjPos.xy, GetDepth(rayProjPos.xy)).xyz;

		float depthDiff = samplePos.z - rayPos.z - 0.02 * -origin.z * traceBias;

		if (depthDiff > 0.0 && depthDiff < zThickness)
		{
			shadow *= 1.0 - shadowStrength;
		}
	}

	return shadow;
}


float OrenNayar(vec3 normal, vec3 eyeDir, vec3 lightDir)
{
	const float PI = 3.14159;
	const float roughness = 0.55;

	// interpolating normals will change the length of the normal, so renormalize the normal.



	// normal = normalize(normal + surface.lightVector * pow(clamp(dot(eyeDir, surface.lightVector), 0.0, 1.0), 5.0) * 0.5);

	// normal = normalize(normal + eyeDir * clamp(dot(normal, eyeDir), 0.0f, 1.0f));

	// calculate intermediary values
	float NdotL = dot(normal, lightDir);
	float NdotV = dot(normal, eyeDir);

	float angleVN = acos(NdotV);
	float angleLN = acos(NdotL);

	float alpha = max(angleVN, angleLN);
	float beta = min(angleVN, angleLN);
	float gamma = dot(eyeDir - normal * dot(eyeDir, normal), lightDir - normal * dot(lightDir, normal));

	float roughnessSquared = roughness * roughness;

	// calculate A and B
	float A = 1.0 - 0.5 * (roughnessSquared / (roughnessSquared + 0.57));

	float B = 0.45 * (roughnessSquared / (roughnessSquared + 0.09));

	float C = sin(alpha) * tan(beta);

	// put it all together
	float L1 = max(0.0, NdotL) * (A + B * max(0.0, gamma) * C);

	//return max(0.0f, surface.NdotL * 0.99f + 0.01f);
	return clamp(L1, 0.0f, 1.0f);
}


void LandAtmosphericScattering(inout vec3 color, in vec3 viewPos, in vec3 viewDir)
{
	float dist = length(viewPos);

	float fogDensity = 0.003 * RAYLEIGH_AMOUNT;
	float fogFactor = pow(1.0 - exp(-dist * fogDensity), 2.0);


	vec3 absorption = vec3(0.2, 0.45, 1.0);

	color *= exp(-dist * absorption * fogDensity * 0.27);
	color += max(vec3(0.0), vec3(1.0) - exp(-fogFactor * absorption)) * mix(colorSunlight, vec3(dot(colorSunlight, vec3(0.33333))), vec3(0.9)) * 2.0;

	float VdotL = dot(viewDir, sunVector);

	float g = 0.72;
				//float g = 0.9;
	float g2 = g * g;
	float theta = VdotL * 0.5 + 0.5;
	float anisoFactor = 1.5 * ((1.0 - g2) / (2.0 + g2)) * ((1.0 + theta * theta) / (1.0 + g2 - 2.0 * g * theta)) + g * theta;

	color += colorSunlight * fogFactor * 0.2 * anisoFactor;

}

void ContextualFog(inout vec3 color, in vec3 viewPos, in vec3 viewDir, float density)
{
	float dist = length(viewPos);

	float fogDensity = density * 0.019;
		  fogDensity *= 1.0 -  saturate(viewDir.y * 0.5 + 0.5) * exp(-density * 0.125);
		  fogDensity *= mix(0.0f, 1.0f, pow(eyeBrightnessSmooth.y / 240.0f, 6.0f));

	float fogFactor = pow(1.0 - exp(-dist * fogDensity), 1.6);
		  //fogFactor = 1.0 -  saturate(viewDir.y * 0.5 + 0.5);




	vec3 fogColor = pow(gl_Fog.color.rgb, vec3(2.2));


	float VdotL = dot(viewDir, worldSunVector);

	float g = 0.72;
				//float g = 0.9;
		  //g = exp(-density) * 0.4 + 0.5;

	float g2 = g * g;
	float theta = VdotL * 0.5 + 0.5;
	float anisoFactor = 1.5 * ((1.0 - g2) / (2.0 + g2)) * ((1.0 + theta * theta) / (1.0 + g2 - 2.0 * g * theta)) + g * theta;


	float skyFactor = pow(saturate(viewDir.y * 0.5 + 0.5), 2.0);
		  //skyFactor = skyFactor * (3.0 - 2.0 * skyFactor);

	fogColor = colorSunlight * anisoFactor * (1.0 - rainStrength) + skyFactor * colorSkylight * 2.0;

	fogColor *= exp(-density * 1.5) * 2.0;

	color = mix(color, fogColor, fogFactor);

}





float GetCoverage(in float coverage, in float density, in float clouds)
{
	clouds = clamp(clouds - (1.0f - coverage), 0.0f, 1.0f -density) / (1.0f - density);
		clouds = max(0.0f, clouds * 1.1f - 0.1f);
	 clouds = clouds = clouds * clouds * (3.0f - 2.0f * clouds);
	 // clouds = pow(clouds, 1.0f);
	return clouds;
}

float   CalculateSunglow(vec3 npos, vec3 lightVector) {

	float curve = 4.0f;

	vec3 halfVector2 = normalize(-lightVector + npos);
	float factor = 1.0f - dot(halfVector2, npos);

	return factor * factor * factor * factor;
}

vec4 CloudColor(in vec4 worldPosition, in float sunglow, in vec3 worldLightVector, in float altitude, in float thickness, const bool isShadowPass)
{
	float eyeLength = length(worldPosition.xyz - cameraPosition);

	float cloudHeight = altitude;
	float cloudDepth  = thickness;
	float cloudUpperHeight = cloudHeight + (cloudDepth / 2.0f);
	float cloudLowerHeight = cloudHeight - (cloudDepth / 2.0f);

	//worldPosition.xz /= 1.0f + max(0.0f, length(worldPosition.xz - cameraPosition.xz) / 5000.0f);

	vec3 p = worldPosition.xyz / 150.0f;



	float t = frameTimeCounter * 1.0f;
		  t *= 0.5;


	 p += (Get2DNoise(p * 0.5f + vec3(0.0f, t * 0.00f, 0.0f)) * 2.0f - 1.0f) * 0.10f;
	 p.z -= (Get2DNoise(p * 0.25f + vec3(0.0f, t * 0.00f, 0.0f)) * 2.0f - 1.0f) * 0.25f;
	 p.x -= (Get2DNoise(p * 0.125f + vec3(0.0f, t * 0.00f, 0.0f)) * 2.0f - 1.0f) * 2.2f;
	p.xz -= (Get2DNoise(p * 0.0525f + vec3(0.0f, t * 0.00f, 0.0f)) * 2.0f - 1.0f) * 2.7f;


	p.x *= 0.25f;
	p.x -= t * 0.01f;

	vec3 p1 = p * vec3(1.0f, 0.5f, 1.0f)  + vec3(0.0f, t * 0.01f, 0.0f);
	float noise  = 	Get2DNoise(p * vec3(1.0f, 0.5f, 1.0f) + vec3(0.0f, t * 0.01f, 0.0f));	p *= 2.0f;	p.x -= t * 0.057f;	vec3 p2 = p;
		  noise += (2.0f - abs(Get2DNoise(p) * 2.0f - 0.0f)) * (0.15f);						p *= 3.0f;	p.xz -= t * 0.035f;	p.x *= 2.0f;	vec3 p3 = p;
		  noise += (3.0f - abs(Get2DNoise(p) * 3.0f - 0.0f)) * (0.020f);						p *= 3.0f;	p.xz -= t * 0.035f;	vec3 p4 = p;
		  noise += (3.0f - abs(Get2DNoise(p) * 3.0f - 0.0f)) * (0.01f);						p *= 3.0f;	p.xz -= t * 0.035f;
		  if (!isShadowPass)
		  {
		 		noise += ((Get2DNoise(p))) * (0.015f);												p *= 3.0f;
		  		noise += ((Get2DNoise(p))) * (0.009f);
		  }
		  noise /= 1.575f;

	//cloud edge
	float coverage = 0.901f;

		  float dist = length(worldPosition.xz - cameraPosition.xz * 0.5);
		  coverage *= max(0.0f, 1.0f - dist / 14000.0f);
	// float density = 0.1f + rainStrength * 0.3;
	float density = 0.1f;

	if (isShadowPass)
	{
		return vec4(GetCoverage(0.4f, 0.4f, noise));
	}

	noise = GetCoverage(coverage, density, noise);

	const float lightOffset = 0.4f;



	float sundiff = Get2DNoise(p1 + worldLightVector.xyz * lightOffset);
		  sundiff += (2.0f - abs(Get2DNoise(p2 + worldLightVector.xyz * lightOffset / 2.0f) * 2.0f - 0.0f)) * (0.55f);
		  				float largeSundiff = sundiff;
		  				      largeSundiff = -GetCoverage(coverage, 0.0f, largeSundiff * 1.3f);
		  sundiff += (3.0f - abs(Get2DNoise(p3 + worldLightVector.xyz * lightOffset / 5.0f) * 3.0f - 0.0f)) * (0.045f);
		  sundiff += (3.0f - abs(Get2DNoise(p4 + worldLightVector.xyz * lightOffset / 8.0f) * 3.0f - 0.0f)) * (0.015f);
		  sundiff /= 1.5f;

		  sundiff *= max(0.0f, 1.0f - dist / 14000.0f);

		  sundiff = -GetCoverage(coverage * 1.0f, 0.0f, sundiff);
	float secondOrder 	= pow(clamp(sundiff * 1.1f + 1.45f, 0.0f, 1.0f), 4.0f);
	float firstOrder 	= pow(clamp(largeSundiff * 1.1f + 1.66f, 0.0f, 1.0f), 3.0f);



	float directLightFalloff = firstOrder * secondOrder;
	float anisoBackFactor = mix(clamp(pow(noise, 1.6f) * 2.5f, 0.0f, 1.0f), 1.0f, pow(sunglow, 1.0f));

		  directLightFalloff *= anisoBackFactor;
	 	  directLightFalloff *= mix(11.5f, 1.0f, pow(sunglow, 0.5f));

	//noise *= saturate(1.0 - directLightFalloff);

	// vec3 colorDirect = colorSunlight * 31.215f;
	vec3 colorDirect = upperCloudSunlightColor * 22.0;
		 colorDirect = mix(colorDirect, colorDirect * vec3(0.2f, 0.2f, 0.2f), timeMidnight);
		 colorDirect *= 1.0f + pow(sunglow, 2.0f) * 120.0f * pow(directLightFalloff, 1.1f);
		 colorDirect *= 1.0f;


	vec3 colorAmbient = mix(colorSkylight, colorSunlight * 2.0f, vec3(0.15f)) * 0.93f;
		 // colorAmbient = mix(colorAmbient, vec3(0.4) * Luminance(colorSkylight), vec3(rainStrength));
		 colorAmbient *= mix(1.0f, 0.3f, timeMidnight);
		 colorAmbient = mix(colorAmbient, colorAmbient * 3.0f + colorSunlight * 0.05f, vec3(clamp(pow(1.0f - noise, 12.0f) * 1.0f, 0.0f, 1.0f)));




	// directLightFalloff *= mix(1.0, 0.085, rainStrength);

	//directLightFalloff += (pow(Get3DNoise(p3), 2.0f) * 0.5f + pow(Get3DNoise(p3 * 1.5f), 2.0f) * 0.25f) * 0.02f;
	//directLightFalloff *= Get3DNoise(p2);

	vec3 color = mix(colorAmbient, colorDirect, vec3(min(1.0f, directLightFalloff)));

	color *= 1.0f;

	// color = mix(color, color * 0.9, rainStrength);


	//rayleigh absorption
	// color *= exp2(-eyeLength * vec3(0.3, 0.55, 1.0) * 0.007);
	//rayleigh scattering
	// color += (1.0 - exp2(-eyeLength * vec3(0.3, 0.595, 1.7) * 0.0005)) * colorSunlight * 1.0;
	// color += MiePhase(0.8, worldDir, worldLightVector) * colorSunlight * (1.0 - exp(-eyeLength * 0.00025)) * 1.0;

	vec4 result = vec4(color.rgb, noise);

	return result;

}

void CloudPlane(inout vec3 color, vec3 viewDir, vec3 worldVector, float linearDepth, MaterialMask mask, vec3 worldLightVector, vec3 lightVector, float gbufferdepth)
{
	//Initialize view ray
	// vec4 worldPos = gbufferModelViewInverse * (vec4(-GetViewPosition(texcoord.st, gbufferdepth).xyz, 1.0));
	// worldVector = normalize(worldPos.xyz);


	Ray viewRay;

	viewRay.dir = normalize(worldVector.xyz);
	// viewRay.origin = (gbufferModelViewInverse * vec4(0.0, 0.0, 0.0, 1.0)).xyz;
	viewRay.origin = vec3(0.0);

	float sunglow = CalculateSunglow(viewDir, lightVector);



	float cloudsAltitude = 540.0f;
	float cloudsThickness = 150.0f;

	float cloudsUpperLimit = cloudsAltitude + cloudsThickness * 0.5f;
	float cloudsLowerLimit = cloudsAltitude - cloudsThickness * 0.5f;

	float density = 1.0f;

	float planeHeight = cloudsUpperLimit;
	float stepSize = 25.5f;
	planeHeight -= cloudsThickness * 0.85f;


	Plane pl;
	pl.origin = vec3(0.0f, cameraPosition.y - planeHeight, 0.0f);
	pl.normal = vec3(0.0f, 1.0f, 0.0f);

	Intersection intersection = RayPlaneIntersectionWorld(viewRay, pl);

	vec3 original = color.rgb;

	if (intersection.angle < 0.0f)
	{
		if (intersection.distance < linearDepth || mask.sky > 0.5 || linearDepth >= far - 0.1)
		{
			vec4 cloudSample = CloudColor(vec4(intersection.pos.xyz * 0.5f + vec3(30.0f) + vec3(1000.0, 0.0, 0.0), 1.0f), sunglow, worldLightVector, cloudsAltitude, cloudsThickness, false);
			 	 cloudSample.a = min(1.0f, cloudSample.a * density);


			float cloudDist = length(intersection.pos.xyz - cameraPosition.xyz);

			const vec3 absorption = vec3(0.2, 0.4, 1.0);

			cloudSample.rgb *= exp(-cloudDist * absorption * 0.0005 * saturate(1.0 - sunglow * 2.0));

			cloudSample.a *= exp(-cloudDist * (0.0004));


			//cloudSample.rgb *= sin(cloudDist * 0.3) * 0.5 + 0.5;

			color.rgb = mix(color.rgb, cloudSample.rgb * 1.0f, cloudSample.a);

		}
	}
}



float G1V(float dotNV, float k)
{
	return 1.0 / (dotNV * (1.0 - k) + k);
}

vec3 SpecularGGX(vec3 N, vec3 V, vec3 L, float roughness, float F0)
{
	float alpha = roughness * roughness;

	vec3 H = normalize(V + L);

	float dotNL = saturate(dot(N, L));
	float dotNV = saturate(dot(N, V));
	float dotNH = saturate(dot(N, H));
	float dotLH = saturate(dot(L, H));

	float F, D, vis;

	float alphaSqr = alpha * alpha;
	float pi = 3.14159265359;
	float denom = dotNH * dotNH * (alphaSqr - 1.0) + 1.0;
	D = alphaSqr / (pi * denom * denom);

	float dotLH5 = pow(1.0f - dotLH, 5.0);
	F = F0 + (1.0 - F0) * dotLH5;

	float k = alpha / 2.0;
	vis = G1V(dotNL, k) * G1V(dotNV, k);

	vec3 specular = vec3(dotNL * D * F * vis) * colorSunlight;

	//specular = vec3(0.1);
	specular *= saturate(pow(1.0 - roughness, 0.7) * 2.0);

	return specular;
}


































//Optimize by not needing to do a dot product every time
float MiePhase(float g, vec3 dir, vec3 lightDir)
{
	float VdotL = dot(dir, lightDir);

	float g2 = g * g;
	float theta = VdotL * 0.5 + 0.5;
	float anisoFactor = 1.5 * ((1.0 - g2) / (2.0 + g2)) * ((1.0 + theta * theta) / (1.0 + g2 - 2.0 * g * theta)) + g * theta;

	return anisoFactor;
}








vec4 SampleVolumetricClouds(CloudProperties cp, vec3 worldPos, vec3 worldDir, float detailNoise, vec3 atmosphere, float rayIncrementLength)
{
	float eyeLength = length(worldPos - cameraPosition);


	float detailNoiseScaled = mix(detailNoise, 2.7, 1.0 / (eyeLength * 0.00025 + 1.0)) * 0.5;
	float detailNoiseScaled2 = mix(detailNoise, 0.0, 1.0 / (eyeLength * 0.00025 + 1.0)) * 0.5;


	float 	density = GetCloudDensity(cp, worldPos, 1.0, vec2(0.0), false, detailNoiseScaled);
	float softDensity = density;
	 		density = smoothstep(0.0, mix(1.0, 0.01, cp.density), density); 	//final cloud edge resolve


	// vec3 worldPosDetailed = worldPos + worldDir * (detailNoiseScaled2) * 0.0;
	 vec3 worldPosDetailed = worldPos;



	//Early out if no cloud here
	if (density < 0.0001)
	{
		return vec4(0.0, 0.0, 0.0, 0.0);
	}

	float approxHighPoint = cp.altitude + cp.thickness * (cp.coverage + 4.0) * 0.2;
	float approxLowPoint = cp.altitude;
	float vgrad = remap(approxLowPoint, approxHighPoint, worldPosDetailed.y + detailNoise * 0.4);

	float sunAngle = dot(worldLightVector, worldDir) * 0.5 + 0.5;







	//lighting..
	float sunlightExtinction = 0.0;
	float lightingRoughness = 1.0;
	for (int i = 1; i <= 3; i++)
	{
		float fi = float(i) / 2;
		fi = pow(fi, 1.5);
		vec3 checkPos = worldPosDetailed + worldLightVector * fi * 150.0 /*make clouds look denser towards sun * (1.5 - sunAngle)*/;

		float densityCheck = GetCloudDensity(cp, checkPos, lightingRoughness, vec2(0.0, 0.2), true, 0.0);

		sunlightExtinction += densityCheck * 2.0;

		lightingRoughness *= 0.5;
	}
	float sunlightEnergy = 1.0 / (sunlightExtinction * 7.0 * cp.lightingDensity + 1.0);

	//powder term
	float powderFactor = exp2(-softDensity * 12.0 * cp.lightingDensity);
	powderFactor *= saturate(sunlightEnergy * sunlightEnergy * 10.5);
	sunlightEnergy *= MiePhase(0.0 + powderFactor * 0.95, worldDir, worldLightVector);
	// sunlightEnergy *= 1.0 - powderFactor;

	//Extra edge highlight
	sunlightEnergy *= MiePhase(0.95, worldDir, worldLightVector) * sunlightEnergy * 0.45 + 1.0;








	//fast approximate skylight energy
	// float skylightEnergy = 1.0 / (pow(approxHighPoint - worldPosDetailed.y, 2.0) * 0.0004 * cp.lightingDensity + 1.0);
	// skylightEnergy /= n2 + 0.1;
	// skylightEnergy /= n2 + 0.1;

	//Cone trace skylight energy
	float skylightExtinction = 0.0;
	lightingRoughness = 0.75;
	for (int i = 1; i < 2; i++)
	{
		float fi = float(i) / 2;
		vec3 checkPos = worldPosDetailed + vec3(0.0, 1.0, 0.0) * fi * 100.0;

		float densityCheck = GetCloudDensity(cp, checkPos, lightingRoughness, vec2(0.1, 0.0), true, 0.0);

		skylightExtinction += densityCheck;
	}
	float skylightEnergy = 1.0 / (skylightExtinction * 4.0 * cp.lightingDensity + 1.0);







	float bouncelightEnergy = pow(1.0 - skylightEnergy, 2.0);



	// vec3 sunlightColor = exp2(-vec3(0.3, 0.55, 1.0) * 0.25 * mix(1.5, 1.0, vgrad) / (worldLightVector.y + 0.01));
	vec3 sunlightColor = upperCloudSunlightColor;


	vec3 cloudColor = vec3(0.0);
	cloudColor += sunlightEnergy * sunlightColor * 5.0;
	cloudColor += skylightEnergy * 1.0 * colorSkylight;
	// cloudColor += vec3(0.7, 0.9, 0.4) * (bouncelightEnergy) * 1.7 * (1.0 - rainStrength) * colorSunlight * worldLightVector.y;
	// cloudColor += skylightEnergy * upperCloudSunlightColor * 0.5; 	//Bounced light from upper cloud layer

	//fake scattered light
	// cloudColor += upperCloudSunlightColor * saturate(1.0 - softDensity * 0.8);


	//fake bounce lighting
	// cloudColor *= vec3(1.0) * (1.8 - softDensity);


	// rayleigh absorption and scattering
	cloudColor *= exp2(-eyeLength * vec3(0.3, 0.55, 1.0) * 0.00038 * mix(1.25, 1.0, vgrad));
	// cloudColor += 1.0 - exp2(-eyeLength * vec3(0.3, 0.55, 1.0) * 0.00048 + 0.0);
	cloudColor += atmosphere * (1.0 - exp2(-eyeLength * 0.00038 * mix(1.0, 0.45, rainStrength)));


	// cloudColor = vec3(powderFactor);


	// cloudColor = vec3(skylightEnergy * 10.0);

	// density = saturate(density * rayIncrementLength * 0.05);

	return vec4(cloudColor, density);
}

float GetDirectionalDetailNoise(vec3 worldDir)
{
	vec3 pos = worldDir * 1.0;

	pos.x -= frameTimeCounter * 0.005;
	pos.y += frameTimeCounter * 0.005;

	float pnoise = 	Get3DNoiseL(pos * 30.0) * 2.0; 			pos.xy += pnoise * 0.001;
	pnoise +=  		Get3DNoiseL(pos * 60.0) * 2.0;			pos.xz -= pnoise * 0.001;
	pnoise +=  		Get3DNoiseL(pos * 120.0) * 1.0;			pos.zy -= pnoise * 0.001;
	pnoise +=  		Get3DNoiseL(pos * 240.0) * 0.5;			pos.xy += pnoise * 0.001;
	pnoise +=  		Get3DNoiseL(pos * 480.0) * 0.25;		pos.xy += pnoise * 0.001;

	// pnoise *= 1.1;

	return pnoise;
}

vec3 IntersectXZPlane(vec3 rayDir, float planeHeight)
{
	return rayDir * (planeHeight - cameraPosition.y) / rayDir.y;
}

void VolumetricClouds(inout vec3 color, in vec3 worldPos, in vec3 worldDir)
{




	float detailNoise = GetDirectionalDetailNoise(worldDir);

	vec3 atmosphere = AtmosphericScattering(worldDir, worldSunVector, 1.0);
	//no clouds in front of sun
	// cloudProperties.coverage *= mix(0.0, 1.0, 1.0 - pow(saturate(dot(worldDir, worldLightVector) * 0.5 + 0.5), 48.0));
	CloudProperties cp = cloudProperties;

	cp.coverage += pow(dot(-worldDir, worldLightVector) * 0.5 + 0.5, 2.0) * 0.3;

#if VC_MARCHING


	const int raySteps = 10;
	const float rayStepSize = 1.0 / raySteps;
	const float actualCloudHeightGuess = 0.6;

	vec3 rayStartPos = IntersectXZPlane(worldDir, cloudProperties.altitude + cloudProperties.thickness * 0.05) + cameraPosition;

	vec3 rayIncrement = (worldDir * cloudProperties.thickness * actualCloudHeightGuess * rayStepSize) / abs(worldDir.y);
	// vec3 rayIncrement = worldDir * 40.1;
	float rayIncrementLength = length(rayIncrement);

	vec4 cloudAccum = vec4(0.0);
	float visibilityAccum = 1.0;

	vec3 rayPos = rayStartPos;
	rayPos += rayIncrement * BlueNoise(texcoord.st);


	// cp.coverage -= length(rayStartPos.xz - cameraPosition.xz) * 0.0001;

	for (int i = 0; i < raySteps; i++)
	{
		//When fully opaque, stop
		if (length(rayPos - cameraPosition) > length(worldPos) || visibilityAccum < 0.00001)
		{
			break;
		}

		vec4 cloudSample = SampleVolumetricClouds(cp, rayPos, worldDir, detailNoise, atmosphere, rayIncrementLength);
		cloudAccum.rgb += (cloudSample.rgb * cloudSample.a) * visibilityAccum;
		visibilityAccum *= 1.0 - cloudSample.a;

		rayPos += rayIncrement;
	}


#else

	const int raySteps = 20;
	const float rayExtent = 2100.0f;
	const float rayStepSize = rayExtent / raySteps;


	vec4 cloudAccum = vec4(0.0);
	float visibilityAccum = 1.0;

	// float rayDepth = 0.0;
	float rayDepth = 0.0 + BlueNoise(texcoord.st) * rayStepSize;
	// rayDepth += abs(cameraPosition.y - cloudProperties.altitude + cloudProperties.thickness * 0.2);

	for (int i = 0; i < raySteps; i++)
	{
		vec3 rayPos = (worldDir * rayDepth) + cameraPosition;

		// cloudProperties.thickness *= 1.05;
		// cp.altitude *= 0.99;
		// cloudProperties.coverage *= 1.03;
		// cloudProperties.density = saturate(cloudProperties.density * 1.05);
		// cloudProperties.density = 0.5;

		// cloudProperties.thickness = mix(200.0, 900.0, Get2DNoise(rayPos * 0.001));

		// cloudProperties.thickness = 200.0 + length(rayPos - cameraPosition) * 0.1;
		cp.altitude = 376.0 - length(rayPos - cameraPosition) * 0.0525;
		// cloudProperties.coverage = mix(-0.1, 0.5, Get2DNoise(rayPos * 0.0015));



		//When fully opaque, stop
		if (length(rayPos - cameraPosition) > length(worldPos) || visibilityAccum < 0.00001)
		{
			break;
		}

		//early out if not in correct altitude range
		if (GetCloudHeightDensity(cp, rayPos, false) < 0.5)
		{
			rayDepth += rayStepSize;
			continue;
		}

		vec4 cloudSample = SampleVolumetricClouds(cp, rayPos, worldDir, detailNoise, atmosphere, 1.0);
		cloudAccum.rgb += (cloudSample.rgb * cloudSample.a) * visibilityAccum;
		visibilityAccum *= 1.0 - cloudSample.a;

		rayDepth += rayStepSize;
	}

#endif
	//apply clouds
	color = (color * visibilityAccum) + cloudAccum.rgb;

	// color.rgb = vec3(detailNoise * 0.1);
}





/////////////////////////MAIN//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////MAIN//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void main() 
{

	

	GBufferData gbuffer 						= GetGBufferData();
	GBufferDataTransparent gbufferTransparent	= GetGBufferDataTransparent();
	MaterialMask materialMask 					= CalculateMasks(gbuffer.materialID);
	MaterialMask materialMaskTransparent 		= CalculateMasks(gbufferTransparent.materialID);

	materialMask.water = materialMaskTransparent.water;
	materialMask.stainedGlass = materialMaskTransparent.stainedGlass;
	materialMask.ice = materialMaskTransparent.ice;


	if (materialMask.stainedGlass > 0.5)
	{
		if (gbufferTransparent.albedo.a >= 0.9)
		{
			gbuffer.depth = gbufferTransparent.depth;
			gbuffer.normal = gbufferTransparent.normal;
			gbuffer.albedo.rgb = gbufferTransparent.albedo.rgb;

			gbuffer.mcLightmap = gbufferTransparent.mcLightmap;

			materialMask.sky = 0.0;
		}
		gbuffer.smoothness = 0.0;
		gbuffer.metalness = 0.0;
	}

	// vec4 gnormalData = texture2D(gnormal, texcoord.st);
	// gl_FragData[0] = gnormalData;
	// gl_FragData[1] = vec4(gbuffer.albedo.rgb, 1.0);
	// return;

	if (materialMask.water > 0.5)
	{
		gbuffer.albedo *= 1.2;
		gbuffer.smoothness = 0.0;
		gbuffer.metalness = 0.0;
	}

	vec4 viewPos 					= GetViewPosition(texcoord.st, gbuffer.depth);

	if (isEyeInWater > 0.5)
	{
		// viewPos.xy *= 0.80;
	}

	vec4 worldPos					= gbufferModelViewInverse * vec4(viewPos.xyz, 0.0);
	vec3 viewDir 					= normalize(viewPos.xyz);
	vec3 worldDir 					= normalize(worldPos.xyz);
	//vec3 worldLightVector 			= normalize((gbufferModelViewInverse * vec4(lightVector, 0.0)).xyz);
	//vec3 worldSunVector 			= normalize((gbufferModelViewInverse * vec4(sunVector, 0.0)).xyz);
	vec3 worldNormal 				= normalize((gbufferModelViewInverse * vec4(gbuffer.normal, 0.0)).xyz);
	vec3 worldTransparentNormal 	= normalize((gbufferModelViewInverse * vec4(GetWaterNormals(texcoord.st), 0.0)).xyz);
	float linearDepth 				= length(viewPos.xyz);

	vec3 finalComposite = vec3(0.0);

	gbuffer.albedo.rgb *= 1.0 + materialMask.water * 0.2;
	gbuffer.albedo.rgb *= 1.0 + materialMask.stainedGlass * 0.2;
	if (materialMask.water > 0.5 || materialMask.ice > 0.5)
	{
		gbuffer.mcLightmap.g = gbufferTransparent.mcLightmap.g;
	}




	//GI
	vec4 gi = GetGI(gbuffer.albedo.rgb, gbuffer.normal, gbuffer.depth, gbuffer.mcLightmap.g);
	// vec4 gi = vec4(0.0, 0.0, 0.0, 1.0);

	vec3 fakeGI = normalize(gbuffer.albedo.rgb + 0.0001) * pow(length(gbuffer.albedo.rgb), 1.0) * colorSunlight * 0.13 * gbuffer.mcLightmap.g;
	float fakeGIFade = saturate((shadowDistance * 0.1 * 1.2) - length(viewPos) * 0.1);

	gi.rgb = mix(fakeGI, gi.rgb, vec3(fakeGIFade));

	//float ao = GetAO(texcoord.st, gbuffer.normal, rand(texcoord.st).x);
	float ao = gi.a;
	//float ao = 1.0;

	//gi.rgb *= ao;





	//grass points up
	if (materialMask.grass > 0.5)
		worldNormal = vec3(0.0, 1.0, 0.0);







	//shading from sky
	vec3 skylight = FromSH(skySHR, skySHG, skySHB, worldNormal);
	skylight = mix(skylight, colorSunlight * 1.0 * (worldNormal.y * 0.5 + 0.6), vec3(0.35 + rainStrength * 0.2)) * (1.0 - rainStrength * 0.55);
	skylight *= gbuffer.mcLightmap.g;
	//skylight *= dot(worldNormal, vec3(0.0, 1.0, 0.0)) * 0.2 + 0.8;
	
	finalComposite += skylight * gbuffer.albedo.rgb * 4.5 * ao;





	//Torchlight
	const float torchlightBrightness = 3.7 * TORCHLIGHT_BRIGHTNESS;


	finalComposite += gbuffer.mcLightmap.r * colorTorchlight * gbuffer.albedo.rgb * 0.5 * ao * torchlightBrightness;

	//held torch light
	float heldLightFalloff = 1.0 / (pow(length(worldPos.xyz), 2.0) + 0.5);
	finalComposite += gbuffer.albedo.rgb * heldLightFalloff * heldBlockLightValue * colorTorchlight * 0.025 * torchlightBrightness * ao * heldLightBlacklist;

	if (materialMask.glowstone > 0.5)
	{
		finalComposite += gbuffer.albedo.rgb * colorTorchlight * 5.0 * pow(length(gbuffer.albedo.rgb), 2.0);
	}
	if (materialMask.lava > 0.5)
	{
		finalComposite += gbuffer.albedo.rgb * colorTorchlight * 5.0 * pow(length(gbuffer.albedo.rgb), 1.0);
	}
	if (materialMask.torch > 0.5)
	{
		finalComposite += gbuffer.albedo.rgb * colorTorchlight * 5.0 * saturate(pow(length(gbuffer.albedo.rgb) - 0.5, 1.0));
	}

	

	//sunlight
	float sunlightMult = 24.0 * SUNLIGHT_INTENSITY;

	float NdotL = dot(worldNormal, worldLightVector);
	//float sunlight = saturate(NdotL);
	float sunlight = OrenNayar(worldNormal, -worldDir, worldLightVector);
	if (materialMask.leaves > 0.5)
	{
		// sunlight = 1.0;
		// if (NdotL > 0.0)
		// {
		// 	sunlight = 0.5;
		// }
		// else
		// {
		// 	sunlight = 1.0;
		// }

		sunlight = 0.4;

		float VdotL = dot(worldDir, worldLightVector);

		float g = 0.65;
					//float g = 0.9;
		float g2 = g * g;
		float theta = VdotL * 0.5 + 0.5;
		float anisoFactor = 1.5 * ((1.0 - g2) / (2.0 + g2)) * ((1.0 + theta * theta) / (1.0 + g2 - 2.0 * g * theta)) + g * theta;

		sunlight += pow(anisoFactor, 1.5) * 0.05;
	}
	if (materialMask.grass > 0.5)
	{
		gbuffer.metalness = 0.0;
	}

	if (materialMask.water > 0.5 || isEyeInWater > 0.5)
	{
		sunlight *= CalculateWaterCaustics(viewPos, materialMask);
	}


	sunlight *= pow(gbuffer.mcLightmap.g, 0.1 + isEyeInWater * 0.4);
 
	vec3 shadow = CalculateSunlightVisibility(viewPos, materialMask);
	//vec3 shadow = vec3(1.0);
	// if (isEyeInWater < 1)
	if (gbuffer.depth > 0.7)
	{
		shadow *= ScreenSpaceShadow(viewPos.xyz, gbuffer.normal.xyz, materialMask);
	}
	float cloudShadow = CloudShadow(worldPos, worldLightVector, cloudProperties);
	// float cloudShadow = 1.0;
	shadow *= cloudShadow;
	shadow *= gbuffer.parallaxShadow;
	gi.rgb *= cloudShadow * 0.88 + 0.12;

	finalComposite += sunlight * gbuffer.albedo.rgb * shadow * sunlightMult * colorSunlight;




	//Sunlight specular
	vec3 specularGGX = SpecularGGX(worldNormal, -worldDir, worldLightVector, pow(1.0 - pow(gbuffer.smoothness, 1.0), 1.0), gbuffer.metalness * 0.98 + 0.02) * sunlightMult * shadow;
	specularGGX *= pow(gbuffer.mcLightmap.g, 0.1);

	if (isEyeInWater < 0.5)
	{
		finalComposite += specularGGX;
	}









	//GI
	finalComposite += gi.rgb * 1.0 * sunlightMult * cloudShadow;

	vec4 viewPosTransparent = GetViewPosition(texcoord.st, texture2D(gdepthtex, texcoord.st).x);


	//Refraction of unterwater surface and total internal reflection detection for water
	if (isEyeInWater > 0)
	{
		if (materialMask.water > 0.5)
		{
			worldDir = refract(worldDir, worldTransparentNormal, WATER_REFRACT_IOR);
		}
	}

	float nightBrightness = 0.00025 * (1.0 + 32.0 * nightVision);

	//sky
	if (materialMask.sky > 0.5 || (isEyeInWater > 0 || materialMask.ice > 0.5 || materialMask.stainedGlass > 0.5) && gbuffer.depth > 0.9999999)
	// if (materialMask.sky > 0.5)
	{



		//remove sun texture
		gbuffer.albedo.rgb *= 1.0 - saturate((dot(worldDir, worldSunVector) - 0.95) * 50.0);

		//finalComposite.rgb = vec3(1.0);
		vec3 sunDisc = vec3(RenderSunDisc(worldDir, worldSunVector));
		vec3 atmosphere = AtmosphericScattering(vec3(worldDir.x, (worldDir.y), worldDir.z), worldSunVector, 1.0);


		// atmosphere = mix(atmosphere, vec3(0.6) * Luminance(colorSkylight), vec3(rainStrength * 0.95));
		//atmosphere = mix(atmosphere, vec3(dot(atmosphere, vec3(0.333333))), vec3(-0.4));
		//atmosphere *= skyTint;

		finalComposite.rgb = atmosphere;
		//finalComposite.rgb *= 1.0 + sunDisc * 950.0;

		//sunDisc *= normalize(atmosphere + 0.0001);
		sunDisc *= colorSunlight;
		sunDisc *= pow(saturate(worldSunVector.y + 0.1), 0.9);

		finalComposite += sunDisc * 50000.0;



//void CloudPlane(inout vec3 color, vec3 viewDir, vec3 worldVector, float linearDepth, MaterialMask mask, vec3 worldLightVector, vec3 lightVector)

		CloudPlane(finalComposite, viewDir, -worldDir, linearDepth, materialMask, worldLightVector, lightVector, gbuffer.depth);



		vec3 moonAtmosphere = AtmosphericScattering(vec3(worldDir.x, (worldDir.y), worldDir.z), -worldSunVector, 1.0);
		// moonAtmosphere = mix(moonAtmosphere, vec3(0.6) * nightBrightness, vec3(rainStrength * 0.95));

		finalComposite += moonAtmosphere * nightBrightness;

		//if (linearDepth < far - 1.0)
		//{
			finalComposite += gbuffer.albedo.rgb * normalize(moonAtmosphere + 0.0000001) * 0.13;
		//}


		worldPos.xyz = worldDir.xyz * 2670.0;
	}
	else
	{
		//finalComposite += AtmosphericScattering(worldDir, worldSunVector, 1.0, ExpToLinearDepth(gbuffer.depth) * 0.000005);
		//LandAtmosphericScattering(finalComposite, viewPos.xyz, viewDir.xyz);

	}

	//If total internal reflection, make black
	float totalInternalReflection = 0.0;
	if (length(worldDir) < 0.5)
	{
		finalComposite *= 0.0;
		totalInternalReflection = 1.0;
	}

	//Push sky back
	if (gbuffer.depth > 0.99999)
	{
		worldPos.xyz *= 10000.0;
	}
	VolumetricClouds(finalComposite, worldPos.xyz, worldDir.xyz);



		//ContextualFog(finalComposite, worldPos.xyz * 0.5, worldDir.xyz, contextualFogFactor);

	WaterFog(finalComposite, materialMask, gbuffer.mcLightmap.g, viewPos, viewPosTransparent);


	// finalComposite = texture2D(gaux1, texcoord.st).rgb;
	// finalComposite = gbuffer.albedo.rgb;

	// finalComposite = vec3(texture2D(gnormal, texcoord.st).a);
	// finalComposite = texture2D(gnormal, texcoord.st).rgb;

	finalComposite *= 0.0001;


	//finalComposite.rgb *= 2.5;



	

	







	finalComposite = LinearToGamma(finalComposite);



	finalComposite += rand(texcoord.st + sin(frameTimeCounter)) * (1.0 / 65535.0);


	vec4 gnormalData = texture2D(gnormal, texcoord.st);
	// gl_FragData[0] = vec4(gnormalData.xy, totalInternalReflection, 1.0);
	gl_FragData[0] = vec4(finalComposite.rgb, totalInternalReflection);
}
