//#define STEREOSCOPIC_RENDERING // Enables stereoscopic 3D rendering

#define STEREO_HALF_AXIS y // Which render resolution axis should be halved for stereo rendering [y x]

#define TAA_ENABLED // Temporal Anti-Aliasing. Utilizes multiple rendered frames to reconstruct an anti-aliased image similar to supersampling. Can cause some artifacts.


float saturate(float x)
{
	return clamp(x, 0.0, 1.0);
}

vec3 saturate(vec3 x)
{
	return clamp(x, vec3(0.0), vec3(1.0));
}

vec2 saturate(vec2 x)
{
	return clamp(x, vec2(0.0), vec2(1.0));
}

float remap(float e0, float e1, float x)
{
	return saturate((x - e0) / (e1 - e0));
}

vec2 EncodeNormal(vec3 normal)
{
	float p = sqrt(normal.z * 8.0 + 8.0);
	return vec2(normal.xy / p + 0.5);
}

vec3 DecodeNormal(vec2 enc)
{
	vec2 fenc = enc * 4.0 - 2.0;
	float f = dot(fenc, fenc);
	float g = sqrt(1.0 - f / 4.0);
	vec3 normal;
	normal.xy = fenc * g;
	normal.z = 1.0 - f / 2.0;
	return normal;
}



vec4 ReadBufferRaw(sampler2D tex, vec2 coord)
{
	coord *= vec2(viewWidth, viewHeight);
	coord = floor(coord) + 0.5;
	coord /= vec2(viewWidth, viewHeight);
	return texture2DLod(tex, coord, 0);
}

vec4 SampleLinear(sampler2D tex, vec2 coord)
{
	return pow(texture2D(tex, coord), vec4(2.2));
}

vec3 LinearToGamma(vec3 c)
{
	return pow(c, vec3(1.0 / 2.2));
}

vec3 GammaToLinear(vec3 c)
{
	return pow(c, vec3(2.2));
}

float curve(float x)
{
	return x * x * (3.0 - 2.0 * x);
}

float Luminance(in vec3 color)
{
	return dot(color.rgb, vec3(0.2125f, 0.7154f, 0.0721f));
}


































vec3 rand(vec2 coord)
{
	float noiseX = saturate(fract(sin(dot(coord, vec2(12.9898, 78.223))) * 43758.5453));
	float noiseY = saturate(fract(sin(dot(coord, vec2(12.9898, 78.223)*2.0)) * 43758.5453));
	float noiseZ = saturate(fract(sin(dot(coord, vec2(12.9898, 78.223)*3.0)) * 43758.5453));

	return vec3(noiseX, noiseY, noiseZ);
}

float  	CalculateDitherPattern(vec2 coord) {
	const int[4] ditherPattern = int[4] (0, 2, 1, 4);

	vec2 count = vec2(0.0f);
	     count.x = floor(mod(coord.s * viewWidth, 2.0f));
		 count.y = floor(mod(coord.t * viewHeight, 2.0f));

	int dither = ditherPattern[int(count.x) + int(count.y) * 2];

	return float(dither) / 4.0f;
}

float  	CalculateDitherPattern1(vec2 coord) {
	const int[16] ditherPattern = int[16] (0 , 8 , 2 , 10,
									 	   12, 4 , 14, 6 ,
									 	   3 , 11, 1,  9 ,
									 	   15, 7 , 13, 5 );

	vec2 count = vec2(0.0f);
	     count.x = floor(mod(coord.s * viewWidth, 4.0f));
		 count.y = floor(mod(coord.t * viewHeight, 4.0f));

	int dither = ditherPattern[int(count.x) + int(count.y) * 4];

	return float(dither) / 16.0f;
}

float BlueNoise(vec2 coord)
{
	vec2 noiseCoord = vec2(coord.st * vec2(viewWidth, viewHeight)) / 64.0;
	noiseCoord += vec2(sin(frameCounter * 0.75), cos(frameCounter * 0.75));

	noiseCoord = (floor(noiseCoord * 64.0) + 0.5) / 64.0;

	float blueNoise = texture2DLod(noisetex, noiseCoord.st, 0).b;

	return blueNoise;
}

vec2 BlueNoiseXY(vec2 coord)
{
	return vec2(BlueNoise(coord.st), BlueNoise(coord.st + 32.0 / vec2(viewWidth, viewHeight)));
}

float BlueNoiseStatic(vec2 coord)
{
	vec2 noiseCoord = vec2(coord.st * vec2(viewWidth, viewHeight)) / 64.0;

	noiseCoord = (floor(noiseCoord * 64.0) + 0.5) / 64.0;

	float blueNoise = texture2DLod(noisetex, noiseCoord.st, 0).b;

	return blueNoise;
}


float Get3DNoise(in vec3 pos)
{
	pos.xyz += 0.5f;

	vec3 p = floor(pos);
	vec3 f = fract(pos);

	f = smoothstep(vec3(0.0), vec3(1.0), f);

	vec2 uv =  (p.xy + p.z * vec2(-17.0f, -17.0f)) + f.xy;

	vec2 coord =  (uv + 0.5f) / 64.0;
	vec2 noiseSample = texture2D(noisetex, coord).xy;
	float xy1 = noiseSample.x;
	float xy2 = noiseSample.y;
	return mix(xy1, xy2, f.z);
}

float Get3DNoiseL(in vec3 pos)
{
	pos.xyz += 0.5f;

	vec3 p = floor(pos);
	vec3 f = fract(pos);


	vec2 uv =  (p.xy + p.z * vec2(-17.0f, -17.0f)) + f.xy;

	vec2 coord =  (uv + 0.5f) / 64.0;
	vec2 noiseSample = texture2D(noisetex, coord).xy;
	float xy1 = noiseSample.x;
	float xy2 = noiseSample.y;
	return mix(xy1, xy2, f.z);
}

float Get2DNoise(in vec3 pos)
{
	pos.xy = pos.xz;
	pos.xy += 0.5f;

	vec2 p = floor(pos.xy);
	vec2 f = fract(pos.xy);

	f = smoothstep(vec2(0.0), vec2(1.0), f);

	vec2 uv =  p.xy + f.xy;

	// uv -= 0.5f;
	// uv2 -= 0.5f;

	vec2 coord =  (uv  + 0.5f) / 64.0;
	float xy1 = texture2D(noisetex, coord).x;
	return xy1;
}

float Get3DNoiseRidged(in vec3 pos)
{
	pos.xyz += 0.5f;

	vec3 p = floor(pos);
	vec3 f = fract(pos);

	vec2 uv =  (p.xy + p.z * vec2(-17.0f, -17.0f)) + f.xy;

	vec2 coord =  (uv + 0.5f) / 64.0;
	vec2 noiseSample = texture2D(noisetex, coord).xy;
	float xy1 = noiseSample.x;
	float xy2 = noiseSample.y;
	return abs(mix(xy1, xy2, f.z) * 2.0 - 1.0);
}


float Get3DNoiseBillows(in vec3 pos)
{
	pos.xyz += 0.5f;

	vec3 p = floor(pos);
	vec3 f = fract(pos);

	vec2 uv =  (p.xy + p.z * vec2(-17.0f, -17.0f)) + f.xy;

	vec2 coord =  (uv + 0.5f) / 64.0;
	vec2 noiseSample = texture2D(noisetex, coord).xy;
	float xy1 = noiseSample.x;
	float xy2 = noiseSample.y;
	return 1.0 - abs(mix(xy1, xy2, f.z) * 2.0 - 1.0);
}
























vec4 ToSH(float value, vec3 dir)
{
	const float PI = 3.14159265359;
	const float N1 = sqrt(4 * PI / 3);
	const float transferl1 = (sqrt(PI) / 3.0) * N1;
	const float transferl0 = PI;

	const float sqrt1OverPI = sqrt(1.0 / PI);
	const float sqrt3OverPI = sqrt(3.0 / PI);

	vec4 coeffs;

	coeffs.x = 0.5 * sqrt1OverPI * value * transferl0;
	coeffs.y = -0.5 * sqrt3OverPI * dir.y * value * transferl1;
	coeffs.z = 0.5 * sqrt3OverPI * dir.z * value * transferl1;
	coeffs.w = -0.5 * sqrt3OverPI * dir.x * value * transferl1; //TODO: Vectorize the math so it's faster

	return coeffs;
}


vec3 FromSH(vec4 cR, vec4 cG, vec4 cB, vec3 lightDir)
{
	const float PI = 3.14159265;

	const float N1 = sqrt(4 * PI / 3);
	const float transferl1 = (sqrt(PI) / 3.0) * N1;
	const float transferl0 = PI;

	const float sqrt1OverPI = sqrt(1.0 / PI);
	const float sqrt3OverPI = sqrt(3.0 / PI);

	vec4 sh;

	sh.x = 0.5 * sqrt1OverPI;
	sh.y = -0.5 * sqrt3OverPI * lightDir.y;
	sh.z = 0.5 * sqrt3OverPI * lightDir.z;
	sh.w = -0.5 * sqrt3OverPI * lightDir.x;

	vec3 result;
	result.r = sh.x * cR.x;
	result.r += sh.y * cR.y;
	result.r += sh.z * cR.z;
	result.r += sh.w * cR.w;

	result.g = sh.x * cG.x;
	result.g += sh.y * cG.y;
	result.g += sh.z * cG.z;
	result.g += sh.w * cG.w;

	result.b = sh.x * cB.x;
	result.b += sh.y * cB.y;
	result.b += sh.z * cB.z;
	result.b += sh.w * cB.w;

	return result.rgb;
}























float CurveBlockLightSky(float blockLight)
{
	//blockLight = pow(blockLight, 3.0);

	//blockLight = InverseSquareCurve(1.0 - blockLight, 0.2);
	blockLight = 1.0 - pow(1.0 - blockLight, 0.55);
	blockLight *= blockLight * blockLight;

	return blockLight;
}

#define TORCHLIGHT_FILL 1.0 // Amount of fill/ambient light to add to torchlight falloff. Higher values makes torchlight dim less intensely based on distance. [0.5 1.0 2.0 4.0 8.0]

float CurveBlockLightTorch(float blockLight)
{
	float decoded = pow(blockLight, 1.0 / 0.25);

	decoded = pow(decoded, 2.0) * 5.0;
	decoded += pow(decoded, 0.4) * 0.1 * TORCHLIGHT_FILL;

	return decoded;
}



























//x is distance to outer surface, y is distance to inner surface
vec2 RaySphereIntersection( vec3 p, vec3 dir, float r ) 
{
	float b = dot( p, dir );
	float c = dot( p, p ) - r * r;
	
	float d = b * b - c;
	if ( d < 0.0 ) 
	{
		return vec2( 10000.0, -10000.0 );
	}

	d = sqrt( d );
	
	return vec2( -b - d, -b + d );
}


#define R_INNER 0.985

// Mie
// g : ( -0.75, -0.999 )
//      3 * ( 1 - g^2 )               1 + c^2
// F = ----------------- * -------------------------------
//      2 * ( 2 + g^2 )     ( 1 + g^2 - 2 * g * c )^(3/2)
float phase_mie( float g, float c, float cc ) {
	float gg = g * g;
	
	float a = ( 1.0 - gg ) * ( 1.0 + cc );

	float b = 1.0 + gg - 2.0 * g * c;
	b *= sqrt( b );
	b *= 2.0 + gg;	
	
	return 1.5 * a / b;
}

// Reyleigh
// g : 0
// F = 3/4 * ( 1 + c^2 )
float phase_reyleigh( float cc ) 
{
	return 0.75 * ( 1.0 + cc );
}

float density( vec3 p )
{
	const float R = 1.0;
	const float SCALE_H = 4.0 / ( R - R_INNER );
	const float SCALE_L = 1.0 / ( R - R_INNER );

	return exp( -( length( p ) - R_INNER ) * SCALE_H ) * 2.0;
}

float optic( vec3 p, vec3 q ) 
{
	const int numOutscatter = 1;

	const float R = 1.0;
	const float SCALE_L = 1.0 / (R - R_INNER);

	vec3 step = ( q - p ) / float(numOutscatter);
	step *= 0.3;
	vec3 v = p + step * 0.5;
	
	float sum = 0.0;
	for ( int i = 0; i < numOutscatter; i++ ) 
	{
		sum += density( v );
		v += step;
	}
	sum *= length( step ) * SCALE_L;


	return sum;
}

vec3 in_scatter(vec3 o, vec3 dir, vec2 e, vec3 l, const float mieAmount, const float rayleighAmount) 
{
	const float numInscatter = 4;
	
	const float PI = 3.14159265359;

	const float R = 1.0;
	const float SCALE_L = 1.0 / (R - R_INNER);

	const float K_R = 0.186 * rayleighAmount;
	const float K_M = 0.045 * mieAmount;
	const float E = 14.3;
	const vec3 C_R = vec3(0.2, 0.45, 1.0);	//Rayleigh scattering coefficients
	const float G_M = -0.75;

	float boosty = saturate(l.y + 0.1) * 0.95 + 0.05;
	boosty = 1.0 / sin(boosty);

	float len = (e.y * (1.0 + boosty * 0.0)) / float(numInscatter);
	vec3 step = dir * len;
	step *= 2.0;
	vec3 p = o;

	//float boosty = 1.0 - abs(l.y);
	

	vec3 v = p + dir * ( len * (0.5 + boosty * 0.0) );



	vec3 sum = vec3( 0.0 );
	for ( int i = 0; i < numInscatter; i++ ) 
	{
		vec2 f = RaySphereIntersection( v, l, R );
		vec3 u = v + l * f.y;
		
		float n = ( optic( p, v ) + optic( v, u ) ) * ( PI * 4.0 );
		
		sum += density( v ) * exp( -n * ( K_R * C_R ) );

		v += step;
	}
	sum *= len * SCALE_L;
	
	float c  = dot( dir, -l );
	float cc = c * c;
	
	return sum * ( K_R * C_R * phase_reyleigh( cc ) + K_M * phase_mie( G_M, c, cc ) ) * E;
}

vec3 in_scatter2(vec3 o, vec3 dir, vec2 e, vec3 l) 
{
	const float numInscatter = 2;
	
	const float PI = 3.14159265359;

	const float R = 1.0;
	const float SCALE_L = 1.0 / (R - R_INNER);

	const float K_R = 0.166;
	const float K_M = 0.00;
	const float E = 14.3;
	const vec3 C_R = vec3(0.2, 0.6, 1.0);	//Rayleigh scattering coefficients
	const float G_M = -0.65;

	float len = (e.y) / float(numInscatter);
	vec3 step = dir * len;
	step *= 2.0;
	vec3 p = o;

	//float boosty = 1.0 - abs(l.y);
	float boosty = saturate(l.y + 0.1) * 0.95 + 0.05;
	boosty = 1.0 / sin(boosty);

	vec3 v = p + dir * ( len * (0.5 + boosty * 0.0) );



	vec3 sum = vec3( 0.0 );
	for ( int i = 0; i < numInscatter; i++ ) 
	{
		vec2 f = RaySphereIntersection( v, l, R );
		vec3 u = v + l * f.y;
		
		float n = ( optic( p, v ) + optic( v, u ) ) * ( PI * 4.0 );
		
		sum += density( v ) * exp( -n * ( K_R * C_R + K_M ) );

		v += step;
	}
	sum *= len * SCALE_L;
	
	float c  = dot( dir, -l );
	float cc = c * c;
	
	return sum * ( K_R * C_R * phase_reyleigh( cc ) + K_M * phase_mie( G_M, c, cc ) ) * E;
}

vec3 AtmosphericScattering(vec3 rayDir, vec3 lightVector, const float mieAmount)
{
	const float PI = 3.14159265359;
	const float DEG_TO_RAD = PI / 180.0;

	//Scatter constants
	const float K_R = 0.166;
	const float K_M = 0.0025;
	const float E = 14.3;
	const vec3 C_R = vec3(0.3, 0.7, 1.0);	//Rayleigh scattering coefficients
	const float G_M = -0.85;

	const float R = 1.0;
	const float SCALE_H = 4.0 / (R - R_INNER);
	const float SCALE_L = 1.0 / (R - R_INNER);

	const int NUM_OUT_SCATTER = 10;
	const float FNUM_OUT_SCATTER = 10.0;

	const int NUM_IN_SCATTER = 10;
	const float FNUM_IN_SCATTER = 10.0;

	vec3 eye = vec3(0.0, mix(R_INNER, 1.0, 0.05), 0.0);

	vec3 originalRayDir = rayDir;

	if (rayDir.y < 0.0)
	{
		//rayDir.y = abs(rayDir.y);
		//rayDir.y *= rayDir.y;
		rayDir.y = 0.0;
	}

	vec3 up = vec3(0.0, 1.0, 0.0);

	vec2 e = RaySphereIntersection(eye, rayDir, R);
	vec2 eup = RaySphereIntersection(eye, up, R);


	vec3 atmosphere = in_scatter(eye, rayDir, e, lightVector, mieAmount, 1.0);

	vec3 secondary = in_scatter2(eye, up, eup, lightVector);

	vec3 ambient = vec3(0.3, 0.5, 1.0);

	vec3 ground = vec3(0.1, 0.1, 0.1) * 0.05;

	float boosty = saturate(lightVector.y) * 0.90 + 0.10;
	boosty = 1.0 / sin(boosty);

	//atmosphere += dot(secondary, vec3(0.06)) * ambient * boosty;
	atmosphere += dot(secondary, vec3(0.66)) * ambient;
	//atmosphere += ambient * 0.01;

	atmosphere *= vec3(0.8, 0.89, 1.0);


	atmosphere = pow(atmosphere, vec3(1.0));

	//if (originalRayDir.y < 0.0)
	//{
		//atmosphere *= curve(saturate(originalRayDir.y + 1.0));
	//}
	atmosphere = mix(atmosphere, vec3(dot(atmosphere, vec3(0.33333))), vec3(rainStrength * remap(0.3, 0.0, rayDir.y) * (lightVector.y + 0.1)) * 0.5);
	// atmosphere = mix(atmosphere, vec3(dot(atmosphere, vec3(0.33333))), vec3(rainStrength * remap(0.3, 0.0, rayDir.y) * (lightVector.y + 0.5)) * 1.0);


	return atmosphere;
}

vec3 AtmosphericScattering(vec3 rayDir, vec3 lightVector, const float mieAmount, float depth)
{
	const float PI = 3.14159265359;
	const float DEG_TO_RAD = PI / 180.0;

	//Scatter constants
	const float K_R = 0.166;
	const float K_M = 0.0025;
	const float E = 14.3;
	const vec3 C_R = vec3(0.3, 0.7, 1.0);	//Rayleigh scattering coefficients
	const float G_M = -0.85;

	const float R = 1.0;
	const float SCALE_H = 4.0 / (R - R_INNER);
	const float SCALE_L = 1.0 / (R - R_INNER);

	const int NUM_OUT_SCATTER = 10;
	const float FNUM_OUT_SCATTER = 10.0;

	const int NUM_IN_SCATTER = 10;
	const float FNUM_IN_SCATTER = 10.0;

	vec3 eye = vec3(0.0, mix(R_INNER, 1.0, 0.05), 0.0);

	vec3 originalRayDir = rayDir;

	if (rayDir.y < 0.0)
	{
		//rayDir.y = abs(rayDir.y);
		//rayDir.y *= rayDir.y;
		rayDir.y = 0.0;
	}

	vec3 up = vec3(0.0, 1.0, 0.0);

	vec2 e = RaySphereIntersection(eye, rayDir, R);
	vec2 eup = RaySphereIntersection(eye, up, R);
	e.y = depth;
	eup.y = depth;


	vec3 atmosphere = in_scatter(eye, rayDir, e, lightVector, mieAmount, 1.0);

	vec3 secondary = in_scatter2(eye, up, eup, lightVector);

	vec3 ambient = vec3(0.3, 0.5, 1.0);

	vec3 ground = vec3(0.1, 0.1, 0.1) * 0.05;

	float boosty = saturate(lightVector.y) * 0.90 + 0.10;
	boosty = 1.0 / sin(boosty);

	//atmosphere += dot(secondary, vec3(0.06)) * ambient * boosty;
	atmosphere += dot(secondary, vec3(0.86)) * ambient;
	//atmosphere += ambient * 0.01;

	atmosphere *= vec3(0.8, 0.89, 1.0);


	atmosphere = pow(atmosphere, vec3(1.2));

	//if (originalRayDir.y < 0.0)
	//{
		//atmosphere *= curve(saturate(originalRayDir.y + 1.0));
	//}


	return atmosphere;
}

vec3 AtmosphericScatteringSingle(vec3 rayDir, vec3 lightVector, const float mieAmount)
{
	const float PI = 3.14159265359;
	const float DEG_TO_RAD = PI / 180.0;

	//Scatter constants
	const float K_R = 0.166;
	const float K_M = 0.0025;
	const float E = 14.3;
	const vec3 C_R = vec3(0.3, 0.7, 1.0);	//Rayleigh scattering coefficients
	const float G_M = -0.85;

	const float R = 1.0;
	const float SCALE_H = 4.0 / (R - R_INNER);
	const float SCALE_L = 1.0 / (R - R_INNER);

	const int NUM_OUT_SCATTER = 10;
	const float FNUM_OUT_SCATTER = 10.0;

	const int NUM_IN_SCATTER = 10;
	const float FNUM_IN_SCATTER = 10.0;

	vec3 eye = vec3(0.0, mix(R_INNER, 1.0, 0.05), 0.0);

	vec3 originalRayDir = rayDir;

	if (rayDir.y < 0.0)
	{
		//rayDir.y = abs(rayDir.y);
		//rayDir.y *= rayDir.y;
		rayDir.y = 0.0;
	}

	vec3 up = vec3(0.0, 1.0, 0.0);

	vec2 e = RaySphereIntersection(eye, rayDir, R);
	vec2 eup = RaySphereIntersection(eye, up, R);


	vec3 atmosphere = in_scatter(eye, rayDir, e, lightVector, mieAmount, 0.7);


	atmosphere = pow(atmosphere, vec3(1.2));

	//if (originalRayDir.y < 0.0)
	//{
		//atmosphere *= curve(saturate(originalRayDir.y + 1.0));
	//}


	return atmosphere;
}



























void TemporalJitterProjPos(inout vec4 pos)
{
	#ifdef TAA_ENABLED
	// const vec2 haltonSequenceOffsets[16] = vec2[16]
	// (
	// 	vec2(-1, -1), 				vec2(0, -0.3333333), 			vec2(-0.5, 0.3333334), 			vec2(0.5, -0.7777778), 
	// 	vec2(-0.75, -0.1111111), 	vec2(0.25, 0.5555556), 			vec2(-0.25, -0.5555556), 		vec2(0.75, 0.1111112), 
	// 	vec2(-0.875, 0.7777778), 	vec2(0.125, -0.9259259), 		vec2(-0.375, -0.2592592), 		vec2(0.625, 0.4074074), 
	// 	vec2(-0.625, -0.7037037), 	vec2(0.375, -0.03703701), 		vec2(-0.125, 0.6296296), 		vec2(0.875, -0.4814815)
	// );
	// const vec2 bayerSequenceOffsets[16] = vec2[16]
	// (
	// 	vec2(0, 3) / 16.0, 		vec2(8, 11) / 16.0, 	vec2(2, 1) / 16.0, 		vec2(10, 9) / 16.0, 
	// 	vec2(12, 15) / 16.0, 	vec2(4, 7) / 16.0, 		vec2(14, 13) / 16.0, 	vec2(6, 5) / 16.0, 
	// 	vec2(3, 0) / 16.0, 		vec2(11, 8) / 16.0, 	vec2(1, 2) / 16.0, 		vec2(9, 10) / 16.0, 
	// 	vec2(15, 12) / 16.0, 	vec2(7, 4) / 16.0, 		vec2(13, 14) / 16.0, 	vec2(5, 6) / 16.0
	// );

	// const vec2 bayerSequenceOffsets[16] = vec2[16]
	// (
	// 	vec2(0, 0) / 4.0, 		vec2(0, 2) / 4.0, 		vec2(2, 0) / 4.0, 		vec2(2, 2) / 4.0, 
	// 	vec2(0, 3) / 4.0, 		vec2(0, 1) / 4.0, 		vec2(2, 3) / 4.0, 		vec2(2, 1) / 4.0, 
	// 	vec2(3, 0.5) / 4.0, 	vec2(3, 2.5) / 4.0, 	vec2(1, 0.5) / 4.0, 	vec2(1, 2.5) / 4.0, 
	// 	vec2(3, 3.5) / 4.0, 	vec2(3, 1.5) / 4.0, 	vec2(1, 3.5) / 4.0, 	vec2(1, 1.5) / 4.0
	// );
	// const vec2 bayerSequenceOffsets[16] = vec2[16]
	// (
	// 	vec2(0, 0) / 4.0, 		vec2(0, 2) / 4.0, 		vec2(2, 0) / 4.0, 		vec2(2, 2) / 4.0, 
	// 	vec2(0, 3) / 4.0, 		vec2(0, 1) / 4.0, 		vec2(2, 3) / 4.0, 		vec2(2, 1) / 4.0, 
	// 	vec2(3, 0.5) / 4.0, 	vec2(3, 2.5) / 4.0, 	vec2(1, 0.5) / 4.0, 	vec2(1, 2.5) / 4.0, 
	// 	vec2(3, 3.5) / 4.0, 	vec2(3, 1.5) / 4.0, 	vec2(1, 3.5) / 4.0, 	vec2(1, 1.5) / 4.0
	// );
	const vec2 bayerSequenceOffsets[16] = vec2[16]
	(
		vec2(0.5, 0) / 4.0, 	vec2(0.5, 2) / 4.0, 	vec2(2.5, 0) / 4.0, 	vec2(2.5, 2) / 4.0, 
		vec2(0, 3) / 4.0, 		vec2(0, 1) / 4.0, 		vec2(2, 3) / 4.0, 		vec2(2, 1) / 4.0, 
		vec2(3.5, 0.5) / 4.0, 	vec2(3.5, 2.5) / 4.0, 	vec2(1.5, 0.5) / 4.0, 	vec2(1.5, 2.5) / 4.0, 
		vec2(3, 3.5) / 4.0, 	vec2(3, 1.5) / 4.0, 	vec2(1, 3.5) / 4.0, 	vec2(1, 1.5) / 4.0
	);
// 	const vec2 otherOffsets[16] = vec2[16](vec2(0.375, 0.4375), vec2(0.625, 0.0625), vec2(0.875, 0.1875), vec2(0.125, 0.0625),
// vec2(0.375, 0.6875), vec2(0.875, 0.4375), vec2(0.625, 0.5625), vec2(0.375, 0.9375),
// vec2(0.625, 0.3125), vec2(0.125, 0.5625), vec2(0.125, 0.8125), vec2(0.375, 0.1875),
// vec2(0.875, 0.9375), vec2(0.875, 0.6875), vec2(0.125, 0.3125), vec2(0.625, 0.8125)
// );
	vec2 offset = ((bayerSequenceOffsets[int(mod(frameCounter, 16))] * 2.0 - 1.0) / vec2(viewWidth, viewHeight)) * 1.0;
	pos.xy -= offset;
	//pos.xy += (rand(vec2(mod(float(frameCounter) / 16.0, 1.0))).xy / vec2(viewWidth, viewHeight)) * 1.0;
	#else

	#endif
}

void TemporalJitterProjPos(inout vec3 pos)
{
	vec4 ppos = vec4(pos, 0.0);

	TemporalJitterProjPos(ppos);

	pos.xyz = ppos.xyz;
}


vec4 GetViewPosition(in vec2 coord, in float depth) 
{	
	vec4 tcoord = vec4(coord.xy, 0.0, 0.0);
		tcoord.xy *= -2.0;
	TemporalJitterProjPos(tcoord);
		tcoord.xy /= -2.0;



	vec4 fragposition = gbufferProjectionInverse * vec4(tcoord.s * 2.0f - 1.0f, tcoord.t * 2.0f - 1.0f, 2.0f * depth - 1.0f, 1.0f);
		 fragposition /= fragposition.w;


	
	return fragposition;
}

vec4 GetViewPositionRaw(in vec2 coord, in float depth) 
{	
	vec4 tcoord = vec4(coord.xy, 0.0, 0.0);
	//TemporalJitterProjPos(tcoord);
	//TemporalJitterProjPos(tcoord);
	//tcoord.x += 1.1;
	//tcoord.x = 0.0;





	vec4 fragposition = gbufferProjectionInverse * vec4(tcoord.s * 2.0f - 1.0f, tcoord.t * 2.0f - 1.0f, 2.0f * depth - 1.0f, 1.0f);
		 fragposition /= fragposition.w;


	
	return fragposition;
}

vec3 ProjectBack(vec3 cameraSpace, vec2 origScreenCoord) 
{


    vec4 clipSpace = gbufferProjection * vec4(cameraSpace, 1.0);
    vec3 NDCSpace = clipSpace.xyz / clipSpace.w;
    vec3 screenSpace = 0.5 * NDCSpace + 0.5;




		 //screenSpace.z = 0.1f;
    return screenSpace;
}


float 	ExpToLinearDepth(in float depth)
{
	return 2.0f * near * far / (far + near - (2.0f * depth - 1.0f) * (far - near));
}























struct Ray {
	vec3 dir;
	vec3 origin;
};

struct Plane {
	vec3 normal;
	vec3 origin;
};

struct Intersection {
	vec3 pos;
	float distance;
	float angle;
};

Intersection 	RayPlaneIntersectionWorld(in Ray ray, in Plane plane)
{
	float rayPlaneAngle = dot(ray.dir, plane.normal);

	float planeRayDist = 100000000.0f;
	vec3 intersectionPos = ray.dir * planeRayDist;

	if (rayPlaneAngle > 0.0001f || rayPlaneAngle < -0.0001f)
	{
		planeRayDist = dot((plane.origin), plane.normal) / rayPlaneAngle;
		intersectionPos = ray.dir * planeRayDist;
		intersectionPos = -intersectionPos;

		intersectionPos += cameraPosition.xyz;
	}

	Intersection i;

	i.pos = intersectionPos;
	i.distance = planeRayDist;
	i.angle = rayPlaneAngle;

	return i;
}

Intersection 	RayPlaneIntersection(in Ray ray, in Plane plane)
{
	float rayPlaneAngle = dot(ray.dir, plane.normal);

	float planeRayDist = 100000000.0f;
	vec3 intersectionPos = ray.dir * planeRayDist;

	if (rayPlaneAngle > 0.0001f || rayPlaneAngle < -0.0001f)
	{
		planeRayDist = dot((plane.origin - ray.origin), plane.normal) / rayPlaneAngle;
		intersectionPos = ray.origin + ray.dir * planeRayDist;
		// intersectionPos = -intersectionPos;

		// intersectionPos += cameraPosition.xyz;
	}

	Intersection i;

	i.pos = intersectionPos;
	i.distance = planeRayDist;
	i.angle = rayPlaneAngle;

	return i;
}




























struct CloudProperties
{
	float altitude;
	float thickness;
	float coverage;
	float density;
	float lightingDensity;
	float roughness;
};

CloudProperties CloudPropertiesLerp(CloudProperties cp1, CloudProperties cp2, float x)
{
	CloudProperties cp;

	cp.altitude = mix(cp1.altitude, cp2.altitude, x);
	cp.thickness = mix(cp1.thickness, cp2.thickness, x);
	cp.coverage = mix(cp1.coverage, cp2.coverage, x);
	cp.density = mix(cp1.density, cp2.density, x);
	cp.lightingDensity = mix(cp1.lightingDensity, cp2.lightingDensity, x);
	cp.roughness = mix(cp1.roughness, cp2.roughness, x);

	return cp;
}


CloudProperties GetGlobalCloudProperties()
{
	CloudProperties cloudPropertiesClear;
	cloudPropertiesClear.altitude = 356.0;
	cloudPropertiesClear.thickness = 365.0;
	cloudPropertiesClear.coverage = -0.2;
	// cloudPropertiesClear.coverage = mix(-0.3, 0.5, sin(frameTimeCounter * 0.5) * 0.5 + 0.5);
	cloudPropertiesClear.density = 0.1;
	cloudPropertiesClear.lightingDensity = 0.5;
	cloudPropertiesClear.roughness = 1.0;

	CloudProperties cloudPropertiesRain;
	cloudPropertiesRain.altitude = 356.0;
	cloudPropertiesRain.thickness = 465.0;
	cloudPropertiesRain.coverage = 0.45;
	cloudPropertiesRain.density = 0.4;
	cloudPropertiesRain.lightingDensity = 1.5;
	cloudPropertiesRain.roughness = 1.0;

	CloudProperties cp = CloudPropertiesLerp(cloudPropertiesClear, cloudPropertiesRain, rainStrength);

	return cp;
}





float GetCloudHeightDensity(CloudProperties cp, vec3 worldPos, bool forLighting)
{
	float w = 0.5;
	float highPoint = cp.altitude + cp.thickness * 1.0;
	float lowPoint =  cp.altitude;
	float midPoint = mix(lowPoint, highPoint, 0.2);

	// float density = smoothstep(0.0, 1.0, 1.0 - abs(worldPos.y - cp.altitude) / cp.thickness);
	// density *= 1.0 - remap(lowPoint, highPoint, worldPos.y);
	// density = pow(density, 0.25);

	float density = remap(lowPoint, midPoint, worldPos.y);
	density *= remap(highPoint, midPoint, worldPos.y);
	density = smoothstep(0.0, 1.0, density);
	// density = pow(density, 0.1251);


	// density /= remap(highPoint, midPoint2, worldPos.y) + 0.1;
	// density /= remap(highPoint, midPoint2, worldPos.y) + 0.1;


	return density;
}

float GetCloudDensity(CloudProperties cp, vec3 worldPos, float roughness, vec2 clampOffsets, bool forLighting, float detailNoise)
{
	vec3 pos = worldPos * 0.00195;
	float noiseGain = 1.0;
	float noiseTotal = 0.0;

	pos.x -= frameTimeCounter * 0.01;
	pos.z -= frameTimeCounter * 0.001;
	pos.y += frameTimeCounter * 0.0025;



	roughness *= 1.0 * cp.roughness;

	float noise = 0.0;
	noise =  mix(Get2DNoise(pos), 1.0, saturate(cp.coverage));  			 		noiseTotal += 1.0;  		pos *= 3.0; noiseGain *= 0.333 * roughness; pos.xy -= frameTimeCounter * 0.01;
	// noise =  Get2DNoise(pos) * (cp.coverage + 1.0);  			 		noiseTotal += 1.0;  		pos *= 3.0; noiseGain *= 0.333 * roughness; pos.xy -= frameTimeCounter * 0.01;
	noise *= GetCloudHeightDensity(cp, worldPos, forLighting);
	noise -= Get3DNoise(pos) * noiseGain * 1.0;  				noiseTotal-= noiseGain;    	pos *= 3.0; noiseGain *= 0.333 * roughness; 									
	noise -= Get3DNoise(pos) * noiseGain;  						noiseTotal-= noiseGain;    	pos *= 3.0; noiseGain *= 0.333 * roughness; 									




	noise /= noiseTotal;
	noise *= 0.8;

	noise -= saturate(-cp.coverage);


	if (!forLighting)
	{
		noise -= (detailNoise - 1.33) * 0.4 * roughness;
	}


	noise = smoothstep(0.3 - clampOffsets.x, 0.85 + clampOffsets.y, noise);



	//clouds more dense at top
	float w = forLighting ? 0.7 : 0.5;
	float highPoint = cp.altitude + cp.thickness * 1.0;
	float lowPoint =  cp.altitude;

	if (!forLighting)
	noise = saturate(noise * mix(1.0, 25.0, pow(remap(lowPoint, highPoint, worldPos.y), 2.0)));



	return noise;
}

float CloudShadow(vec4 worldPos, vec3 worldLightVector, CloudProperties cloudProperties)
{
	Ray ray;
	ray.dir = worldLightVector;
	ray.origin = worldPos.xyz + cameraPosition.xyz;

	Plane plane;
	plane.normal = vec3(0.0, 1.0, 0.0);
	plane.origin = vec3(0.0, cloudProperties.altitude + cloudProperties.thickness * 0.2, 0.0);

	vec3 cloudCheckPos = RayPlaneIntersection(ray, plane).pos;

	float cloudDensity = GetCloudDensity(cloudProperties, cloudCheckPos, 1.0, vec2(0.2, -0.2), true, 0.0);

	return 1.0 - cloudDensity;
}






















