/*
 * Decompiled with CFR 0.152.
 */
package net.aurelj.dungeons_arise;

import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;
import net.aurelj.dungeons_arise.WDAConfiguredStructures;
import net.aurelj.dungeons_arise.WDAStructureMaps;
import net.aurelj.dungeons_arise.WDAStructures;
import net.aurelj.dungeons_arise.config.ConfigHelper;
import net.aurelj.dungeons_arise.config.WDAConfig;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="dungeons_arise")
public class DungeonsAriseMain {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "dungeons_arise";
    public static WDAConfig.WDAConfigValues WDAConfig = null;
    private static Method GETCODEC_METHOD;

    public DungeonsAriseMain() {
        WDAConfig = ConfigHelper.register(ModConfig.Type.COMMON, WDAConfig.WDAConfigValues::new, "when-dungeons-arise-common.toml");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        WDAStructures.DEFERRED_REGISTRY_STRUCTURE.register(modEventBus);
        modEventBus.addListener(this::setup);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        forgeBus.addListener(EventPriority.HIGH, this::biomeModification);
        forgeBus.addListener(WDAStructureMaps::onVillagerTradesEvent);
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            WDAStructures.setupStructures();
            WDAConfiguredStructures.registerConfiguredStructures();
        });
    }

    public void biomeModification(BiomeLoadingEvent event) {
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName());
        Set types = BiomeDictionary.getTypes((RegistryKey)key);
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && (types.contains(BiomeDictionary.Type.MOUNTAIN) || types.contains(BiomeDictionary.Type.COLD) && DungeonsAriseMain.WDAConfig.monasteryGenerates.get().booleanValue())) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_MONASTERY);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && (types.contains(BiomeDictionary.Type.HILLS) || types.contains(BiomeDictionary.Type.PLAINS)) && !types.contains(BiomeDictionary.Type.HOT) && DungeonsAriseMain.WDAConfig.illagerCampsiteGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_ILLAGER_CAMPSITE);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.FOREST) && types.contains(BiomeDictionary.Type.CONIFEROUS) && DungeonsAriseMain.WDAConfig.illagerCastleGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_ILLAGER_CASTLE);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && (types.contains(BiomeDictionary.Type.MOUNTAIN) || types.contains(BiomeDictionary.Type.CONIFEROUS)) && DungeonsAriseMain.WDAConfig.abandonedTempleGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_ABANDONED_TEMPLE);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.BEACH) && DungeonsAriseMain.WDAConfig.lighthouseGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_LIGHTHOUSE);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.FOREST) && !types.contains(BiomeDictionary.Type.COLD) && !types.contains(BiomeDictionary.Type.SAVANNA) && DungeonsAriseMain.WDAConfig.mushroomVillageGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_MUSHROOM_VILLAGE);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.FOREST) && !types.contains(BiomeDictionary.Type.COLD) && DungeonsAriseMain.WDAConfig.illagerHallGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_ILLAGER_HALL);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.PLAINS) && !types.contains(BiomeDictionary.Type.COLD) && !types.contains(BiomeDictionary.Type.SAVANNA) && DungeonsAriseMain.WDAConfig.smallPrairieHouseGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_SMALL_PRAIRIE_HOUSE);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.BEACH) && !types.contains(BiomeDictionary.Type.COLD) && DungeonsAriseMain.WDAConfig.fishingHutGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_FISHING_HUT);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && (types.contains(BiomeDictionary.Type.SWAMP) || !types.contains(BiomeDictionary.Type.COLD) && types.contains(BiomeDictionary.Type.FOREST)) && DungeonsAriseMain.WDAConfig.mushroomMinesGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_MUSHROOM_MINES);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.PLAINS) && DungeonsAriseMain.WDAConfig.coliseumGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_COLISEUM);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.PLAINS) && DungeonsAriseMain.WDAConfig.merchantCampsiteGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_MERCHANT_CAMPSITE);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.PLAINS) && DungeonsAriseMain.WDAConfig.wishingWellGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_WISHING_WELL);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.COLD) && DungeonsAriseMain.WDAConfig.illagerFortGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_ILLAGER_FORT);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.CONIFEROUS) && DungeonsAriseMain.WDAConfig.infestedTempleGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_INFESTED_TEMPLE);
        }
        if ((types.contains(BiomeDictionary.Type.OVERWORLD) || types.contains(BiomeDictionary.Type.END)) && DungeonsAriseMain.WDAConfig.heavenlyRiderGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_HEAVENLY_RIDER);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.SANDY) && types.contains(BiomeDictionary.Type.DRY) && DungeonsAriseMain.WDAConfig.miningSystemGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_MINING_SYSTEM);
        }
        if ((types.contains(BiomeDictionary.Type.OVERWORLD) || types.contains(BiomeDictionary.Type.END)) && DungeonsAriseMain.WDAConfig.heavenlyConquerorGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_HEAVENLY_CONQUEROR);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.DRY) && DungeonsAriseMain.WDAConfig.scorchedMinesGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_SCORCHED_MINES);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.OCEAN) && !types.contains(BiomeDictionary.Type.COLD) && DungeonsAriseMain.WDAConfig.undeadPirateShipGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_UNDEAD_PIRATE_SHIP);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && DungeonsAriseMain.WDAConfig.foundryGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_FOUNDRY);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && DungeonsAriseMain.WDAConfig.smallBlimpGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_SMALL_BLIMP);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.MESA) && DungeonsAriseMain.WDAConfig.banditVillageGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_BANDIT_VILLAGE);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.OCEAN) && types.contains(BiomeDictionary.Type.HOT) && DungeonsAriseMain.WDAConfig.typhonGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_TYPHON);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.SANDY) && types.contains(BiomeDictionary.Type.DRY) && DungeonsAriseMain.WDAConfig.ceryneianHindGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_CERYNEIAN_HIND);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.OCEAN) && !types.contains(BiomeDictionary.Type.COLD) && DungeonsAriseMain.WDAConfig.illagerCorsairGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_ILLAGER_CORSAIR);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.OCEAN) && !types.contains(BiomeDictionary.Type.COLD) && DungeonsAriseMain.WDAConfig.illagerGalleyGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_ILLAGER_GALLEY);
        }
        if ((types.contains(BiomeDictionary.Type.OVERWORLD) || types.contains(BiomeDictionary.Type.END)) && DungeonsAriseMain.WDAConfig.heavenlyChallengerGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_HEAVENLY_CHALLENGER);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.PLAINS) && !types.contains(BiomeDictionary.Type.COLD) && !types.contains(BiomeDictionary.Type.DRY) && !types.contains(BiomeDictionary.Type.HOT) && DungeonsAriseMain.WDAConfig.mushroomHouseGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_MUSHROOM_HOUSE);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.PLAINS) && !types.contains(BiomeDictionary.Type.COLD) && !types.contains(BiomeDictionary.Type.DRY) && !types.contains(BiomeDictionary.Type.HOT) && DungeonsAriseMain.WDAConfig.giantMushroomGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_GIANT_MUSHROOM);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.SANDY) && types.contains(BiomeDictionary.Type.DRY) && !types.contains(BiomeDictionary.Type.MESA) && DungeonsAriseMain.WDAConfig.shirazPalaceGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_SHIRAZ_PALACE);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && DungeonsAriseMain.WDAConfig.plagueAsylumGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_PLAGUE_ASYLUM);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.MESA) && DungeonsAriseMain.WDAConfig.banditTowersGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_BANDIT_TOWERS);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.FOREST) && !types.contains(BiomeDictionary.Type.COLD) && !types.contains(BiomeDictionary.Type.DRY) && DungeonsAriseMain.WDAConfig.thornbornTowersGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_THORNBORN_TOWERS);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && types.contains(BiomeDictionary.Type.JUNGLE) && DungeonsAriseMain.WDAConfig.jungleTreeHouseGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_JUNGLE_TREE_HOUSE);
        }
        if (types.contains(BiomeDictionary.Type.END) && DungeonsAriseMain.WDAConfig.aviaryGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_AVIARY);
        }
        if (types.contains(BiomeDictionary.Type.OVERWORLD) && (types.contains(BiomeDictionary.Type.PLAINS) || types.contains(Biomes.field_150585_R)) && !types.contains(BiomeDictionary.Type.COLD) && DungeonsAriseMain.WDAConfig.illagerWindmillGenerates.get().booleanValue()) {
            event.getGeneration().getStructures().add(() -> WDAConfiguredStructures.CONFIGURED_ILLAGER_WINDMILL);
        }
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)serverWorld.func_72863_F().field_186029_c, new Object[0])))) != null && cgRL.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Was unable to check if " + serverWorld.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator.");
            }
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.putIfAbsent(WDAStructures.MONASTERY.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.MONASTERY.get()));
            tempMap.putIfAbsent(WDAStructures.ILLAGER_CAMPSITE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.ILLAGER_CAMPSITE.get()));
            tempMap.putIfAbsent(WDAStructures.ILLAGER_CASTLE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.ILLAGER_CASTLE.get()));
            tempMap.putIfAbsent(WDAStructures.ABANDONED_TEMPLE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.ABANDONED_TEMPLE.get()));
            tempMap.putIfAbsent(WDAStructures.LIGHTHOUSE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.LIGHTHOUSE.get()));
            tempMap.putIfAbsent(WDAStructures.MUSHROOM_VILLAGE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.MUSHROOM_VILLAGE.get()));
            tempMap.putIfAbsent(WDAStructures.ILLAGER_HALL.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.ILLAGER_HALL.get()));
            tempMap.putIfAbsent(WDAStructures.SMALL_PRAIRIE_HOUSE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.SMALL_PRAIRIE_HOUSE.get()));
            tempMap.putIfAbsent(WDAStructures.FISHING_HUT.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.FISHING_HUT.get()));
            tempMap.putIfAbsent(WDAStructures.MUSHROOM_MINES.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.MUSHROOM_MINES.get()));
            tempMap.putIfAbsent(WDAStructures.COLISEUM.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.COLISEUM.get()));
            tempMap.putIfAbsent(WDAStructures.MERCHANT_CAMPSITE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.MERCHANT_CAMPSITE.get()));
            tempMap.putIfAbsent(WDAStructures.WISHING_WELL.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.WISHING_WELL.get()));
            tempMap.putIfAbsent(WDAStructures.ILLAGER_FORT.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.ILLAGER_FORT.get()));
            tempMap.putIfAbsent(WDAStructures.INFESTED_TEMPLE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.INFESTED_TEMPLE.get()));
            tempMap.putIfAbsent(WDAStructures.HEAVENLY_RIDER.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.HEAVENLY_RIDER.get()));
            tempMap.putIfAbsent(WDAStructures.MINING_SYSTEM.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.MINING_SYSTEM.get()));
            tempMap.putIfAbsent(WDAStructures.HEAVENLY_CONQUEROR.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.HEAVENLY_CONQUEROR.get()));
            tempMap.putIfAbsent(WDAStructures.SCORCHED_MINES.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.SCORCHED_MINES.get()));
            tempMap.putIfAbsent(WDAStructures.UNDEAD_PIRATE_SHIP.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.UNDEAD_PIRATE_SHIP.get()));
            tempMap.putIfAbsent(WDAStructures.FOUNDRY.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.FOUNDRY.get()));
            tempMap.putIfAbsent(WDAStructures.SMALL_BLIMP.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.SMALL_BLIMP.get()));
            tempMap.putIfAbsent(WDAStructures.BANDIT_VILLAGE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.BANDIT_VILLAGE.get()));
            tempMap.putIfAbsent(WDAStructures.TYPHON.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.TYPHON.get()));
            tempMap.putIfAbsent(WDAStructures.CERYNEIAN_HIND.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.CERYNEIAN_HIND.get()));
            tempMap.putIfAbsent(WDAStructures.HEAVENLY_CHALLENGER.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.HEAVENLY_CHALLENGER.get()));
            tempMap.putIfAbsent(WDAStructures.ILLAGER_CORSAIR.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.ILLAGER_CORSAIR.get()));
            tempMap.putIfAbsent(WDAStructures.ILLAGER_GALLEY.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.ILLAGER_GALLEY.get()));
            tempMap.putIfAbsent(WDAStructures.MUSHROOM_HOUSE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.MUSHROOM_HOUSE.get()));
            tempMap.putIfAbsent(WDAStructures.GIANT_MUSHROOM.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.GIANT_MUSHROOM.get()));
            tempMap.putIfAbsent(WDAStructures.SHIRAZ_PALACE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.SHIRAZ_PALACE.get()));
            tempMap.putIfAbsent(WDAStructures.PLAGUE_ASYLUM.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.PLAGUE_ASYLUM.get()));
            tempMap.putIfAbsent(WDAStructures.BANDIT_TOWERS.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.BANDIT_TOWERS.get()));
            tempMap.putIfAbsent(WDAStructures.THORNBORN_TOWERS.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.THORNBORN_TOWERS.get()));
            tempMap.putIfAbsent(WDAStructures.JUNGLE_TREE_HOUSE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.JUNGLE_TREE_HOUSE.get()));
            tempMap.putIfAbsent(WDAStructures.AVIARY.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WDAStructures.AVIARY.get()));
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }
}

