/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.spawnercompat;

import com.BrassAmber.ba_bt.block.tileentity.BTMobSpawnerTileEntity;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDreadSpawner;
import com.mrbysco.ageingspawners.config.SpawnerConfig;
import com.mrbysco.ageingspawners.util.AgeingHelper;
import com.mrbysco.ageingspawners.util.AgeingWorldData;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SpawnersEvents {

    public static class BRASSAMBERBATTLETOWER {
        @SubscribeEvent
        public void SpawnEvent(LivingSpawnEvent.CheckSpawn event) {
            if (!event.getWorld().func_201670_d() && event.isSpawner()) {
                AbstractSpawner spawner = event.getSpawner();
                IWorld world = event.getWorld();
                if (spawner != null) {
                    ResourceLocation registryName = event.getEntityLiving().func_200600_R().getRegistryName();
                    switch ((SpawnerConfig.EnumAgeingMode)SpawnerConfig.SERVER.spawnerMode.get()) {
                        case BLACKLIST: {
                            this.handleBlacklist((World)world, spawner, registryName);
                            break;
                        }
                        case WHITELIST: {
                            this.handleWhitelist((World)world, spawner, registryName);
                        }
                    }
                }
            }
        }

        public void handleBlacklist(World world, AbstractSpawner spawner, ResourceLocation registryName) {
            if (!AgeingHelper.blacklistContains((ResourceLocation)registryName)) {
                this.ageTheSpawner(world, spawner, (Integer)SpawnerConfig.SERVER.blacklistMaxSpawnCount.get());
            } else {
                BlockPos pos = spawner.func_177221_b();
                ResourceLocation dimensionLocation = world.func_234923_W_().func_240901_a_();
                AgeingWorldData worldData = AgeingWorldData.get((World)world);
                Map locationMap = worldData.getMapFromWorld(dimensionLocation);
                locationMap.remove(pos);
                worldData.setMapForWorld(dimensionLocation, locationMap);
                worldData.func_76185_a();
            }
        }

        public void handleWhitelist(World world, AbstractSpawner spawner, ResourceLocation registryName) {
            if (AgeingHelper.whitelistContains((ResourceLocation)registryName)) {
                int maxSpawnCount = AgeingHelper.getMaxSpawnCount((ResourceLocation)registryName);
                this.ageTheSpawner(world, spawner, maxSpawnCount);
            } else {
                BlockPos pos = spawner.func_177221_b();
                ResourceLocation dimensionLocation = world.func_234923_W_().func_240901_a_();
                AgeingWorldData worldData = AgeingWorldData.get((World)world);
                Map locationMap = worldData.getMapFromWorld(dimensionLocation);
                locationMap.remove(pos);
                worldData.setMapForWorld(dimensionLocation, locationMap);
                worldData.func_76185_a();
            }
        }

        public void ageTheSpawner(World world, AbstractSpawner spawner, int maxCount) {
            BlockPos spawnerPos = spawner.func_177221_b();
            ResourceLocation dimensionLocation = world.func_234923_W_().func_240901_a_();
            AgeingWorldData worldData = AgeingWorldData.get((World)world);
            Map locationMap = worldData.getMapFromWorld(dimensionLocation);
            if (world.func_175625_s(spawnerPos) != null && world.func_175625_s(spawnerPos) instanceof BTMobSpawnerTileEntity) {
                int spawnCount = locationMap.getOrDefault(spawnerPos, 0);
                if (++spawnCount >= maxCount) {
                    world.func_217377_a(spawnerPos, false);
                    locationMap.remove(spawnerPos);
                } else {
                    locationMap.put(spawnerPos, spawnCount);
                }
            }
            worldData.setMapForWorld(dimensionLocation, locationMap);
            worldData.func_76185_a();
        }

        @SubscribeEvent
        public void breakEvent(BlockEvent.BreakEvent event) {
            if (!event.getWorld().func_201670_d()) {
                BlockPos pos = event.getPos();
                World world = (World)event.getWorld();
                ResourceLocation dimensionLocation = world.func_234923_W_().func_240901_a_();
                Map locationMap = AgeingWorldData.get((World)world).getMapFromWorld(dimensionLocation);
                locationMap.remove(pos);
            }
        }
    }

    public static class ICEANDFIRE {
        @SubscribeEvent
        public void SpawnEvent(LivingSpawnEvent.CheckSpawn event) {
            if (!event.getWorld().func_201670_d() && event.isSpawner()) {
                AbstractSpawner spawner = event.getSpawner();
                IWorld world = event.getWorld();
                if (spawner != null) {
                    ResourceLocation registryName = event.getEntityLiving().func_200600_R().getRegistryName();
                    switch ((SpawnerConfig.EnumAgeingMode)SpawnerConfig.SERVER.spawnerMode.get()) {
                        case BLACKLIST: {
                            this.handleBlacklist((World)world, spawner, registryName);
                            break;
                        }
                        case WHITELIST: {
                            this.handleWhitelist((World)world, spawner, registryName);
                        }
                    }
                }
            }
        }

        public void handleBlacklist(World world, AbstractSpawner spawner, ResourceLocation registryName) {
            if (!AgeingHelper.blacklistContains((ResourceLocation)registryName)) {
                this.ageTheSpawner(world, spawner, (Integer)SpawnerConfig.SERVER.blacklistMaxSpawnCount.get());
            } else {
                BlockPos pos = spawner.func_177221_b();
                ResourceLocation dimensionLocation = world.func_234923_W_().func_240901_a_();
                AgeingWorldData worldData = AgeingWorldData.get((World)world);
                Map locationMap = worldData.getMapFromWorld(dimensionLocation);
                locationMap.remove(pos);
                worldData.setMapForWorld(dimensionLocation, locationMap);
                worldData.func_76185_a();
            }
        }

        public void handleWhitelist(World world, AbstractSpawner spawner, ResourceLocation registryName) {
            if (AgeingHelper.whitelistContains((ResourceLocation)registryName)) {
                int maxSpawnCount = AgeingHelper.getMaxSpawnCount((ResourceLocation)registryName);
                this.ageTheSpawner(world, spawner, maxSpawnCount);
            } else {
                BlockPos pos = spawner.func_177221_b();
                ResourceLocation dimensionLocation = world.func_234923_W_().func_240901_a_();
                AgeingWorldData worldData = AgeingWorldData.get((World)world);
                Map locationMap = worldData.getMapFromWorld(dimensionLocation);
                locationMap.remove(pos);
                worldData.setMapForWorld(dimensionLocation, locationMap);
                worldData.func_76185_a();
            }
        }

        public void ageTheSpawner(World world, AbstractSpawner spawner, int maxCount) {
            BlockPos spawnerPos = spawner.func_177221_b();
            ResourceLocation dimensionLocation = world.func_234923_W_().func_240901_a_();
            AgeingWorldData worldData = AgeingWorldData.get((World)world);
            Map locationMap = worldData.getMapFromWorld(dimensionLocation);
            if (world.func_175625_s(spawnerPos) != null && world.func_175625_s(spawnerPos) instanceof TileEntityDreadSpawner) {
                int spawnCount = locationMap.getOrDefault(spawnerPos, 0);
                if (++spawnCount >= maxCount) {
                    world.func_217377_a(spawnerPos, false);
                    locationMap.remove(spawnerPos);
                } else {
                    locationMap.put(spawnerPos, spawnCount);
                }
            }
            worldData.setMapForWorld(dimensionLocation, locationMap);
            worldData.func_76185_a();
        }

        @SubscribeEvent
        public void breakEvent(BlockEvent.BreakEvent event) {
            if (!event.getWorld().func_201670_d()) {
                BlockPos pos = event.getPos();
                World world = (World)event.getWorld();
                ResourceLocation dimensionLocation = world.func_234923_W_().func_240901_a_();
                Map locationMap = AgeingWorldData.get((World)world).getMapFromWorld(dimensionLocation);
                locationMap.remove(pos);
            }
        }
    }
}

