/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.misc;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class BlossomLootModifier
extends LootModifier {
    public BlossomLootModifier(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (AMConfig.acaciaBlossomsDropFromLeaves) {
            int bananaStep;
            int silkTouch;
            ItemStack ctxTool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
            Random random = context.func_216032_b();
            if (ctxTool != null && ((silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)ctxTool)) > 0 || ctxTool.func_77973_b() instanceof ShearsItem)) {
                return generatedLoot;
            }
            int bonusLevel = ctxTool != null ? EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)ctxTool) : 0;
            int bananaRarity = AMConfig.blossomChance - bonusLevel * (bananaStep = (int)Math.min((float)AMConfig.blossomChance * 0.1f, 0.0f));
            if (bananaRarity < 1 || random.nextInt(bananaRarity) == 0) {
                generatedLoot.add(new ItemStack((IItemProvider)AMItemRegistry.ACACIA_BLOSSOM));
            }
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<BlossomLootModifier> {
        public BlossomLootModifier read(ResourceLocation name, JsonObject object, ILootCondition[] conditionsIn) {
            return new BlossomLootModifier(conditionsIn);
        }

        public JsonObject write(BlossomLootModifier instance) {
            return null;
        }
    }
}

