/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.item;

import com.github.alexthe666.alexsmobs.entity.EntityCachalotEcho;
import com.github.alexthe666.alexsmobs.misc.AMPointOfInterestRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.google.common.base.Predicates;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ItemEcholocator
extends Item {
    public boolean ender;

    public ItemEcholocator(Item.Properties properties, boolean ender) {
        super(properties);
        this.ender = ender;
    }

    private List<BlockPos> getNearbyPortals(BlockPos blockpos, ServerWorld world, int range) {
        if (this.ender) {
            PointOfInterestManager pointofinterestmanager = world.func_217443_B();
            Stream stream = pointofinterestmanager.func_225399_a(AMPointOfInterestRegistry.END_PORTAL_FRAME.func_221045_c(), (Predicate)Predicates.alwaysTrue(), blockpos, range, PointOfInterestManager.Status.ANY);
            return stream.collect(Collectors.toList());
        }
        Random random = new Random();
        for (int i = 0; i < 256; ++i) {
            BlockPos checkPos = blockpos.func_177982_a(random.nextInt(range) - range / 2, random.nextInt(range) / 2 - range / 2, random.nextInt(range) - range / 2);
            if (world.func_180495_p(checkPos).func_177230_c() != Blocks.field_201941_jj || world.func_201696_r(checkPos) >= 4) continue;
            return Collections.singletonList(checkPos);
        }
        return Collections.emptyList();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity livingEntityIn, Hand handIn) {
        ItemStack stack = livingEntityIn.func_184586_b(handIn);
        boolean left = false;
        if (livingEntityIn.func_184600_cs() == Hand.OFF_HAND && livingEntityIn.func_184591_cq() == HandSide.RIGHT || livingEntityIn.func_184600_cs() == Hand.MAIN_HAND && livingEntityIn.func_184591_cq() == HandSide.LEFT) {
            left = true;
        }
        EntityCachalotEcho whaleEcho = new EntityCachalotEcho(worldIn, (LivingEntity)livingEntityIn, !left);
        if (!worldIn.field_72995_K && worldIn instanceof ServerWorld) {
            BlockPos playerPos = livingEntityIn.func_233580_cy_();
            List<BlockPos> portals = this.getNearbyPortals(playerPos, (ServerWorld)worldIn, 128);
            BlockPos pos = null;
            if (this.ender) {
                for (BlockPos portalPos : portals) {
                    if (pos != null && !(pos.func_177951_i((Vector3i)playerPos) > portalPos.func_177951_i((Vector3i)playerPos))) continue;
                    pos = portalPos;
                }
            } else {
                CompoundNBT nbt = stack.func_196082_o();
                if (nbt.func_74764_b("CavePos") && nbt.func_74767_n("ValidCavePos")) {
                    pos = BlockPos.func_218283_e((long)nbt.func_74763_f("CavePos"));
                    if (worldIn.func_180495_p(pos).func_177230_c() != Blocks.field_201941_jj || worldIn.func_201696_r(pos) >= 4 || 1000000.0 < pos.func_177951_i((Vector3i)playerPos)) {
                        nbt.func_74757_a("ValidCavePos", false);
                    }
                } else {
                    for (BlockPos portalPos : portals) {
                        if (pos != null && !(pos.func_177951_i((Vector3i)playerPos) < portalPos.func_177951_i((Vector3i)playerPos))) continue;
                        pos = portalPos;
                    }
                    if (pos != null) {
                        nbt.func_74772_a("CavePos", pos.func_218275_a());
                        nbt.func_74757_a("ValidCavePos", true);
                        stack.func_77982_d(nbt);
                    }
                }
            }
            if (pos != null) {
                double d0 = (double)((float)pos.func_177958_n() + 0.5f) - whaleEcho.func_226277_ct_();
                double d1 = (double)((float)pos.func_177956_o() + 0.5f) - whaleEcho.func_226278_cu_();
                double d2 = (double)((float)pos.func_177952_p() + 0.5f) - whaleEcho.func_226281_cx_();
                whaleEcho.field_70173_aa = 15;
                whaleEcho.shoot(d0, d1, d2, 0.4f, 0.3f);
                worldIn.func_217376_c((Entity)whaleEcho);
                worldIn.func_184148_a((PlayerEntity)null, whaleEcho.func_226277_ct_(), whaleEcho.func_226278_cu_(), whaleEcho.func_226281_cx_(), AMSoundRegistry.CACHALOT_WHALE_CLICK, SoundCategory.PLAYERS, 1.0f, 1.0f);
                stack.func_222118_a(1, (LivingEntity)livingEntityIn, player -> player.func_213334_d(livingEntityIn.func_184600_cs()));
            }
        }
        livingEntityIn.func_184811_cZ().func_185145_a((Item)this, 5);
        return ActionResult.func_233538_a_((Object)stack, (boolean)worldIn.func_201670_d());
    }
}

