/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityShoebill;
import java.util.EnumSet;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.Heightmap;

public class ShoebillAIFlightFlee
extends Goal {
    private EntityShoebill bird;
    private BlockPos currentTarget = null;
    private int executionTime = 0;

    public ShoebillAIFlightFlee(EntityShoebill bird) {
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.bird = bird;
    }

    public void func_75251_c() {
        this.currentTarget = null;
        this.executionTime = 0;
        this.bird.setFlying(false);
    }

    public boolean func_75253_b() {
        return this.bird.isFlying() && (this.executionTime < 15 || !this.bird.func_233570_aj_());
    }

    public boolean func_75250_a() {
        return this.bird.revengeCooldown > 0 && this.bird.func_233570_aj_();
    }

    public void func_75249_e() {
        if (this.bird.func_233570_aj_()) {
            this.bird.setFlying(true);
        }
    }

    public void func_75246_d() {
        ++this.executionTime;
        if (this.currentTarget == null) {
            this.currentTarget = this.bird.revengeCooldown == 0 ? this.getBlockGrounding(this.bird.func_213303_ch()) : this.getBlockInViewAway(this.bird.func_213303_ch());
        }
        if (this.currentTarget != null) {
            this.bird.func_70661_as().func_75492_a((double)((float)this.currentTarget.func_177958_n() + 0.5f), (double)((float)this.currentTarget.func_177956_o() + 0.5f), (double)((float)this.currentTarget.func_177952_p() + 0.5f), 1.0);
            if (this.bird.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.currentTarget)) < 4.0) {
                this.currentTarget = null;
            }
        }
        if (this.bird.revengeCooldown == 0 && (this.bird.func_70090_H() || !this.bird.field_70170_p.func_175623_d(this.bird.func_233580_cy_().func_177977_b()))) {
            this.func_75251_c();
            this.bird.setFlying(false);
        }
    }

    public BlockPos getBlockInViewAway(Vector3d fleePos) {
        float radius = -9.45f - (float)this.bird.func_70681_au().nextInt(24);
        float neg = this.bird.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.bird.field_70761_aq;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.bird.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(fleePos.func_82615_a() + extraX, 0.0, fleePos.func_82616_c() + extraZ);
        BlockPos ground = this.bird.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, radialPos);
        int distFromGround = (int)this.bird.func_226278_cu_() - ground.func_177956_o();
        int flightHeight = 4 + this.bird.func_70681_au().nextInt(10);
        BlockPos newPos = radialPos.func_177981_b(distFromGround > 8 ? flightHeight : (int)this.bird.func_226278_cu_() + this.bird.func_70681_au().nextInt(6) + 1);
        if (!this.bird.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)newPos)) && this.bird.func_195048_a(Vector3d.func_237489_a_((Vector3i)newPos)) > 6.0) {
            return newPos;
        }
        return null;
    }

    public BlockPos getBlockGrounding(Vector3d fleePos) {
        float radius = -9.45f - (float)this.bird.func_70681_au().nextInt(24);
        float neg = this.bird.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.bird.field_70761_aq;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.bird.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(fleePos.func_82615_a() + extraX, 0.0, fleePos.func_82616_c() + extraZ);
        BlockPos ground = this.bird.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, radialPos);
        if (!this.bird.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)ground.func_177984_a()))) {
            return ground;
        }
        return null;
    }
}

