/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityCrimsonMosquito;
import com.github.alexthe666.alexsmobs.entity.EntityHemolymph;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.FlightMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityWarpedMosco
extends MonsterEntity
implements IAnimatedEntity {
    public static final Animation ANIMATION_PUNCH_R = Animation.create((int)25);
    public static final Animation ANIMATION_PUNCH_L = Animation.create((int)25);
    public static final Animation ANIMATION_SLAM = Animation.create((int)35);
    public static final Animation ANIMATION_SUCK = Animation.create((int)60);
    public static final Animation ANIMATION_SPIT = Animation.create((int)60);
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityWarpedMosco.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HAND_SIDE = EntityDataManager.func_187226_a(EntityWarpedMosco.class, (IDataSerializer)DataSerializers.field_187198_h);
    public float flyLeftProgress;
    public float prevLeftFlyProgress;
    public float flyRightProgress;
    public float prevFlyRightProgress;
    private int animationTick;
    private Animation currentAnimation;
    private boolean isLandNavigator;
    private int timeFlying;
    private int loopSoundTick = 0;

    protected EntityWarpedMosco(EntityType entityType, World world) {
        super(entityType, world);
        this.field_70728_aV = 30;
        this.switchNavigator(false);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 100.0).func_233815_a_(Attributes.field_233819_b_, 128.0).func_233815_a_(Attributes.field_233823_f_, 10.0).func_233815_a_(Attributes.field_233826_i_, 10.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233827_j_, 2.0).func_233815_a_(Attributes.field_233821_d_, 0.3);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    private static Animation getRandomAttack(Random rand) {
        switch (rand.nextInt(4)) {
            case 0: {
                return ANIMATION_PUNCH_L;
            }
            case 1: {
                return ANIMATION_PUNCH_R;
            }
            case 2: {
                return ANIMATION_SLAM;
            }
            case 3: {
                return ANIMATION_SUCK;
            }
        }
        return ANIMATION_SUCK;
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.WARPED_MOSCO_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.WARPED_MOSCO_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.WARPED_MOSCO_HURT;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new AttackGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new AIWalkIdle());
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 32.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{EntityCrimsonMosquito.class, EntityWarpedMosco.class}));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestTarget3D<PlayerEntity>((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestTarget3D<LivingEntity>((MobEntity)this, LivingEntity.class, 50, false, true, AMEntityRegistry.buildPredicateFromTag(EntityTypeTags.func_219762_a().func_199910_a(AMTagRegistry.CRIMSON_MOSQUITO_TARGETS))));
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new GroundPathNavigatorWide((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new FlightMoveController((MobEntity)this, 0.7f, false);
            this.field_70699_by = new DirectPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
        this.field_70180_af.func_187214_a(HAND_SIDE, (Object)true);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(FLYING);
    }

    public void setFlying(boolean flying) {
        this.setDashRight(flying != this.isFlying() ? this.field_70146_Z.nextBoolean() : this.isDashRight());
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
    }

    public boolean isDashRight() {
        return (Boolean)this.field_70180_af.func_187225_a(HAND_SIDE);
    }

    public void setDashRight(boolean right) {
        this.field_70180_af.func_187227_b(HAND_SIDE, (Object)right);
    }

    public void func_70071_h_() {
        LivingEntity target;
        super.func_70071_h_();
        this.prevFlyRightProgress = this.flyRightProgress;
        this.prevLeftFlyProgress = this.flyLeftProgress;
        if (this.isFlying() && this.isDashRight() && this.flyRightProgress < 5.0f) {
            this.flyRightProgress += 1.0f;
        }
        if (!(this.isFlying() && this.isDashRight() || !(this.flyRightProgress > 0.0f))) {
            this.flyRightProgress -= 1.0f;
        }
        if (this.isFlying() && !this.isDashRight() && this.flyLeftProgress < 5.0f) {
            this.flyLeftProgress += 1.0f;
        }
        if ((!this.isFlying() || this.isDashRight()) && this.flyLeftProgress > 0.0f) {
            this.flyLeftProgress -= 1.0f;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isFlying() && this.isLandNavigator) {
                this.switchNavigator(false);
            }
            if (!this.isFlying() && !this.isLandNavigator) {
                this.switchNavigator(true);
            }
        }
        if (this.isFlying()) {
            if (this.loopSoundTick == 0) {
                this.func_184185_a(AMSoundRegistry.MOSQUITO_LOOP, this.func_70599_aP(), this.func_70647_i() * 0.3f);
            }
            ++this.loopSoundTick;
            if (this.loopSoundTick > 100) {
                this.loopSoundTick = 0;
            }
        }
        if (this.isFlying()) {
            ++this.timeFlying;
            this.func_189654_d(true);
            if (this.func_184218_aH() || this.func_184207_aI()) {
                this.setFlying(false);
            }
        } else {
            this.timeFlying = 0;
            this.func_189654_d(false);
        }
        ITag transformMatches = BlockTags.func_199896_a().func_199910_a(AMTagRegistry.WARPED_MOSCO_BREAKABLES);
        if (this.field_70123_F && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            boolean flag = false;
            AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_186662_g(0.2);
            for (BlockPos blockpos : BlockPos.func_191531_b((int)MathHelper.func_76128_c((double)axisalignedbb.field_72340_a), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72338_b), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72339_c), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72336_d), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72337_e), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72334_f))) {
                BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                Block block = blockstate.func_177230_c();
                if (!transformMatches.func_230235_a_((Object)block)) continue;
                flag = this.field_70170_p.func_225521_a_(blockpos, true, (Entity)this) || flag;
            }
            if (!flag && this.field_70122_E) {
                this.func_70664_aZ();
            }
        }
        if ((target = this.func_70638_az()) != null && this.func_70089_S()) {
            if (this.getAnimation() == ANIMATION_SUCK && this.getAnimationTick() == 3 && this.func_70032_d((Entity)target) < 4.7f) {
                target.func_184205_a((Entity)this, true);
            }
            if (this.getAnimation() == ANIMATION_SLAM && this.getAnimationTick() == 19) {
                for (Entity entity : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(5.0), null)) {
                    if (this.func_184191_r(entity) || entity instanceof EntityWarpedMosco || entity == this) continue;
                    entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 10.0f + this.field_70146_Z.nextFloat() * 8.0f);
                    this.launch(entity, true);
                }
            }
            if ((this.getAnimation() == ANIMATION_PUNCH_R || this.getAnimation() == ANIMATION_PUNCH_L) && this.getAnimationTick() == 13 && this.func_70032_d((Entity)target) < 4.7f) {
                target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_));
                this.knockbackRidiculous(target, 0.9f);
            }
        }
        if (this.getAnimation() == ANIMATION_SLAM && this.getAnimationTick() == 19) {
            this.spawnGroundEffects();
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void spawnGroundEffects() {
        float radius = 2.3f;
        for (int i = 0; i < 4; ++i) {
            for (int i1 = 0; i1 < 20 + this.field_70146_Z.nextInt(12); ++i1) {
                double motionX = this.func_70681_au().nextGaussian() * 0.07;
                double motionY = this.func_70681_au().nextGaussian() * 0.07;
                double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                float angle = (float)Math.PI / 180 * this.field_70761_aq + (float)i1;
                double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.8f;
                double extraZ = radius * MathHelper.func_76134_b((float)angle);
                BlockPos ground = this.getMoscoGround(new BlockPos(MathHelper.func_76128_c((double)(this.func_226277_ct_() + extraX)), MathHelper.func_76128_c((double)(this.func_226278_cu_() + extraY)) - 1, MathHelper.func_76128_c((double)(this.func_226281_cx_() + extraZ))));
                BlockState BlockState2 = this.field_70170_p.func_180495_p(ground);
                if (BlockState2.func_185904_a() == Material.field_151579_a || !this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_195590_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, BlockState2), true, this.func_226277_ct_() + extraX, (double)ground.func_177956_o() + extraY, this.func_226281_cx_() + extraZ, motionX, motionY, motionZ);
            }
        }
    }

    private void launch(Entity e, boolean huge) {
        if (e.func_233570_aj_()) {
            double d0 = e.func_226277_ct_() - this.func_226277_ct_();
            double d1 = e.func_226281_cx_() - this.func_226281_cx_();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            float f = huge ? 2.0f : 0.5f;
            e.func_70024_g(d0 / d2 * (double)f, huge ? 0.5 : (double)0.2f, d1 / d2 * (double)f);
        }
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PUNCH_L, ANIMATION_PUNCH_R, ANIMATION_SLAM, ANIMATION_SUCK, ANIMATION_SPIT};
    }

    private BlockPos getMoscoGround(BlockPos in) {
        BlockPos position = new BlockPos((double)in.func_177958_n(), this.func_226278_cu_(), (double)in.func_177952_p());
        while (position.func_177956_o() > 2 && this.field_70170_p.func_175623_d(position) && this.field_70170_p.func_204610_c(position).func_206888_e()) {
            position = position.func_177977_b();
        }
        return position;
    }

    public Vector3d getBlockGrounding(Vector3d fleePos) {
        float radius = -9.45f - (float)this.func_70681_au().nextInt(24);
        float neg = this.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.field_70761_aq;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(fleePos.func_82615_a() + extraX, this.func_226278_cu_(), fleePos.func_82616_c() + extraZ);
        BlockPos ground = this.getMoscoGround(radialPos);
        if (ground.func_177956_o() == 0) {
            return this.func_213303_ch();
        }
        ground = this.func_233580_cy_();
        while (ground.func_177956_o() > 2 && this.field_70170_p.func_175623_d(ground)) {
            ground = ground.func_177977_b();
        }
        if (!this.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)ground.func_177984_a()))) {
            return Vector3d.func_237489_a_((Vector3i)ground);
        }
        return null;
    }

    public Vector3d getBlockInViewAway(Vector3d fleePos, float radiusAdd) {
        float radius = -9.45f - (float)this.func_70681_au().nextInt(24) - radiusAdd;
        float neg = this.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.field_70761_aq;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(fleePos.func_82615_a() + extraX, 0.0, fleePos.func_82616_c() + extraZ);
        BlockPos ground = this.getMoscoGround(radialPos);
        int distFromGround = (int)this.func_226278_cu_() - ground.func_177956_o();
        int flightHeight = 4 + this.func_70681_au().nextInt(10);
        BlockPos newPos = ground.func_177981_b(distFromGround > 8 ? flightHeight : this.func_70681_au().nextInt(6) + 1);
        if (!this.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)newPos)) && this.func_195048_a(Vector3d.func_237489_a_((Vector3i)newPos)) > 1.0) {
            return Vector3d.func_237489_a_((Vector3i)newPos);
        }
        return null;
    }

    public void knockbackRidiculous(LivingEntity target, float power) {
        target.func_233627_a_(power, this.func_226277_ct_() - target.func_226277_ct_(), this.func_226281_cx_() - target.func_226281_cx_());
        float knockbackResist = (float)MathHelper.func_151237_a((double)(1.0 - this.func_233637_b_(Attributes.field_233820_c_)), (double)0.0, (double)1.0);
        target.func_213317_d(target.func_213322_ci().func_72441_c(0.0, (double)(knockbackResist * power * 0.45f), 0.0));
    }

    public boolean isTargetBlocked(Vector3d target) {
        Vector3d Vector3d2 = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() != RayTraceResult.Type.MISS;
    }

    private boolean isOverLiquid() {
        BlockPos position = this.func_233580_cy_();
        while (position.func_177956_o() > 2 && this.field_70170_p.func_175623_d(position)) {
            position = position.func_177977_b();
        }
        return !this.field_70170_p.func_204610_c(position).func_206888_e();
    }

    public void func_213352_e(Vector3d travelVector) {
        if ((this.getAnimation() == ANIMATION_SUCK || this.getAnimation() == ANIMATION_SLAM) && this.getAnimationTick() > 8) {
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            travelVector = Vector3d.field_186680_a;
            super.func_213352_e(travelVector);
            return;
        }
        super.func_213352_e(travelVector);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            int tick = 5;
            if (this.getAnimation() == ANIMATION_SUCK) {
                tick = this.getAnimationTick();
            } else {
                passenger.func_184210_p();
            }
            float radius = 2.0f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            double extraY = tick < 10 ? 0.0 : (double)(0.15f * (float)MathHelper.func_76125_a((int)(tick - 10), (int)0, (int)15));
            passenger.func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + extraY + (double)0.1f, this.func_226281_cx_() + extraZ);
            if ((tick - 10) % 4 == 0) {
                this.func_195064_c(new EffectInstance(Effects.field_76428_l, 100, 1));
                passenger.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_));
            }
        }
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.warpedMoscoSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    private void spit(LivingEntity target) {
        if (this.getAnimation() != ANIMATION_SPIT) {
            return;
        }
        this.func_70625_a((Entity)target, 100.0f, 100.0f);
        this.field_70761_aq = this.field_70759_as;
        for (int i = 0; i < 2 + this.field_70146_Z.nextInt(2); ++i) {
            EntityHemolymph llamaspitentity = new EntityHemolymph(this.field_70170_p, this);
            double d0 = target.func_226277_ct_() - this.func_226277_ct_();
            double d1 = target.func_226283_e_(0.3333333333333333) - llamaspitentity.func_226278_cu_();
            double d2 = target.func_226281_cx_() - this.func_226281_cx_();
            float f = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
            llamaspitentity.shoot(d0, d1 + (double)f, d2, 1.5f, 5.0f);
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_191255_dF, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            }
            this.field_70170_p.func_217376_c((Entity)llamaspitentity);
        }
    }

    private boolean shouldRangeAttack(LivingEntity target) {
        if ((double)this.func_110143_aJ() < Math.floor(this.func_110138_aP() * 0.25f)) {
            return true;
        }
        return this.func_110143_aJ() < this.func_110143_aJ() * 0.5f && this.func_70032_d((Entity)target) > 10.0f;
    }

    private class AttackGoal
    extends Goal {
        private int upTicks = 0;
        private int dashCooldown = 0;
        private boolean ranged = false;
        private BlockPos farTarget = null;

        public boolean func_75250_a() {
            return EntityWarpedMosco.this.func_70638_az() != null;
        }

        public void func_75246_d() {
            if (this.dashCooldown > 0) {
                --this.dashCooldown;
            }
            if (EntityWarpedMosco.this.func_70638_az() != null) {
                LivingEntity target = EntityWarpedMosco.this.func_70638_az();
                this.ranged = EntityWarpedMosco.this.shouldRangeAttack(target);
                if (EntityWarpedMosco.this.isFlying() || this.ranged || EntityWarpedMosco.this.func_70032_d((Entity)target) > 12.0f && !EntityWarpedMosco.this.isTargetBlocked(target.func_213303_ch().func_72441_c(0.0, (double)(target.func_213302_cg() * 0.6f), 0.0))) {
                    float speedRush = 5.0f;
                    ++this.upTicks;
                    EntityWarpedMosco.this.setFlying(true);
                    if (this.ranged) {
                        int tick;
                        if (this.farTarget == null || EntityWarpedMosco.this.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.farTarget)) < 9.0) {
                            this.farTarget = this.getAvoidTarget(target);
                        }
                        if (this.farTarget != null) {
                            EntityWarpedMosco.this.func_70605_aq().func_75642_a((double)this.farTarget.func_177958_n(), (double)((float)this.farTarget.func_177956_o() + target.func_70047_e() * 0.6f), (double)this.farTarget.func_177952_p(), 3.0);
                        }
                        EntityWarpedMosco.this.setAnimation(ANIMATION_SPIT);
                        if (this.upTicks % 30 == 0) {
                            EntityWarpedMosco.this.func_70691_i(1.0f);
                        }
                        if ((tick = EntityWarpedMosco.this.getAnimationTick()) == 10 || tick == 20 || tick == 30 || tick == 40) {
                            EntityWarpedMosco.this.spit(target);
                        }
                    } else if (this.upTicks > 20 || EntityWarpedMosco.this.func_70032_d((Entity)target) < 6.0f) {
                        EntityWarpedMosco.this.func_70605_aq().func_75642_a(target.func_226277_ct_(), target.func_226278_cu_() + (double)(target.func_70047_e() * 0.6f), target.func_226281_cx_(), (double)speedRush);
                    } else {
                        EntityWarpedMosco.this.func_70605_aq().func_75642_a(EntityWarpedMosco.this.func_226277_ct_(), EntityWarpedMosco.this.func_226278_cu_() + 3.0, EntityWarpedMosco.this.func_226281_cx_(), 0.5);
                    }
                } else {
                    EntityWarpedMosco.this.func_70661_as().func_75497_a((Entity)EntityWarpedMosco.this.func_70638_az(), 1.25);
                }
                if (EntityWarpedMosco.this.isFlying()) {
                    if (EntityWarpedMosco.this.func_70032_d((Entity)target) < 4.3f) {
                        if (this.dashCooldown == 0 || target.func_233570_aj_() || target.func_180799_ab() || target.func_70090_H()) {
                            target.func_70097_a(DamageSource.func_76358_a((LivingEntity)EntityWarpedMosco.this), 5.0f);
                            EntityWarpedMosco.this.knockbackRidiculous(target, 1.0f);
                            this.dashCooldown = 30;
                        }
                        float groundHeight = EntityWarpedMosco.this.getMoscoGround(EntityWarpedMosco.this.func_233580_cy_()).func_177956_o();
                        if (Math.abs(EntityWarpedMosco.this.func_226278_cu_() - (double)groundHeight) < 3.0 && !EntityWarpedMosco.this.isOverLiquid()) {
                            EntityWarpedMosco entityWarpedMosco = EntityWarpedMosco.this;
                            entityWarpedMosco.timeFlying = entityWarpedMosco.timeFlying + 300;
                            EntityWarpedMosco.this.setFlying(false);
                        }
                    }
                } else if (EntityWarpedMosco.this.func_70032_d((Entity)target) < 4.0f && EntityWarpedMosco.this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                    Animation animation = EntityWarpedMosco.getRandomAttack(EntityWarpedMosco.this.field_70146_Z);
                    if (animation == ANIMATION_SUCK && target.func_184218_aH()) {
                        animation = ANIMATION_SLAM;
                    }
                    EntityWarpedMosco.this.setAnimation(animation);
                }
            }
        }

        public BlockPos getAvoidTarget(LivingEntity target) {
            float radius = 10 + EntityWarpedMosco.this.func_70681_au().nextInt(8);
            float neg = EntityWarpedMosco.this.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
            float angle = (float)Math.PI / 180 * (target.field_70759_as + 90.0f + (float)EntityWarpedMosco.this.func_70681_au().nextInt(180));
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            BlockPos radialPos = new BlockPos(target.func_226277_ct_() + extraX, target.func_226278_cu_() + 1.0, target.func_226281_cx_() + extraZ);
            BlockPos ground = radialPos;
            if (EntityWarpedMosco.this.func_195048_a(Vector3d.func_237489_a_((Vector3i)ground)) > 30.0 && !EntityWarpedMosco.this.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)ground)) && EntityWarpedMosco.this.func_195048_a(Vector3d.func_237489_a_((Vector3i)ground)) > 6.0) {
                return ground;
            }
            return EntityWarpedMosco.this.func_233580_cy_();
        }

        public void func_75251_c() {
            this.upTicks = 0;
            this.dashCooldown = 0;
            this.ranged = false;
        }
    }

    private class AIWalkIdle
    extends Goal {
        protected final EntityWarpedMosco mosco;
        protected double x;
        protected double y;
        protected double z;
        private boolean flightTarget = false;

        public AIWalkIdle() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.mosco = EntityWarpedMosco.this;
        }

        public boolean func_75250_a() {
            if (this.mosco.func_184207_aI() || this.mosco.func_70638_az() != null && this.mosco.func_70638_az().func_70089_S() || this.mosco.func_184218_aH()) {
                return false;
            }
            if (this.mosco.func_70681_au().nextInt(30) != 0 && !this.mosco.isFlying()) {
                return false;
            }
            this.flightTarget = this.mosco.func_233570_aj_() ? EntityWarpedMosco.this.field_70146_Z.nextInt(8) == 0 : EntityWarpedMosco.this.field_70146_Z.nextInt(5) > 0 && this.mosco.timeFlying < 200;
            Vector3d lvt_1_1_ = this.getPosition();
            if (lvt_1_1_ == null) {
                return false;
            }
            this.x = lvt_1_1_.field_72450_a;
            this.y = lvt_1_1_.field_72448_b;
            this.z = lvt_1_1_.field_72449_c;
            return true;
        }

        public void func_75246_d() {
            if (this.flightTarget) {
                this.mosco.func_70605_aq().func_75642_a(this.x, this.y, this.z, 1.0);
            } else {
                this.mosco.func_70661_as().func_75492_a(this.x, this.y, this.z, 1.0);
            }
            if (!this.flightTarget && EntityWarpedMosco.this.isFlying() && this.mosco.field_70122_E) {
                this.mosco.setFlying(false);
            }
            if (EntityWarpedMosco.this.isFlying() && this.mosco.field_70122_E && this.mosco.timeFlying > 10) {
                this.mosco.setFlying(false);
            }
        }

        @Nullable
        protected Vector3d getPosition() {
            Vector3d vector3d = this.mosco.func_213303_ch();
            if (this.mosco.isOverLiquid()) {
                this.flightTarget = true;
            }
            if (this.flightTarget) {
                if (this.mosco.timeFlying < 50 || this.mosco.isOverLiquid()) {
                    return this.mosco.getBlockInViewAway(vector3d, 0.0f);
                }
                return this.mosco.getBlockGrounding(vector3d);
            }
            return RandomPositionGenerator.func_75463_a((CreatureEntity)this.mosco, (int)20, (int)7);
        }

        public boolean func_75253_b() {
            if (this.flightTarget) {
                return this.mosco.isFlying() && this.mosco.func_70092_e(this.x, this.y, this.z) > 20.0 && !this.mosco.field_70123_F;
            }
            return !this.mosco.func_70661_as().func_75500_f() && !this.mosco.func_184207_aI();
        }

        public void func_75249_e() {
            if (this.flightTarget) {
                this.mosco.setFlying(true);
                this.mosco.func_70605_aq().func_75642_a(this.x, this.y, this.z, 1.0);
            } else {
                this.mosco.func_70661_as().func_75492_a(this.x, this.y, this.z, 1.0);
            }
        }

        public void func_75251_c() {
            this.mosco.func_70661_as().func_75499_g();
            super.func_75251_c();
        }
    }
}

