/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityVoidPortal;
import com.github.alexthe666.alexsmobs.entity.EntityVoidWormPart;
import com.github.alexthe666.alexsmobs.entity.EntityVoidWormShot;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.FlightMoveController;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTriggerRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityVoidWorm
extends MonsterEntity {
    public static final ResourceLocation SPLITTER_LOOT = new ResourceLocation("alexsmobs", "entities/void_worm_splitter");
    private static final DataParameter<Optional<UUID>> CHILD_UUID = EntityDataManager.func_187226_a(EntityVoidWorm.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Optional<UUID>> SPLIT_FROM_UUID = EntityDataManager.func_187226_a(EntityVoidWorm.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Integer> SEGMENT_COUNT = EntityDataManager.func_187226_a(EntityVoidWorm.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> JAW_TICKS = EntityDataManager.func_187226_a(EntityVoidWorm.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> WORM_ANGLE = EntityDataManager.func_187226_a(EntityVoidWorm.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SPEEDMOD = EntityDataManager.func_187226_a(EntityVoidWorm.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> SPLITTER = EntityDataManager.func_187226_a(EntityVoidWorm.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> PORTAL_TICKS = EntityDataManager.func_187226_a(EntityVoidWorm.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    public float prevWormAngle;
    public float prevJawProgress;
    public float jawProgress;
    public Vector3d teleportPos = null;
    public EntityVoidPortal portalTarget = null;
    public boolean fullyThrough = true;
    public boolean updatePostSummon = false;
    private int makePortalCooldown = 0;
    private int stillTicks = 0;
    private int blockBreakCounter;
    private int makeIdlePortalCooldown = 200 + this.field_70146_Z.nextInt(800);

    protected EntityVoidWorm(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 10;
        this.field_70765_h = new FlightMoveController((MobEntity)this, 1.0f, false, true);
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.VOID_WORM_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.VOID_WORM_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.VOID_WORM_HURT;
    }

    protected float func_70599_aP() {
        return this.func_174814_R() ? 0.0f : 5.0f;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.voidWormSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public static boolean canVoidWormSpawn(EntityType animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return true;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, AMConfig.voidWormMaxHealth).func_233815_a_(Attributes.field_233826_i_, 4.0).func_233815_a_(Attributes.field_233819_b_, 256.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, 5.0);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.isSplitter() ? SPLITTER_LOOT : super.func_184647_J();
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && !this.isSplitter() && cause != null && cause.func_76346_g() instanceof ServerPlayerEntity) {
            AMAdvancementTriggerRegistry.VOID_WORM_SLAY_HEAD.trigger((ServerPlayerEntity)cause.func_76346_g());
        }
    }

    public ItemEntity func_199701_a_(ItemStack stack) {
        ItemEntity itementity = this.func_70099_a(stack, 0.0f);
        if (itementity != null) {
            itementity.func_189654_d(true);
            itementity.func_184195_f(true);
            itementity.func_174873_u();
        }
        return itementity;
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76379_h || source == DamageSource.field_76369_e || source == DamageSource.field_76368_d || source == DamageSource.field_82729_p || source == DamageSource.field_76371_c || source == DamageSource.field_76380_i || source.func_76347_k() || super.func_180431_b(source);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new AIEnterPortal());
        this.field_70714_bg.func_75776_a(2, (Goal)new AIAttack());
        this.field_70714_bg.func_75776_a(3, (Goal)new AIFlyIdle());
        this.field_70715_bh.func_75776_a(1, new EntityAINearestTarget3D<PlayerEntity>((MobEntity)this, PlayerEntity.class, 10, false, true, null));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestTarget3D<EnderDragonEntity>((MobEntity)this, EnderDragonEntity.class, 10, false, true, null));
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new DirectPathNavigator((MobEntity)this, this.field_70170_p);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_186855_b("ChildUUID")) {
            this.setChildId(compound.func_186857_a("ChildUUID"));
        }
        this.setWormSpeed(compound.func_74760_g("WormSpeed"));
        this.setSplitter(compound.func_74767_n("Splitter"));
        this.setPortalTicks(compound.func_74762_e("PortalTicks"));
        this.makeIdlePortalCooldown = compound.func_74762_e("MakePortalTime");
        this.makePortalCooldown = compound.func_74762_e("MakePortalCooldown");
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public boolean func_189652_ae() {
        return true;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.getChildId() != null) {
            compound.func_186854_a("ChildUUID", this.getChildId());
        }
        compound.func_74768_a("PortalTicks", this.getPortalTicks());
        compound.func_74768_a("MakePortalTime", this.makeIdlePortalCooldown);
        compound.func_74768_a("MakePortalCooldown", this.makePortalCooldown);
        compound.func_74776_a("WormSpeed", this.getWormSpeed());
        compound.func_74757_a("Splitter", this.isSplitter());
    }

    public Entity getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.field_70170_p.field_72995_K) {
            return ((ServerWorld)this.field_70170_p).func_217461_a(id);
        }
        return null;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return true;
    }

    public void func_70071_h_() {
        Entity child;
        float f2;
        super.func_70071_h_();
        this.prevWormAngle = this.getWormAngle();
        this.prevJawProgress = this.jawProgress;
        float threshold = 0.05f;
        this.field_70728_aV = this.isSplitter() ? 10 : 70;
        if (this.field_70126_B - this.field_70177_z > threshold) {
            this.setWormAngle(this.getWormAngle() + 15.0f);
        } else if (this.field_70126_B - this.field_70177_z < -threshold) {
            this.setWormAngle(this.getWormAngle() - 15.0f);
        } else if (this.getWormAngle() > 0.0f) {
            this.setWormAngle(Math.max(this.getWormAngle() - 20.0f, 0.0f));
        } else if (this.getWormAngle() < 0.0f) {
            this.setWormAngle(Math.min(this.getWormAngle() + 20.0f, 0.0f));
        }
        if (!this.field_70170_p.field_72995_K) {
            if (!this.fullyThrough) {
                this.func_213317_d(this.func_213322_ci().func_216372_d((double)0.9f, (double)0.9f, (double)0.9f).func_72441_c(0.0, -0.01, 0.0));
            } else {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.01, 0.0));
            }
        }
        this.stillTicks = Math.abs(this.field_70169_q - this.func_226277_ct_()) < (double)0.01f && Math.abs(this.field_70167_r - this.func_226278_cu_()) < (double)0.01f && Math.abs(this.field_70166_s - this.func_226281_cx_()) < (double)0.01f ? ++this.stillTicks : 0;
        if (this.stillTicks > 40 && this.makePortalCooldown == 0) {
            this.createStuckPortal();
        }
        if (this.makePortalCooldown > 0) {
            --this.makePortalCooldown;
        }
        if (this.makeIdlePortalCooldown > 0) {
            --this.makeIdlePortalCooldown;
        }
        if (this.makeIdlePortalCooldown == 0 && this.field_70146_Z.nextInt(100) == 0) {
            this.createPortalRandomDestination();
            this.makeIdlePortalCooldown = 200 + this.field_70146_Z.nextInt(1000);
        }
        if ((Integer)this.field_70180_af.func_187225_a(JAW_TICKS) > 0) {
            if (this.jawProgress < 5.0f) {
                this.jawProgress += 1.0f;
            }
            this.field_70180_af.func_187227_b(JAW_TICKS, (Object)((Integer)this.field_70180_af.func_187225_a(JAW_TICKS) - 1));
        } else if (this.jawProgress > 0.0f) {
            this.jawProgress -= 1.0f;
        }
        if (this.func_70089_S()) {
            for (Entity entity : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(2.0), null)) {
                if (entity.func_70028_i((Entity)this) || entity instanceof EntityVoidWormPart || entity.func_184191_r((Entity)this) || entity == this) continue;
                this.launch(entity, false);
            }
            this.field_70138_W = 2.0f;
        }
        this.field_70761_aq = this.field_70177_z;
        this.field_70125_A = f2 = (float)(-((double)((float)this.func_213322_ci().field_72448_b) * 57.2957763671875));
        this.field_70138_W = 2.0f;
        if (!this.field_70170_p.field_72995_K && (child = this.getChild()) == null) {
            Object partParent = this;
            int tailstart = Math.min(3 + this.field_70146_Z.nextInt(2), this.getSegmentCount());
            int segments = this.getSegmentCount();
            for (int i = 0; i < segments; ++i) {
                float scale = 1.0f + (float)i / (float)segments * 0.5f;
                boolean tail = false;
                if (i >= segments - tailstart) {
                    tail = true;
                    scale *= 0.85f;
                }
                EntityVoidWormPart part = new EntityVoidWormPart(AMEntityRegistry.VOID_WORM_PART, (LivingEntity)partParent, 1.0f + scale * (tail ? 0.65f : 0.3f) + (i == 0 ? 0.8f : 0.0f), 180.0f, i == 0 ? -0.0f : (i == segments - tailstart ? -0.3f : 0.0f));
                part.setParent((Entity)partParent);
                if (this.updatePostSummon) {
                    part.setPortalTicks(i * 2);
                }
                part.setBodyIndex(i);
                part.setTail(tail);
                part.setWormScale(scale);
                if (partParent == this) {
                    this.setChildId(part.func_110124_au());
                } else if (partParent instanceof EntityVoidWormPart) {
                    ((EntityVoidWormPart)partParent).setChildId(part.func_110124_au());
                }
                part.setInitialPartPos((Entity)this);
                partParent = part;
                this.field_70170_p.func_217376_c((Entity)part);
            }
        }
        if (this.getPortalTicks() > 0) {
            this.setPortalTicks(this.getPortalTicks() - 1);
            if (this.getPortalTicks() == 2 && this.teleportPos != null) {
                this.func_70107_b(this.teleportPos.field_72450_a, this.teleportPos.field_72448_b, this.teleportPos.field_72449_c);
                this.teleportPos = null;
            }
        }
        if (this.portalTarget != null && this.portalTarget.getLifespan() < 5) {
            this.portalTarget = null;
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        this.breakBlock();
        if (this.updatePostSummon) {
            this.updatePostSummon = false;
        }
        if (!this.func_174814_R() && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)67);
        }
    }

    public void setMaxHealth(double maxHealth, boolean heal) {
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(maxHealth);
        if (heal) {
            this.func_70691_i((float)maxHealth);
        }
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void teleportTo(Vector3d vec) {
        this.setPortalTicks(10);
        this.teleportPos = vec;
        this.fullyThrough = false;
        if (this.getChild() instanceof EntityVoidWormPart) {
            ((EntityVoidWormPart)this.getChild()).teleportTo(this.func_213303_ch(), this.teleportPos);
        }
    }

    private void launch(Entity e, boolean huge) {
        if (e.func_233570_aj_()) {
            double d0 = e.func_226277_ct_() - this.func_226277_ct_();
            double d1 = e.func_226281_cx_() - this.func_226281_cx_();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            float f = huge ? 2.0f : 0.5f;
            e.func_70024_g(d0 / d2 * (double)f, huge ? 0.5 : (double)0.2f, d1 / d2 * (double)f);
        }
    }

    public void resetWormScales() {
        Entity child;
        if (!this.field_70170_p.field_72995_K && (child = this.getChild()) == null) {
            Object nextPart = this;
            int tailstart = Math.min(3 + this.field_70146_Z.nextInt(2), this.getSegmentCount());
            int segments = this.getSegmentCount();
            int i = 0;
            while (nextPart instanceof EntityVoidWormPart) {
                EntityVoidWormPart part = (EntityVoidWormPart)((EntityVoidWormPart)nextPart).getChild();
                float scale = 1.0f + (float)(++i) / (float)segments * 0.5f;
                boolean tail = i >= segments - tailstart;
                part.setTail(tail);
                part.setWormScale(scale);
                part.radius = 1.0f + scale * (tail ? 0.65f : 0.3f) + (i == 0 ? 0.8f : 0.0f);
                part.offsetY = i == 0 ? -0.0f : (i == segments - tailstart ? -0.3f : 0.0f);
                nextPart = part;
            }
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setSegmentCount(25 + this.field_70146_Z.nextInt(15));
        this.field_70125_A = 0.0f;
        this.setMaxHealth(AMConfig.voidWormMaxHealth, true);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPLIT_FROM_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(CHILD_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(SEGMENT_COUNT, (Object)10);
        this.field_70180_af.func_187214_a(JAW_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(WORM_ANGLE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(SPEEDMOD, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(SPLITTER, (Object)false);
        this.field_70180_af.func_187214_a(PORTAL_TICKS, (Object)0);
    }

    public float getWormAngle() {
        return ((Float)this.field_70180_af.func_187225_a(WORM_ANGLE)).floatValue();
    }

    public void setWormAngle(float progress) {
        this.field_70180_af.func_187227_b(WORM_ANGLE, (Object)Float.valueOf(progress));
    }

    public float getWormSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(SPEEDMOD)).floatValue();
    }

    public void setWormSpeed(float progress) {
        if (this.getWormSpeed() != progress) {
            this.field_70765_h = new FlightMoveController((MobEntity)this, progress, false, true);
        }
        this.field_70180_af.func_187227_b(SPEEDMOD, (Object)Float.valueOf(progress));
    }

    public boolean isSplitter() {
        return (Boolean)this.field_70180_af.func_187225_a(SPLITTER);
    }

    public void setSplitter(boolean splitter) {
        this.field_70180_af.func_187227_b(SPLITTER, (Object)splitter);
    }

    public void openMouth(int time) {
        this.field_70180_af.func_187227_b(JAW_TICKS, (Object)time);
    }

    public boolean isMouthOpen() {
        return (float)((Integer)this.field_70180_af.func_187225_a(JAW_TICKS)).intValue() >= 5.0f;
    }

    @Nullable
    public UUID getChildId() {
        return ((Optional)this.field_70180_af.func_187225_a(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    @Nullable
    public UUID getSplitFromUUID() {
        return ((Optional)this.field_70180_af.func_187225_a(SPLIT_FROM_UUID)).orElse(null);
    }

    public void setSplitFromUuid(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(SPLIT_FROM_UUID, Optional.ofNullable(uniqueId));
    }

    public int getPortalTicks() {
        return (Integer)this.field_70180_af.func_187225_a(PORTAL_TICKS);
    }

    public void setPortalTicks(int ticks) {
        this.field_70180_af.func_187227_b(PORTAL_TICKS, (Object)ticks);
    }

    public int getSegmentCount() {
        return (Integer)this.field_70180_af.func_187225_a(SEGMENT_COUNT);
    }

    public void setSegmentCount(int command) {
        this.field_70180_af.func_187227_b(SEGMENT_COUNT, (Object)command);
    }

    public void func_85033_bc() {
        List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a((double)0.2f, 0.0, (double)0.2f));
        entities.stream().filter(entity -> !(entity instanceof EntityVoidWormPart) && entity.func_70104_M()).forEach(entity -> entity.func_70108_f((Entity)this));
    }

    public void func_70108_f(Entity entityIn) {
    }

    public void createStuckPortal() {
        if (this.func_70638_az() != null) {
            this.createPortal(this.func_70638_az().func_213303_ch().func_72441_c((double)(this.field_70146_Z.nextInt(8) - 4), (double)(2 + this.field_70146_Z.nextInt(3)), (double)(this.field_70146_Z.nextInt(8) - 4)));
        } else {
            Vector3d vec = Vector3d.func_237489_a_((Vector3i)this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING, this.func_233580_cy_().func_177981_b(this.field_70146_Z.nextInt(10) + 10)));
            this.createPortal(vec);
        }
    }

    public void createPortal(Vector3d to) {
        this.createPortal(this.func_213303_ch().func_178787_e(this.func_70040_Z().func_186678_a(20.0)), to, null);
    }

    public void createPortalRandomDestination() {
        Vector3d vec = null;
        for (int i = 0; i < 15; ++i) {
            BlockPos pos = new BlockPos(this.func_226277_ct_() + (double)this.field_70146_Z.nextInt(60) - 30.0, 0.0, this.func_226281_cx_() + (double)this.field_70146_Z.nextInt(60) - 30.0);
            BlockPos height = this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING, pos);
            height = height.func_177956_o() < 10 ? height.func_177981_b(50 + this.field_70146_Z.nextInt(50)) : height.func_177981_b(this.field_70146_Z.nextInt(30));
            if (!this.field_70170_p.func_175623_d(height)) continue;
            vec = Vector3d.func_237492_c_((Vector3i)height);
        }
        if (vec != null) {
            this.createPortal(this.func_213303_ch().func_178787_e(this.func_70040_Z().func_186678_a(20.0)), vec, null);
        }
    }

    public void createPortal(Vector3d from, Vector3d to, @Nullable Direction outDir) {
        if (!this.field_70170_p.field_72995_K && this.portalTarget == null) {
            Vector3d vec;
            Vector3d Vector3d2 = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
            BlockRayTraceResult result = this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, from, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
            Vector3d vector3d = vec = result.func_216347_e() != null ? result.func_216347_e() : this.func_213303_ch();
            if (result instanceof BlockRayTraceResult) {
                BlockRayTraceResult result1 = result;
                vec = vec.func_178787_e(Vector3d.func_237491_b_((Vector3i)result1.func_216354_b().func_176730_m()));
            }
            EntityVoidPortal portal = (EntityVoidPortal)AMEntityRegistry.VOID_PORTAL.func_200721_a(this.field_70170_p);
            portal.func_70107_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            Vector3d dirVec = vec.func_178788_d(this.func_213303_ch());
            Direction dir = Direction.func_210769_a((double)dirVec.field_72450_a, (double)dirVec.field_72448_b, (double)dirVec.field_72449_c);
            portal.setAttachmentFacing(dir);
            portal.setLifespan(10000);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_217376_c((Entity)portal);
            }
            this.portalTarget = portal;
            portal.setDestination(new BlockPos(to.field_72450_a, to.field_72448_b, to.field_72449_c), outDir);
            this.makePortalCooldown = 300;
        }
    }

    public void resetPortalLogic() {
        this.portalTarget = null;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void breakBlock() {
        if (this.blockBreakCounter > 0) {
            --this.blockBreakCounter;
            return;
        }
        boolean flag = false;
        if (!this.field_70170_p.field_72995_K && this.blockBreakCounter == 0 && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            for (int a = (int)Math.round(this.func_174813_aQ().field_72340_a); a <= (int)Math.round(this.func_174813_aQ().field_72336_d); ++a) {
                for (int b = (int)Math.round(this.func_174813_aQ().field_72338_b) - 1; b <= (int)Math.round(this.func_174813_aQ().field_72337_e) + 1 && b <= 127; ++b) {
                    for (int c = (int)Math.round(this.func_174813_aQ().field_72339_c); c <= (int)Math.round(this.func_174813_aQ().field_72334_f); ++c) {
                        BlockPos pos = new BlockPos(a, b, c);
                        BlockState state = this.field_70170_p.func_180495_p(pos);
                        FluidState fluidState = this.field_70170_p.func_204610_c(pos);
                        Block block = state.func_177230_c();
                        if (state.func_196958_f() || state.func_196954_c((IBlockReader)this.field_70170_p, pos).func_197766_b() || !BlockTags.func_199896_a().func_199910_a(AMTagRegistry.VOID_WORM_BREAKABLES).func_230235_a_((Object)state.func_177230_c()) || !fluidState.func_206888_e() || block == Blocks.field_150350_a) continue;
                        this.func_213317_d(this.func_213322_ci().func_216372_d((double)0.6f, 1.0, (double)0.6f));
                        flag = true;
                        this.field_70170_p.func_175655_b(pos, true);
                        if (!state.func_177230_c().func_203417_a((ITag)BlockTags.field_205213_E)) continue;
                        this.field_70170_p.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
                    }
                }
            }
        }
        if (flag) {
            this.blockBreakCounter = 10;
        }
    }

    public boolean isTargetBlocked(Vector3d target) {
        Vector3d Vector3d2 = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() != RayTraceResult.Type.MISS;
    }

    public Vector3d getBlockInViewAway(Vector3d fleePos, float radiusAdd) {
        float radius = (-9.45f - (float)this.func_70681_au().nextInt(24)) * radiusAdd;
        float neg = this.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.field_70761_aq;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(fleePos.func_82615_a() + extraX, 0.0, fleePos.func_82616_c() + extraZ);
        BlockPos ground = this.getGround(radialPos);
        int distFromGround = (int)this.func_226278_cu_() - ground.func_177956_o();
        int flightHeight = 10 + this.func_70681_au().nextInt(20);
        BlockPos newPos = ground.func_177981_b(distFromGround > 8 ? flightHeight : this.func_70681_au().nextInt(10) + 15);
        if (!this.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)newPos)) && this.func_195048_a(Vector3d.func_237489_a_((Vector3i)newPos)) > 1.0) {
            return Vector3d.func_237489_a_((Vector3i)newPos);
        }
        return null;
    }

    public Vector3d getBlockInViewAwaySlam(Vector3d fleePos, int slamHeight) {
        float radius = 3 + this.field_70146_Z.nextInt(3);
        float neg = this.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.field_70761_aq;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(fleePos.func_82615_a() + extraX, 0.0, fleePos.func_82616_c() + extraZ);
        BlockPos ground = this.getHeighestAirAbove(radialPos, slamHeight);
        if (!this.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)ground)) && this.func_195048_a(Vector3d.func_237489_a_((Vector3i)ground)) > 1.0) {
            return Vector3d.func_237489_a_((Vector3i)ground);
        }
        return null;
    }

    private BlockPos getHeighestAirAbove(BlockPos radialPos, int limit) {
        BlockPos position = new BlockPos((double)radialPos.func_177958_n(), this.func_226278_cu_(), (double)radialPos.func_177952_p());
        while (position.func_177956_o() < 256 && (double)position.func_177956_o() < this.func_226278_cu_() + (double)limit && this.field_70170_p.func_175623_d(position)) {
            position = position.func_177984_a();
        }
        return position;
    }

    private BlockPos getGround(BlockPos in) {
        BlockPos position = new BlockPos((double)in.func_177958_n(), this.func_226278_cu_(), (double)in.func_177952_p());
        while (position.func_177956_o() > 1 && this.field_70170_p.func_175623_d(position)) {
            position = position.func_177977_b();
        }
        if (position.func_177956_o() < 2) {
            return position.func_177981_b(60 + this.field_70146_Z.nextInt(5));
        }
        return position;
    }

    public boolean func_184191_r(Entity entityIn) {
        return super.func_184191_r(entityIn) || this.getSplitFromUUID() != null && this.getSplitFromUUID().equals(entityIn.func_110124_au()) || entityIn instanceof EntityVoidWorm && ((EntityVoidWorm)entityIn).getSplitFromUUID() != null && ((EntityVoidWorm)entityIn).getSplitFromUUID().equals(entityIn.func_110124_au());
    }

    private void spit(Vector3d shotAt, boolean portal) {
        shotAt = shotAt.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
        EntityVoidWormShot shot = new EntityVoidWormShot(this.field_70170_p, this);
        double d0 = shotAt.field_72450_a;
        double d1 = shotAt.field_72448_b;
        double d2 = shotAt.field_72449_c;
        float f = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.35f;
        shot.shoot(d0, d1 + (double)f, d2, 0.5f, 3.0f);
        if (!this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_204780_be, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
        shot.setPortalType(portal);
        this.openMouth(5);
        this.field_70170_p.func_217376_c((Entity)shot);
    }

    private boolean wormAttack(Entity entity, DamageSource source, float dmg) {
        dmg = (float)((double)dmg * AMConfig.voidWormDamageModifier);
        return entity instanceof EnderDragonEntity ? ((EnderDragonEntity)entity).func_82195_e(source, dmg * 0.5f) : entity.func_70097_a(source, dmg);
    }

    public void playHurtSoundWorm(DamageSource source) {
        this.func_184581_c(source);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 67) {
            AlexsMobs.PROXY.onEntityStatus((Entity)this, id);
        } else {
            super.func_70103_a(id);
        }
    }

    public class AIEnterPortal
    extends Goal {
        public AIEnterPortal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return EntityVoidWorm.this.portalTarget != null;
        }

        public void func_75246_d() {
            if (EntityVoidWorm.this.portalTarget != null) {
                EntityVoidWorm.this.field_70145_X = true;
                AxisAlignedBB bb = EntityVoidWorm.this.portalTarget.func_174813_aQ();
                double centerX = bb.field_72340_a + (bb.field_72336_d - bb.field_72340_a) / 2.0;
                double centerY = bb.field_72338_b + (bb.field_72337_e - bb.field_72338_b) / 2.0;
                double centerZ = bb.field_72339_c + (bb.field_72334_f - bb.field_72339_c) / 2.0;
                float sped = 0.08f;
                EntityVoidWorm.this.func_213317_d(EntityVoidWorm.this.func_213322_ci().func_72441_c(Math.signum(centerX - EntityVoidWorm.this.func_226277_ct_()) * (double)sped, Math.signum(centerY - EntityVoidWorm.this.func_226278_cu_()) * (double)sped, Math.signum(centerZ - EntityVoidWorm.this.func_226281_cx_()) * (double)sped));
                EntityVoidWorm.this.func_70605_aq().func_75642_a(centerX, centerY, centerZ, 1.0);
            }
        }

        public void func_75251_c() {
            EntityVoidWorm.this.field_70145_X = false;
        }
    }

    public class AIAttack
    extends Goal {
        private AttackMode mode = AttackMode.CIRCLE;
        private int modeTicks = 0;
        private int maxCircleTime = 500;
        private Vector3d moveTo = null;

        public AIAttack() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return EntityVoidWorm.this.func_70638_az() != null && EntityVoidWorm.this.func_70638_az().func_70089_S();
        }

        public void func_75251_c() {
            this.mode = AttackMode.CIRCLE;
            this.modeTicks = 0;
        }

        public void func_75249_e() {
            this.mode = AttackMode.CIRCLE;
            this.maxCircleTime = 60 + EntityVoidWorm.this.field_70146_Z.nextInt(200);
        }

        public void func_75246_d() {
            LivingEntity target = EntityVoidWorm.this.func_70638_az();
            boolean flag = false;
            float speed = 1.0f;
            for (Entity entity : EntityVoidWorm.this.field_70170_p.func_175647_a(LivingEntity.class, EntityVoidWorm.this.func_174813_aQ().func_186662_g(2.0), null)) {
                if (entity.func_70028_i((Entity)EntityVoidWorm.this) || entity instanceof EntityVoidWormPart || entity.func_184191_r((Entity)EntityVoidWorm.this) || entity == EntityVoidWorm.this) continue;
                if (EntityVoidWorm.this.isMouthOpen()) {
                    EntityVoidWorm.this.launch(entity, true);
                    flag = true;
                    EntityVoidWorm.this.wormAttack(entity, DamageSource.func_76358_a((LivingEntity)EntityVoidWorm.this), 8.0f + EntityVoidWorm.this.field_70146_Z.nextFloat() * 8.0f);
                    continue;
                }
                EntityVoidWorm.this.openMouth(15);
            }
            if (target != null) {
                if (this.mode == AttackMode.CIRCLE) {
                    if (this.moveTo == null || EntityVoidWorm.this.func_195048_a(this.moveTo) < 16.0 || EntityVoidWorm.this.field_70123_F) {
                        this.moveTo = EntityVoidWorm.this.getBlockInViewAway(target.func_213303_ch(), 0.4f + EntityVoidWorm.this.field_70146_Z.nextFloat() * 0.2f);
                    }
                    ++this.modeTicks;
                    if (this.modeTicks % 50 == 0) {
                        EntityVoidWorm.this.spit(new Vector3d(3.0, 3.0, 0.0), false);
                        EntityVoidWorm.this.spit(new Vector3d(-3.0, 3.0, 0.0), false);
                        EntityVoidWorm.this.spit(new Vector3d(3.0, -3.0, 0.0), false);
                        EntityVoidWorm.this.spit(new Vector3d(-3.0, -3.0, 0.0), false);
                    }
                    if (this.modeTicks > this.maxCircleTime) {
                        this.maxCircleTime = 60 + EntityVoidWorm.this.field_70146_Z.nextInt(200);
                        this.mode = AttackMode.SLAM_RISE;
                        this.modeTicks = 0;
                        this.moveTo = null;
                    }
                } else if (this.mode == AttackMode.SLAM_RISE) {
                    if (this.moveTo == null) {
                        this.moveTo = EntityVoidWorm.this.getBlockInViewAwaySlam(target.func_213303_ch(), 20 + EntityVoidWorm.this.field_70146_Z.nextInt(20));
                    }
                    if (this.moveTo != null && EntityVoidWorm.this.func_226278_cu_() > target.func_226278_cu_() + 15.0) {
                        this.moveTo = null;
                        this.modeTicks = 0;
                        this.mode = AttackMode.SLAM_FALL;
                    }
                } else if (this.mode == AttackMode.SLAM_FALL) {
                    speed = 2.0f;
                    EntityVoidWorm.this.func_70625_a((Entity)target, 360.0f, 360.0f);
                    this.moveTo = target.func_213303_ch();
                    if (EntityVoidWorm.this.field_70123_F) {
                        this.moveTo = new Vector3d(target.func_226277_ct_(), EntityVoidWorm.this.func_226278_cu_() + 3.0, target.func_226281_cx_());
                    }
                    EntityVoidWorm.this.openMouth(20);
                    if (EntityVoidWorm.this.func_195048_a(this.moveTo) < 4.0 || flag) {
                        this.mode = AttackMode.CIRCLE;
                        this.moveTo = null;
                        this.modeTicks = 0;
                    }
                }
            }
            if (!EntityVoidWorm.this.func_70685_l((Entity)target) && EntityVoidWorm.this.field_70146_Z.nextInt(100) == 0 && EntityVoidWorm.this.makePortalCooldown == 0) {
                Vector3d to = new Vector3d(target.func_226277_ct_(), target.func_174813_aQ().field_72337_e + 0.1, target.func_226281_cx_());
                EntityVoidWorm.this.createPortal(EntityVoidWorm.this.func_213303_ch().func_178787_e(EntityVoidWorm.this.func_70040_Z().func_186678_a(20.0)), to, Direction.UP);
                EntityVoidWorm.this.makePortalCooldown = 50;
                this.mode = AttackMode.SLAM_FALL;
            }
            if (this.moveTo != null && EntityVoidWorm.this.portalTarget == null) {
                EntityVoidWorm.this.func_70605_aq().func_75642_a(this.moveTo.field_72450_a, this.moveTo.field_72448_b, this.moveTo.field_72449_c, (double)speed);
            }
        }
    }

    private class AIFlyIdle
    extends Goal {
        protected final EntityVoidWorm voidWorm;
        protected double x;
        protected double y;
        protected double z;

        public AIFlyIdle() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.voidWorm = EntityVoidWorm.this;
        }

        public boolean func_75250_a() {
            if (this.voidWorm.func_184207_aI() || this.voidWorm.portalTarget != null || this.voidWorm.func_70638_az() != null && this.voidWorm.func_70638_az().func_70089_S() || this.voidWorm.func_184218_aH()) {
                return false;
            }
            Vector3d lvt_1_1_ = this.getPosition();
            if (lvt_1_1_ == null) {
                return false;
            }
            this.x = lvt_1_1_.field_72450_a;
            this.y = lvt_1_1_.field_72448_b;
            this.z = lvt_1_1_.field_72449_c;
            return true;
        }

        public void func_75246_d() {
            this.voidWorm.func_70605_aq().func_75642_a(this.x, this.y, this.z, 1.0);
        }

        @Nullable
        protected Vector3d getPosition() {
            Vector3d vector3d = this.voidWorm.func_213303_ch();
            return this.voidWorm.getBlockInViewAway(vector3d, 1.0f);
        }

        public boolean func_75253_b() {
            return this.voidWorm.func_70092_e(this.x, this.y, this.z) > 20.0 && this.voidWorm.portalTarget == null && !this.voidWorm.field_70123_F && (this.voidWorm.func_70638_az() == null || !this.voidWorm.func_70638_az().func_70089_S());
        }

        public void func_75249_e() {
            this.voidWorm.func_70605_aq().func_75642_a(this.x, this.y, this.z, 1.0);
        }

        public void func_75251_c() {
            this.voidWorm.func_70661_as().func_75499_g();
            super.func_75251_c();
        }
    }

    private static enum AttackMode {
        CIRCLE,
        SLAM_RISE,
        SLAM_FALL,
        PORTAL;

    }
}

