/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.misc.AMPointOfInterestRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.google.common.base.Predicates;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tileentity.BeaconTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class EntitySunbird
extends AnimalEntity
implements IFlyingAnimal {
    public static final Predicate<? super Entity> SCORCH_PRED = new com.google.common.base.Predicate<Entity>(){

        public boolean apply(@Nullable Entity e) {
            return e.func_70089_S() && e.func_200600_R().func_220341_a(EntityTypeTags.func_219762_a().func_199910_a(AMTagRegistry.SUNBIRD_SCORCH_TARGETS));
        }
    };
    public float birdPitch = 0.0f;
    public float prevBirdPitch = 0.0f;
    private int beaconSearchCooldown = 50;
    private BlockPos beaconPos = null;
    private boolean orbitClockwise = false;

    protected EntitySunbird(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
        this.orbitClockwise = new Random().nextBoolean();
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233819_b_, 64.0).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233821_d_, 1.0);
    }

    public static boolean canSunbirdSpawn(EntityType<? extends MobEntity> typeIn, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        BlockPos blockpos = pos.func_177977_b();
        if (reason != SpawnReason.SPAWNER) {
            // empty if block
        }
        return true;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.sunbirdSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.SUNBIRD_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.SUNBIRD_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.SUNBIRD_HURT;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(3, (Goal)new RandomFlyGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 32.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean prev = super.func_70097_a(source, amount);
        if (prev) {
            if (source.func_76346_g() != null && source.func_76346_g() instanceof LivingEntity) {
                LivingEntity hurter = (LivingEntity)source.func_76346_g();
                if (hurter.func_70644_a(AMEffectRegistry.SUNBIRD_BLESSING)) {
                    hurter.func_195063_d(AMEffectRegistry.SUNBIRD_BLESSING);
                }
                hurter.func_195064_c(new EffectInstance(AMEffectRegistry.SUNBIRD_CURSE, 600, 0));
            }
            return prev;
        }
        return prev;
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70090_H()) {
            this.func_213309_a(0.02f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a((double)0.8f));
        } else if (this.func_180799_ab()) {
            this.func_213309_a(0.02f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
        } else {
            BlockPos ground = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() - 1.0, this.func_226281_cx_());
            float f = 0.91f;
            if (this.field_70122_E) {
                f = this.field_70170_p.func_180495_p(ground).getSlipperiness((IWorldReader)this.field_70170_p, ground, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277137f / (f * f * f);
            f = 0.91f;
            if (this.field_70122_E) {
                f = this.field_70170_p.func_180495_p(ground).getSlipperiness((IWorldReader)this.field_70170_p, ground, (Entity)this) * 0.91f;
            }
            this.func_233629_a_((LivingEntity)this, true);
            this.func_213309_a(0.2f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a((double)f));
        }
        this.func_233629_a_((LivingEntity)this, false);
    }

    public void func_70071_h_() {
        float f2;
        super.func_70071_h_();
        this.prevBirdPitch = this.birdPitch;
        this.birdPitch = f2 = (float)(-((double)((float)this.func_213322_ci().field_72448_b) * 57.2957763671875));
        if (this.field_70170_p.field_72995_K) {
            float radius = 0.35f + this.field_70146_Z.nextFloat() * 1.85f;
            float angle = (float)Math.PI / 180 * ((this.field_70146_Z.nextBoolean() ? -85.0f : 85.0f) + this.field_70761_aq);
            float angleMotion = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            double extraXMotion = -0.2f * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angleMotion)));
            double extraZMotion = -0.2f * MathHelper.func_76134_b((float)angleMotion);
            double yRandom = 0.2f + this.field_70146_Z.nextFloat() * 0.3f;
            BasicParticleType type = ParticleTypes.field_197629_v;
            this.field_70170_p.func_195594_a((IParticleData)type, this.func_226277_ct_() + extraX, this.func_226278_cu_() + yRandom, this.func_226281_cx_() + extraZ, extraXMotion, 0.0, extraZMotion);
        } else {
            if (this.field_70173_aa % 100 == 0) {
                List list = this.field_70170_p.func_175647_a(LivingEntity.class, this.getScorchArea(), SCORCH_PRED);
                for (Entity e : list) {
                    e.func_70015_d(4);
                    if (!(e instanceof PhantomEntity)) continue;
                    ((PhantomEntity)e).func_195064_c(new EffectInstance(AMEffectRegistry.SUNBIRD_CURSE, 200, 0));
                }
                List playerList = this.field_70170_p.func_175647_a(PlayerEntity.class, this.getScorchArea(), (Predicate)Predicates.alwaysTrue());
                for (PlayerEntity e : playerList) {
                    if (e.func_70644_a(AMEffectRegistry.SUNBIRD_BLESSING) || e.func_70644_a(AMEffectRegistry.SUNBIRD_CURSE)) continue;
                    e.func_195064_c(new EffectInstance(AMEffectRegistry.SUNBIRD_BLESSING, 600, 0));
                }
            }
            if (this.beaconSearchCooldown > 0) {
                --this.beaconSearchCooldown;
            }
            if (this.beaconSearchCooldown <= 0) {
                this.beaconSearchCooldown = 100 + this.field_70146_Z.nextInt(200);
                if (this.field_70170_p instanceof ServerWorld) {
                    List<BlockPos> beacons = this.getNearbyBeacons(this.func_233580_cy_(), (ServerWorld)this.field_70170_p, 64);
                    BlockPos closest = null;
                    for (BlockPos pos : beacons) {
                        if (closest != null && !(this.func_70092_e(closest.func_177958_n(), closest.func_177956_o(), closest.func_177952_p()) > this.func_70092_e(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) || !this.isValidBeacon(pos)) continue;
                        closest = pos;
                    }
                    if (closest != null && this.isValidBeacon(closest)) {
                        this.beaconPos = closest;
                    }
                }
                if (this.beaconPos != null && !this.isValidBeacon(this.beaconPos) && this.field_70173_aa > 40) {
                    this.beaconPos = null;
                }
            }
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("BeaconPosX")) {
            int i = compound.func_74762_e("BeaconPosX");
            int j = compound.func_74762_e("BeaconPosY");
            int k = compound.func_74762_e("BeaconPosZ");
            this.beaconPos = new BlockPos(i, j, k);
        } else {
            this.beaconPos = null;
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        BlockPos blockpos = this.beaconPos;
        if (blockpos != null) {
            compound.func_74768_a("BeaconPosX", blockpos.func_177958_n());
            compound.func_74768_a("BeaconPosY", blockpos.func_177956_o());
            compound.func_74768_a("BeaconPosZ", blockpos.func_177952_p());
        }
    }

    private AxisAlignedBB getScorchArea() {
        return this.func_174813_aQ().func_72314_b(15.0, 32.0, 15.0);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    public boolean isTargetBlocked(Vector3d target) {
        Vector3d Vector3d2 = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() != RayTraceResult.Type.MISS;
    }

    private List<BlockPos> getNearbyBeacons(BlockPos blockpos, ServerWorld world, int range) {
        PointOfInterestManager pointofinterestmanager = world.func_217443_B();
        Stream stream = pointofinterestmanager.func_225399_a(AMPointOfInterestRegistry.BEACON.func_221045_c(), (Predicate)Predicates.alwaysTrue(), blockpos, range, PointOfInterestManager.Status.ANY);
        return stream.collect(Collectors.toList());
    }

    private boolean isValidBeacon(BlockPos pos) {
        TileEntity te = this.field_70170_p.func_175625_s(pos);
        return te instanceof BeaconTileEntity && ((BeaconTileEntity)te).func_191979_s() > 0;
    }

    static class RandomFlyGoal
    extends Goal {
        private final EntitySunbird parentEntity;
        private BlockPos target = null;

        public RandomFlyGoal(EntitySunbird sunbird) {
            this.parentEntity = sunbird;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            MovementController movementcontroller = this.parentEntity.func_70605_aq();
            if (!movementcontroller.func_75640_a() || this.target == null) {
                this.target = this.parentEntity.beaconPos != null ? this.getBlockInViewBeacon(this.parentEntity.beaconPos, 5 + this.parentEntity.field_70146_Z.nextInt(1)) : this.getBlockInViewSunbird();
                if (this.target != null) {
                    this.parentEntity.func_70605_aq().func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, this.parentEntity.beaconPos != null ? 0.8 : 1.0);
                }
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.target != null && this.parentEntity.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.target)) > 2.4 && this.parentEntity.func_70605_aq().func_75640_a() && !this.parentEntity.field_70123_F;
        }

        public void func_75251_c() {
            this.target = null;
        }

        public void func_75246_d() {
            if (this.target == null) {
                this.target = this.parentEntity.beaconPos != null ? this.getBlockInViewBeacon(this.parentEntity.beaconPos, 5 + this.parentEntity.field_70146_Z.nextInt(1)) : this.getBlockInViewSunbird();
            }
            if (this.parentEntity.beaconPos != null && this.parentEntity.field_70146_Z.nextInt(100) == 0) {
                this.parentEntity.orbitClockwise = this.parentEntity.field_70146_Z.nextBoolean();
            }
            if (this.target != null) {
                this.parentEntity.func_70605_aq().func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, this.parentEntity.beaconPos != null ? 0.8 : 1.0);
                if (this.parentEntity.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.target)) < 2.5) {
                    this.target = null;
                }
            }
        }

        private BlockPos getBlockInViewBeacon(BlockPos orbitPos, float gatheringCircleDist) {
            BlockPos pos;
            float angle = 0.15707964f * (float)(this.parentEntity.orbitClockwise ? -this.parentEntity.field_70173_aa : this.parentEntity.field_70173_aa);
            double extraX = gatheringCircleDist * MathHelper.func_76126_a((float)angle);
            double extraZ = gatheringCircleDist * MathHelper.func_76134_b((float)angle);
            if (orbitPos != null && this.parentEntity.field_70170_p.func_175623_d(new BlockPos((Vector3i)(pos = new BlockPos((double)orbitPos.func_177958_n() + extraX, (double)(orbitPos.func_177956_o() + this.parentEntity.field_70146_Z.nextInt(2) + 2), (double)orbitPos.func_177952_p() + extraZ))))) {
                return pos;
            }
            return null;
        }

        public BlockPos getBlockInViewSunbird() {
            float radius = -9.45f - (float)this.parentEntity.func_70681_au().nextInt(24);
            float neg = this.parentEntity.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
            float renderYawOffset = this.parentEntity.field_70761_aq;
            float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.parentEntity.func_70681_au().nextFloat() * neg;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            BlockPos radialPos = new BlockPos(this.parentEntity.func_226277_ct_() + extraX, 0.0, this.parentEntity.func_226281_cx_() + extraZ);
            BlockPos ground = this.parentEntity.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, radialPos);
            int distFromGround = (int)this.parentEntity.func_226278_cu_() - ground.func_177956_o();
            int flightHeight = Math.max(ground.func_177956_o(), 180 + this.parentEntity.func_70681_au().nextInt(40)) - ground.func_177956_o();
            BlockPos newPos = radialPos.func_177981_b(distFromGround > 16 ? flightHeight : (int)this.parentEntity.func_226278_cu_() + this.parentEntity.func_70681_au().nextInt(16) + 1);
            if (!this.parentEntity.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)newPos)) && this.parentEntity.func_195048_a(Vector3d.func_237489_a_((Vector3i)newPos)) > 6.0) {
                return newPos;
            }
            return null;
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final EntitySunbird parentEntity;

        public MoveHelperController(EntitySunbird sunbird) {
            super((MobEntity)sunbird);
            this.parentEntity = sunbird;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                Vector3d vector3d = new Vector3d(this.field_75646_b - this.parentEntity.func_226277_ct_(), this.field_75647_c - this.parentEntity.func_226278_cu_(), this.field_75644_d - this.parentEntity.func_226281_cx_());
                double d0 = vector3d.func_72433_c();
                if (d0 < this.parentEntity.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_186678_a(0.5));
                } else {
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_178787_e(vector3d.func_186678_a(this.field_75645_e * 0.05 / d0)));
                    if (this.parentEntity.func_70638_az() == null) {
                        Vector3d vector3d1 = this.parentEntity.func_213322_ci();
                        this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)vector3d1.field_72450_a, (double)vector3d1.field_72449_c)) * 57.295776f;
                    } else {
                        double d2 = this.parentEntity.func_70638_az().func_226277_ct_() - this.parentEntity.func_226277_ct_();
                        double d1 = this.parentEntity.func_70638_az().func_226281_cx_() - this.parentEntity.func_226281_cx_();
                        this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d2, (double)d1)) * 57.295776f;
                    }
                }
            }
        }

        private boolean func_220673_a(Vector3d p_220673_1_, int p_220673_2_) {
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.parentEntity.field_70170_p.func_226665_a__((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_191194_a(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }
}

