/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityRoadrunner;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityRattlesnake
extends AnimalEntity
implements IAnimatedEntity {
    public float prevCurlProgress;
    public float curlProgress;
    public int randomToungeTick = 0;
    public int maxCurlTime = 75;
    private int curlTime = 0;
    private static final DataParameter<Boolean> RATTLING = EntityDataManager.func_187226_a(EntityRattlesnake.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CURLED = EntityDataManager.func_187226_a(EntityRattlesnake.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Predicate<LivingEntity> WARNABLE_PREDICATE = mob -> mob instanceof PlayerEntity && !((PlayerEntity)mob).func_184812_l_() && !mob.func_175149_v() || mob instanceof EntityRoadrunner;
    private static final Predicate<LivingEntity> TARGETABLE_PREDICATE = mob -> mob instanceof PlayerEntity && !((PlayerEntity)mob).func_184812_l_() && !mob.func_175149_v() || mob instanceof EntityRoadrunner;
    private int animationTick;
    private Animation currentAnimation;
    public static final Animation ANIMATION_BITE = Animation.create((int)20);
    private int loopSoundTick = 0;

    protected EntityRattlesnake(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new WarnPredatorsGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (Goal)new AnimalAIWanderRanged((CreatureEntity)this, 60, 1.0, 7, 7));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 15.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, RabbitEntity.class, 15, true, true, null));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new ShortDistanceTarget());
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.RATTLESNAKE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.RATTLESNAKE_HURT;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.rattlesnakeSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public boolean func_70652_k(Entity entityIn) {
        this.setAnimation(ANIMATION_BITE);
        return true;
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        if (potioneffectIn.func_188419_a() == Effects.field_76436_u) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CURLED, (Object)false);
        this.field_70180_af.func_187214_a(RATTLING, (Object)false);
    }

    public boolean isCurled() {
        return (Boolean)this.field_70180_af.func_187225_a(CURLED);
    }

    public void setCurled(boolean curled) {
        this.field_70180_af.func_187227_b(CURLED, (Object)curled);
    }

    public boolean isRattling() {
        return (Boolean)this.field_70180_af.func_187225_a(RATTLING);
    }

    public void setRattling(boolean rattling) {
        this.field_70180_af.func_187227_b(RATTLING, (Object)rattling);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevCurlProgress = this.curlProgress;
        if (this.isCurled() && this.curlProgress < 5.0f) {
            this.curlProgress += 0.5f;
        }
        if (!this.isCurled() && this.curlProgress > 0.0f) {
            this.curlProgress -= 1.0f;
        }
        if (this.field_70146_Z.nextInt(15) == 0 && this.randomToungeTick == 0) {
            this.randomToungeTick = 10 + this.field_70146_Z.nextInt(20);
        }
        if (this.randomToungeTick > 0) {
            --this.randomToungeTick;
        }
        if (this.isCurled() && !this.isRattling() && ++this.curlTime > this.maxCurlTime) {
            this.setCurled(false);
            this.curlTime = 0;
            this.maxCurlTime = 75 + this.field_70146_Z.nextInt(50);
        }
        if (!this.field_70170_p.field_72995_K && this.isCurled() && this.func_70638_az() != null && this.func_70638_az().func_70089_S()) {
            this.setCurled(false);
        }
        if (!this.field_70170_p.field_72995_K && this.isRattling() && this.func_70638_az() == null) {
            this.setCurled(true);
        }
        if (!this.field_70170_p.field_72995_K && !this.isCurled() && this.func_70638_az() == null && this.field_70146_Z.nextInt(500) == 0) {
            this.maxCurlTime = 300 + this.field_70146_Z.nextInt(250);
            this.setCurled(true);
        }
        if (this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() == 4) {
            this.func_184185_a(AMSoundRegistry.RATTLESNAKE_ATTACK, this.func_70599_aP(), this.func_70647_i());
        }
        LivingEntity target = this.func_70638_az();
        if (this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() == 8 && target != null && (double)this.func_70032_d((Entity)target) < 2.0) {
            boolean meepMeep = target instanceof EntityRoadrunner;
            target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), meepMeep ? 1.0f : (float)this.func_110148_a(Attributes.field_233823_f_).func_111125_b());
            if (!meepMeep) {
                target.func_195064_c(new EffectInstance(Effects.field_76436_u, 300, 2));
            }
        }
        if (this.isRattling()) {
            if (this.loopSoundTick == 0) {
                this.func_184185_a(AMSoundRegistry.RATTLESNAKE_LOOP, this.func_70599_aP() * 0.5f, this.func_70647_i());
            }
            ++this.loopSoundTick;
            if (this.loopSoundTick > 50) {
                this.loopSoundTick = 0;
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void func_213352_e(Vector3d vec3d) {
        if (this.func_233570_aj_() && this.isCurled()) {
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            vec3d = Vector3d.field_186680_a;
        }
        super.func_213352_e(vec3d);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233826_i_, 0.0).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233821_d_, (double)0.28f);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b().func_219971_r() && stack.func_77973_b().func_219967_s() != null && stack.func_77973_b().func_219967_s().func_221467_c();
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return (AgeableEntity)AMEntityRegistry.RATTLESNAKE.func_200721_a((World)p_241840_1_);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE};
    }

    public static boolean canRattlesnakeSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        boolean spawnBlock = BlockTags.func_199896_a().func_199910_a(AMTagRegistry.RATTLESNAKE_SPAWNS).func_230235_a_((Object)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c());
        return spawnBlock && worldIn.func_226659_b_(pos, 0) > 8;
    }

    class ShortDistanceTarget
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public ShortDistanceTarget() {
            super((MobEntity)EntityRattlesnake.this, PlayerEntity.class, 3, true, true, TARGETABLE_PREDICATE);
        }

        public boolean func_75250_a() {
            if (EntityRattlesnake.this.func_70631_g_()) {
                return false;
            }
            return super.func_75250_a();
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntityRattlesnake.this.setCurled(false);
            EntityRattlesnake.this.setRattling(true);
        }

        protected double func_111175_f() {
            return 2.0;
        }
    }

    class WarnPredatorsGoal
    extends Goal {
        int executionChance = 20;
        Entity target = null;

        WarnPredatorsGoal() {
        }

        public boolean func_75250_a() {
            if (EntityRattlesnake.this.func_70681_au().nextInt(this.executionChance) == 0) {
                double dist = 5.0;
                List list = EntityRattlesnake.this.field_70170_p.func_175647_a(LivingEntity.class, EntityRattlesnake.this.func_174813_aQ().func_72314_b(dist, dist, dist), WARNABLE_PREDICATE);
                double d0 = Double.MAX_VALUE;
                Entity possibleTarget = null;
                for (Entity entity : list) {
                    double d1 = EntityRattlesnake.this.func_70068_e(entity);
                    if (d1 > d0) continue;
                    d0 = d1;
                    possibleTarget = entity;
                }
                this.target = possibleTarget;
                return !list.isEmpty();
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.target != null && (double)EntityRattlesnake.this.func_70032_d(this.target) < 5.0 && EntityRattlesnake.this.func_70638_az() == null;
        }

        public void func_75251_c() {
            this.target = null;
            EntityRattlesnake.this.setRattling(false);
        }

        public void func_75246_d() {
            EntityRattlesnake.this.setRattling(true);
            EntityRattlesnake.this.setCurled(true);
            EntityRattlesnake.this.curlTime = 0;
            EntityRattlesnake.this.func_70671_ap().func_75651_a(this.target, 30.0f, 30.0f);
        }
    }
}

