ForgeEvents.onEvent("net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent", event => {
    let entity = event.entity
    // 处理登记盔甲架的装备同步
    if (entity.persistentData.getString("Resident")) {
        let soldierUuid = entity.persistentData.getString("Resident")
        if (soldierUuid) {
            // 首先尝试直接通过UUID获取士兵实体
            let soldier = entity.level.getEntity(soldierUuid)
            if (soldier) {
                // 如果直接获取成功，立即同步装备
                global.weaponUtils.syncEquipment(entity, soldier)
            } else {
                // 获取失败，从盔甲架Owner信息获取玩家
                let ownerUuid = entity.persistentData.getString("Owner")
                if (ownerUuid) {
                    let ownerPlayer = entity.level.server.getPlayer(ownerUuid)
                    if (ownerPlayer) {
                        // 使用全局方法获取士兵实体
                        global.GetGlobalEntity(soldierUuid, ownerPlayer, (soldier, usedForceLoad) => {
                            if (soldier) {
                                // 使用全局方法同步装备
                                global.weaponUtils.syncEquipment(entity, soldier)
                            }
                        })
                    }
                }
            }
        }
    }
    // 修正百年战争士兵攻击距离
    if (
        entity.type === "hundred_years_war:mounted_lancer_rider" ||
        entity.type === "hundred_years_war:mounted_light_lancer_rider" ||
        entity.type === "hundred_years_war:militia" ||
        entity.type === "hundred_years_war:shieldman" ||
        entity.type === "hundred_years_war:spear_man" ||
        entity.type === "hundred_years_war:warrior"
    ) {
        let WEAPON_ATTACK_REACH_CONFIG = [
            { pattern: /(_chakram)$/i, reach: 5.0 },
            { pattern: /(_claymore|_greathammer|greataxe|scythe)$/i, reach: 3.5 },
            { pattern: /(_glaive)$/i, reach: 3.25 },
            { pattern: /(_halberd)$/i, reach: 4.0 },
            { pattern: /(_longsword|_katana)$/i, reach: 2.9 },
            { pattern: /(_pike)$/i, reach: 5.5 },
            { pattern: /(_rapier)$/i, reach: 2.75 },
            { pattern: /(_sai)$/i, reach: 1.8 },
            { pattern: /(_twinblade)$/i, reach: 3 },
            { pattern: /(_warglaive)$/i, reach: 2.6 },
            { pattern: /(pickarang|flamerang)$/i, reach: 6.2 },
        ]
        // 获取士兵主手武器
        let mainHandItem = entity.getMainHandItem()
        let weaponId = mainHandItem.id
        let attackReach = 2.5
        let matched = false
        for (let i = 0; i < WEAPON_ATTACK_REACH_CONFIG.length; i++) {
            let config = WEAPON_ATTACK_REACH_CONFIG[i]
            if (config.pattern.test(weaponId)) {
                attackReach = config.reach
                matched = true
                break
            }
        }
        entity.setAttributeBaseValue("hundred_years_war:attack_reach", attackReach)
    }
})