//获取距离实体最近的玩家，类似命令@p
//使用方法：
//let player = global.atP(entity)
global.atP = function (entity) {
  let players = entity.level.players()
  if (players.isEmpty()) return null
  let nearestPlayer = null
  let minDistance = Infinity
  for (let i = 0; i < players.size(); i++) {
    let player = players.get(i)
    let distance = entity.distanceTo(player)
    if (distance < minDistance) {
      minDistance = distance
      nearestPlayer = player
    }
  }
  return nearestPlayer
}

//获取距离实体指定距离内的所有玩家，类似命令@a[distance=..10]
//使用方法：
//let players = global.atPD(entity，10)
//Players.forEach(player => { }
global.atPD = function (entity, maxDistance) {
  let players = entity.level.players()
  if (players.isEmpty()) return []
  let result = []
  for (let i = 0; i < players.size(); i++) {
    let player = players.get(i)
    if (entity.distanceTo(player) <= maxDistance) {
      result.push(player)
    }
  }
  return result
}