ForgeEvents.onEvent("net.minecraftforge.event.entity.living.LivingEvent$LivingTickEvent", event => {
    let entity = event.entity
    let type = entity.type
    if (type === "minecraft:player") return
    if (!entity.persistentData) return
    let eData = entity.persistentData
    let commandData = eData.getCompound("command")
    let wasInCombat = eData.getBoolean("target")
    // 百年战争步兵
    if (type.toString().startsWith("hundred_years_war") && !type.toString().startsWith("hundred_years_war:mounted")) {
        if (entity.getTarget() && !wasInCombat) {
            // 战斗时调速
            entity.setAttributeBaseValue("minecraft:generic.movement_speed", 0.45)
            eData.putBoolean("target", true)
        } else {
            if (commandData.getInt("Behavior") === 2) {
                // 无战斗跟随调速
                entity.setAttributeBaseValue("minecraft:generic.movement_speed", 0.37)
            } else {
                // 无战斗驻守调速
                entity.setAttributeBaseValue("minecraft:generic.movement_speed", 0.30)
            }
            eData.putBoolean("target", false)
        }
    } else if (type.toString().startsWith("hundred_years_war:mounted")) {
        if (entity.getTarget() && !wasInCombat) {
            eData.putBoolean("target", true)
        } else {
            eData.putBoolean("target", false)
        }
    }
    // 警卫村民
    if (type.toString().startsWith("guardvillagers")) {
        let mount = entity.getVehicle()
        if (entity.getTarget() && !wasInCombat) {
            // 战斗时调速
            entity.setAttributeBaseValue("minecraft:generic.movement_speed", 0.28)
            eData.putBoolean("target", true)
            // 警卫村民在驻守状态无法射击，因此进入战斗时取消驻守状态
            if (entity.nbt.Patrolling === 1) {
                entity.mergeNbt({ Patrolling: 0 })
            }
            // 骑乘战斗时对坐骑调速
            if (mount) {
                mount.setAttributeBaseValue("minecraft:generic.movement_speed", 0.30)
            }
        } else {
            if (commandData.getInt("Behavior") === 2) {
                // 无战斗跟随调速
                entity.setAttributeBaseValue("minecraft:generic.movement_speed", 0.42)
            } else {
                // 无战斗驻守调速
                entity.setAttributeBaseValue("minecraft:generic.movement_speed", 0.60)
            }
            // 骑乘对坐骑调速
            if (mount) {
                mount.setAttributeBaseValue("minecraft:generic.movement_speed", 0.37)
            }
            eData.putBoolean("target", false)
            if (entity.nbt.Patrolling === 1) {
                entity.mergeNbt({ Patrolling: 1 })
            }
        }
    }
})

// 警卫村民骑乘时提高移速
ForgeEvents.onEvent("net.minecraftforge.event.entity.EntityMountEvent", event => {
    let entity = event.entity
    let mount = event.entityBeingMounted
    if (entity.type.toString().startsWith("guardvillagers")) {
        if (event.mounting) {
            mount.setAttributeBaseValue("minecraft:generic.movement_speed", 0.37)
        }
    }
})