ForgeEvents.onEvent("net.minecraftforge.event.entity.EntityLeaveLevelEvent", event => {
    if (event.entity.level.isClientSide()) return
    let entity = event.entity
    if (!entity.persistentData) return
    let eData = entity.persistentData
    if (!eData.getCompound("soldier")) return
    let soldierData = eData.getCompound("soldier")
    // 获取玩家（部分生物不支持getOwner，因此从数据库读取）
    if (!entity.level.server.getPlayer(soldierData.getString("Owner"))) return
    let player = entity.level.server.getPlayer(soldierData.getString("Owner"))
    let pData = player.persistentData
    let pSoldierData = pData.getCompound("soldier")
    let eUuid = entity.uuid.toString()
    let eUuidData = pSoldierData.getCompound(eUuid)
    eUuidData.putInt("TPPosX", entity.x)
    eUuidData.putInt("TPPosZ", entity.z)
    eUuidData.putString("TPPosDim", entity.level.dimension.path)

    // 保存回玩家数据
    pSoldierData.put(eUuid, eUuidData)
    pData.put("soldier", pSoldierData)
})