ItemEvents.entityInteracted("minecraft:stick", event => {
    let player = event.player
    let soldier = event.target
    let pUUID = player.nbt.UUID
    if (event.item.nbt.Tags) {
        let tags = event.item.nbt.Tags
        for (let i = 0; i < tags.length; i++) {
            let tag = tags[i]
            if (tag.indexOf("skin_") === 0) {
                let skinNumberStr = tag.substring(5)
                let skinNumber = parseInt(skinNumberStr)
                if (!isNaN(skinNumber) &&
                    soldier.nbt.OwnerUUID &&
                    pUUID.equals(soldier.nbt.OwnerUUID)) {
                    soldier.mergeNbt({ Skin: skinNumber })
                    break
                }
            }
        }
    }
})