//团队需以颜色命名，这将同时管理颜色代码，显示名字可以改
function teamHandling(server, player, team) {
    let pUuid = player.uuid.toString()
    let pName = player.name.string
    let pData = player.persistentData
    let pSoldierData = pData.getCompound("soldier")
    server.runCommandSilent(`team leave ${pName}`)
    server.runCommandSilent(`team join ${team} ${pName}`)
    // 新版本换队伍逻辑
    pSoldierData.getAllKeys().forEach(soldierUuid => {
        global.GetGlobalEntity(soldierUuid, player, (soldier, usedForceLoad) => {
            if (!soldier) return
            if (soldier.type === "hundred_years_war:priest") return
            let eUuid = soldier.uuid.toString()
            server.runCommandSilent(`team leave ${eUuid}`)
            server.runCommandSilent(`team join ${team} ${eUuid}`)
        })
    })
    // 对旧版本队伍系统的兼容逻辑（盔甲架，市民，游客等）
    server.entities.forEach(entity => {
        if (entity.persistentData && entity.persistentData.getString("pUuid") === pUuid ) {
            if (entity.type === "hundred_years_war:priest") return
            let eUuid = entity.uuid.toString()
            server.runCommandSilent(`team leave ${eUuid}`)
            server.runCommandSilent(`team join ${team} ${eUuid}`)
        }
    })
}

FTBQuestsEvents.customReward(event => {
    let server = event.server
    let player = event.player
    if (event.reward.tags.contains('team_white')) {
        teamHandling(server, player, 'white')
    }
    if (event.reward.tags.contains('team_red')) {
        teamHandling(server, player, 'red')
    }
    if (event.reward.tags.contains('team_yellow')) {
        teamHandling(server, player, 'yellow')
    }
    if (event.reward.tags.contains('team_blue')) {
        teamHandling(server, player, 'blue')
    }
    if (event.reward.tags.contains('team_green')) {
        teamHandling(server, player, 'green')
    }
})