// priority: 50

////////////////////
//玩家属性矩阵加成
FTBQuestsEvents.customReward((event) => {
  let player = event.player
  let pData = player.persistentData
  CAPABILITY.forEach((config) => {
    for (let level = 1; level <= 5; level++) {
      let tag = `${config.prefix}_${level}`
      if (event.reward.tags.contains(tag)) {
        pData.putInt(config.prefix, level)
        // 跳过只对士兵生效的加成
        if (config.target === "soldier") continue
        // 使用新的属性加成函数
        let value = config.baseValue * level
        global.AttributeEnhancement(player, config.Attribute, config.prefix, value, config.Operation)
        break
      }
    }
  })
})

////////////////////
//领兵数量加成
ItemEvents.rightClicked("waystones:warp_scroll", (event) => {
  let player = event.player;
  let pData = player.persistentData;
  if (!pData.getInt("MaxScale")) {
    pData.putInt("MaxScale", 4)
    player.tell(`远征军上限初始化完成,初始为4，上限为${scaleLimit}`)
  }
  if (pData.getInt("MaxScale") < scaleLimit) {
    let MAXScale = pData.getInt("MaxScale") + 1
    pData.putInt("MaxScale", MAXScale)
    if (!global.ConsumableItems(player, [{ id: "waystones:warp_scroll", count: 1 },])) return
    player.tell(`远征军上限提高${MAXScale}/${scaleLimit}`)
  }
  if (pData.getInt("MaxScale") >= scaleLimit) {
    player.tell(`远征军数量已经达到上限${pData.getInt("MaxScale")}/${scaleLimit}`)
    player.tell(`继续消耗卷轴将兑换为40枚紫水晶碎片`)
    if (!global.ConsumableItems(player, [{ id: "waystones:warp_scroll", count: 1 },])) return
    player.give(Item.of("minecraft:amethyst_shard", 40))
  }
  event.cancel()
})

////////////////////
//自动维修触发器转义
FTBQuestsEvents.customReward((event) => {
  for (let level = 1; level <= 5; level++) {
    let tag = `cb_ar_${level}`;
    if (event.reward.tags.contains(tag)) {
      event.player.persistentData.putInt("cb_ar", level);
      break;
    }
  }
});

////////////////////
//远征军团队切换
ServerEvents.command((event) => {
  if (event.input.match(/nothing (\d+)/)) {
    let player = event.parseResults.context.source.entity;
    let pName = player.name.string;
    let pData = player.persistentData;
    for (let i = 0; i <= 9; i++) {
      if (event.input === `nothing 2${i}`) {
        event.server.runCommandSilent(
          `scoreboard players set ${pName} snk_key 0`
        );
        event.server.runCommandSilent(
          `scoreboard players enable ${pName} snk_key`
        );
        pData.putInt("legion", i);
        player.tell(`§a已切换到第${i}队`);
      }
    }
  }
})