FTBQuestsEvents.customReward((event) => {
  let server = event.server;
  let player = event.player;
  let pUuid = player.uuid.toString();
  let pName = player.name.string;
  let pAABB = player.boundingBox.inflate(100, 50, 100);
  if (event.reward.tags.contains("bd_level_1")) {
    let confirm = false;
    player.level.getEntitiesWithin(pAABB).forEach((citizen) => {
      if (confirm) return;
      if (
        citizen.type === "minecolonies:citizen" &&
        citizen.nbt.ForgeData.owner === pUuid
      ) {
        confirm = true;
      }
    });
    if (confirm === false) {
      player.tell("§c仅能在殖民地内使用平整地面功能");
      return;
    }
    if (
      !global.ConsumableItems(player, [
        { id: "minecraft:amethyst_shard", count: 16 },
      ])
    ) {
      return;
    }
    server.runCommandSilent(
      `execute at ${pName} run place template snk:level_1 ~0 ~-10 ~0`
    );
  }
  if (event.reward.tags.contains("bd_level_2")) {
    let confirm = false;
    player.level.getEntitiesWithin(pAABB).forEach((citizen) => {
      if (confirm) return;
      if (
        citizen.type === "minecolonies:citizen" &&
        citizen.nbt.ForgeData.owner === pUuid
      ) {
        confirm = true;
      }
    });
    if (confirm === false) {
      player.tell("§c仅能在殖民地内使用平整地面功能");
      return;
    }
    if (
      !global.ConsumableItems(player, [
        { id: "minecraft:amethyst_shard", count: 16 },
      ])
    ) {
      return;
    }
    server.runCommandSilent(
      `execute at ${pName} run place template snk:level_2 ~-4 ~-10 ~-4`
    );
  }
  if (event.reward.tags.contains("bd_transfer_1")) {
    let confirm = true;
    player.level.getEntitiesWithin(pAABB).forEach((oldTransfer) => {
      if (oldTransfer.type === "minecraft:armor_stand" && oldTransfer.tags.contains("snk_transfer")) {
        confirm = false;
        return;
      }
    });
    if (confirm === false) {
      player.tell(
        "§c检测到100米矩形范围内存在其他传送点，无法在这么近的距离建设新的传送点"
      );
      return;
    }
    if (
      !global.ConsumableItems(player, [
        { id: "minecraft:amethyst_shard", count: 200 },
      ])
    ) {
      return;
    }
    server.runCommandSilent(
      `execute at ${pName} run place template snk:transfer ~-1 ~-4 ~-1`
    );
    player.teleportTo(
      player.level.dimension.path,
      player.x + 1,
      player.y,
      player.z,
      player.yaw,
      player.pitch
    );
    player.server.scheduleInTicks(5, () => {
      let pAABB2 = player.boundingBox.inflate(3, 6, 3);
      player.level.getEntitiesWithin(pAABB2).forEach((transfer) => {
        if (
          transfer.tags.contains("snk_transfer") &&
          !transfer.persistentData.contains("pUuid")
        ) {
          transfer.persistentData.putString("pUuid", pUuid);
          let team = player.team.name;
          let tUuid = transfer.uuid.toString();
          player.server.runCommandSilent(
            `execute as ${tUuid} run team join ${team} @s`
          );
          transfer.persistentData.putString(`team`, `${team}`);
          player.tell("传送点已建立，请下蹲右键传送石碑给石碑取名");
        }
      });
    });
  }
  if (event.reward.tags.contains("bd_dismantle")) {
    let confirm = false;
    let pAABB2 = player.boundingBox.inflate(10, 10, 10);
    player.level.getEntitiesWithin(pAABB2).forEach((transfer) => {
      if (
        transfer.tags.contains("snk_transfer") &&
        transfer.persistentData.getString("pUuid") === pUuid
      ) {
        let tUuid = transfer.uuid.toString();
        if (
          !global.ConsumableItems(player, [
            { id: "minecraft:amethyst_shard", count: 8 },
          ])
        ) {
          return;
        }
        server.runCommandSilent(
          `execute at ${tUuid} run place template snk:dismantle ~-2 ~-1 ~-2`
        );
        server.runCommandSilent(`execute as ${tUuid} run kill @s`);
        player.give(Item.of("minecraft:amethyst_shard", 200));
        player.tell("传送点已拆除");
        confirm = true;
      }
    });
    if (confirm === false) {
      player.tell("§c没有找到可以拆除的传送点");
      return;
    }
  }
});
