// 删除召唤的马匹
MEJSEvents.entityStopRiding(event => {
    let entity = event.entity
    let mount = event.vehicle
    let sData = entity.persistentData
    // 认证骑兵
    if (sData.getCompound("soldier").contains("Owner")) {
        let rideData = sData.getCompound("ride")
        // 如果是替换骑乘，则恢复为步行士兵
        if (rideData.getBoolean("replace")) {
            let pedestrianType = sData.getString("Pedestrian")
            if (pedestrianType) {
                let newSoldier = entity.level.createEntity(pedestrianType)
                newSoldier.setPosition(entity.x, entity.y, entity.z)
                newSoldier.mergeNbt(entity.nbt)
                // 恢复武器配置
                if (rideData.getCompound("PedestrianWeapon")) {
                    newSoldier.mergeNbt({
                        HandItems: [rideData.PedestrianWeapon, entity.nbt.HandItems[1]]
                    })
                }
                // 删除骑兵实体和马匹
                if (entity.vehicle) {
                    entity.vehicle.discard()
                }
                entity.discard()
                entity.server.scheduleInTicks(2, () => {
                    newSoldier.spawn()
                    // 加入团队（从士兵数据库中获取团队信息）
                    let sSoldierData = sData.getCompound("soldier")
                    let ownerUuid = sSoldierData.getString("Owner")
                    let ownerPlayer = entity.server.getPlayer(ownerUuid)
                    if (ownerPlayer) {
                        let team = ownerPlayer.team.name
                        entity.server.runCommandSilent(`execute as ${newSoldier.uuid} run team join ${team} @s`)
                    }
                })
            }
        } else {
            // 普通骑乘，只删除马匹
            if (mount && !mount.tags.contains("snk_mount")) {
                mount.discard()
            }
        }
    }
})