// priority: 10

// 如果宝箱内含有某样东西，则新增另一些东西

LootJS.modifiers(event => {

  //宝箱战利品匹配数组
  let categories = {
    //小麦
    WHEAT: ['minecraft:wheat'],
    //皮革
    LEATHER: ['minecraft:leather'],
    //马铠
    HORSE_ARMOR: [
      'minecraft:leather_horse_armor',
      'minecraft:iron_horse_armor',
      'minecraft:golden_horse_armor',
      'minecraft:diamond_horse_armor',
    ],
    //骨头
    BONE: ['minecraft:bone'],
    //腐肉
    ROTTENFLESH: ['minecraft:rotten_flesh'],
    //蜘蛛网
    COBWEB: ['minecraft:cobweb'],
    //农产品
    FARMPRODUCTS: [
      'minecraft:acacia_sapling',
      'minecraft:beetroot_seeds',
      'minecraft:beetroot',
      'minecraft:birch_sapling',
      'minecraft:cactus',
      'minecraft:carrot',
      'minecraft:cherry_sapling',
      'minecraft:dark_oak_sapling',
      'minecraft:jungle_sapling',
      'minecraft:mangrove_propagule',
      'minecraft:melon_seeds',
      'minecraft:oak_sapling',
      'minecraft:potato',
      'minecraft:pumpkin_seeds',
      'minecraft:spruce_sapling',
      'minecraft:sugar_cane',
      'minecraft:wheat_seeds',
    ],
    //畜产品
    ANIMALPRODUCTS: [
      'minecraft:beef',
      'minecraft:chicken',
      'minecraft:mutton',
      'minecraft:porkchop',
      'minecraft:rabbit',
    ],
    //水产品
    AQUATICPRODUCT: [
      'minecraft:cod',
      'minecraft:dried_kelp_block',
      'minecraft:dried_kelp',
      'minecraft:kelp',
      'minecraft:salmon',
    ],
    //食物
    FOOD: [
      'minecraft:baked_potato',
      'minecraft:cooked_beef',
      'minecraft:cooked_porkchop',
      'minecraft:cooked_mutton',
      'minecraft:cooked_chicken',
      'minecraft:cooked_rabbit',
      'minecraft:cooked_cod',
      'minecraft:cooked_salmon',
      'minecraft:bread',
      'minecraft:cookie',
      'minecraft:cake',
      'minecraft:pumpkin_pie',
      'minecraft:mushroom_stew',
      'minecraft:beetroot_soup',
      'minecraft:rabbit_stew',
    ],
    //工具
    TOOLS: [
      'minecraft:diamond_axe',
      'minecraft:diamond_hoe',
      'minecraft:diamond_pickaxe',
      'minecraft:diamond_shovel',
      'minecraft:golden_axe',
      'minecraft:golden_hoe',
      'minecraft:golden_pickaxe',
      'minecraft:golden_shovel',
      'minecraft:iron_axe',
      'minecraft:iron_hoe',
      'minecraft:iron_pickaxe',
      'minecraft:iron_shovel',
      'minecraft:netherite_axe',
      'minecraft:netherite_hoe',
      'minecraft:netherite_pickaxe',
      'minecraft:netherite_shovel',
      'minecraft:stone_axe',
      'minecraft:stone_hoe',
      'minecraft:stone_pickaxe',
      'minecraft:stone_shovel',
      'minecraft:wooden_axe',
      'minecraft:wooden_hoe',
      'minecraft:wooden_pickaxe',
      'minecraft:wooden_shovel',
      'dungeonnowloading:redstone_chip',
      'dungeonnowloading:redstone_suppressor',
      'dungeonnowloading:spawner_blade',
    ],
    //低级武器
    LOW_TIER_WEAPONS: [
      'minecraft:bow',
      'minecraft:crossbow',
      'minecraft:golden_sword',
      'minecraft:iron_axe',
      'minecraft:iron_sword',
      'minecraft:shield',
      'minecraft:stone_axe',
      'minecraft:stone_sword',
      'minecraft:wooden_axe',
      'minecraft:wooden_sword',
    ],
    //高级武器
    HIGH_TIER_WEAPONS: [
      'dungeonnowloading:redstone_chip',
      'dungeonnowloading:redstone_suppressor',
      'dungeonnowloading:spawner_blade',
      'dungeonnowloading:spawner_fragment',
      'minecraft:diamond_axe',
      'minecraft:diamond_sword',
      'minecraft:netherite_axe',
      'minecraft:netherite_sword',
      'minecraft:trident',
    ],
    //低级防具
    LOW_TIER_ARMOR: [
      'minecraft:chainmail_boots',
      'minecraft:chainmail_chestplate',
      'minecraft:chainmail_helmet',
      'minecraft:chainmail_leggings',
      'minecraft:golden_boots',
      'minecraft:golden_chestplate',
      'minecraft:golden_helmet',
      'minecraft:golden_leggings',
      'minecraft:iron_boots',
      'minecraft:iron_chestplate',
      'minecraft:iron_helmet',
      'minecraft:iron_leggings',
      'minecraft:leather_boots',
      'minecraft:leather_chestplate',
      'minecraft:leather_helmet',
      'minecraft:leather_leggings',
    ],
    //高级防具
    HIGH_TIER_ARMOR: [
      'dungeonnowloading:redstone_chip',
      'dungeonnowloading:redstone_suppressor',
      'dungeonnowloading:spawner_blade',
      'dungeonnowloading:spawner_fragment',
      'minecraft:diamond_boots',
      'minecraft:diamond_chestplate',
      'minecraft:diamond_helmet',
      'minecraft:diamond_horse_armor',
      'minecraft:diamond_leggings',
      'minecraft:netherite_boots',
      'minecraft:netherite_chestplate',
      'minecraft:netherite_helmet',
      'minecraft:netherite_leggings',
    ],
    //箭
    ARROW: [
      'minecraft:arrow',
      'minecraft:spectral_arrow',
    ],
    //常规矿物和珍贵品
    LOW_VALUE_MINERALS: [
      'alexscaves:galena_iron_ore',
      'minecraft:copper_ore',
      'minecraft:deepslate_copper_ore',
      'minecraft:deepslate_gold_ore',
      'minecraft:deepslate_iron_ore',
      'minecraft:emerald_ore',
      'minecraft:emerald',
      'minecraft:enchanted_book',
      'minecraft:gold_ingot',
      'minecraft:gold_ore',
      'minecraft:iron_ingot',
      'minecraft:iron_ore',
      'minecraft:nether_quartz_ore',
      'minecraft:quartz',
      'minecraft:raw_copper',
      'minecraft:raw_gold',
      'minecraft:raw_iron',
    ],
    //贵重矿物和珍贵品
    HIGH_VALUE_MINERALS: [
      'born_in_chaos_v1:dark_metal_deposit',
      'born_in_chaos_v1:dark_metal_ingot',
      'born_in_chaos_v1:dark_metal_nugget',
      'born_in_chaos_v1:pieceofdarkmetal',
      'born_in_chaos_v1:pileof_dark_metal',
      'cataclysm:ancient_metal_ingot',
      'cataclysm:black_steel_ingot',
      'cataclysm:black_steel_nugget',
      'dungeonnowloading:redstone_chip',
      'dungeonnowloading:redstone_suppressor',
      'dungeonnowloading:spawner_blade',
      'dungeonnowloading:spawner_fragment',
      'minecraft:amethyst_shard',
      'minecraft:crying_obsidian',
      'minecraft:deepslate_emerald_ore',
      'minecraft:diamond_ore',
      'minecraft:diamond',
      'minecraft:enchanted_golden_apple',
      'minecraft:gilded_blackstone',
      'minecraft:golden_apple',
      'minecraft:nether_gold_ore',
      'minecraft:netherite_ingot',
      'minecraft:netherite_scrap',
      'minecraft:diamond_horse_armor',
    ],
    //书
    BOOKS: [
      'minecraft:paper',
      'minecraft:book',
      'minecraft:experience_bottle',
    ],
    //粉末
    POWDER: [
      'minecraft:redstone',
      'minecraft:gunpowder',
    ],
  }
  //追加战利品数组
  //配置示例
  //   {
  //     id: 'minecraft:stick',                                                         //物品ID
  //     //其他配置均为可选项
  //     chance: 0.001,                                                                 //出现概率，默认1.0
  //     count: [5, 20],                                                                //数量范围，默认[1,1]
  //     name: { text: '世界树枝条', italic: false, color: 'yellow', bold: true },       //物品名称
  //     lore: [
  //       { text: '保持着旺盛的生命力', italic: false, color: 'white' },                 //物品描述
  //     ],
  //     enchantments: [                                                                 //附魔
  //       { id: 'l2complements:eternal', lvl: 1, },
  //     ],
  //     enchantColor: 'orange'                                                          //附魔颜色
  //     potion: 'parcool:energy_drink',                                                 //药水类型
  //     potioneffects: [                                                                //药水效果
  //       { Amplifier: 1, Duration: 18000, Id: 1 },
  //     ]
  //     Damage: 3,                                                                      //物品耐久(损伤值)
  //     enchantColor: 'lime'                                                            //附魔颜色
  //     Trim: { material: 'additionaltrims:feather', pattern: 'minecraft:wild' },       //盔甲修饰
  //   },
  let lootByCategory = {
    //小麦宝箱
    WHEAT: [
      {
        id: 'minecraft:stick',
        chance: 0.005,
        name: { text: '世界树枝条', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '保持着旺盛的生命力', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'l2complements:eternal', lvl: 1, },
          { id: 'l2complements:cubic_digging', lvl: 1, },
        ],
        enchantColor: 'orange'
      },
      {
        id: 'farm_and_charm:corn',
        chance: 0.15,
        count: [5, 20],
      },
      {
        id: 'farm_and_charm:oat',
        chance: 0.15,
        count: [5, 20],
      },
      {
        id: 'farm_and_charm:barley',
        chance: 0.15,
        count: [5, 20],
      },
    ],
    //皮革宝箱
    LEATHER: [
      {
        id: 'born_in_chaos_v1:monster_skin',
        chance: 0.15,
        count: [3, 6],
      },
      {
        id: 'quark:ravager_hide',
        chance: 0.03,
        count: [1, 3],
      },
    ],
    HORSE_ARMOR: [
      {
        id: 'farm_and_charm:horse_fodder',
        chance: 0.2,
        count: [5, 20],
      },
      {
        id: 'minecraft:golden_horse_armor',
        chance: 0.02,
        name: { text: '恶灵骑士', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '只有真正的地狱烈马才能穿上它', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'l2complements:durable_armor', lvl: 5, },
          { id: 'jlme:burning_thorns', lvl: 5, },
          { id: 'l2complements:soul_flame_thorn', lvl: 5, },
          { id: 'minecraft:soul_speed', lvl: 3, }
        ],
        enchantColor: 'red'
      },
      {
        id: 'minecraft:leather_horse_armor',
        chance: 0.02,
        name: { text: '天行者', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '我寻思脚下是地面', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'minecraft:frost_walker', lvl: 2, },
          { id: 'l2complements:snow_walker', lvl: 1, }
        ],
        enchantColor: 'orange'
      },
    ],
    //骨头宝箱
    BONE: [
      {
        id: 'call_of_yucutan:elder_bone',
        chance: 0.05,
        count: [1, 4],
      },
    ],
    //农产品宝箱
    FARMPRODUCTS: [
      {
        id: 'minecraft:stick',
        chance: 0.005,
        name: { text: '世界树枝条', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '保持着旺盛的生命力', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'l2complements:eternal', lvl: 1, },
          { id: 'l2complements:cubic_digging', lvl: 1, },
        ],
        enchantColor: 'orange'
      },
      {
        id: 'minecraft:carved_pumpkin',
        chance: 0.01,
        name: { text: '怪杰假面', italic: false, color: 'green', bold: true },
        lore: [
          { text: '有一种莫名的力量', italic: false, color: 'white' },
          { text: '让人忍不住想要戴上它', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'minecraft:respiration', lvl: 10, },
          { id: 'minecraft:depth_strider', lvl: 10, },
          { id: 'combatroll:longfooted', lvl: 10, },
          { id: 'combatroll:acrobat', lvl: 10, },
          { id: 'combatroll:multi_roll', lvl: 10, },
          { id: 'minecraft:binding_curse', lvl: 1, },
          { id: 'minecraft:vanishing_curse', lvl: 1, },
        ],
        enchantColor: 'lime'
      },
      {
        id: 'arcanelanterns:feral_lantern',
        chance: 0.03,
      },
      {
        id: 'farm_and_charm:strawberry_seeds',
        chance: 0.005,
        count: [3, 10],
      },
      {
        id: 'farm_and_charm:lettuce_seeds',
        chance: 0.005,
        count: [3, 10],
      },
      {
        id: 'crockpot:asparagus_seeds',
        chance: 0.005,
        count: [3, 10],
      },
      {
        id: 'farm_and_charm:kernels',
        chance: 0.005,
        count: [3, 10],
      },
      {
        id: 'crockpot:eggplant_seeds',
        chance: 0.005,
        count: [3, 10],
      },
      {
        id: 'crockpot:garlic_seeds',
        chance: 0.005,
        count: [3, 10],
      },
      {
        id: 'farm_and_charm:onion',
        chance: 0.005,
        count: [3, 10],
      },
      {
        id: 'crockpot:pepper_seeds',
        chance: 0.005,
        count: [3, 10],
      },
      {
        id: 'crockpot:tomato_seeds',
        chance: 0.005,
        count: [3, 10],
      },
      {
        id: 'farm_and_charm:oat_seeds',
        chance: 0.005,
        count: [3, 10],
      },
      {
        id: 'farm_and_charm:barley_seeds',
        chance: 0.005,
        count: [3, 10],
      },
    ],
    //水产品宝箱
    AQUATICPRODUCT: [
      {
        id: 'alexscaves:deep_sea_sushi_roll',
        chance: 0.05,
      },
      {
        id: 'aquamirae:sea_casserole',
        chance: 0.02,
      },
      {
        id: 'aquamirae:sea_stew',
        chance: 0.01,
      },
      {
        id: 'aquamirae:poseidons_breakfast',
        chance: 0.005,
      },
    ],
    //食物宝箱
    FOOD: [
      {
        id: 'alexscaves:alex_meal',
        chance: 0.005,
      },
      {
        id: 'alexscaves:vesper_stew',
        chance: 0.05,
        count: [2, 5],
      },
      {
        id: 'alexscaves:deep_sea_sushi_roll',
        chance: 0.05,
        count: [2, 5],
      },
      {
        id: 'alexscaves:seething_stew',
        chance: 0.05,
        count: [2, 5],
      },
      {
        id: 'alexscaves:primordial_soup',
        chance: 0.05,
        count: [2, 5],
      },
      {
        id: 'alexscaves:slam',
        chance: 0.05,
        count: [2, 5],
      },
      {
        id: 'alexscaves:spelunkie',
        chance: 0.05,
        count: [2, 5],
      },
      {
        id: 'born_in_chaos_v1:chocolate_heart',
        chance: 0.05,
        count: [2, 5],
      },
      {
        id: 'born_in_chaos_v1:caramel_pepper',
        chance: 0.05,
        count: [2, 5],
      },
      {
        id: 'born_in_chaos_v1:holiday_candy',
        chance: 0.05,
        count: [2, 5],
      },
      {
        id: 'born_in_chaos_v1:mint_candy',
        chance: 0.05,
        count: [2, 5],
      },
      {
        id: 'born_in_chaos_v1:mint_ice_cream',
        chance: 0.05,
        count: [2, 5],
      },
      {
        id: 'born_in_chaos_v1:coffee_candy',
        chance: 0.05,
        count: [2, 5],
      },
      {
        id: 'born_in_chaos_v1:gummy_vampire_teeth',
        chance: 0.05,
        count: [2, 5],
      },
      {
        id: 'aquamirae:sea_stew',
        chance: 0.05,
        count: [2, 5],
      },
      {
        id: 'aquamirae:sea_casserole',
        chance: 0.05,
        count: [2, 5],
      },
      {
        id: 'call_of_yucutan:xocolatl',
        chance: 0.05,
        count: [2, 5],
      },
      {
        id: 'minecraft:potion',
        chance: 0.03,
        name: { text: '能量液泵', italic: false, color: 'yellow', bold: true },
        potion: 'parcool:energy_drink',
        potioneffects: [
          { Amplifier: 1, Duration: 18000, Id: 1 },
          { Amplifier: 1, Duration: 18000, Id: 8 },
        ]
      },
    ],
    //工具宝箱
    TOOLS: [
      {
        id: 'minecraft:bow',
        chance: 0.03,
        name: { text: '传送魔杖', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '唉？它为啥叫魔杖？', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'chromaticenchantments:riding', lvl: 1, },
          { id: 'jlme:range', lvl: 1, },
        ],
        enchantColor: 'orange'
      },
      {
        id: 'minecraft:fishing_rod',
        chance: 0.015,
        name: { text: '格劳克斯的钓竿', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '只是一把旧鱼竿', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'l2complements:eternal', lvl: 1, },
        ],
        enchantColor: 'orange'
      },
      {
        id: 'minecraft:shears',
        chance: 0.015,
        name: { text: '阿特洛波斯的命运之剪', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '用来剪断生命之线', italic: false, color: 'white' },
          { text: '可能是营销号在瞎扯', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'l2complements:eternal', lvl: 1, },
          { id: 'l2complements:vien_mining', lvl: 3, },
          { id: 'l2complements:ender_reach', lvl: 1, },
        ],
        enchantColor: 'orange'
      },
      {
        id: 'l2complements:eternium_hoe',
        chance: 0.002,
        name: { text: '永恒的终极奉献', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '终极的终极', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'minecraft:unbreaking', lvl: 10, },
          { id: 'l2complements:life_mending', lvl: 10, },
          { id: 'l2complements:eternal', lvl: 1, },
          { id: 'minecraft:mending', lvl: 1, },
          { id: 'l2complements:life_sync', lvl: 1, },
          { id: 'l2complements:safeguard', lvl: 1, },
          { id: 'l2complements:hardened', lvl: 1, },
          { id: 'l2complements:soul_bound', lvl: 1, },
        ],
        enchantColor: 'orange'
      },
      {
        id: 'minecraft:wooden_pickaxe',
        chance: 0.03,
        name: { text: '怨灵镐', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '据说', italic: false, color: 'white' },
          { text: '由只使用过三次', italic: false, color: 'white' },
          { text: '的木镐制成', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'l2complements:cubic_eater', lvl: 2, },
          { id: 'l2complements:soul_bound', lvl: 1, },
          { id: 'l2complements:ender_reach', lvl: 1, },
          { id: 'jlme:curse_of_possession', lvl: 1, },
        ],
        Damage: 3,
        enchantColor: 'orange'
      },
      {
        id: 'minecraft:iron_shovel',
        chance: 0.03,
        name: { text: '清扫者', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '清理一切障碍', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'l2complements:vien_mining', lvl: 2, },
        ],
        enchantColor: 'orange'
      },
      {
        id: 'metalmith:copper_pickaxe',
        chance: 0.03,
        name: { text: '矮人矿镐', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '矮人打造的矿镐', italic: false, color: 'white' },
          { text: '精确挖掘', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'l2complements:vien_mining', lvl: 2, },
        ],
        enchantColor: 'orange'
      },
      {
        id: 'minecraft:iron_pickaxe',
        chance: 0.015,
        name: { text: '地底掘进者', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '太快了！', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'l2complements:cubic_digging', lvl: 1, },
          { id: 'minecraft:efficiency', lvl: 5, },
        ],
        enchantColor: 'orange'
      },
      {
        id: 'metalmith:copper_shovel',
        chance: 0.05,
        name: { text: '盗墓者', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '快速获取土样', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'l2complements:drill_diggin', lvl: 2, },
          { id: 'l2complements:ender_reach', lvl: 1, },
        ],
        enchantColor: 'orange'
      },
      {
        id: 'minecraft:stone_pickaxe',
        chance: 0.03,
        name: { text: '黑曜石重锤', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '对石头造成范围伤害', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'l2complements:cubic_digging', lvl: 1, },
          { id: 'minecraft:unbreaking', lvl: 10, },
        ],
        enchantColor: 'orange'
      },
      {
        id: 'minecraft:stick',
        chance: 0.01,
        name: { text: '皇帝的新镐', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '据说只有聪明的人', italic: false, color: 'white' },
          { text: '才能看见它', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'l2complements:plane_digging', lvl: 1, },
        ],
        enchantColor: 'orange'
      },
      {
        id: 'born_in_chaos_v1:wood_splitter_axe',
        chance: 0.03,
        name: { text: '尼德霍格的利齿', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '传说中', italic: false, color: 'white' },
          { text: '这把斧头能劈开世界树的树干', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'l2complements:tree_chopping', lvl: 2, },
          { id: 'l2complements:ender_reach', lvl: 1, },
        ],
        enchantColor: 'orange'
      },
      {
        id: 'minecraft:splash_potion',
        chance: 0.05,
        count: [5, 20],
        name: { text: '精神震撼弹', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '注意闪光！', italic: false, color: 'white' },
          { text: '唉？好像并没有', italic: false, color: 'white' },
        ],
        potion: 'l2complements:stone_cage',
        potioneffects: [
          { Amplifier: 0, Duration: 80, Id: 98 },

        ]
      },
      {
        id: 'minecraft:splash_potion',
        chance: 0.05,
        count: [5, 20],
        name: { text: '反重力药剂', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '轻飘飘的感觉', italic: false, color: 'white' },
        ],
        potion: 'l2complements:long_levitation',
        potioneffects: [
          { Amplifier: 0, Duration: 120, Id: 25 },

        ]
      },
      {
        id: 'minecraft:splash_potion',
        chance: 0.05,
        count: [5, 20],
        name: { text: '腐蚀药剂', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '除你盔甲！', italic: false, color: 'white' },
        ],
        potion: 'l2complements:armor_reduce',
        potioneffects: [
          { Amplifier: 1, Duration: 600, Id: 97 },

        ]
      },
      {
        id: 'l2complements:eternium_axe',
        chance: 0.001,
      },
      {
        id: 'l2complements:eternium_shovel',
        chance: 0.001,
      },
      {
        id: 'l2complements:eternium_pickaxe',
        chance: 0.001,
      },
      {
        id: 'minecraft:amethyst_shard',
        chance: 0.1,
        count: [10, 40],
      },
    ],
    //低级武器宝箱
    LOW_TIER_WEAPONS: [
      {
        id: 'waystones:warp_scroll',
        chance: 0.2,
        name: { text: '领兵卷轴', italic: false, color: 'gold', bold: true },
        lore: [
          { text: '增加远征军上限', italic: false, color: 'white' },
          { text: '不可超过最大值', italic: false, color: 'white' },
          { text: '达到上限将兑换为紫水晶碎片', italic: false, color: 'white' }
        ]
      },
      {
        id: 'minecraft:splash_potion',
        chance: 0.05,
        count: [5, 20],
        name: { text: '精神震撼弹', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '注意闪光！', italic: false, color: 'white' },
          { text: '唉？好像并没有', italic: false, color: 'white' },
        ],
        potion: 'l2complements:stone_cage',
        potioneffects: [
          { Amplifier: 0, Duration: 80, Id: 98 },

        ]
      },
      {
        id: 'minecraft:splash_potion',
        chance: 0.05,
        count: [5, 20],
        name: { text: '反重力药剂', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '轻飘飘的感觉', italic: false, color: 'white' },
        ],
        potion: 'l2complements:long_levitation',
        potioneffects: [
          { Amplifier: 0, Duration: 120, Id: 25 },

        ]
      },
      {
        id: 'minecraft:splash_potion',
        chance: 0.05,
        count: [5, 20],
        name: { text: '腐蚀药剂', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '除你盔甲！', italic: false, color: 'white' },
        ],
        potion: 'l2complements:armor_reduce',
        potioneffects: [
          { Amplifier: 1, Duration: 600, Id: 97 },

        ]
      },
      {
        id: 'simplyswords:runic_tablet',
        chance: 0.25,
      },
      {
        id: 'simplyswords:contained_remnant',
        chance: 0.025,
      },
      {
        id: 'quark:smithing_template_rune',
        chance: 0.01,
      },
      {
        id: 'minecolonies:ancienttome',
        chance: 0.01,
      },
      {
        id: 'minecraft:amethyst_shard',
        chance: 0.05,
        count: [10, 40],
      },
    ],
    //高级武器宝箱
    HIGH_TIER_WEAPONS: [
      {
        id: 'call_of_yucutan:obsidian_tecpatl',
        chance: 0.06,
        name: { text: '龙晶匕首', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '你或许觉得它不起眼', italic: false, color: 'white' },
          { text: '但遇到异鬼时就会改变想法了', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'minecraft:smite', lvl: 20, }
        ],
        enchantColor: 'blank'
      },
      {
        id: 'musketmod:musket',
        chance: 0.03,
        name: { text: '双管猎枪', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '一次射击', italic: false, color: 'white' },
          { text: '两次伤害', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'call_of_yucutan:double_edged', lvl: 10, },
        ],
        enchantColor: 'blank'
      },
      {
        id: 'sticknstone:wooden_rapier',
        chance: 0.05,
        name: { text: '并非木荆之杖', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '击中时没有概率释放一片有毒孢子云', italic: false, color: 'white' },
          { text: '但它确实有毒', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'jlme:envenomed', lvl: 5, },
          { id: 'jlme:viper', lvl: 5, },
          { id: 'l2complements:cursed_blade', lvl: 5, },
        ],
        enchantColor: 'blank'
      },
      {
        id: 'minecraft:blaze_rod',
        chance: 0.01,
        name: { text: '锟斤拷', italic: false, color: 'red', bold: true },
        lore: [
          { text: '烫烫烫烫', italic: false, color: 'red' }
        ],
        enchantments: [
          { id: 'minecraft:fire_aspect', lvl: 5, },
          { id: 'l2complements:soul_flame_blade', lvl: 5, },
          { id: 'jlme:ash_destroyer', lvl: 5, },
          { id: 'jlme:burning_thorns', lvl: 5, },
          { id: 'l2complements:soul_flame_thorn', lvl: 5, },
          { id: 'jlme:double_edge', lvl: 1, },
        ],
        enchantColor: 'orange'
      },
      {
        id: 'born_in_chaos_v1:supreme_measure',
        chance: 0.01,
        name: { text: '都得死', italic: false, color: 'red', bold: true },
        lore: [
          { text: '亡灵都得死', italic: false, color: 'red' },
          { text: '爬虫都得死', italic: false, color: 'red' },
          { text: '生物都得死', italic: false, color: 'red' },
          { text: '总之都得死', italic: false, color: 'red' },
        ],
        enchantments: [
          { id: 'minecraft:sharpness', lvl: 100, },
          { id: 'jlme:double_edge', lvl: 1, },
          { id: 'minecraft:vanishing_curse', lvl: 1, },
        ],
        enchantColor: 'red'
      },
      {
        id: 'born_in_chaos_v1:trident_hayfork',
        chance: 0.03,
        name: { text: '干草堆刺客', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '“我要把它埋在干草堆里”', italic: false, color: 'white' },
        ],
        enchantments: [
          { id: 'jlme:armor_piercing', lvl: 10, },
        ],
        enchantColor: 'blank'
      },
      {
        id: 'simplyswords:iron_katana',
        chance: 0.01,
        name: { text: '并非风语', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '命中时没有几率刷新技能冷却', italic: false, color: 'white' },
          { text: '但它能号令狂风', italic: false, color: 'white' },
        ],
        enchantments: [
          { id: 'l2complements:wind_sweep', lvl: 10, },
          { id: 'call_of_yucutan:double_edged', lvl: 10, },
          { id: 'minecraft:sweeping', lvl: 1, },
          { id: 'jlme:cleaving', lvl: 1, },
        ],
        enchantColor: 'blank'
      },
      {
        id: 'waystones:warp_scroll',
        chance: 0.2,
        name: { text: '领兵卷轴', italic: false, color: 'gold', bold: true },
        lore: [
          { text: '增加远征军上限', italic: false, color: 'white' },
          { text: '不可超过最大值', italic: false, color: 'white' },
          { text: '达到上限将兑换为紫水晶碎片', italic: false, color: 'white' }
        ]
      },
      {
        id: 'minecraft:torch',
        chance: 0.05,
        name: { text: '并非余烬鞭挞', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '无法使受击者进入隐燃状态', italic: false, color: 'white' },
          { text: '但会使受击者进入明燃状态', italic: false, color: 'white' },
          { text: '右键无法恢复生命', italic: false, color: 'white' },
          { text: '但对着方块右键可以阻止生命的诞生', italic: false, color: 'white' },
        ],
        enchantments: [
          { id: 'minecraft:fire_aspect', lvl: 5, },
          { id: 'jlme:ash_destroyer', lvl: 5, }
        ],
        enchantColor: 'blank'
      },
      {
        id: 'l2complements:eternium_sword',
        chance: 0.001,
      },
      {
        id: 'simplyswords:runic_tablet',
        chance: 0.25,
      },
      {
        id: 'simplyswords:contained_remnant',
        chance: 0.1,
      },
      {
        id: 'quark:smithing_template_rune',
        chance: 0.05,
      },
      {
        id: 'minecolonies:ancienttome',
        chance: 0.05,
      },
      {
        id: 'minecraft:amethyst_shard',
        chance: 0.15,
        count: [10, 40],
      },
    ],
    //低级防具宝箱
    LOW_TIER_ARMOR: [
      {
        id: 'waystones:warp_scroll',
        chance: 0.2,
        name: { text: '领兵卷轴', italic: false, color: 'gold', bold: true },
        lore: [
          { text: '增加远征军上限', italic: false, color: 'white' },
          { text: '不可超过最大值', italic: false, color: 'white' },
          { text: '达到上限将兑换为紫水晶碎片', italic: false, color: 'white' }
        ]
      },
      {
        id: 'quark:smithing_template_rune',
        chance: 0.01,
      },
      {
        id: 'minecolonies:ancienttome',
        chance: 0.01,
      },
      {
        id: 'minecraft:amethyst_shard',
        chance: 0.05,
        count: [10, 40],
      },
    ],
    //高级防具宝箱
    HIGH_TIER_ARMOR: [
      {
        id: 'waystones:warp_scroll',
        chance: 0.05,
        name: { text: '领兵卷轴', italic: false, color: 'gold', bold: true },
        lore: [
          { text: '增加远征军上限', italic: false, color: 'white' },
          { text: '不可超过最大值', italic: false, color: 'white' },
          { text: '达到上限将兑换为紫水晶碎片', italic: false, color: 'white' }
        ]
      },
      {
        id: 'minecraft:carved_pumpkin',
        chance: 0.01,
        name: { text: '怪杰假面', italic: false, color: 'green', bold: true },
        lore: [
          { text: '有一种莫名的力量', italic: false, color: 'white' },
          { text: '让人忍不住想要戴上它', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'minecraft:respiration', lvl: 10, },
          { id: 'minecraft:depth_strider', lvl: 10, },
          { id: 'combatroll:longfooted', lvl: 10, },
          { id: 'combatroll:acrobat', lvl: 10, },
          { id: 'combatroll:multi_roll', lvl: 10, },
          { id: 'minecraft:binding_curse', lvl: 1, },
          { id: 'minecraft:vanishing_curse', lvl: 1, },
        ],
        enchantColor: 'lime'
      },
      {
        id: 'immersive_armors:wooden_chestplate',
        chance: 0.03,
        name: { text: '木箭靶', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '由使用了很久的箭靶改造而成', italic: false, color: 'white' },
          { text: '不知为何一直没用坏', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'l2complements:projectile_reject', lvl: 1, },
        ],
        enchantColor: 'blank'
      },
      {
        id: 'immersive_armors:robe_chestplate',
        chance: 0.03,
        name: { text: '真炎法袍', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '据说穿上它能抵御火焰', italic: false, color: 'white' },
          { text: '但从没见过有人试过', italic: false, color: 'white' }
        ],
        enchantments: [
          { id: 'l2complements:fire_reject', lvl: 1, },
          { id: 'l2complements:soul_flame_thorn', lvl: 3, },
          { id: 'jlme:burning_thorns', lvl: 3, },
        ],
        enchantColor: 'blank'
      },
      {
        id: 'immersive_armors:steampunk_leggings',
        chance: 0.03,
        name: { text: '泵动弹射腰带', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '通过多重推进装置弹射', italic: false, color: 'white' },
          { text: '三次', italic: false, color: 'white' }
        ],
        Trim: { material: 'additionaltrims:feather', pattern: 'minecraft:wild' },
        enchantments: [
          { id: 'jlme:double_jump', lvl: 1, },
        ],
        enchantColor: 'blank'
      },
      {
        id: 'immersive_armors:steampunk_boots',
        chance: 0.03,
        name: { text: '爆炸弹射护腿', italic: false, color: 'yellow', bold: true },
        lore: [
          { text: '通过爆炸装药弹射', italic: false, color: 'white' }
        ],
        Trim: { material: 'additionaltrims:feather', pattern: 'minecraft:redstone' },
        enchantments: [
          { id: 'jlme:high_jump', lvl: 5, },
          { id: 'combatroll:acrobat', lvl: 5, },
        ],
        enchantColor: 'blank'
      },
      {
        id: 'waystones:warp_scroll',
        chance: 0.2,
        name: { text: '领兵卷轴', italic: false, color: 'gold', bold: true },
        lore: [
          { text: '增加远征军上限', italic: false, color: 'white' },
          { text: '不可超过最大值', italic: false, color: 'white' },
          { text: '达到上限将兑换为紫水晶碎片', italic: false, color: 'white' }
        ]
      },
      {
        id: 'l2complements:eternium_boots',
        chance: 0.001,
      },
      {
        id: 'l2complements:eternium_chestplate',
        chance: 0.001,
      },
      {
        id: 'l2complements:eternium_helmet',
        chance: 0.001,
      },
      {
        id: 'l2complements:eternium_leggings',
        chance: 0.001,
      },
      {
        id: 'quark:smithing_template_rune',
        chance: 0.05,
      },
      {
        id: 'minecolonies:ancienttome',
        chance: 0.05,
      },
      {
        id: 'minecraft:amethyst_shard',
        chance: 0.15,
        count: [10, 40],
      },
    ],
    //箭宝箱
    ARROW: [
      {
        id: 'quark:torch_arrow',
        chance: 0.05,
        count: [16, 64],
      },
    ],
    //常规矿物和珍贵品
    LOW_VALUE_MINERALS: [
      {
        id: 'illagerinvasion:platinum_chunk',
        chance: 0.05,
        count: [2, 5],
      },
      {
        id: 'minecraft:amethyst_shard',
        chance: 0.25,
        count: [40, 80],
      },
      {
        id: 'metalmith:silicon_bronze_ingot',
        chance: 0.1,
        count: [4, 8],
      },
      {
        id: 'metalmith:vein_gold_ingot',
        chance: 0.1,
        count: [4, 8],
      },
    ],
    //贵重矿物和珍贵品
    HIGH_VALUE_MINERALS: [
      {
        id: 'dungeonnowloading:durite',
        chance: 0.1,
        count: [3, 6],
      },
      {
        id: 'dungeonnowloading:mendstone',
        chance: 0.05,
        count: [1, 2],
      },
      {
        id: 'illagerinvasion:platinum_chunk',
        chance: 0.1,
        count: [3, 12],
      },
      {
        id: 'minecraft:amethyst_shard',
        chance: 0.25,
        count: [100, 200],
      },
      {
        id: 'metalmith:flam_iron_ingot',
        chance: 0.05,
        count: [1, 4],
      },
      {
        id: 'simplyswords:runic_tablet',
        chance: 0.1,
      },
      {
        id: 'simplyswords:contained_remnant',
        chance: 0.05,
      },
    ],
    //书宝箱
    BOOKS: [
      {
        id: 'waystones:warp_scroll',
        chance: 0.2,
        name: { text: '领兵卷轴', italic: false, color: 'gold', bold: true },
        lore: [
          { text: '增加远征军上限', italic: false, color: 'white' },
          { text: '不可超过最大值', italic: false, color: 'white' },
          { text: '达到上限将兑换为紫水晶碎片', italic: false, color: 'white' }
        ]
      },
      {
        id: 'minecolonies:ancienttome',
        chance: 0.5,
        count: [1, 5],
      },
      {
        id: 'quark:smithing_template_rune',
        chance: 0.25,
        count: [1, 3],
      },
      {
        id: 'simplyswords:runic_tablet',
        chance: 0.05,
      },
      {
        id: 'simplyswords:contained_remnant',
        chance: 0.015,
      },
      {
        id: 'minecraft:amethyst_shard',
        chance: 0.3,
        count: [10, 40],
      },
    ],
    //粉末宝箱
    POWDER: [
      {
        id: 'born_in_chaos_v1:phantom_powder',
        chance: 0.05,
        count: [5, 64],
      },
    ],
  }

  // 创建一个主modifier
  let mainModifier = event.addLootTypeModifier(LootType.CHEST)

  // 收集所有要匹配的物品
  let allMatchItems = []
  for (let matchItems of Object.values(categories)) {
    allMatchItems = allMatchItems.concat(matchItems)
  }

  // 设置匹配条件
  mainModifier.matchLoot(allMatchItems)

  // 应用所有符合条件的战利品
  mainModifier.apply(context => {
    // 检查每个类别是否匹配
    for (let [category, matchItems] of Object.entries(categories)) {
      if (!lootByCategory[category]) continue
      // 检查当前战利品表中是否有该类别的任何物品
      let hasMatch = false
      for (let item of matchItems) {
        if (context.hasLoot(Item.of(item))) {
          hasMatch = true
          break
        }
      }
      // 如果匹配，添加该类别的所有战利品
      if (hasMatch) {
        lootByCategory[category].forEach(lootItem => {
          let nbtData = {}

          if (lootItem.enchantments && lootItem.enchantments.length > 0) {
            nbtData.Enchantments = lootItem.enchantments
          }
          if (lootItem.potioneffects && lootItem.potioneffects.length > 0) {
            nbtData.CustomPotionEffects = lootItem.potioneffects
          }
          if (lootItem.potion) {
            nbtData.Potion = lootItem.potion
          }
          if (lootItem.Damage) {
            nbtData.Damage = lootItem.Damage
          }
          if (lootItem.Trim && Object.keys(lootItem.Trim).length > 0) {
            nbtData.Trim = lootItem.Trim
          }
          if (lootItem.enchantColor) {
            nbtData['quark:RuneColor'] = lootItem.enchantColor
          }

          let lootEntry = LootEntry.of(lootItem.id)
            .when(c => c.randomChance(lootItem.chance || 1.0))
            .limitCount(lootItem.count || [1, 1])

          if (lootItem.name) {
            lootEntry = lootEntry.setName(lootItem.name)
          }
          if (lootItem.lore && lootItem.lore.length > 0) {
            lootEntry = lootEntry.replaceLore(lootItem.lore)
          }
          if (Object.keys(nbtData).length > 0) {
            lootEntry = lootEntry.addNBT(nbtData)
          }

          context.addLoot(lootEntry)
        })
      }
    }
  })
})