// priority: 50

// 将数组内的物品全部替换为数组名

LootJS.modifiers(event => {

  let integration = {
    "materials_integration:dirt_integration": [
      "minecraft:coarse_dirt",
      "minecraft:dirt_path",
      "minecraft:dirt",
      "minecraft:farmland",
      "minecraft:grass_block",
      "minecraft:mud_brick_stairs",
      "minecraft:mud_brick_wall",
      "minecraft:mud_bricks",
      "minecraft:mud",
      "minecraft:mycelium",
      "minecraft:packed_mud",
      "minecraft:podzol",
      "minecraft:rooted_dirt",
      "minecraft:mud_brick_slab",
    ],
    "materials_integration:log_integration": [
      "minecraft:acacia_log",
      "minecraft:acacia_wood",
      "minecraft:birch_log",
      "minecraft:birch_wood",
      "minecraft:cherry_log",
      "minecraft:cherry_wood",
      "minecraft:dark_oak_log",
      "minecraft:dark_oak_wood",
      "minecraft:jungle_log",
      "minecraft:jungle_wood",
      "minecraft:mangrove_log",
      "minecraft:mangrove_wood",
      "minecraft:oak_log",
      "minecraft:oak_wood",
      "minecraft:spruce_log",
      "minecraft:spruce_wood",
      "minecraft:stripped_acacia_log",
      "minecraft:stripped_acacia_wood",
      "minecraft:stripped_birch_log",
      "minecraft:stripped_birch_wood",
      "minecraft:stripped_cherry_log",
      "minecraft:stripped_cherry_wood",
      "minecraft:stripped_dark_oak_log",
      "minecraft:stripped_dark_oak_wood",
      "minecraft:stripped_jungle_log",
      "minecraft:stripped_jungle_wood",
      "minecraft:stripped_mangrove_log",
      "minecraft:stripped_mangrove_wood",
      "minecraft:stripped_oak_log",
      "minecraft:stripped_oak_wood",
      "minecraft:stripped_spruce_log",
      "minecraft:stripped_spruce_wood",
    ],
    "materials_integration:planks_integration": [
      "minecraft:acacia_door",
      "minecraft:acacia_fence_gate",
      "minecraft:acacia_fence",
      "minecraft:acacia_planks",
      "minecraft:acacia_slab",
      "minecraft:acacia_stairs",
      "minecraft:acacia_trapdoor",
      "minecraft:birch_door",
      "minecraft:birch_fence_gate",
      "minecraft:birch_fence",
      "minecraft:birch_planks",
      "minecraft:birch_slab",
      "minecraft:birch_stairs",
      "minecraft:birch_trapdoor",
      "minecraft:cherry_door",
      "minecraft:cherry_fence_gate",
      "minecraft:cherry_fence",
      "minecraft:cherry_planks",
      "minecraft:cherry_slab",
      "minecraft:cherry_stairs",
      "minecraft:cherry_trapdoor",
      "minecraft:dark_oak_door",
      "minecraft:dark_oak_fence_gate",
      "minecraft:dark_oak_fence",
      "minecraft:dark_oak_planks",
      "minecraft:dark_oak_slab",
      "minecraft:dark_oak_stairs",
      "minecraft:dark_oak_trapdoor",
      "minecraft:jungle_door",
      "minecraft:jungle_fence_gate",
      "minecraft:jungle_fence",
      "minecraft:jungle_planks",
      "minecraft:jungle_slab",
      "minecraft:jungle_stairs",
      "minecraft:jungle_trapdoor",
      "minecraft:mangrove_door",
      "minecraft:mangrove_fence_gate",
      "minecraft:mangrove_fence",
      "minecraft:mangrove_planks",
      "minecraft:mangrove_slab",
      "minecraft:mangrove_stairs",
      "minecraft:mangrove_trapdoor",
      "minecraft:oak_door",
      "minecraft:oak_fence_gate",
      "minecraft:oak_fence",
      "minecraft:oak_planks",
      "minecraft:oak_slab",
      "minecraft:oak_stairs",
      "minecraft:oak_trapdoor",
      "minecraft:spruce_door",
      "minecraft:spruce_fence_gate",
      "minecraft:spruce_fence",
      "minecraft:spruce_planks",
      "minecraft:spruce_slab",
      "minecraft:spruce_stairs",
      "minecraft:spruce_trapdoor",
    ],
    "materials_integration:sand_integration": [
      "minecraft:chiseled_red_sandstone",
      "minecraft:chiseled_sandstone",
      "minecraft:cut_red_sandstone_slab",
      "minecraft:cut_red_sandstone",
      "minecraft:cut_sandstone_slab",
      "minecraft:cut_sandstone",
      "minecraft:red_sandstone_slab",
      "minecraft:red_sandstone_stairs",
      "minecraft:red_sandstone_wall",
      "minecraft:red_sandstone",
      "minecraft:sandstone_slab",
      "minecraft:sandstone_stairs",
      "minecraft:sandstone_wall",
      "minecraft:sandstone",
      "minecraft:smooth_red_sandstone_slab",
      "minecraft:smooth_red_sandstone_stairs",
      "minecraft:smooth_red_sandstone",
      "minecraft:smooth_sandstone_slab",
      "minecraft:smooth_sandstone_stairs",
      "minecraft:smooth_sandstone",
    ],
    "materials_integration:stone_integration": [
      "minecraft:andesite_slab",
      "minecraft:andesite_stairs",
      "minecraft:andesite_wall",
      "minecraft:andesite",
      "minecraft:calcite",
      "minecraft:chiseled_deepslate",
      "minecraft:cobbled_deepslate_slab",
      "minecraft:cobbled_deepslate_stairs",
      "minecraft:cobbled_deepslate_wall",
      "minecraft:cobbled_deepslate",
      "minecraft:cobblestone_slab",
      "minecraft:cobblestone_stairs",
      "minecraft:cobblestone_wall",
      "minecraft:cobblestone",
      "minecraft:deepslate_brick_slab",
      "minecraft:deepslate_brick_stairs",
      "minecraft:deepslate_brick_wall",
      "minecraft:deepslate_bricks",
      "minecraft:deepslate_tile_slab",
      "minecraft:deepslate_tile_stairs",
      "minecraft:deepslate_tile_wall",
      "minecraft:deepslate_tiles",
      "minecraft:deepslate",
      "minecraft:diorite_slab",
      "minecraft:diorite_stairs",
      "minecraft:diorite_wall",
      "minecraft:diorite",
      "minecraft:dripstone_block",
      "minecraft:granite_slab",
      "minecraft:granite_stairs",
      "minecraft:granite_wall",
      "minecraft:granite",
      "minecraft:mossy_cobblestone_slab",
      "minecraft:mossy_cobblestone_stairs",
      "minecraft:mossy_cobblestone_wall",
      "minecraft:mossy_cobblestone",
      "minecraft:polished_andesite_slab",
      "minecraft:polished_andesite_stairs",
      "minecraft:polished_andesite",
      "minecraft:polished_deepslate_slab",
      "minecraft:polished_deepslate_stairs",
      "minecraft:polished_deepslate_wall",
      "minecraft:polished_deepslate",
      "minecraft:polished_diorite_slab",
      "minecraft:polished_diorite_stairs",
      "minecraft:polished_diorite",
      "minecraft:polished_granite_slab",
      "minecraft:polished_granite_stairs",
      "minecraft:polished_granite",
      "minecraft:tuff",
    ],
    "materials_integration:rock_integration": [
      "minecraft:chiseled_stone_bricks",
      "minecraft:cracked_stone_bricks",
      "minecraft:mossy_stone_brick_slab",
      "minecraft:mossy_stone_brick_stairs",
      "minecraft:mossy_stone_brick_wall",
      "minecraft:mossy_stone_bricks",
      "minecraft:smooth_stone_slab",
      "minecraft:smooth_stone",
      "minecraft:stone_brick_slab",
      "minecraft:stone_brick_stairs",
      "minecraft:stone_brick_wall",
      "minecraft:stone_bricks",
      "minecraft:stone_slab",
      "minecraft:stone_stairs",
      "minecraft:stone",
    ]
  }

  let modifier = event.addLootTypeModifier(LootType.CHEST)

  for (let [integrationId, items] of Object.entries(integration)) {
    items.forEach(itemId => {
      modifier.replaceLoot(itemId, integrationId, true)
    })
  }
})