// priority: 0

EntityEvents.spawned(event => {
    let entity = event.entity
    if (!entity.type) return
    let type = entity.type
    let eData = entity.persistentData
    // 初始化检查
    if (eData.getBoolean("initialize")) return
    eData.putBoolean("initialize", true)
    // 数据库构建
    let soldierData = eData.getCompound("soldier")
    let rideData = eData.getCompound("ride")
    // 百年战争士兵
    if (type.toString().startsWith("hundred_years_war") && !type.toString().startsWith("hundred_years_war:mounted")) {
        if (entity.tags.contains("snk_minion")) return
        // 移速配平
        entity.setAttributeBaseValue("minecraft:generic.movement_speed", 0.30)

        // 随机分配性别 
        let gender = Math.random() < 0.66 ? "male" : "female"
        soldierData.putString("Gender", gender)
        if (gender === "male") {
            entity.mergeNbt({ Skin: Math.floor(Math.random() * 20) + 1 })
        } else {
            entity.mergeNbt({ Skin: Math.floor(Math.random() * 10) + 21 })
        }
        if (
            type === "hundred_years_war:militia" ||
            type === "hundred_years_war:spear_man"
        ) {
            rideData.putBoolean("replace", true)
            rideData.putString("rideID", "hundred_years_war:mounted_light_lancer_rider")
            let ChargeWeaponData = rideData.getCompound("ChargeWeapon")
            ChargeWeaponData.putBoolean("Count", true)
            ChargeWeaponData.putString("id", "hundred_years_war:iron_pike_charge")
            rideData.put("ChargeWeapon", ChargeWeaponData)
        }
        if (
            type === "hundred_years_war:warrior" ||
            type === "hundred_years_war:shieldman"
        ) {
            rideData.putBoolean("replace", true)
            rideData.putString("rideID", "hundred_years_war:mounted_lancer_rider")
            let ChargeWeaponData = rideData.getCompound("ChargeWeapon")
            ChargeWeaponData.putBoolean("Count", true)
            ChargeWeaponData.putString("id", "hundred_years_war:iron_lance")
            rideData.put("ChargeWeapon", ChargeWeaponData)
        }
        if (
            type === "hundred_years_war:archer" ||
            type === "hundred_years_war:crossbowman"
        ) {
            rideData.putBoolean("replace", true)
            rideData.putString("rideID", "hundred_years_war:mounted_archer_rider")
        }
        if (
            type === "hundred_years_war:handgonne_man" ||
            type === "hundred_years_war:matchlock_man"
        ) {
            rideData.putBoolean("replace", true)
            rideData.putString("rideID", "hundred_years_war:mounted_matchlock_man")
        }
        if (type === "hundred_years_war:priest") {
            rideData.putString("riding", "hundred_years_war:hyw_horse")
            if (gender === "female") {
                entity.mergeNbt({ Skin: Math.floor(Math.random() * 3) + 1 })
            } else {
                entity.mergeNbt({ Skin: Math.floor(Math.random() * 3) + 4 })
            }
        }
    }
    // 警卫村民
    if (type.toString().startsWith("guardvillagers")) {
        // 移速配平
        entity.setAttributeBaseValue("minecraft:generic.movement_speed", 0.62)
        // 设置固定性别和职业
        soldierData.putString("Gender", "male")
        soldierData.putString("Profession", "guard")
        soldierData.putString("ProfessionDisplay", "警卫")
        // 生成随机姓名
        let fullName = generateRandomName("male")
        soldierData.putString("FullName", fullName)
        // 设置显示名称
        let displayName = `[警卫]${fullName}`
        entity.setCustomName(Component.of(displayName))
        // 士兵数据库
        soldierData.putInt("HomePosX", entity.x)
        soldierData.putInt("HomePosY", entity.y)
        soldierData.putInt("HomePosZ", entity.z)
        soldierData.putString("HomePosDim", entity.level.dimension.path)
        soldierData.putInt("Occupation", 2)
        soldierData.putString("Type", "guard")
        rideData.putString("riding", "minecraft:donkey")
        let weaponsSets = [
            [{ id: "born_in_chaos_v1:trident_hayfork", Count: 1 }, { id: "bakery:baguette", Count: 64 }],
            [{ id: "born_in_chaos_v1:wood_splitter_axe", Count: 1 }, { id: "bakery:baguette", Count: 64 }],
            [{ id: "hundred_years_war:iron_pike", Count: 1 }, { id: "bakery:baguette", Count: 1 }],
            [{ id: "metalmith:copper_chakram", Count: 1 }, { id: "metalmith:copper_chakram", Count: 1 }],
            [{ id: "metalmith:copper_spear", Count: 1 }, { id: "bakery:baguette", Count: 1 }],
            [{ id: "metalmith:copper_sword", Count: 1 }, { id: "metalmith:copper_sword", Count: 1 }],
            [{ id: "metalmith:silicon_bronze_chakram", Count: 1 }, { id: "metalmith:silicon_bronze_chakram", Count: 1 }],
            [{ id: "metalmith:silicon_bronze_spear", Count: 1 }, { id: "bakery:baguette", Count: 1 }],
            [{ id: "metalmith:silicon_bronze_sword", Count: 1 }, { id: "metalmith:silicon_bronze_sword", Count: 1 }],
            [{ id: "minecraft:bow", Count: 1 }, { id: "bakery:baguette", Count: 1 }],
            [{ id: "minecraft:crossbow", Count: 1 }, { id: "bakery:baguette", Count: 64 }],
            [{ id: "minecraft:iron_sword", Count: 1 }, { id: "minecraft:iron_sword", Count: 1 }],
            [{ id: "musketmod:blunderbuss", Count: 1 }, { id: "bakery:baguette", Count: 1 }],
            [{ id: "musketmod:musket_with_bayonet", Count: 1 }, { id: "bakery:baguette", Count: 1 }],
            [{ id: "musketmod:musket", Count: 1 }, { id: "bakery:baguette", Count: 1 }],
            [{ id: "musketmod:pistol", Count: 1 }, { id: "bakery:baguette", Count: 1 }],
            [{ id: "simplyswords:iron_chakram", Count: 1 }, { id: "simplyswords:iron_chakram", Count: 1 }],
            [{ id: "simplyswords:iron_spear", Count: 1 }, { id: "bakery:baguette", Count: 1 }],
        ]

        let armorSets = [
            {
                helmet: "minecraft:iron_helmet",
                chestplate: "minecraft:iron_chestplate",
                leggings: "minecraft:iron_leggings",
                boots: "minecraft:iron_boots"
            },
            {
                helmet: "minecraft:chainmail_helmet",
                chestplate: "minecraft:chainmail_chestplate",
                leggings: "minecraft:chainmail_leggings",
                boots: "minecraft:chainmail_boots"
            },
            {
                helmet: "minecraft:leather_helmet",
                chestplate: "minecraft:leather_chestplate",
                leggings: "minecraft:leather_leggings",
                boots: "minecraft:leather_boots"
            },
            {
                helmet: "metalmith:copper_helmet",
                chestplate: "metalmith:copper_chestplate",
                leggings: "metalmith:copper_leggings",
                boots: "metalmith:copper_boots"
            },
            {
                helmet: "metalmith:silicon_bronze_helmet",
                chestplate: "metalmith:silicon_bronze_chestplate",
                leggings: "metalmith:silicon_bronze_leggings",
                boots: "metalmith:silicon_bronze_boots"
            },
            {
                helmet: "immersive_armors:wooden_helmet",
                chestplate: "immersive_armors:wooden_chestplate",
                leggings: "immersive_armors:wooden_leggings",
                boots: "immersive_armors:wooden_boots"
            }
        ]

        // 随机装备分配
        let randomWeapons = weaponsSets[Math.floor(Math.random() * weaponsSets.length)]
        let armorSet = armorSets[Math.floor(Math.random() * armorSets.length)]
        entity.mergeNbt({ HandItems: randomWeapons })
        entity.setHeadArmorItem(Item.of(armorSet.helmet))
        entity.setChestArmorItem(Item.of(armorSet.chestplate))
        entity.setLegsArmorItem(Item.of(armorSet.leggings))
        entity.setFeetArmorItem(Item.of(armorSet.boots))
    }
    // 数据储存
    eData.put("soldier", soldierData)
    eData.put("ride", rideData)
})

// 随机姓名生成函数（仅用于警卫村民）
function generateRandomName(gender) {
    let randomLastName = familyName[Math.floor(Math.random() * familyName.length)]
    let randomFirstName

    if (gender === "male") {
        randomFirstName = maleName[Math.floor(Math.random() * maleName.length)]
    } else {
        randomFirstName = femaleName[Math.floor(Math.random() * femaleName.length)]
    }

    if (familyNameFront) {
        return `${randomLastName}${randomFirstName}`
    } else {
        return `${randomFirstName} ${randomLastName}`
    }
}