// priority: 50

EntityEvents.death(event => {
    let entity = event.entity

    // 检查是否是自然生成的警卫村民
    if (!entity.type.toString().startsWith("guardvillagers")) return
    if (!entity.nbt.getString('forge:spawn_type') === 'STRUCTURE') return
    let sData = entity.persistentData
    let sSoldierData = sData.getCompound("soldier")

    // 检查是否有home坐标数据
    if (!sSoldierData.contains("HomePosX") ||
        !sSoldierData.contains("HomePosY") ||
        !sSoldierData.contains("HomePosZ") ||
        !sSoldierData.contains("HomePosDim")) {
        return
    }

    // 获取home坐标和维度
    let homeX = sSoldierData.getInt("HomePosX")
    let homeY = sSoldierData.getInt("HomePosY")
    let homeZ = sSoldierData.getInt("HomePosZ")
    let homeDim = sSoldierData.getString("HomePosDim")

    // 获取维度
    let level = event.server.getLevel(homeDim)
    if (!level) return

    // 延迟10分钟（12000 tick）后重生
    event.server.scheduleInTicks(12000, () => {

        // 加载区块
        global.ShortLoadChunks(level, homeX, homeZ, 20)

        // 创建新的警卫村民
        let newGuard = level.createEntity("guardvillagers:guard")
        newGuard.setPosition(homeX + 0.5, homeY, homeZ + 0.5)

        // 生成实体
        newGuard.spawn()
    })
})