// priority: 0

//剑士营地      snk_swordsmen_barracks   附属盔甲架：snk_swordsmen_mark
//射手营地      snk_archer_barracks      附属盔甲架：snk_archer_mark
//火枪营地      snk_musketeer_barracks   附属盔甲架：snk_musketeer_mark
//祭司营地      snk_priests_barracks     附属盔甲架：snk_priests_mark
//军械库        snk_arsenal              附属盔甲架：snk_arsenal_mark

FTBQuestsEvents.customReward((event) => {
  Object.keys(ARMOUR).forEach((prefix) => {
    if (event.reward.tags.contains(prefix)) {
      let player = event.player
      let config = ARMOUR[prefix]
      global.posMark(event, (mark, building) => {
        // 检查盔甲架装备栏是否为空
        if (
          !(
            mark.headArmorItem === "minecraft:air" &&
            mark.chestArmorItem === "minecraft:air" &&
            mark.legsArmorItem === "minecraft:air" &&
            mark.feetArmorItem === "minecraft:air"
          )
        ) {
          player.tell("§c盔甲架已有其他盔甲")
          return
        }
        // 构建成本数组
        let costs = [
          { id: config.materialItem, count: config.materialAmount },
          { id: config.costItem, count: config.costAmount },
        ]
        // 扣除物品
        if (!global.ConsumableItems(player, costs)) return

        mark.mergeNbt(`{ArmorItems:[
                    {Count:1b,id:"${config.boots}"},
                    {Count:1b,id:"${config.leggings}"},
                    {Count:1b,id:"${config.chestplate}"},
                    {Count:1b,id:"${config.helmet}"}
                ]}`)
        
        // 使用新的数据库系统获取士兵
        let soldierUuid = mark.persistentData.getString("Resident")
        if (soldierUuid) {
          global.GetGlobalEntity(soldierUuid, player, (soldier, usedForceLoad) => {
            if (soldier) {
              global.weaponUtils.syncEquipment(mark, soldier)
              player.tell("盔甲已购买并同步到士兵")
            } else {
              player.tell("§c无法找到绑定的士兵，盔甲仅放置在盔甲架上")
            }
          })
        } else {
          player.tell("§c该盔甲架未绑定士兵，盔甲仅放置在盔甲架上")
        }
      })
    }
  })
  Object.keys(WEAPON).forEach((prefix) => {
    if (event.reward.tags.contains(prefix)) {
      let player = event.player;
      let config = WEAPON[prefix];
      global.posMark(event, (mark, building) => {
        if (config.mainHandItem) {
          if (mark.mainHandItem.id !== "minecraft:air") {
            player.tell("§c盔甲架已有其他右手装备")
            return
          }
        }
        if (config.offHandItem) {
          if (mark.offHandItem.id !== "minecraft:air") {
            player.tell("§c盔甲架已有其他左手装备")
            return
          }
        }
        // 构建成本数组
        let costs = [
          { id: config.materialItem, count: config.materialAmount },
          { id: config.costItem, count: config.costAmount },
        ]
        // 扣除物品
        if (!global.ConsumableItems(player, costs)) return

        if (config.mainHandItem) {
          mark.setMainHandItem(Item.of(config.mainHandItem))
        }
        if (config.offHandItem) {
          mark.setOffHandItem(Item.of(config.offHandItem))
        }
        
        // 使用新的数据库系统获取士兵
        let soldierUuid = mark.persistentData.getString("Resident")
        if (soldierUuid) {
          global.GetGlobalEntity(soldierUuid, player, (soldier, usedForceLoad) => {
            if (soldier) {
              global.weaponUtils.syncEquipment(mark, soldier)
              player.tell("武器已购买并同步到士兵")
            } else {
              player.tell("§c无法找到绑定的士兵，武器仅放置在盔甲架上")
            }
          })
        } else {
          player.tell("§c该盔甲架未绑定士兵，武器仅放置在盔甲架上")
        }
      })
    }
  })
})