//交易列表
let TRANSACTION_LIST = {
  ////////////基础材料
  goods_log_integration: {
    goodsId: "materials_integration:log_integration",
    goodsAmount: 640,
    costAmount: 160,
    costItem: "minecraft:amethyst_shard",
  },
  goods_stone_integration: {
    goodsId: "materials_integration:stone_integration",
    goodsAmount: 640,
    costAmount: 160,
    costItem: "minecraft:amethyst_shard",
  },
  goods_dirt_integration: {
    goodsId: "materials_integration:dirt_integration",
    goodsAmount: 640,
    costAmount: 80,
    costItem: "minecraft:amethyst_shard",
  },
  goods_sand_integration: {
    goodsId: "materials_integration:sand_integration",
    goodsAmount: 640,
    costAmount: 160,
    costItem: "minecraft:amethyst_shard",
  },

  ////////////洞穴材料
  goods_clay_ball: {
    goodsId: "minecraft:clay_ball",
    goodsAmount: 640,
    costAmount: 240,
    costItem: "minecraft:amethyst_shard",
  },
  goods_moss_block: {
    goodsId: "minecraft:moss_block",
    goodsAmount: 64,
    costAmount: 32,
    costItem: "minecraft:amethyst_shard",
  },
  goods_amethyst_block: {
    goodsId: "minecraft:amethyst_block",
    goodsAmount: 64,
    costAmount: 32,
    costItem: "minecraft:amethyst_shard",
  },
  goods_ochre_froglight: {
    goodsId: "minecraft:ochre_froglight",
    goodsAmount: 16,
    costAmount: 32,
    costItem: "minecraft:amethyst_shard",
  },
  goods_verdant_froglight: {
    goodsId: "minecraft:verdant_froglight",
    goodsAmount: 16,
    costAmount: 32,
    costItem: "minecraft:amethyst_shard",
  },
  goods_pearlescent_froglight: {
    goodsId: "minecraft:pearlescent_froglight",
    goodsAmount: 16,
    costAmount: 32,
    costItem: "minecraft:amethyst_shard",
  },
  goods_big_dripleaf: {
    goodsId: "minecraft:big_dripleaf",
    goodsAmount: 16,
    costAmount: 32,
    costItem: "minecraft:amethyst_shard",
  },
  goods_small_dripleaf: {
    goodsId: "minecraft:small_dripleaf",
    goodsAmount: 16,
    costAmount: 32,
    costItem: "minecraft:amethyst_shard",
  },

  ////////////下界材料
  goods_quartz: {
    goodsId: "minecraft:quartz",
    goodsAmount: 64,
    costAmount: 32,
    costItem: "minecraft:amethyst_shard",
  },
  goods_glowstone_dust: {
    goodsId: "minecraft:glowstone_dust",
    goodsAmount: 64,
    costAmount: 32,
    costItem: "minecraft:amethyst_shard",
  },
  goods_shroomlight: {
    goodsId: "minecraft:shroomlight",
    goodsAmount: 64,
    costAmount: 32,
    costItem: "minecraft:amethyst_shard",
  },
  goods_crimson_stem: {
    goodsId: "minecraft:crimson_stem",
    goodsAmount: 64,
    costAmount: 16,
    costItem: "minecraft:amethyst_shard",
  },
  goods_warped_stem: {
    goodsId: "minecraft:warped_stem",
    goodsAmount: 64,
    costAmount: 16,
    costItem: "minecraft:amethyst_shard",
  },
  goods_netherrack: {
    goodsId: "minecraft:netherrack",
    goodsAmount: 64,
    costAmount: 16,
    costItem: "minecraft:amethyst_shard",
  },
  goods_basalt: {
    goodsId: "minecraft:basalt",
    goodsAmount: 64,
    costAmount: 16,
    costItem: "minecraft:amethyst_shard",
  },
  goods_blackstone: {
    goodsId: "minecraft:blackstone",
    goodsAmount: 64,
    costAmount: 16,
    costItem: "minecraft:amethyst_shard",
  },

  ////////////海洋材料
  goods_prismarine_shard: {
    goodsId: "minecraft:prismarine_shard",
    goodsAmount: 64,
    costAmount: 32,
    costItem: "minecraft:amethyst_shard",
  },
  goods_prismarine_crystals: {
    goodsId: "minecraft:prismarine_crystals",
    goodsAmount: 64,
    costAmount: 32,
    costItem: "minecraft:amethyst_shard",
  },

  ////////////末地材料
  goods_end_stone: {
    goodsId: "minecraft:end_stone",
    goodsAmount: 64,
    costAmount: 32,
    costItem: "minecraft:amethyst_shard",
  },
  goods_chorus_fruit: {
    goodsId: "minecraft:chorus_fruit",
    goodsAmount: 64,
    costAmount: 32,
    costItem: "minecraft:amethyst_shard",
  },

  ////////////其他
  goods_bread: {
    goodsId: "minecraft:bread",
    goodsAmount: 64,
    costAmount: 32,
    costItem: "minecraft:amethyst_shard",
  },
  goods_birch_liquid: {
    goodsId: "snk:birch_liquid",
    goodsAmount: 16,
    costAmount: 16,
    costItem: "minecraft:amethyst_shard",
  },
  goods_chrysanthemum_tea: {
    goodsId: "snk:chrysanthemum_tea",
    goodsAmount: 16,
    costAmount: 16,
    costItem: "minecraft:amethyst_shard",
  },
  goods_dandelion_tea: {
    goodsId: "snk:dandelion_tea",
    goodsAmount: 16,
    costAmount: 16,
    costItem: "minecraft:amethyst_shard",
  },
  goods_name_tag: {
    goodsId: "minecraft:name_tag",
    goodsAmount: 16,
    costAmount: 16,
    costItem: "minecraft:amethyst_shard",
  },

  ////////////备份
  goods_command_staff: {
    goodsId: "hundred_years_war:command_staff",
    goodsAmount: 1,
    costAmount: 24,
    costItem: "minecraft:amethyst_shard",
  },
  goods_crafting_terminal: {
    goodsId: "toms_storage:ts.crafting_terminal",
    goodsAmount: 1,
    costAmount: 24,
    costItem: "minecraft:amethyst_shard",
  },
  goods_warp_stone: {
    goodsId: "waystones:warp_stone",
    goodsAmount: 1,
    goodsNBT: `{Damage:0}`,
    costAmount: 24,
    costItem: "minecraft:amethyst_shard",
  },
  goods_roster: {
    goodsId: "minecraft:writable_book",
    goodsAmount: 1,
    goodsNBT: `{
    display:{
    Name:'{"italic":"false","bold":"true","color":"gold","text":"士兵管理手册"}',
    Lore: [
    '{"text":"左键检查并记录所有士兵信息","italic":"false","color":"white"}',
    '{"text":"可以自动清理士兵的异常","italic":"false","color":"white"}'
    ]},
    roster:1b
    }`,
    costAmount: 24,
    costItem: "minecraft:amethyst_shard",
  },
};

//交易代码
FTBQuestsEvents.customReward((event) => {
  Object.keys(TRANSACTION_LIST).forEach((tag) => {
    if (event.reward.tags.contains(tag)) {
      let player = event.player;
      let config = TRANSACTION_LIST[tag];

      //条件检查（50格半径内存在市民）
      let confirm = false;
      let AABB = player.boundingBox.inflate(50, 30, 50);
      player.level.getEntitiesWithin(AABB).forEach((citizen) => {
        if (confirm) {
          return;
        }
        if (citizen.type === "minecolonies:citizen") {
          confirm = true; //找到任意符合条件的市民后停止寻找节约性能
        }
      });
      if (confirm === false) {
        player.tell("§c仅能在殖民地内使用市场功能");
        return;
      }

      //扣费函数
      if (
        !global.ConsumableItems(player, [
          { id: config.costItem, count: config.costAmount },
        ])
      ) {
        return;
      }

      //给玩家物品
      player.give(Item.of(config.goodsId, config.goodsAmount, config.goodsNBT));
    }
  });
});
