LootJS.modifiers(event => {
  event.addLootTypeModifier(LootType.BLOCK)
    .removeLoot("#snk:ban")
  event.addLootTypeModifier(LootType.CHEST)
    .removeLoot("#snk:ban")
  event.addLootTypeModifier(LootType.ENTITY)
    .removeLoot("#snk:ban")
})

ServerEvents.recipes(event => {
  event.remove({ output: "#snk:ban" })
})

ServerEvents.tags("item", event => {
  event.removeAllTagsFrom("#snk:ban")
})

//另外删除配方
let itemsToRemoveRecipesOnly = [
  //盔甲和装备原配方删除，使用数据包添加新配方替代
  "minecolonies:chainmailchestplate",
  "minecolonies:chainmailhelmet",
  "minecolonies:chainmailleggings",
  "minecolonies:chainmailboots",
  "aquamirae:fin_cutter",
  "aquamirae:divider",
  "aquamirae:whisper_of_the_abyss",
  "aquamirae:maze_rose",
  "aquamirae:abyssal_amethyst",
  "aquamirae:abyssal_boots",
  "aquamirae:abyssal_brigantine",
  "aquamirae:abyssal_heaume",
  "aquamirae:abyssal_leggings",
  "aquamirae:abyssal_tiara",
  "aquamirae:terrible_boots",
  "aquamirae:terrible_chestplate",
  "aquamirae:terrible_helmet",
  "aquamirae:terrible_leggings",
  "born_in_chaos_v1:armor_plate_from_dark_metal_k_2",
  "born_in_chaos_v1:armor_plate_from_dark_metal_k_3",
  "born_in_chaos_v1:armor_plate_from_dark_metal_k_4",
  "born_in_chaos_v1:armor_plate_from_dark_metal_k_5",
  "born_in_chaos_v1:armor_plate_from_dark_metal_k",
  "cataclysm:bulwark_of_the_flame",
  "cataclysm:cursium_upgrade_smithing_template",
  "cataclysm:ignitium_upgrade_smithing_template",
  "cataclysm:laser_gatling",
  "cataclysm:meat_shredder",
  "cataclysm:smithing/cursium_boots",
  "cataclysm:smithing/cursium_chestplate",
  "cataclysm:smithing/cursium_helmet",
  "cataclysm:smithing/cursium_leggings",
  "cataclysm:smithing/ignitium_boots",
  "cataclysm:smithing/ignitium_chestplate",
  "cataclysm:smithing/ignitium_helmet",
  "cataclysm:smithing/ignitium_leggings",
  "cataclysm:soul_render",
  "cataclysm:the_annihilator",
  "cataclysm:the_incinerator",
  "dungeonnowloading:scepter_of_sealed_chaos",
  "dungeonnowloading:soul_silk",
  "dungeonnowloading:spawner_boots",
  "dungeonnowloading:spawner_chestplate",
  "dungeonnowloading:spawner_frame",
  "dungeonnowloading:spawner_helmet",
  "dungeonnowloading:spawner_leggings",
  "immersive_armors:divine_boots",
  "immersive_armors:divine_chestplate",
  "immersive_armors:divine_helmet",
  "immersive_armors:divine_leggings",
  "immersive_armors:heavy_boots",
  "immersive_armors:heavy_chestplate",
  "immersive_armors:heavy_helmet",
  "immersive_armors:heavy_leggings",
  "immersive_armors:prismarine_boots",
  "immersive_armors:prismarine_chestplate",
  "immersive_armors:prismarine_helmet",
  "immersive_armors:prismarine_leggings",
  "immersive_armors:steampunk_boots",
  "immersive_armors:steampunk_chestplate",
  "immersive_armors:steampunk_helmet",
  "immersive_armors:steampunk_leggings",
  "immersive_armors:warrior_boots",
  "immersive_armors:warrior_chestplate",
  "immersive_armors:warrior_helmet",
  "immersive_armors:warrior_leggings",
  "immersive_armors:wither_boots",
  "immersive_armors:wither_chestplate",
  "immersive_armors:wither_helmet",
  "immersive_armors:wither_leggings",
  "l2complements:craft/sculkium_ingot",
  "l2complements:craft/totem_of_undying",
  "l2complements:craft/trident",
  "l2complements:generated_tools/poseidite/craft/poseidite_boots",
  "l2complements:generated_tools/poseidite/craft/poseidite_chestplate",
  "l2complements:generated_tools/poseidite/craft/poseidite_helmet",
  "l2complements:generated_tools/poseidite/craft/poseidite_leggings",
  "l2complements:generated_tools/sculkium/craft/sculkium_boots",
  "l2complements:generated_tools/sculkium/craft/sculkium_chestplate",
  "l2complements:generated_tools/sculkium/craft/sculkium_helmet",
  "l2complements:generated_tools/sculkium/craft/sculkium_leggings",

  "constructionwand:diamond_wand",
  "constructionwand:infinity_wand",
  "constructionwand:iron_wand",
  "constructionwand:stone_wand",
  "farm_and_charm:mincer/minced_beef",
  "farm_and_charm:mincer/lamb_ham",
  "farm_and_charm:mincer/chicken_parts",
  "farm_and_charm:mincer/bacon",
  "quark:oddtiies/crafting/backpack",
  "alexscaves_torpedoes:brazier_recipe",
  "alexscaves:gunpowder_from_sulfur",
  "arcanelanterns:lantern_maker",
  "born_in_chaos_v1:fused_bone_k",
  "born_in_chaos_v1:infernal_evil_pumpkin_k_2",
  "born_in_chaos_v1:infernal_evil_pumpkink",
  "born_in_chaos_v1:phantom_powder_k",
  "bosses_of_mass_destruction:levitation_block",
  "call_of_yucutan:elder_bone_meal",
  "call_of_yucutan:xocolatl",
  "cataclysm:mechanical_fusion_anvil",
  "farm_and_charm:stove/improved_bread",
  "illagerinvasion:hallowed_gem",
  "l2complements:enchantments/cubic_digging",
  "l2complements:enchantments/cubic_eater",
  "l2complements:enchantments/cursed_blade",
  "l2complements:enchantments/dampened",
  "l2complements:enchantments/durable_armor_1",
  "l2complements:enchantments/durable_armor_2",
  "l2complements:enchantments/durable_armor_3",
  "l2complements:enchantments/ender_mask",
  "l2complements:enchantments/ender_reach",
  "l2complements:enchantments/environment_reject",
  "l2complements:enchantments/eternal",
  "l2complements:enchantments/explosion_reject",
  "l2complements:enchantments/fire_reject",
  "l2complements:enchantments/hardened",
  "l2complements:enchantments/ice_blade",
  "l2complements:enchantments/ice_thorn",
  "l2complements:enchantments/invincible",
  "l2complements:enchantments/life_mending",
  "l2complements:enchantments/life_sync",
  "l2complements:enchantments/magic_reject",
  "l2complements:enchantments/owner_protection",
  "l2complements:enchantments/plane_digging",
  "l2complements:enchantments/plane_eater",
  "l2complements:enchantments/projectile_reject",
  "l2complements:enchantments/safeguard",
  "l2complements:enchantments/sharp_blade",
  "l2complements:enchantments/shinny",
  "l2complements:enchantments/shulker_armor",
  "l2complements:enchantments/smelt",
  "l2complements:enchantments/snow_walker",
  "l2complements:enchantments/soul_bound",
  "l2complements:enchantments/soul_flame_blade",
  "l2complements:enchantments/soul_flame_thorn",
  "l2complements:enchantments/stable_body",
  "l2complements:enchantments/tree_chopping",
  "l2complements:enchantments/vien_mining",
  "l2complements:enchantments/void_touch",
  "l2complements:enchantments/wind_sweep",
  "minecraft:bread",
  "musketmod:blunderbuss",
  "musketmod:cartridge",
  "musketmod:musket",
  "musketmod:pistol",
  "quark:tweaks/crafting/utility/bent/bread",
  "quark:tweaks/crafting/utility/bent/cookie",
  "twilightforest:uncrafting_table",
  "untitledduckmod:crafting_shaped/duck_cake",
  "untitledduckmod:crafting_shaped/goose_cake",
  "untitledduckmod:crafting_shaped/pumpkin_pie",
];

//删除指定MOD的所有物品配方
let modsToRemoveRecipes = [
  'bagofholding',
  'bountiful',
  'hundred_years_war',
  'sellingbin',
  'shieldexp',
  'toms_storage',
  'waystones',
  'wishing_fountain',
  'yyzsbackpack',
]

function removeRecipes(serverEvent) {

  itemsToRemoveRecipesOnly.forEach(id => {
    serverEvent.remove({ id: id });
  })

  modsToRemoveRecipes.forEach(mod => {
    serverEvent.remove({ mod: mod });
  })
}

ServerEvents.recipes(removeRecipes);