// 检查位置函数
global.isValidPosition = function (level, x, y, z, requireGround) {
    // 检查当前位置是否安全
    let blockHere = level.getBlock(x, y, z)
    let blockBelow = level.getBlock(x, y - 1, z)
    let blockAbove = level.getBlock(x, y + 1, z)
    // 检查条件
    let isAirBlock = id => [
        "minecraft:air",
        "minecraft:cave_air",
        "minecraft:void_air"
    ].includes(id)
    let isUnsafeBelow = id => [
        "minecraft:lava",
        "minecraft:flowing_lava",
        "minecraft:cobweb",
        "minecraft:pointed_dripstone"
    ].includes(id)
    // 地面要求的安全条件
    if (requireGround) {
        return isAirBlock(blockHere.id) &&
            isAirBlock(blockAbove.id) &&
            !isAirBlock(blockBelow.id) &&
            !isUnsafeBelow(blockBelow.id)
    }
    // 空中要求的安全条件
    return isAirBlock(blockHere.id) && isAirBlock(blockAbove.id)
}

// 检查位置是否可通行
global.isPassablePosition = function (level, x, y, z) {
    let block = level.getBlock(x, y, z)
    let blockId = block.id
    
    // 只检查是否为空气方块
    return [
        "minecraft:air",
        "minecraft:cave_air",
        "minecraft:void_air"
    ].includes(blockId)
}