//剑士营地      snk_swordsmen_barracks   附属盔甲架：snk_swordsmen_mark
//射手营地      snk_archer_barracks      附属盔甲架：snk_archer_mark
//火枪营地      snk_musketeer_barracks   附属盔甲架：snk_musketeer_mark
//祭司营地      snk_priests_barracks     附属盔甲架：snk_priests_mark
//军械库        snk_arsenal              附属盔甲架：snk_arsenal_mark

// 函数：通用定位盔甲架函数
// 使用例：global.posMark(event, (mark, building) => {})
global.posMark = function (event, callback) {
    let player = event.player
    let check = false
    let AABB = player.boundingBox.expandTowards(6, 1, 6).expandTowards(-6, -4, -6)
    player.level.getEntitiesWithin(AABB).forEach(building => {
        let bData = building.persistentData
        // 检查建筑类型
        if (!(
            building.tags.contains('snk_swordsmen_barracks') ||
            building.tags.contains('snk_archer_barracks') ||
            building.tags.contains('snk_musketeer_barracks') ||
            building.tags.contains('snk_priests_barracks') ||
            building.tags.contains('snk_arsenal')
        )) return
        // 检查所属
        if (building.persistentData.getString("pUuid") != player.uuid.toString()) return
        check = true
        let xzExtend = bData.contains("xzExtend") ? bData.getInt("xzExtend") : 8
        let upExtend = bData.contains("upExtend") ? bData.getInt("upExtend") : 8
        let downExtend = bData.contains("downExtend") ? bData.getInt("downExtend") : 1
        let bAABB = building.boundingBox.expandTowards(xzExtend, upExtend, xzExtend).expandTowards(-xzExtend, -downExtend, -xzExtend)
        building.level.getEntitiesWithin(bAABB).forEach(mark => {
            if (building.tags.contains('snk_swordsmen_barracks') && mark.tags.contains('snk_swordsmen_mark')) {
                if (callback) callback(mark, building)
                return
            }
            if (building.tags.contains('snk_archer_barracks') && mark.tags.contains('snk_archer_mark')) {
                if (callback) callback(mark, building)
                return
            }
            if (building.tags.contains('snk_musketeer_barracks') && mark.tags.contains('snk_musketeer_mark')) {
                if (callback) callback(mark, building)
                return
            }
            if (building.tags.contains('snk_priests_barracks') && mark.tags.contains('snk_priests_mark')) {
                if (callback) callback(mark, building)
                return
            }
            if (building.tags.contains('snk_arsenal') && mark.tags.contains('snk_arsenal_mark')) {
                if (callback) callback(mark, building)
                return
            }
        })
    })
    if (!check) player.tell(`§c未能找到可互动建筑`)
}