//检测玩家物品数量并扣除
//调用方法（附带检查，不满足数量时反馈信息并停止后续代码）
//if (!global.ConsumableItems(player, [
//    { id: itemID1, count: count1 },
//    { id: itemID2, count: count2 },
//    ])
//    ) return;
global.ConsumableItems = function (player, costs) {
  for (let cost of costs) {
    let item = Item.of(cost.id);
    let count = cost.count;
    let itemName = item.displayName.getString();
    if (player.inventory.count(item) < count) {
      player.tell(`§c费用不足，需要 ${count} 个${itemName}！`);
      return false;
    }
  }
  for (let cost of costs) {
    let item = Item.of(cost.id);
    let count = cost.count;
    let itemName = item.displayName.getString();
    while (count > 0) {
      let slot = player.inventory.find(item);
      let stack = player.inventory.getItem(slot);
      let deductAmount = Math.min(stack.count, count);
      stack.shrink(deductAmount);
      count -= deductAmount;
      player.tell(`§a已扣除 ${deductAmount} 个${itemName}`);
    }
  }
  return true;
};

//仅计算数量不扣除
global.CountConsumableItems = function (player, costs) {
  for (let cost of costs) {
    let item = Item.of(cost.id);
    let count = cost.count;
    let itemName = item.displayName.getString();
    if (player.inventory.count(item) < count) {
      player.tell(`§c费用不足，需要 ${count} 个${itemName}！`);
      return false;
    }
  }
  return true;
};
