// priority: 999999

// 使用票证系统短暂加载区块
global.ShortLoadChunks = function (level, centerX, centerZ, durationTicks) {
    // 导入必要的Java类
    let ChunkPos = Java.loadClass('net.minecraft.world.level.ChunkPos')
    let TicketType = Java.loadClass('net.minecraft.server.level.TicketType')
    // 创建区块位置
    let chunkPos = new ChunkPos(Math.floor(centerX / 16), Math.floor(centerZ / 16))
    // 添加区域票证
    level.getChunkSource().addRegionTicket(TicketType.PLAYER, chunkPos, 1, chunkPos)
    // 如果指定了持续时间，则在时间到后自动移除票证
    if (durationTicks > 0) {
        Utils.server.scheduleInTicks(durationTicks, () => {
            global.unloadChunks(level, centerX, centerZ)
        })
    }
    return {
        level: level,
        chunkPos: chunkPos
    }
}

// 依据坐标卸载区块票证
global.unloadChunks = function (level, centerX, centerZ) {
    let ChunkPos = Java.loadClass('net.minecraft.world.level.ChunkPos')
    let TicketType = Java.loadClass('net.minecraft.server.level.TicketType')
    let chunkPos = new ChunkPos(Math.floor(centerX / 16), Math.floor(centerZ / 16))
    level.getChunkSource().removeRegionTicket(TicketType.PLAYER, chunkPos, 1, chunkPos)
}

// 增强的实体获取函数，使用票证系统获取未加载区域的士兵
global.GetGlobalEntity = function (soldierUuid, player, callback) {
    // 首先尝试从玩家数据库获取坐标信息
    let server = player.server
    let pData = player.persistentData
    let pSoldierData = pData.getCompound("soldier")
    let soldierData = pSoldierData.getCompound(soldierUuid)
    // 首先尝试从当前维度获取实体
    let soldier = player.level.getEntity(soldierUuid)
    if (soldier) {
        callback(soldier, false) // false表示未使用强加载
        return
    }
    // 检查是否有传送坐标记录
    if (soldierData.contains("TPPosX") && soldierData.contains("TPPosZ") && soldierData.contains("TPPosDim")) {
        let x = soldierData.getInt("TPPosX")
        let z = soldierData.getInt("TPPosZ")
        let dimension = soldierData.getString("TPPosDim")
        let level = server.getLevel(dimension)
        // 如果正常获取失败，使用票证系统加载区块
        global.ShortLoadChunks(level, x, z, 40)
        // 延迟后尝试获取实体
        server.scheduleInTicks(20, () => {
            let loadedSoldier = level.getEntity(soldierUuid)
            if (loadedSoldier) {
                callback(loadedSoldier, true) // true表示使用了票证加载
                return
            } else {
                // 最后，尝试在所有已加载维度中查找
                let found = false
                server.getAllLevels().forEach(level => {
                    if (found) return
                    let loadedSoldier = level.getEntity(soldierUuid)
                    if (loadedSoldier) {
                        callback(loadedSoldier, true)
                        found = true
                    }
                })
                if (!found) {
                    callback(null, true)
                }
            }
        })
    } else {
        // 没有记录，直接在所有维度中尝试找到实体
        let found = false
        server.getAllLevels().forEach(level => {
            if (found) return
            let soldier = level.getEntity(soldierUuid)
            if (soldier) {
                callback(soldier, false)
                found = true
            }
        })
        if (!found) {
            callback(null, false)
        }
    }
}