// 翻译各种MOD生物行为，纳入统一指挥体系
// 公用数值改变时同步到MOD原版数值
// 主动使用

// humancompanions行为翻译（nbt数据）
// Owner = 主人UUID
// Alert = 是否攻击敌对生物
// Sitting = 是否可以移动
// Following = 是否跟随
// Guarding = 是否警戒（在驻守坐标站着不动）
// Hunting = 是否可以狩猎动物
// Eating = 是否正在进食
// Patrolling = 是否巡逻（在驻守坐标小范围游荡）
// patrol_pos[x，y，z] = 驻守坐标
// Stationery = 远程单位是否站着不动射击
// XpLevel = 等级
// XpTotal = 经验值

// hundred_years_war行为翻译（nbt数据）
// OwnerUUID = 主人UUID
// HomePosX = 驻守坐标X值
// HomePosY = 驻守坐标Y值
// HomePosZ = 驻守坐标Z值
// FollowTargetUUID = 跟随目标的UUID
// 停止跟随命令 `hundred_years_war stop_follow ${eUuid}`
// 跟随命令`hundred_years_war follow ${eUuid} ${pName}`

// guardvillagers:guard行为翻译（nbt数据）
// Owner = 主人UUID
// PatrolPosX = 驻守坐标X值
// PatrolPosY = 驻守坐标Y值
// PatrolPosZ = 驻守坐标Z值
// Following = 是否跟随
// Patrolling = 是否巡逻（在驻守坐标站着不动）
// ShieldCooldown = 使用盾牌冷却时间
// KickCooldown = 踢击冷却时间

// 转译设定
// command
// PosX,PosY,PosZ = 驻守坐标
// Behavior = 0:游荡（在驻守坐标小范围游荡）
// Behavior = 1:警戒（在驻守坐标站着不动）
// Behavior = 2:跟随
// Hostility = 0 不能对中立单位造成伤害
// Hostility = 1 可以对中立单位造成伤害
// Hostility = 2 团队内部分职业会主动猎杀动物
// team = 是否在团队内
// teamID = 原版团队名称，用于同步MC原版团队

global.BehaviorTranslation = function (entity, player) {
    let type = entity.type
    let eData = entity.persistentData
    let commandData = eData.getCompound("command")
    // 翻译人类同伴
    if (type.toString().startsWith("humancompanions")) {
        if (commandData.getInt("Behavior") === 0) {
            entity.mergeNbt({
                Following: 0,
                Guarding: 0,
                Patrolling: 1
            })
        }
        if (commandData.getInt("Behavior") === 1) {
            entity.mergeNbt({
                Following: 0,
                Guarding: 1,
                Patrolling: 0,
                patrol_pos: [
                    commandData.getInt("PosX"),
                    commandData.getInt("PosY"),
                    commandData.getInt("PosZ")
                ]
            })
        }
        if (commandData.getInt("Behavior") === 2) {
            entity.mergeNbt({
                Following: 1,
                Guarding: 0,
                Patrolling: 0
            })
        }
        if (commandData.getInt("Hostility") === 2) {
            entity.mergeNbt({ Hunting: 1 })
        }
    }
    // 翻译警卫村民
    if (type.toString().startsWith("guardvillagers")) {
        if (commandData.getInt("Behavior") === 0) {
            entity.mergeNbt({
                Following: 0,
                Patrolling: 0
            })
            entity.setAttributeBaseValue("minecraft:generic.movement_speed", 0.38)
        }
        if (commandData.getInt("Behavior") === 1) {
            // 警卫村民接受多个驻守坐标时AI会堆栈处理，通过瞬间给个跟随取消坐标堆栈
            entity.mergeNbt({
                Following: 1,
                Patrolling: 0,
            })
            entity.server.scheduleInTicks(1, () => {
                entity.mergeNbt({
                    Following: 0,
                    Patrolling: 1,
                    PatrolPosX: commandData.getInt("PosX"),
                    PatrolPosY: commandData.getInt("PosY"),
                    PatrolPosZ: commandData.getInt("PosZ")
                })
            })
            entity.setAttributeBaseValue("minecraft:generic.movement_speed", 0.60)
        }
        if (commandData.getInt("Behavior") === 2) {
            entity.mergeNbt({
                Following: 1,
                Patrolling: 0
            })
            entity.setAttributeBaseValue("minecraft:generic.movement_speed", 0.42)
        }
    }
    // 翻译百年战争士兵
    if (type.toString().startsWith("hundred_years_war")) {
        let server = entity.server
        let eUuid = entity.uuid.toString()
        let pName = player.name.string
        if (commandData.getInt("Behavior") === 0) {
            // 百年战争士兵没有游荡行为
            server.runCommandSilent(`hundred_years_war stop_follow ${eUuid}`)
            entity.mergeNbt({
                HomePosX: commandData.getInt("PosX"),
                HomePosY: commandData.getInt("PosY"),
                HomePosZ: commandData.getInt("PosZ")
            })
            entity.setAttributeBaseValue("minecraft:generic.movement_speed", 0.30)
        }
        if (commandData.getInt("Behavior") === 1) {
            server.runCommandSilent(`hundred_years_war stop_follow ${eUuid}`)
            entity.mergeNbt({
                HomePosX: commandData.getInt("PosX"),
                HomePosY: commandData.getInt("PosY"),
                HomePosZ: commandData.getInt("PosZ")
            })
            entity.setAttributeBaseValue("minecraft:generic.movement_speed", 0.30)
        }
        if (commandData.getInt("Behavior") === 2) {
            server.runCommandSilent(`hundred_years_war follow ${eUuid} ${pName}`)
        }
        entity.setAttributeBaseValue("minecraft:generic.movement_speed", 0.37)
    }
}