//团队识别以及其他生成事件
EntityEvents.spawned(event => {
    let entity = event.entity
    let eUuid = entity.uuid.toString()
    let type = entity.type
    //将事件生成的生物加入敌对阵营（袭击，入侵事件）
    if (entity.nbt.getString('forge:spawn_type') === 'EVENT') {
        entity.server.scheduleInTicks(5, () => {
            event.server.runCommandSilent(`execute as ${eUuid} run team join hostile @s`)
        })
    }
    if (
        type === 'minecraft:pillager'
    ) {
        if (entity.tags.contains("snk_arms")) return
        entity.addTag("snk_arms")
        let spawnWeapons = [
            'minecraft:crossbow',
            'musketmod:pistol',
            'musketmod:blunderbuss',
            'musketmod:musket'
        ]
        let randomWeapons = spawnWeapons[Math.floor(Math.random() * spawnWeapons.length)]
        entity.mergeNbt({ HandItems: [{ id: randomWeapons, Count: 1 }] })
    }
    if (
        type === 'minecraft:vindicator' ||
        type === 'takesapillage:skirmisher' ||
        type === 'illagerinvasion:basher'
    ) {
        if (entity.tags.contains("snk_arms")) return
        entity.addTag("snk_arms")
        let spawnWeapons = [
            'born_in_chaos_v1:wood_splitter_axe',
            'cataclysm:black_steel_axe',
            'metalmith:copper_axe',
            'metalmith:copper_greataxe',
            'minecraft:iron_axe',
            'minecraft:stone_axe',
            'simplyswords:iron_greataxe',
            'sticknstone:stone_greataxe',
        ]
        let randomWeapons = spawnWeapons[Math.floor(Math.random() * spawnWeapons.length)]
        entity.mergeNbt({ HandItems: [{ id: randomWeapons, Count: 1 }] })
    }
    if (
        type === 'illagerinvasion:provoker' ||
        type === 'minecraft:illusioner'
    ) {
        if (entity.tags.contains("snk_arms")) return
        entity.addTag("snk_arms")
        entity.mergeNbt({ HandItems: [{ id: 'minecraft:bow', Count: 1 }] })
    }
    if (
        type === 'illagerinvasion:marauder'
    ) {
        if (entity.tags.contains("snk_arms")) return
        entity.addTag("snk_arms")
        entity.mergeNbt({ HandItems: [{ id: 'illagerinvasion:platinum_infused_hatchet', Count: 1 }] })
    }
    if (
        type === 'takesapillage:legioner' ||
        type === 'illagerinvasion:inquisitor'
    ) {
        if (entity.tags.contains("snk_arms")) return
        entity.addTag("snk_arms")
        let spawnWeapons = [
            'aquamirae:fin_cutter',
            'cataclysm:black_steel_sword',
            'minecraft:iron_sword',
            'simplyswords:iron_cutlass',
            'simplyswords:iron_longsword'
        ]
        let spawnShield = [
            'cataclysm:black_steel_targe',
            'endermanoverhaul:corrupted_shield',
            'minecraft:shield',
            'shieldexex:iron_shield',
            'shieldexex:iron_tower_shield',
            'shieldexex:stone_shield',
            'shieldexex:stone_tower_shield'
        ]
        let randomWeapons = spawnWeapons[Math.floor(Math.random() * spawnWeapons.length)]
        let randomShield = spawnShield[Math.floor(Math.random() * spawnShield.length)]
        entity.mergeNbt({ HandItems: [{ id: randomWeapons, Count: 1 }, { id: randomShield, Count: 1 }] })
    }
    //市民和访客加入对应玩家队伍
    if (type === 'minecolonies:citizen' || type === 'minecolonies:visitor') {
        entity.server.scheduleInTicks(100, () => {
            let confirm = false
            if (type === 'minecolonies:citizen') {
                //优先检测附近市民团队信息
                let AABB = entity.boundingBox.inflate(50, 30, 50)
                entity.level.getEntitiesWithin(AABB).forEach(citizen => {
                    if (confirm) return
                    if ((citizen.type === 'minecolonies:citizen') && citizen.persistentData.contains("pUuid")) {
                        event.server.runCommandSilent(`execute as ${eUuid} run team join ${citizen.persistentData.getString(`team`)} @s`)
                        entity.persistentData.putString("pUuid", citizen.persistentData.getString("pUuid"))
                        entity.persistentData.putString(`team`, `${citizen.persistentData.getString(`team`)}`)
                        confirm = true
                        return
                    }
                })
                if (confirm) return
                //其次检测对应玩家
                entity.level.getPlayers().forEach(player => {
                    if (confirm) return
                    if (player.uuid.toString() === entity.nbt.ForgeData.owner) {
                        let team = player.team.name
                        event.server.runCommandSilent(`execute as ${eUuid} run team join ${team} @s`)
                        entity.persistentData.putString("pUuid", entity.nbt.ForgeData.owner)
                        entity.persistentData.putString(`team`, `${team}`)
                        confirm = true
                        return
                    }
                })
            }
            if (type === 'minecolonies:visitor') {
                let AABB = entity.boundingBox.inflate(50, 30, 50)
                entity.level.getEntitiesWithin(AABB).forEach(citizen => {
                    if (confirm) return
                    if ((citizen.type === 'minecolonies:citizen') && citizen.persistentData.contains("pUuid")) {
                        event.server.runCommandSilent(`execute as ${eUuid} run team join ${citizen.persistentData.getString(`team`)} @s`)
                        entity.persistentData.putString("pUuid", citizen.persistentData.getString("pUuid"))
                        entity.persistentData.putString(`team`, `${citizen.persistentData.getString(`team`)}`)
                        confirm = true
                        return
                    }
                })
            }
            //如果没有找到对应玩家则加入白队
            if (!confirm) {
                entity.server.runCommandSilent(`execute as ${eUuid} run team join white @s`)
            }
        })
    }
    //阻止在市民附近生成
    if (
        type === 'born_in_chaos_v1:nightmare_stalker' ||
        type === 'cataclysm:amethyst_crab' ||
        type === 'mowziesmobs:naga' ||
        type === 'mowziesmobs:umvuthana_follower_raptor' ||
        type === 'mowziesmobs:umvuthana_raptor'
    ) {
        let AABB = entity.boundingBox.inflate(120, 30, 120)
        entity.level.getEntitiesWithin(AABB).forEach(citizen => {
            if (citizen.type === 'minecolonies:citizen' || citizen.type === 'minecolonies:visitor') {
                event.cancel()
                return
            }
        })
    }
    //阻止在市民附近和玩家附近生成
    if ((type === 'minecraft:pillager' ||
        type === 'minecraft:vindicator'
    ) && entity.nbt.getString("forge:spawn_type") === "NATURAL") {
        let AABB = entity.boundingBox.inflate(60, 20, 60)
        entity.level.getEntitiesWithin(AABB).forEach(citizen => {
            if (citizen.type === 'minecolonies:citizen' || citizen.type === 'minecolonies:visitor' || citizen.type === 'minecraft:player') {
                event.cancel()
                return
            }
        })
    }
    //阻止错误猪生成
    if (type === 'minecraft:pig' && entity.nbt.getString("forge:spawn_type") === "NATURAL") {
        event.cancel()
        return
    }
    //阻止末影龙附近生成自然生成的末影人
    if ((type === 'minecraft:enderman' || type === 'endermanoverhaul:end_enderman') && entity.nbt.getString("forge:spawn_type") === "NATURAL") {
        let AABB = entity.boundingBox.inflate(180, 90, 180)
        entity.level.getEntitiesWithin(AABB).forEach(citizen => {
            if (citizen.type === 'minecraft:ender_dragon') {
                event.cancel()
                return
            }
        })
    }
    //撼地撕拉生成时提示年龄已锁死
    if (type === 'alexscaves:tremorzilla') {
        let player = global.atP(entity)
        player.tell(`§c提示：震地撕拉的年龄已被锁死`)
    }
    //玩家搭建的效用生物加入玩家队伍
    if (entity.nbt.PlayerCreated === "1") {
        let player = global.atP(entity)
        let team = player.team.name
        let eUuid = entity.uuid.toString()
        entity.persistentData.putString("pUuid", player.uuid.toString())
        player.server.scheduleInTicks(5, () => {
            player.server.runCommandSilent(`execute as ${eUuid} run team join ${team} @s`)
        })
    }
})