EntityEvents.hurt(event => {
  if (!event.entity) return
  let entity = event.entity
  if (!event.source.actual) return
  let attacker = event.source.actual
  // 同队伍取消互相伤害
  if (attacker.team && entity.team) {
    if (entity.team === attacker.team) {
      event.cancel()
    }
  }
  let teamTypes = [
    "white",
    "red",
    "yellow",
    "blue",
    "green"
  ]
  // 白名单内的生物取消互相伤害
  if (immuneEntityTypes.includes(attacker.type.toString()) && immuneEntityTypes.includes(entity.type.toString())) {
    event.cancel()
  }
  // 禁止玩家团队生物伤害白名单内无队伍状态的生物
  if (immuneEntityTypes.includes(entity.type.toString()) && !entity.team && teamTypes.includes(attacker.teamId)) {
    event.cancel()
  }
  // 反之也禁止
  if (immuneEntityTypes.includes(attacker.type.toString()) && !attacker.team && teamTypes.includes(entity.teamId)) {
    event.cancel()
  }
})

let ProjectileImpactEvent = Java.loadClass("net.minecraftforge.event.entity.ProjectileImpactEvent")
let EntityHitResult = Java.loadClass("net.minecraft.world.phys.EntityHitResult")

NativeEvents.onEvent(ProjectileImpactEvent, event => {
  let rayTraceResult = event.getRayTraceResult()

  if (!(rayTraceResult instanceof EntityHitResult)) return

  let hitEntity = rayTraceResult.getEntity()

  if (hitEntity.type === "minecraft:armor_stand") {
    event.setCanceled(true)
  }
})