// priority: 10

// 随从生物召唤函数
function SummonedCreature(event, summoner, config) {
    // 自动生成冷却标签
    let healthKey = config.healthThreshold || (config.spawned ? "spawned" : "default")
    let entityTypeForTag = config.entityType.replace(/:/g, '_')
    let cooldownTag = `${healthKey}_${entityTypeForTag}`
    // 检查冷却
    if (summoner.tags.contains(cooldownTag)) return
    // 检查是否在召唤时触发
    if (!config.spawned) {
        // 计算当前血量百分比
        let currentHealthPercent = summoner.health / summoner.maxHealth
        // 检查是否达到触发血量
        if (currentHealthPercent > config.healthThreshold) return
    }
    // 标记冷却
    summoner.addTag(cooldownTag)
    // 获取召唤师位置和世界
    let bossX = summoner.x
    let bossY = summoner.y
    let bossZ = summoner.z
    let level = summoner.level
    // 添加最小范围参数（默认为0）
    let minRadius = config.minRadius || 0
    // 确保最小范围不超过最大范围
    if (minRadius > config.radius) { minRadius = config.radius }
    // 召唤随从生物
    for (let i = 0; i < config.count; i++) {
        // 在方形范围内随机生成位置（考虑最小范围）
        let offsetX, offsetZ
        do {
            // 生成随机偏移量
            offsetX = (Math.random() - 0.5) * 2 * config.radius
            offsetZ = (Math.random() - 0.5) * 2 * config.radius
            // 确保位置在最小范围之外
        } while (Math.abs(offsetX) < minRadius && Math.abs(offsetZ) < minRadius)
        let spawnX = bossX + offsetX
        let spawnZ = bossZ + offsetZ
        let spawnY = bossY
        // 在垂直方向搜索安全位置（从Boss高度向下搜索到-15，然后向上搜索到+10）
        let foundPosition = false
        // 先向下搜索（0到-15）
        for (let yOffset = 0; yOffset >= -15; yOffset--) {
            let testY = Math.round(bossY) + yOffset
            if (isValidPosition(level, spawnX, testY, spawnZ, config.requireGround)) {
                spawnY = testY
                foundPosition = true
                break
            }
        }
        // 如果没找到，向上搜索（1到10）
        if (!foundPosition) {
            for (let yOffset = 1; yOffset <= 10; yOffset++) {
                let testY = Math.round(bossY) + yOffset
                if (isValidPosition(level, spawnX, testY, spawnZ, config.requireGround)) {
                    spawnY = testY
                    foundPosition = true
                    break
                }
            }
        }
        // 创建随从生物实体
        let minion = level.createEntity(config.entityType)
        // 若不需要地面，则提升Y轴
        if (!config.requireGround) {
            spawnY += 4
        }
        minion.setPosition(spawnX, spawnY, spawnZ)
        // 设置随从生物属性
        if (config.maxHealth) {
            minion.setMaxHealth(config.maxHealth)
            minion.setHealth(99999)
        }
        if (config.name) minion.mergeNbt(`{CustomName:"{\\"text\\":\\"${config.name}\\"}"}`)
        if (config.nbt) minion.mergeNbt(config.nbt)
        // 生成随从生物
        minion.addTag("snk_minion")
        minion.spawn()
        minion.server.scheduleInTicks(1, () => {
            let mUuid = minion.uuid.toString()
            // 召唤特效
            //minion.server.runCommandSilent(`execute at ${mUuid} run particle minecraft:sculk_soul ~ ~1 ~ 0.5 0.5 0.5 0.01 5 normal`)
            //命令方法太卡了先去掉
            // 和boss同队伍
            minion.server.runCommandSilent(`execute as ${mUuid} run team join hostile @s`)
            // 通用敌对
            minion.server.runCommandSilent(`execute as ${mUuid} at @s run damage @s 0 minecraft:generic by @p from @p`)
            minion.server.scheduleInTicks(1, () => {
                minion.server.runCommandSilent(`execute as ${mUuid} at @s run damage @s 0 minecraft:generic by @p from @p`)
                minion.server.scheduleInTicks(1, () => {
                    minion.server.runCommandSilent(`execute as ${mUuid} at @s run damage @s 0 minecraft:generic by @p from @p`)
                })
            })
        })
    }
}
// 检查位置函数
function isValidPosition(level, x, y, z, requireGround) {
    // 检查当前位置是否安全
    let blockHere = level.getBlock(x, y, z)
    let blockBelow = level.getBlock(x, y - 1, z)
    let blockAbove = level.getBlock(x, y + 1, z)
    // 检查条件
    let isAirBlock = id => [
        "minecraft:air",
        "minecraft:cave_air",
        "minecraft:void_air"
    ].includes(id)
    let isUnsafeBelow = id => [
        "minecraft:lava",
        "minecraft:flowing_lava",
        "minecraft:cobweb",
        "minecraft:pointed_dripstone"
    ].includes(id)
    // 地面要求的安全条件
    if (requireGround) {
        return isAirBlock(blockHere.id) &&
            isAirBlock(blockAbove.id) &&
            !isAirBlock(blockBelow.id) &&
            !isUnsafeBelow(blockBelow.id)
    }
    // 空中要求的安全条件
    return isAirBlock(blockHere.id) && isAirBlock(blockAbove.id)
}
// 召唤师死亡事件处理
EntityEvents.death(event => {
    let boss = event.entity
    // 检查是否是标记的召唤师
    if (!boss.tags.contains('snk_summoner')) return
    // 清除召唤物
    boss.server.runCommandSilent(`execute at ${boss.uuid.toString()} run kill @e[tag=snk_minion, distance=..100]`)
})
//  球形挖掘函数
function sphericalExcavation(entity, dy) {
    let level = entity.level.dimension.path
    let x = entity.block.x
    let y = entity.block.y
    let z = entity.block.z
    if (!dy) { dy = 0 }
    entity.server.runCommandSilent(`execute in ${level} run place template snk:spherical_excavation ${x - 5} ${y + dy} ${z - 5}`);
}
//////////末影龙//////////
EntityEvents.spawned("minecraft:ender_dragon", event => {
    let HP = 3250
    let boss = event.entity
    boss.persistentData.putInt("coercion", 3)
    boss.addTag("snk_summoner")
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
})
EntityEvents.hurt("minecraft:ender_dragon", event => {
    let boss = event.entity
    SummonedCreature(event, boss, {
        healthThreshold: 0.9,
        requireGround: false,
        entityType: "minecraft:phantom",
        count: 4,
        radius: 4,
        maxHealth: 100,
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.5,
        requireGround: false,
        entityType: "minecraft:phantom",
        count: 6,
        radius: 4,
        maxHealth: 100,
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.25,
        requireGround: false,
        entityType: "minecraft:phantom",
        count: 8,
        radius: 4,
        maxHealth: 100,
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.9,
        requireGround: false,
        entityType: "endertrigon:baby_ender_dragon",
        count: 6,
        radius: 6,
        maxHealth: 325,
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.5,
        requireGround: false,
        entityType: "endertrigon:baby_ender_dragon",
        count: 8,
        radius: 6,
        maxHealth: 325,
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.25,
        requireGround: false,
        entityType: "endertrigon:baby_ender_dragon",
        count: 10,
        radius: 6,
        maxHealth: 325,
    })
})
//////////末影空骑士//////////
EntityEvents.spawned("endertrigon:baby_ender_dragon", event => {
    let entity = event.entity
    if (entity.tags.contains("snk_minion")) {
        let vesperUUID = entity.uuid.toString()
        SummonedCreature(event, entity, {
            spawned: true,
            requireGround: false,
            entityType: "hundred_years_war:hyw_wither_skeleton",
            count: 1,
            radius: 2,
            name: "末影空骑士",
            maxHealth: 156,
            nbt: {
                HandItems: [
                    { id: "hundred_years_war:iron_pike", Count: 1 },
                    { id: "cataclysm:black_steel_targe", Count: 1 },
                ], ArmorItems: [{}, {},
                { id: "alexscaves:cloak_of_darkness", Count: 1 },
                { id: "alexscaves:hood_of_darkness", Count: 1 }
                ],
                KubeJSPersistentData: {
                    vesperUUID: vesperUUID
                }
            }
        })
    }
})
//////////凋灵//////////
EntityEvents.spawned("minecraft:wither", event => {
    let HP = 3900
    let boss = event.entity
    boss.persistentData.putInt("coercion", 1)
    boss.addTag("snk_summoner")
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    sphericalExcavation(boss)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
})
EntityEvents.hurt("minecraft:wither", event => {
    let boss = event.entity
    let eUUID = boss.nbt.UUID
    SummonedCreature(event, boss, {
        healthThreshold: 1,
        requireGround: false,
        entityType: "alexscaves:vesper",
        count: 4,
        radius: 4,
        maxHealth: 300,
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.5,
        requireGround: true,
        entityType: "hundred_years_war:hyw_wither_skeleton",
        count: 4,
        radius: 18,
        name: "凋灵战士",
        maxHealth: 200,
        nbt: {
            OwnerUUID: eUUID,
            FollowTargetUUID: eUUID,
            HandItems: [
                { id: "cataclysm:black_steel_sword", Count: 1 },
                { id: "cataclysm:black_steel_targe", Count: 1 },
            ], ArmorItems: [
                { id: "taxbt:armor_wither_boots", Count: 1 },
                { id: "taxbt:armor_wither_leggings", Count: 1 },
                { id: "taxbt:armor_wither_chestplate", Count: 1 },
                { id: "taxbt:armor_wither_helmet", Count: 1 }
            ]
        }
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.49,
        requireGround: true,
        entityType: "hundred_years_war:hyw_wither_skeleton",
        count: 4,
        radius: 18,
        name: "凋灵收割者",
        maxHealth: 180,
        nbt: {
            OwnerUUID: eUUID,
            FollowTargetUUID: eUUID,
            HandItems: [
                { id: "simplyswords:netherite_scythe", Count: 1 }
            ], ArmorItems: [
                { id: "immersive_armors:wither_boots", Count: 1 },
                { id: "immersive_armors:wither_leggings", Count: 1 },
                { id: "immersive_armors:wither_chestplate", Count: 1 },
                { id: "immersive_armors:wither_helmet", Count: 1 }
            ]
        }
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.5,
        requireGround: false,
        entityType: "alexscaves:vesper",
        count: 4,
        radius: 4,
        maxHealth: 300,
    })
})
//////////凋零空骑士//////////
EntityEvents.spawned("alexscaves:vesper", event => {
    let entity = event.entity
    if (entity.tags.contains("snk_minion")) {
        let vesperUUID = entity.uuid.toString()
        SummonedCreature(event, entity, {
            spawned: true,
            requireGround: false,
            entityType: "hundred_years_war:hyw_wither_skeleton",
            count: 1,
            radius: 2,
            name: "凋零空骑士",
            maxHealth: 100,
            nbt: {
                HandItems: [
                    { id: "hundred_years_war:iron_pike", Count: 1 },
                    { id: "cataclysm:black_steel_targe", Count: 1 },
                ], ArmorItems: [{}, {},
                { id: "alexscaves:cloak_of_darkness", Count: 1 },
                { id: "alexscaves:hood_of_darkness", Count: 1 }
                ],
                KubeJSPersistentData: {
                    vesperUUID: vesperUUID
                }
            }
        })
    }
})
EntityEvents.spawned("hundred_years_war:hyw_wither_skeleton", event => {
    let entity = event.entity
    let data = entity.persistentData
    if (data.contains("vesperUUID")) {
        entity.server.scheduleInTicks(2, () => {
            event.server.runCommandSilent(`execute as ${entity.uuid.toString()} at @s run ride @s mount ${data.getString("vesperUUID")}`)
        })
    }
})
//////////科妮莉亚船长//////////
EntityEvents.spawned("aquamirae:captain_cornelia", event => {
    let HP = 4200
    let boss = event.entity
    boss.persistentData.putInt("coercion", 2)
    boss.addTag("snk_summoner")
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    let eUUID = boss.nbt.UUID
    sphericalExcavation(boss, 6)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
    boss.mergeNbt(`{Attributes:[{Base:0.1d,Name:"obscure_api:healing_power"}]}`)
    SummonedCreature(event, boss, {
        spawned: true,
        requireGround: true,
        entityType: "hundred_years_war:hyw_skeleton",
        count: 4,
        radius: 4,
        name: "溺毙的突击队员",
        maxHealth: 156,
        nbt: {
            OwnerUUID: eUUID,
            FollowTargetUUID: eUUID,
            HandItems: [
                { id: "simplyswords:iron_cutlass", Count: 1 },
                { id: "simplyswords:iron_cutlass", Count: 1 },
            ],
            ArmorItems: [
                { id: "minecolonies:pirate_shoes", Count: 1 },
                { id: "minecolonies:pirate_legs", Count: 1 },
                { id: "minecolonies:pirate_chest", Count: 1 },
                { id: "minecolonies:pirate_cap", Count: 1 }
            ]
        }
    })
})
EntityEvents.hurt("aquamirae:captain_cornelia", event => {
    let boss = event.entity
    let eUUID = boss.nbt.UUID
    SummonedCreature(event, boss, {
        healthThreshold: 0.75,
        requireGround: true,
        entityType: "minecraft:skeleton",
        count: 8,
        minRadius: 12,
        radius: 18,
        name: "溺毙的火枪手",
        maxHealth: 65,
        nbt: {
            HandItems: [
                { id: "musketmod:blunderbuss", Count: 1 },
            ],
            ArmorItems: [
                { id: "minecolonies:pirate_boots", Count: 1 },
                { id: "minecolonies:pirate_leggins", Count: 1 },
                { id: "minecolonies:pirate_top", Count: 1 },
                { id: "minecolonies:pirate_hat", Count: 1 }
            ]
        }
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.5,
        requireGround: true,
        entityType: "hundred_years_war:hyw_skeleton",
        count: 6,
        radius: 4,
        name: "溺毙的突击队员",
        maxHealth: 156,
        nbt: {
            OwnerUUID: eUUID,
            FollowTargetUUID: eUUID,
            HandItems: [
                { id: "simplyswords:iron_cutlass", Count: 1 },
                { id: "simplyswords:iron_cutlass", Count: 1 },
            ],
            ArmorItems: [
                { id: "minecolonies:pirate_shoes", Count: 1 },
                { id: "minecolonies:pirate_legs", Count: 1 },
                { id: "minecolonies:pirate_chest", Count: 1 },
                { id: "minecolonies:pirate_cap", Count: 1 }
            ]
        }
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.5,
        requireGround: true,
        entityType: "hundred_years_war:cannon",
        count: 2,
        minRadius: 18,
        radius: 24,
        name: "沉没的大炮",
        maxHealth: 200,
        nbt: {
            OwnerUUID: eUUID,
            FollowTargetUUID: eUUID
        }
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.25,
        requireGround: true,
        entityType: "minecraft:skeleton",
        count: 16,
        minRadius: 12,
        radius: 18,
        name: "溺毙的火枪手",
        maxHealth: 65,
        nbt: {
            HandItems: [
                { id: "musketmod:blunderbuss", Count: 1 },
            ],
            ArmorItems: [
                { id: "minecolonies:pirate_boots", Count: 1 },
                { id: "minecolonies:pirate_leggins", Count: 1 },
                { id: "minecolonies:pirate_top", Count: 1 },
                { id: "minecolonies:pirate_hat", Count: 1 }
            ]
        }
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.25,
        requireGround: true,
        entityType: "hundred_years_war:cannon",
        count: 4,
        minRadius: 18,
        radius: 24,
        name: "沉没的大炮",
        maxHealth: 200,
        nbt: {
            OwnerUUID: eUUID,
            FollowTargetUUID: eUUID
        }
    })
})
//////////焰魔//////////
EntityEvents.spawned("cataclysm:ignis", event => {
    let HP = 10000
    let boss = event.entity
    boss.persistentData.putInt("coercion", 3)
    boss.addTag("snk_summoner")
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
})
EntityEvents.hurt("cataclysm:ignis", event => {
    let boss = event.entity
    let eUUID = boss.nbt.UUID
    SummonedCreature(event, boss, {
        healthThreshold: 1,
        requireGround: false,
        entityType: "minecraft:blaze",
        count: 4,
        minRadius: 12,
        radius: 18,
        name: "烈焰元素",
        maxHealth: 75
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.8,
        requireGround: false,
        entityType: "minecraft:blaze",
        count: 4,
        minRadius: 12,
        radius: 18,
        name: "烈焰元素",
        maxHealth: 75
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.6,
        requireGround: false,
        entityType: "minecraft:blaze",
        count: 4,
        minRadius: 12,
        radius: 18,
        name: "烈焰元素",
        maxHealth: 75
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.4,
        requireGround: false,
        entityType: "minecraft:blaze",
        count: 4,
        minRadius: 12,
        radius: 18,
        name: "烈焰元素",
        maxHealth: 75
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.2,
        requireGround: false,
        entityType: "minecraft:blaze",
        count: 4,
        minRadius: 12,
        radius: 18,
        name: "烈焰元素",
        maxHealth: 75
    })
    SummonedCreature(event, boss, {
        healthThreshold: 1,
        requireGround: true,
        entityType: "cataclysm:ignited_revenant",
        count: 2,
        radius: 12,
        maxHealth: 650
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.6,
        requireGround: true,
        entityType: "cataclysm:ignited_revenant",
        count: 2,
        radius: 12,
        maxHealth: 650
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.25,
        requireGround: true,
        entityType: "cataclysm:ignited_berserker",
        count: 4,
        radius: 12,
        maxHealth: 450
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.25,
        requireGround: true,
        entityType: "eeeabsmobs:corpse_warlock",
        count: 1,
        minRadius: 18,
        radius: 24,
        name: "侵蚀术士",
        maxHealth: 780
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.20,
        requireGround: true,
        entityType: "hundred_years_war:priest",
        count: 6,
        minRadius: 18,
        radius: 24,
        name: "侵蚀祭司",
        maxHealth: 20,
        nbt: {
            OwnerUUID: eUUID,
            Skin: 20,
            HandItems: [
                { id: "alexscaves:beholder", Count: 1 },
                { id: "hundred_years_war:priest_cane_1", Count: 1 }
            ],
            Attributes: [
                { Base: 50, Name: "hundred_years_war:ranged_attack_damage" },
                { Base: 25, Name: "hundred_years_war:attack_reach" },
            ]
        }
    })
})
//////////灾厄诅咒//////////
EntityEvents.spawned("cataclysm:maledictus", event => {
    let HP = 10100
    let boss = event.entity
    boss.persistentData.putInt("coercion", 3)
    boss.addTag("snk_summoner")
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
})
EntityEvents.hurt("cataclysm:maledictus", event => {
    let boss = event.entity
    let eUUID = boss.nbt.UUID
    SummonedCreature(event, boss, {
        healthThreshold: 1,
        requireGround: true,
        entityType: "eeeabsmobs:immortal_shaman",
        count: 2,
        radius: 18,
        maxHealth: 325
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.75,
        requireGround: true,
        entityType: "eeeabsmobs:immortal_shaman",
        count: 2,
        radius: 18,
        maxHealth: 325
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.5,
        requireGround: true,
        entityType: "eeeabsmobs:immortal_shaman",
        count: 2,
        radius: 18,
        maxHealth: 325
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.25,
        requireGround: true,
        entityType: "eeeabsmobs:immortal_shaman",
        count: 2,
        radius: 18,
        maxHealth: 325
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.5,
        requireGround: true,
        entityType: "eeeabsmobs:immortal_executioner",
        count: 4,
        minRadius: 18,
        radius: 24,
        maxHealth: 480
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.25,
        requireGround: true,
        entityType: "eeeabsmobs:immortal_executioner",
        count: 6,
        minRadius: 18,
        radius: 24,
        maxHealth: 480
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.25,
        requireGround: true,
        entityType: "eeeabsmobs:corpse_warlock",
        count: 1,
        minRadius: 18,
        radius: 24,
        name: "侵蚀术士",
        maxHealth: 780
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.20,
        requireGround: true,
        entityType: "hundred_years_war:priest",
        count: 6,
        minRadius: 18,
        radius: 24,
        name: "侵蚀祭司",
        maxHealth: 20,
        nbt: {
            OwnerUUID: eUUID,
            Skin: 20,
            HandItems: [
                { id: "alexscaves:beholder", Count: 1 },
                { id: "hundred_years_war:priest_cane_1", Count: 1 }
            ],
            Attributes: [
                { Base: 50, Name: "hundred_years_war:ranged_attack_damage" },
                { Base: 25, Name: "hundred_years_war:attack_reach" },
            ]
        }
    })
})
//////////无名守卫者//////////
EntityEvents.spawned("eeeabsmobs:nameless_guardian", event => {
    let HP = 4500
    let boss = event.entity
    boss.persistentData.putInt("coercion", 3)
    boss.addTag("snk_summoner")
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
})
EntityEvents.hurt("eeeabsmobs:nameless_guardian", event => {
    let boss = event.entity
    let eUUID = boss.nbt.UUID
    SummonedCreature(event, boss, {
        healthThreshold: 1,
        requireGround: true,
        entityType: "eeeabsmobs:guling_sentinel_heavy",
        count: 2,
        radius: 4,
        maxHealth: 1250
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.8,
        requireGround: true,
        entityType: "eeeabsmobs:guling_sentinel",
        count: 4,
        minRadius: 10,
        radius: 16,
        maxHealth: 200
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.4,
        requireGround: true,
        entityType: "eeeabsmobs:guling_sentinel",
        count: 4,
        minRadius: 10,
        radius: 16,
        maxHealth: 200
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.2,
        requireGround: true,
        entityType: "eeeabsmobs:guling_sentinel",
        count: 4,
        minRadius: 10,
        radius: 16,
        maxHealth: 200
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.25,
        requireGround: true,
        entityType: "eeeabsmobs:corpse_warlock",
        count: 1,
        minRadius: 18,
        radius: 24,
        name: "侵蚀术士",
        maxHealth: 600
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.1,
        requireGround: true,
        entityType: "hundred_years_war:priest",
        count: 6,
        minRadius: 18,
        radius: 24,
        name: "侵蚀祭司",
        maxHealth: 20,
        nbt: {
            OwnerUUID: eUUID,
            Skin: 20,
            HandItems: [
                { id: "alexscaves:beholder", Count: 1 },
                { id: "hundred_years_war:priest_cane_1", Count: 1 }
            ],
            Attributes: [
                { Base: 50, Name: "hundred_years_war:ranged_attack_damage" },
                { Base: 25, Name: "hundred_years_war:attack_reach" },
            ]
        }
    })
})
//////////远古遗魂//////////
EntityEvents.spawned("cataclysm:ancient_remnant", event => {
    let HP = 1500
    let boss = event.entity
    boss.addTag("snk_summoner")
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
})
EntityEvents.hurt("cataclysm:ancient_remnant", event => {
    let boss = event.entity
    SummonedCreature(event, boss, {
        healthThreshold: 0.5,
        requireGround: true,
        entityType: "cataclysm:wadjet",
        count: 1,
        radius: 8,
        maxHealth: 375
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.25,
        requireGround: true,
        entityType: "cataclysm:wadjet",
        count: 1,
        radius: 8,
        maxHealth: 375
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.5,
        requireGround: true,
        entityType: "cataclysm:kobolediator",
        count: 1,
        radius: 8,
        maxHealth: 450
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.25,
        requireGround: true,
        entityType: "cataclysm:kobolediator",
        count: 1,
        radius: 8,
        maxHealth: 450
    })
})
//////////先驱者//////////
EntityEvents.spawned("cataclysm:the_harbinger", event => {
    let HP = 3250
    let boss = event.entity
    boss.persistentData.putInt("coercion", 2)
    boss.addTag("snk_summoner")
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
})
EntityEvents.hurt("cataclysm:the_harbinger", event => {
    let boss = event.entity
    SummonedCreature(event, boss, {
        healthThreshold: 0.66,
        requireGround: true,
        entityType: "cataclysm:the_watcher",
        count: 4,
        minRadius: 10,
        radius: 16,
        maxHealth: 100
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.33,
        requireGround: true,
        entityType: "cataclysm:the_watcher",
        count: 8,
        minRadius: 10,
        radius: 16,
        maxHealth: 100
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.66,
        requireGround: true,
        entityType: "cataclysm:the_prowler",
        count: 1,
        minRadius: 16,
        radius: 20,
        maxHealth: 800
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.33,
        requireGround: true,
        entityType: "cataclysm:the_prowler",
        count: 2,
        minRadius: 16,
        radius: 20,
        maxHealth: 800
    })
})
//////////末影守卫//////////
EntityEvents.spawned("cataclysm:ender_guardian", event => {
    let HP = 4225
    let boss = event.entity
    boss.persistentData.putInt("coercion", 2)
    boss.addTag("snk_summoner")
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
})
EntityEvents.hurt("cataclysm:ender_guardian", event => {
    let boss = event.entity
    let eUUID = boss.nbt.UUID
    SummonedCreature(event, boss, {
        healthThreshold: 1,
        requireGround: true,
        entityType: "cataclysm:ender_golem",
        count: 2,
        radius: 6,
        maxHealth: 1500
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.5,
        requireGround: true,
        entityType: "cataclysm:ender_golem",
        count: 2,
        radius: 6,
        maxHealth: 1500
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.25,
        requireGround: true,
        entityType: "eeeabsmobs:corpse_warlock",
        count: 1,
        minRadius: 18,
        radius: 24,
        name: "侵蚀术士",
        maxHealth: 780
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.2,
        requireGround: true,
        entityType: "hundred_years_war:priest",
        count: 6,
        minRadius: 18,
        radius: 24,
        name: "侵蚀祭司",
        maxHealth: 20,
        nbt: {
            OwnerUUID: eUUID,
            Skin: 20,
            HandItems: [
                { id: "alexscaves:beholder", Count: 1 },
                { id: "hundred_years_war:priest_cane_1", Count: 1 }
            ],
            Attributes: [
                { Base: 50, Name: "hundred_years_war:ranged_attack_damage" },
                { Base: 25, Name: "hundred_years_war:attack_reach" },
            ]
        }
    })
})
//////////斯库拉//////////
EntityEvents.spawned("cataclysm:scylla", event => {
    let HP = 3000
    let boss = event.entity
    boss.persistentData.putInt("coercion", 2)
    boss.addTag("snk_summoner")
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
})
EntityEvents.hurt("cataclysm:scylla", event => {
    let boss = event.entity
    let eUUID = boss.nbt.UUID
    SummonedCreature(event, boss, {
        healthThreshold: 1,
        requireGround: true,
        entityType: "cataclysm:cindaria",
        count: 2,
        minRadius: 8,
        radius: 15,
        maxHealth: 280
    })
    SummonedCreature(event, boss, {
        healthThreshold: 1,
        requireGround: true,
        entityType: "cataclysm:hippocamtus",
        count: 1,
        radius: 4,
        maxHealth: 400
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.5,
        requireGround: true,
        entityType: "cataclysm:cindaria",
        count: 4,
        minRadius: 8,
        radius: 15,
        maxHealth: 280
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.5,
        requireGround: true,
        entityType: "cataclysm:hippocamtus",
        count: 2,
        radius: 4,
        maxHealth: 400
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.25,
        requireGround: true,
        entityType: "cataclysm:cindaria",
        count: 8,
        minRadius: 8,
        radius: 15,
        maxHealth: 280
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.25,
        requireGround: true,
        entityType: "cataclysm:hippocamtus",
        count: 2,
        radius: 4,
        maxHealth: 400
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.25,
        requireGround: true,
        entityType: "eeeabsmobs:corpse_warlock",
        count: 1,
        minRadius: 18,
        radius: 24,
        name: "侵蚀术士",
        maxHealth: 780
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.2,
        requireGround: true,
        entityType: "hundred_years_war:priest",
        count: 4,
        minRadius: 18,
        radius: 24,
        name: "侵蚀祭司",
        maxHealth: 20,
        nbt: {
            OwnerUUID: eUUID,
            Skin: 20,
            HandItems: [
                { id: "alexscaves:beholder", Count: 1 },
                { id: "hundred_years_war:priest_cane_1", Count: 1 }
            ],
            Attributes: [
                { Base: 50, Name: "hundred_years_war:ranged_attack_damage" },
                { Base: 25, Name: "hundred_years_war:attack_reach" },
            ]
        }
    })
})
//////////下界合金巨兽//////////
EntityEvents.spawned("cataclysm:netherite_monstrosity", event => {
    let HP = 7150
    let boss = event.entity
    boss.persistentData.putInt("coercion", 2)
    boss.addTag("snk_summoner")
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
})
EntityEvents.hurt("cataclysm:netherite_monstrosity", event => {
    let boss = event.entity
    let eUUID = boss.nbt.UUID
    SummonedCreature(event, boss, {
        healthThreshold: 0.25,
        requireGround: true,
        entityType: "eeeabsmobs:corpse_warlock",
        count: 1,
        minRadius: 18,
        radius: 24,
        name: "侵蚀术士",
        maxHealth: 780
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.2,
        requireGround: true,
        entityType: "hundred_years_war:priest",
        count: 4,
        minRadius: 18,
        radius: 24,
        name: "侵蚀祭司",
        maxHealth: 20,
        nbt: {
            OwnerUUID: eUUID,
            Skin: 20,
            HandItems: [
                { id: "alexscaves:beholder", Count: 1 },
                { id: "hundred_years_war:priest_cane_1", Count: 1 }
            ],
            Attributes: [
                { Base: 50, Name: "hundred_years_war:ranged_attack_damage" },
                { Base: 25, Name: "hundred_years_war:attack_reach" },
            ]
        }
    })
})
//////////太阳鸟酋长//////////
EntityEvents.spawned("mowziesmobs:umvuthi", event => {
    let HP = 2600
    let boss = event.entity
    boss.persistentData.putInt("coercion", 2)
    boss.addTag("snk_summoner")
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
})
EntityEvents.hurt("mowziesmobs:umvuthi", event => {
    let boss = event.entity
    SummonedCreature(event, boss, {
        healthThreshold: 0.75,
        requireGround: false,
        entityType: "call_of_yucutan:blowgun_huracan",
        count: 8,
        minRadius: 12,
        radius: 18,
        name: "丛林援军",
        maxHealth: 78
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.5,
        requireGround: false,
        entityType: "call_of_yucutan:blowgun_huracan",
        count: 8,
        minRadius: 12,
        radius: 18,
        name: "丛林援军",
        maxHealth: 78
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.5,
        requireGround: false,
        entityType: "dungeonnowloading:scuttle",
        count: 2,
        radius: 6,
        name: "重组图腾",
        maxHealth: 416
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.25,
        requireGround: false,
        entityType: "call_of_yucutan:blowgun_huracan",
        count: 8,
        minRadius: 12,
        radius: 18,
        name: "丛林援军",
        maxHealth: 78
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.25,
        requireGround: false,
        entityType: "dungeonnowloading:scuttle",
        count: 2,
        radius: 6,
        name: "重组图腾",
        maxHealth: 416
    })
})
//////////祈灵师//////////
EntityEvents.spawned("illagerinvasion:invoker", event => {
    let HP = 1300
    let boss = event.entity
    boss.persistentData.putInt("coercion", 2)
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
})
//////////南瓜领主//////////
EntityEvents.spawned("born_in_chaos_v1:lord_pumpkinhead", event => {
    let HP = 1300
    let boss = event.entity
    boss.persistentData.putInt("coercion", 1)
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
    boss.mergeNbt({
        Attributes: [
            { Base: 70, Name: "minecraft:generic.follow_range" },
            { Base: 2, Name: "forge:step_height_addition" }
        ]
    })
})
//////////南瓜伯爵//////////
EntityEvents.spawned("born_in_chaos_v1:sir_pumpkinhead", event => {
    let HP = 650
    let boss = event.entity
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
    boss.mergeNbt({
        Attributes: [
            { Base: 70, Name: "minecraft:generic.follow_range" },
            { Base: 2, Name: "forge:step_height_addition" }
        ]
    })
})
//////////暗夜巫妖//////////
EntityEvents.spawned("bosses_of_mass_destruction:lich", event => {
    let HP = 1500
    let boss = event.entity
    boss.persistentData.putInt("coercion", 2)
    boss.addTag("snk_summoner")
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
})
EntityEvents.hurt("bosses_of_mass_destruction:lich", event => {
    let boss = event.entity
    SummonedCreature(event, boss, {
        healthThreshold: 1,
        requireGround: false,
        entityType: "minecraft:phantom",
        count: 4,
        radius: 4,
        maxHealth: 60,
    })
    SummonedCreature(event, boss, {
        healthThreshold: 1,
        requireGround: false,
        entityType: "alexscaves:vesper",
        count: 2,
        radius: 4,
        maxHealth: 200,
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.75,
        requireGround: false,
        entityType: "minecraft:phantom",
        count: 6,
        radius: 4,
        maxHealth: 60,
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.5,
        requireGround: false,
        entityType: "minecraft:phantom",
        count: 8,
        radius: 4,
        maxHealth: 60,
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.5,
        requireGround: false,
        entityType: "alexscaves:vesper",
        count: 4,
        radius: 4,
        maxHealth: 200,
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.25,
        requireGround: false,
        entityType: "minecraft:phantom",
        count: 10,
        radius: 4,
        maxHealth: 60,
    })
    SummonedCreature(event, boss, {
        healthThreshold: 0.25,
        requireGround: false,
        entityType: "alexscaves:vesper",
        count: 4,
        radius: 4,
        maxHealth: 200,
    })
})
//////////骷髅空骑士//////////
EntityEvents.spawned("minecraft:phantom", event => {
    let entity = event.entity
    if (entity.tags.contains("snk_minion")) {
        let vesperUUID = entity.uuid.toString()
        SummonedCreature(event, entity, {
            spawned: true,
            requireGround: false,
            entityType: "hundred_years_war:hyw_skeleton_archer",
            count: 1,
            radius: 2,
            name: "骷髅空骑士",
            maxHealth: 40,
            nbt: {
                HandItems: [
                    { id: "minecraft:bow", Count: 1 }
                ],
                KubeJSPersistentData: {
                    vesperUUID: vesperUUID
                }
            }
        })
    }
})
EntityEvents.spawned("hundred_years_war:hyw_skeleton_archer", event => {
    let entity = event.entity
    let data = entity.persistentData
    if (data.contains("vesperUUID")) {
        entity.server.scheduleInTicks(2, () => {
            event.server.runCommandSilent(`execute as ${entity.uuid.toString()} at @s run ride @s mount ${data.getString("vesperUUID")}`)
        })
    }
})
//////////下界铁掌//////////
EntityEvents.spawned("bosses_of_mass_destruction:gauntlet", event => {
    let HP = 4225
    let boss = event.entity
    boss.persistentData.putInt("coercion", 1)
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
})
//////////黑曜石柱//////////
EntityEvents.spawned("bosses_of_mass_destruction:obsidilith", event => {
    let HP = 3250
    let boss = event.entity
    boss.persistentData.putInt("coercion", 1)
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
})
//////////虚空之花//////////
EntityEvents.spawned("bosses_of_mass_destruction:void_blossom", event => {
    let HP = 3900
    let boss = event.entity
    boss.persistentData.putInt("coercion", 1)
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
})
///////////利维坦//////////
EntityEvents.spawned("cataclysm:the_leviathan", event => {
    let HP = 800
    let boss = event.entity
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
})
//////////霜冻巨兽//////////
EntityEvents.spawned("mowziesmobs:frostmaw", event => {
    let HP = 3250
    let boss = event.entity
    boss.persistentData.putInt("coercion", 1)
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
})
//////////钢铁守护者//////////
EntityEvents.spawned("mowziesmobs:ferrous_wroughtnaut", event => {
    let HP = 80
    let boss = event.entity
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
})
//////////监守者//////////
EntityEvents.spawned("minecraft:warden", event => {
    let HP = 1560
    let boss = event.entity
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
})
//////////遗弃者//////////
EntityEvents.spawned("alexscaves:forsaken", event => {
    let HP = 3900
    let boss = event.entity
    boss.persistentData.putInt("coercion", 3)
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
})
//////////暝煌龙//////////
EntityEvents.spawned("alexscaves:luxtructosaurus", event => {
    let HP = 6500
    let boss = event.entity
    boss.persistentData.putInt("coercion", 3)
    boss.setMaxHealth(HP)
    boss.setHealth(99999)
    boss.server.scheduleInTicks(2, () => {
        boss.server.runCommandSilent(`execute as ${boss.uuid.toString()} run team join hostile @s`)
    })
})