// priority: 999999

// 此文件配置殖民地建筑对玩家以及士兵的加成
let CAPABILITY = [
    {
        prefix: 'cb_townhall',                          // 用于任务奖励tag，任务里应该增加_1这样的数字代表属性等级
        baseValue: 10,                                  // 每个等级加成的数值
        Operation: 0,                                   // 加成方式：0=加算，1=乘算，2=最后乘算
        Attribute: 'minecraft:generic.max_health',      // 加成的属性
        target: 'both'                                  // 生效目标: both(两者都), player(仅玩家), soldier(仅士兵)
    },
    {
        prefix: 'cb_cook',
        baseValue: 2,
        Operation: 0,
        Attribute: 'minecraft:generic.max_health',
        target: 'both'
    },
    {
        prefix: 'cb_kitchen',
        baseValue: 4,
        Operation: 0,
        Attribute: 'minecraft:generic.max_health',
        target: 'both'
    },
    {
        prefix: 'cb_baker',
        baseValue: 4,
        Operation: 0,
        Attribute: 'minecraft:generic.max_health',
        target: 'both'
    },
    // 攻击力加成，仅士兵
    {
        prefix: 'cb_combatacademy',
        baseValue: 0.1,
        Operation: 1,
        Attribute: 'minecraft:generic.attack_damage',
        target: "soldier"
    },
    // 这个属性提高无视地形直接移动的高度
    {
        prefix: 'cb_deliveryman',
        baseValue: 1,
        Operation: 0,
        Attribute: 'forge:step_height_addition',
        target: 'soldier'
    },
    // 这个属性提高受到治疗的效果百分比
    {
        prefix: 'cb_hospital',
        baseValue: 0.05,
        Operation: 1,
        Attribute: 'obscure_api:healing_power',
        target: 'both'
    },
    // 这个属性减少受到魔法伤害和药水伤害的百分比
    {
        prefix: 'cb_alchemist',
        baseValue: 5,
        Operation: 0,
        Attribute: 'obscure_api:magic_resistance',
        target: 'both'
    },
    {
        prefix: 'cb_enchanter',
        baseValue: 5,
        Operation: 0,
        Attribute: 'obscure_api:magic_resistance',
        target: 'both'
    },
    // 士兵弓弩伤害加成
    {
        prefix: 'cb_archery_b',
        baseValue: 0.1,
        Operation: 1,
        Attribute: 'hundred_years_war:ranged_attack_damage',
        target: "soldier",
        soldierTypes: ["poisoned_archer", "heavy_crossbowman", "hunter", "archer", "crossbowman"]
    },
    // 火枪手伤害加成
    {
        prefix: 'cb_mechanic',
        baseValue: 0.1,
        Operation: 1,
        Attribute: 'hundred_years_war:ranged_attack_damage',
        target: "soldier",
        soldierTypes: ["handgonne_man", "matchlock_man"]
    },
    // 祭司治疗加成1
    {
        prefix: 'cb_alchemist_b',
        baseValue: 0.1,
        Operation: 2,
        Attribute: 'hundred_years_war:ranged_attack_damage',
        target: "soldier",
        soldierTypes: ["priest"]
    },
    // 祭司治疗加成2
    {
        prefix: 'cb_hospital_b',
        baseValue: 0.1,
        Operation: 2,
        Attribute: 'hundred_years_war:ranged_attack_damage',
        target: "soldier",
        soldierTypes: ["priest"]
    },
    ////////////////////////////
    // 以下配置用于增加百年战争士兵初始属性，已经有调用，不需要在任务里添加
    {
        prefix: 'cb_initial_hunter',
        baseValue: -70,
        Operation: 0,
        Attribute: 'hundred_years_war:attack_reach',
        target: "soldier",
        soldierTypes: ["hunter"]
    },
    {
        prefix: 'cb_initial_health',
        baseValue: 30,
        Operation: 0,
        Attribute: 'minecraft:generic.max_health',
        target: "soldier",
        soldierTypes: [
            "shieldman",
            "warrior",
            "spear_man"
        ]
    },
    {
        prefix: 'cb_initial_health2',
        baseValue: 50,
        Operation: 0,
        Attribute: 'minecraft:generic.max_health',
        target: "soldier",
        soldierTypes: [
            "shield_guardian",
            "sword_dancer"
        ]
    },
    {
        prefix: 'cb_initial_crit_rate',
        baseValue: 0.5,
        Operation: 0,
        Attribute: 'l2damagetracker:crit_rate',
        target: "soldier",
        soldierTypes: ["sword_dancer", "warrior"]
    },
    {
        prefix: 'cb_initial_attack',
        baseValue: 0.25,
        Operation: 2,
        Attribute: 'hundred_years_war:ranged_attack_damage',
        target: "soldier",
        soldierTypes: ["heavy_crossbowman", "crossbowman", "matchlock_man"]
    },
    {
        prefix: 'cb_initial_attack2',
        baseValue: 8,
        Operation: 0,
        Attribute: 'hundred_years_war:ranged_attack_damage',
        target: "soldier",
        soldierTypes: ["priest"]
    },
    {
        prefix: 'cb_initial_attack3',
        baseValue: 0.15,
        Operation: 2,
        Attribute: 'hundred_years_war:ranged_attack_damage',
        target: "soldier",
        soldierTypes: ["poisoned_archer", "heavy_crossbowman"]
    },
]