/*
 * Decompiled with CFR 0.152.
 */
package n1luik.KAllFix.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import n1luik.KAllFix.Imixin.IOptimizeTag;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.level.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class UtilKAF {
    public static double calculateDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static long hash64long(long[] data, int seed) {
        return UtilKAF.hash64long(data, data.length, seed);
    }

    public static long hash64long(long[] data, int length, int seed) {
        long k1;
        long h1 = seed;
        long h2 = seed;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        int i = 0;
        int chunkCount = length / 2;
        for (int j = 0; j < chunkCount; ++j) {
            k1 = data[i];
            long k2 = data[i + 1];
            i += 2;
            k1 *= -8663945395140668459L;
            k1 = Long.rotateLeft(k1, 31);
            h1 ^= (k1 *= 5545529020109919103L);
            h1 = Long.rotateLeft(h1, 27);
            h1 = h1 * 5L + 1390208809L;
            k2 *= 5545529020109919103L;
            k2 = Long.rotateLeft(k2, 33);
            h2 ^= (k2 *= -8663945395140668459L);
            h2 = Long.rotateLeft(h2, 31);
            h2 = h2 * 5L + 944331445L;
        }
        int remaining = length % 2;
        if (remaining != 0) {
            k1 = data[i];
            k1 *= -8663945395140668459L;
            k1 = Long.rotateLeft(k1, 31);
            h1 ^= (k1 *= 5545529020109919103L);
        }
        h1 ^= (long)length;
        h1 += (h2 ^= (long)length);
        h2 += h1;
        h1 = UtilKAF.fmix64(h1);
        h2 = UtilKAF.fmix64(h2);
        h1 += h2;
        return h2 += h1;
    }

    public static long hash64int(int[] data, int seed) {
        return UtilKAF.hash64int(data, data.length, seed);
    }

    public static long hash64int(int[] data, int length, int seed) {
        long k1;
        long h1 = seed;
        long h2 = seed;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        int i = 0;
        int chunkCount = length / 4;
        for (int j = 0; j < chunkCount; ++j) {
            k1 = (long)data[i] << 32 | (long)data[i + 1] & 0xFFFFFFFFL;
            long k2 = (long)data[i + 2] << 32 | (long)data[i + 3] & 0xFFFFFFFFL;
            i += 4;
            k1 *= -8663945395140668459L;
            k1 = Long.rotateLeft(k1, 31);
            h1 ^= (k1 *= 5545529020109919103L);
            h1 = Long.rotateLeft(h1, 27);
            h1 = h1 * 5L + 1390208809L;
            k2 *= 5545529020109919103L;
            k2 = Long.rotateLeft(k2, 33);
            h2 ^= (k2 *= -8663945395140668459L);
            h2 = Long.rotateLeft(h2, 31);
            h2 = h2 * 5L + 944331445L;
        }
        int remaining = length % 4;
        if (remaining != 0) {
            k1 = 0L;
            for (int j = 0; j < remaining; ++j) {
                k1 |= ((long)data[i + j] & 0xFFFFFFFFL) << j * 32;
            }
            k1 *= -8663945395140668459L;
            k1 = Long.rotateLeft(k1, 31);
            h1 ^= (k1 *= 5545529020109919103L);
        }
        h1 ^= (long)length;
        h1 += (h2 ^= (long)length);
        h2 += h1;
        h1 = UtilKAF.fmix64(h1);
        h2 = UtilKAF.fmix64(h2);
        h1 += h2;
        return h2 += h1;
    }

    private static long fmix64(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    public static Integer[] sortPos(int[] array) {
        Integer[] indices = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            indices[i] = i;
        }
        Arrays.sort(indices, Comparator.comparingInt(a -> array[a]));
        return indices;
    }

    public static long hashAttributeModifier(AttributeModifier data) {
        UUID id = data.m_22209_();
        return UtilKAF.hash64long(new long[]{Double.doubleToLongBits(data.m_22218_()), id.getMostSignificantBits(), id.getLeastSignificantBits(), data.m_22217_().ordinal()}, 0);
    }

    public static long hashAttributeInstanceList(Collection<AttributeInstance> list) {
        ArrayList<AttributeInstance> copy = new ArrayList<AttributeInstance>(list);
        int Hlen = 0;
        int Hwrite = 0;
        for (AttributeInstance attributeInstance : copy) {
            Hlen += 1 + attributeInstance.f_22091_.size() * 4;
        }
        long[] buf = new long[Hlen];
        for (AttributeInstance data : copy) {
            buf[Hwrite++] = data.m_22099_().m_22087_().hashCode();
            for (AttributeModifier modifier : data.f_22091_) {
                UUID id = modifier.m_22209_();
                buf[Hwrite] = Double.doubleToLongBits(modifier.m_22218_());
                buf[Hwrite + 1] = id.getMostSignificantBits();
                buf[Hwrite + 2] = id.getLeastSignificantBits();
                buf[Hwrite + 3] = modifier.m_22217_().ordinal();
                Hwrite += 4;
            }
        }
        return UtilKAF.hash64long(buf, 0);
    }

    public static long hashAttributeInstanceSize(Collection<AttributeInstance> list) {
        int Hwrite = 1;
        long[] buf = new long[list.size() + 1];
        buf[0] = list.size();
        for (AttributeInstance data : list) {
            buf[Hwrite++] = data.f_22091_.size();
        }
        return UtilKAF.hash64long(buf, 0);
    }

    public static long hashAttributeInstance(AttributeInstance data) {
        int Hlen = 1 + data.f_22091_.size() * 4;
        int Hwrite = 1;
        long[] buf = new long[Hlen];
        buf[0] = data.m_22099_().m_22087_().hashCode();
        for (AttributeModifier modifier : data.f_22091_) {
            UUID id = modifier.m_22209_();
            buf[Hwrite] = Double.doubleToLongBits(modifier.m_22218_());
            buf[Hwrite + 1] = id.getMostSignificantBits();
            buf[Hwrite + 2] = id.getLeastSignificantBits();
            buf[Hwrite + 3] = modifier.m_22217_().ordinal();
            Hwrite += 4;
        }
        return UtilKAF.hash64long(buf, 0);
    }

    public static byte[] toMixinClassHashCheckDataByte(ClassNode classData) {
        UtilKAF.toMixinClassHashCheckData(classData);
        ClassWriter classWriter = new ClassWriter(1);
        classData.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    public static byte[] toMixinClassHashCheckDataByte(byte[] classFile) {
        ClassNode classData = new ClassNode();
        new ClassReader(classFile).accept((ClassVisitor)classData, 0);
        UtilKAF.toMixinClassHashCheckData(classData);
        ClassWriter classWriter = new ClassWriter(1);
        classData.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    public static void toMixinClassHashCheckData(ClassNode classData) {
        ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        ArrayList<FieldNode> fieldNodes = new ArrayList<FieldNode>();
        block4: for (MethodNode method : classData.methods) {
            if (method.visibleAnnotations == null) continue;
            for (AnnotationNode visibleAnnotation : method.visibleAnnotations) {
                if (!visibleAnnotation.desc.equals("Lorg/spongepowered/asm/mixin/transformer/meta/MixinMerged;")) continue;
                methodInfos.add(new MethodInfo(method.name, method.desc));
                method.name = "mixinFix";
                method.visibleAnnotations.remove(visibleAnnotation);
                continue block4;
            }
        }
        block6: for (FieldNode field : classData.fields) {
            if (field.visibleAnnotations == null) continue;
            for (AnnotationNode visibleAnnotation : field.visibleAnnotations) {
                if (!visibleAnnotation.desc.equals("Lorg/spongepowered/asm/mixin/transformer/meta/MixinMerged;")) continue;
                fieldInfos.add(new FieldInfo(field.name));
                fieldNodes.add(field);
                field.visibleAnnotations.remove(visibleAnnotation);
                continue block6;
            }
        }
        classData.fields = fieldNodes;
        for (MethodNode method : classData.methods) {
            for (AbstractInsnNode instruction : method.instructions) {
                if (instruction instanceof MethodInsnNode) {
                    MethodInsnNode methodInsnNode = (MethodInsnNode)instruction;
                    for (MethodInfo methodInfo : methodInfos) {
                        if (methodInfo.nameHash != methodInsnNode.name.hashCode() || methodInfo.descHash != methodInsnNode.desc.hashCode() || !methodInsnNode.name.equals(methodInfo.name) || !methodInsnNode.desc.equals(methodInfo.desc)) continue;
                        methodInsnNode.name = "";
                    }
                    continue;
                }
                if (instruction instanceof FieldInsnNode) {
                    FieldInsnNode fieldInsnNode = (FieldInsnNode)instruction;
                    for (FieldInfo fieldInfo : fieldInfos) {
                        if (fieldInfo.nameHash != fieldInsnNode.name.hashCode() || !fieldInsnNode.name.equals(fieldInfo.name)) continue;
                        fieldInsnNode.name = "";
                    }
                    continue;
                }
                if (!(instruction instanceof InvokeDynamicInsnNode)) continue;
                InvokeDynamicInsnNode invokeDynamicInsnNode = (InvokeDynamicInsnNode)instruction;
                Handle bsm = invokeDynamicInsnNode.bsm;
                if (bsm.getOwner().equals(classData.name)) {
                    for (MethodInfo methodInfo : methodInfos) {
                        if (methodInfo.nameHash != bsm.getName().hashCode() || methodInfo.descHash != bsm.getDesc().hashCode() || !bsm.getName().equals(methodInfo.name) || !bsm.getDesc().equals(methodInfo.desc)) continue;
                        invokeDynamicInsnNode.bsm = new Handle(bsm.getTag(), bsm.getOwner(), "", bsm.getDesc(), bsm.isInterface());
                    }
                }
                if (invokeDynamicInsnNode.bsmArgs == null) continue;
                block13: for (int i = 0; i < invokeDynamicInsnNode.bsmArgs.length; ++i) {
                    Object bsmArg = invokeDynamicInsnNode.bsmArgs[i];
                    if (!(bsmArg instanceof Handle)) continue;
                    Handle handle = (Handle)bsmArg;
                    switch (handle.getTag()) {
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: {
                            for (MethodInfo methodInfo : methodInfos) {
                                if (methodInfo.nameHash != handle.getName().hashCode() || methodInfo.descHash != handle.getDesc().hashCode() || !handle.getName().equals(methodInfo.name) || !handle.getDesc().equals(methodInfo.desc)) continue;
                                invokeDynamicInsnNode.bsmArgs[i] = new Handle(handle.getTag(), handle.getOwner(), "", handle.getDesc(), handle.isInterface());
                            }
                            continue block13;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            for (FieldInfo fieldInfo : fieldInfos) {
                                if (fieldInfo.nameHash != handle.getName().hashCode() || !handle.getName().equals(fieldInfo.name)) continue;
                                invokeDynamicInsnNode.bsmArgs[i] = new Handle(handle.getTag(), handle.getOwner(), "", handle.getDesc(), handle.isInterface());
                            }
                            continue block13;
                        }
                    }
                }
            }
        }
    }

    public static Optional<BlockPos> tagFindClosestMatch(Level w, int id, BlockPos pos, int r, int h, Predicate<BlockPos> predicate) {
        boolean zFlag;
        int x = SectionPos.m_123171_((int)pos.m_123341_());
        int z = SectionPos.m_123171_((int)pos.m_123343_());
        int xb = x * 16;
        int zb = z * 16;
        boolean xFlag = pos.m_123341_() % 16 != 0;
        boolean bl = zFlag = pos.m_123343_() % 16 != 0;
        int xEnd = (xFlag ? (SectionPos.m_123171_((int)(pos.m_123341_() + r)) == SectionPos.m_123171_((int)pos.m_123341_()) ? (r >= 16 ? 1 : 2) : 1) : 0) + r / 16;
        int zEnd = (zFlag ? (SectionPos.m_123171_((int)(pos.m_123343_() + r)) == SectionPos.m_123171_((int)pos.m_123343_()) ? (r >= 16 ? 1 : 2) : 1) : 0) + r / 16;
        int y = pos.m_123342_();
        BlockPos.MutableBlockPos mp = new BlockPos.MutableBlockPos();
        if (xFlag || zFlag) {
            for (int tx = 0; tx <= xEnd; ++tx) {
                for (int tz = 0; tz <= zEnd; ++tz) {
                    for (int tn = 0; tn < 4; ++tn) {
                        int zo;
                        int xo;
                        boolean nx = (tn & 1) == 0;
                        boolean nz = (tn & 2) == 0;
                        int rcx = nx ? x + tx : x - tx;
                        int rcz = nz ? z + tz : z - tz;
                        IOptimizeTag chunkNow = (IOptimizeTag)w.m_7726_().m_7131_(rcx, rcz);
                        if (chunkNow == null || !chunkNow.KAllFix$getOptimizeTag(id)) continue;
                        if (tx == 0 || tz == 0 || tx == xEnd || tz == zEnd) {
                            int zoe;
                            int xoe;
                            if (tx == 0) {
                                if (nx) {
                                    xo = rcx * 16 + (pos.m_123341_() - SectionPos.m_123171_((int)pos.m_123341_()) * 16);
                                    xoe = xo + 16;
                                } else {
                                    xo = rcx * 16;
                                    xoe = xo + (16 - (16 - (pos.m_123341_() - SectionPos.m_123171_((int)pos.m_123341_()) * 16)));
                                }
                            } else if (nx) {
                                xo = rcx * 16;
                                xoe = tx == xEnd ? xo + (pos.m_123341_() + r - SectionPos.m_123171_((int)(pos.m_123341_() + r)) * 16) : xo + 16;
                            } else if (tx == xEnd) {
                                xoe = rcx * 16 + 16;
                                xo = rcx * 16 + (16 - (pos.m_123341_() + r - SectionPos.m_123171_((int)(pos.m_123341_() + r)) * 16));
                            } else {
                                xo = rcx * 16;
                                xoe = xo + 16;
                            }
                            if (tz == 0) {
                                if (nz) {
                                    zo = rcz * 16 + (pos.m_123343_() - SectionPos.m_123171_((int)pos.m_123343_()) * 16);
                                    zoe = rcz * 16 + 16;
                                } else {
                                    zo = rcz * 16;
                                    zoe = zo + (16 - (16 - (pos.m_123343_() - SectionPos.m_123171_((int)pos.m_123343_()) * 16)));
                                }
                            } else if (nz) {
                                zo = rcz * 16;
                                zoe = tz == zEnd ? zo + (pos.m_123343_() + r - SectionPos.m_123171_((int)(pos.m_123343_() + r)) * 16) : zo + 16;
                            } else if (tz == zEnd) {
                                zoe = rcz * 16 + 16;
                                zo = rcz * 16 + (16 - (pos.m_123343_() + r - SectionPos.m_123171_((int)(pos.m_123343_() + r)) * 16));
                            } else {
                                zo = rcz * 16;
                                zoe = zo + 16;
                            }
                            for (int ty = 0; ty <= h; ++ty) {
                                for (int rn = 0; rn < 2; ++rn) {
                                    int tempz;
                                    int tempx;
                                    if (rn == 0) {
                                        for (tempx = xo; tempx < xoe; ++tempx) {
                                            for (tempz = zo; tempz < zoe; ++tempz) {
                                                mp.m_122178_(tempx, y + ty, tempz);
                                                if (!predicate.test((BlockPos)mp)) continue;
                                                return Optional.of(new BlockPos((Vec3i)mp));
                                            }
                                        }
                                        continue;
                                    }
                                    for (tempx = xo; tempx < xoe; ++tempx) {
                                        for (tempz = zo; tempz < zoe; ++tempz) {
                                            mp.m_122178_(tempx, y - ty, tempz);
                                            if (!predicate.test((BlockPos)mp)) continue;
                                            return Optional.of(new BlockPos((Vec3i)mp));
                                        }
                                    }
                                }
                            }
                            continue;
                        }
                        xo = rcx * 16;
                        zo = rcz * 16;
                        for (int ty = 0; ty <= h; ++ty) {
                            for (int rn = 0; rn < 2; ++rn) {
                                int tz2;
                                int tx2;
                                if (rn == 0) {
                                    for (tx2 = 0; tx2 < 16; ++tx2) {
                                        for (tz2 = 0; tz2 < 16; ++tz2) {
                                            mp.m_122178_(xo + tx2, y + ty, zo + tz2);
                                            if (!predicate.test((BlockPos)mp)) continue;
                                            return Optional.of(new BlockPos((Vec3i)mp));
                                        }
                                    }
                                    continue;
                                }
                                for (tx2 = 0; tx2 < 16; ++tx2) {
                                    for (tz2 = 0; tz2 < 16; ++tz2) {
                                        mp.m_122178_(xo + tx2, y - ty, zo + tz2);
                                        if (!predicate.test((BlockPos)mp)) continue;
                                        return Optional.of(new BlockPos((Vec3i)mp));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int tx = 0; tx <= xEnd; ++tx) {
                for (int tz = 0; tz <= zEnd; ++tz) {
                    for (int tn = 0; tn < 4; ++tn) {
                        int rcx = ((tn & 1) == 0 ? tx : -tx) + x;
                        int rcz = ((tn & 2) == 0 ? tz : -tz) + z;
                        IOptimizeTag chunkNow = (IOptimizeTag)w.m_7726_().m_7131_(rcx, rcz);
                        if (chunkNow == null || !chunkNow.KAllFix$getOptimizeTag(id)) continue;
                        int xo = rcx * 16;
                        int zo = rcz * 16;
                        for (int ty = 0; ty <= h; ++ty) {
                            for (int rn = 0; rn < 2; ++rn) {
                                int tz2;
                                int tx2;
                                if (rn == 0) {
                                    for (tx2 = 0; tx2 < 16; ++tx2) {
                                        for (tz2 = 0; tz2 < 16; ++tz2) {
                                            mp.m_122178_(xo + tx2, y + ty, zo + tz2);
                                            if (!predicate.test((BlockPos)mp)) continue;
                                            return Optional.of(new BlockPos((Vec3i)mp));
                                        }
                                    }
                                    continue;
                                }
                                for (tx2 = 0; tx2 < 16; ++tx2) {
                                    for (tz2 = 0; tz2 < 16; ++tz2) {
                                        mp.m_122178_(xo + tx2, y - ty, zo + tz2);
                                        if (!predicate.test((BlockPos)mp)) continue;
                                        return Optional.of(new BlockPos((Vec3i)mp));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Optional.empty();
    }

    public static Optional<BlockPos> tagAddFindClosestMatch(Level w, int id, BlockPos pos, int r, int h, Predicate<BlockPos> predicate) {
        boolean zFlag;
        int x = SectionPos.m_123171_((int)pos.m_123341_());
        int z = SectionPos.m_123171_((int)pos.m_123343_());
        boolean xFlag = pos.m_123341_() % 16 != 0;
        boolean bl = zFlag = pos.m_123343_() % 16 != 0;
        int xEnd = (xFlag ? (SectionPos.m_123171_((int)(pos.m_123341_() + r)) == SectionPos.m_123171_((int)pos.m_123341_()) ? 1 : 2) : 0) + x + r / 16;
        int zEnd = (zFlag ? (SectionPos.m_123171_((int)(pos.m_123343_() + r)) == SectionPos.m_123171_((int)pos.m_123343_()) ? 1 : 2) : 0) + z + r / 16;
        int y = pos.m_123342_();
        int yEnd = pos.m_123342_() + h;
        BlockPos.MutableBlockPos mp = new BlockPos.MutableBlockPos();
        if (xFlag || zFlag) {
            for (int tx = x; tx <= xEnd; ++tx) {
                for (int tz = z; tz <= zEnd; ++tz) {
                    int zo;
                    int xo;
                    IOptimizeTag chunkNow = (IOptimizeTag)w.m_7726_().m_7131_(tx, tz);
                    if (chunkNow == null || !chunkNow.KAllFix$getOptimizeTag(id)) continue;
                    if (tx == x || tz == z || tx == xEnd || tz == zEnd) {
                        int zoe;
                        int xoe;
                        if (tx == x) {
                            xo = tx * 16 + (pos.m_123341_() - SectionPos.m_123171_((int)pos.m_123341_()) * 16);
                            xoe = xo + 16;
                        } else {
                            xo = tx * 16;
                            xoe = tx == xEnd ? xo + (pos.m_123341_() + r - SectionPos.m_123171_((int)(pos.m_123341_() + r)) * 16) : xo + 16;
                        }
                        if (tz == z) {
                            zo = tz * 16 + (pos.m_123343_() - SectionPos.m_123171_((int)pos.m_123343_()) * 16);
                            zoe = zo + 16;
                        } else {
                            zo = tz * 16;
                            zoe = tz == zEnd ? zo + (pos.m_123343_() + r - SectionPos.m_123171_((int)(pos.m_123343_() + r)) * 16) : zo + 16;
                        }
                        for (int ty = y; ty <= yEnd; ++ty) {
                            for (int tempx = xo; tempx < xoe; ++tempx) {
                                for (int tempz = zo; tempz < zoe; ++tempz) {
                                    mp.m_122178_(tempx, ty, tempz);
                                    if (!predicate.test((BlockPos)mp)) continue;
                                    return Optional.of(new BlockPos((Vec3i)mp));
                                }
                            }
                        }
                        continue;
                    }
                    xo = tx * 16;
                    zo = tz * 16;
                    for (int ty = y; ty <= yEnd; ++ty) {
                        for (int tx2 = 0; tx2 < 16; ++tx2) {
                            for (int tz2 = 0; tz2 < 16; ++tz2) {
                                mp.m_122178_(xo + tx2, ty, zo + tz2);
                                if (!predicate.test((BlockPos)mp)) continue;
                                return Optional.of(new BlockPos((Vec3i)mp));
                            }
                        }
                    }
                }
            }
        } else {
            for (int tx = x; tx <= xEnd; ++tx) {
                for (int tz = z; tz <= zEnd; ++tz) {
                    IOptimizeTag chunkNow = (IOptimizeTag)w.m_7726_().m_7131_(tx, tz);
                    if (chunkNow == null || !chunkNow.KAllFix$getOptimizeTag(id)) continue;
                    int xo = tx * 16;
                    int zo = tz * 16;
                    for (int ty = y; ty <= yEnd; ++ty) {
                        for (int tx2 = 0; tx2 < 16; ++tx2) {
                            for (int tz2 = 0; tz2 < 16; ++tz2) {
                                mp.m_122178_(xo + tx2, ty, zo + tz2);
                                if (!predicate.test((BlockPos)mp)) continue;
                                return Optional.of(new BlockPos((Vec3i)mp));
                            }
                        }
                    }
                }
            }
        }
        return Optional.empty();
    }

    public record MethodInfo(String name, String desc, int nameHash, int descHash) {
        public MethodInfo(String name, String desc) {
            this(name, desc, name.hashCode(), desc.hashCode());
        }
    }

    public record FieldInfo(String name, int nameHash) {
        public FieldInfo(String name) {
            this(name, name.hashCode());
        }
    }
}

