/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.alienday.config;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.fml.loading.FMLPaths;

public class AlienDayConfig {
    private static final Path CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("alienday/skip_celebrations.json");
    private static final Gson GSON = new Gson();
    private static Set<String> skipSet = Collections.emptySet();

    public static void load() {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            AlienDayConfig.createDefaultConfig();
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
            skipSet = new HashSet<String>((Collection)GSON.fromJson((Reader)reader, new TypeToken<Set<String>>(){}.getType()));
        }
        catch (IOException e) {
            e.printStackTrace();
            skipSet = Collections.emptySet();
        }
    }

    private static void createDefaultConfig() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson(Collections.singleton("example1")), new OpenOption[0]);
            skipSet = Set.of("example1");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean shouldSkip(String name) {
        return skipSet.contains(name);
    }
}

