<br><br>

<h1 align = "center">photon</h1>

<p align = "center">A gameplay-focused shader pack for Minecraft</p>

![Screenshot](docs/images/a.png)

## acknowledgments

* [Emin](https://github.com/EminGT) - Shadow bias method from [Complementary Reimagined](https://www.complementary.dev/shaders/) (fully fixes peter panning and light leaking underground!)
* [DrDesten](https://github.com/DrDesten) - Depth tolerance calculation for SSR (helps to prevent false reflections)
* [Jessie](https://github.com/Jessie-LC) - f0 and f82 values for labPBR hardcoded metals
* [Sledgehammer Games](https://www.sledgehammergames.com/) - Bloom downsampling method used in Call of Duty Advanced Warfare (described [here](http://www.iryoku.com/next-generation-post-processing-in-call-of-duty-advanced-warfare))
* http://momentsingraphics.de/ - Blue noise texture

## installation

* [Download latest commit](https://github.com/sixthsurge/photon/archive/refs/heads/main.zip)

* Photon can be used with [Iris](https://irisshaders.dev/download) (recommended) or [OptiFine](https://optifine.net/home)
* Iris is a modern shader loader with far better performance, mod compatibility and developer features than OptiFine. Some features (Colored Lighting) will only work on Iris
* Once you have your preferred shader loader installed, simply place the downloaded zip file in your `.minecraft/shaderpacks` folder

## features
* Fully revamped sky, lighting and water with a cohesive visual style
* Immersive weather system with different skies each day, featuring multiple volumetric cloud layers
* [Colored lighting](https://cdn.discordapp.com/attachments/736930818835873813/1123586429902135338/2023-06-28_13.02.33.png?ex=65f197e8&is=65df22e8&hm=c7871d2d3a5af5f6c84d98ad9997e4f4e1cfff40d3d9539b03e471abf48f677c&) using a voxel flood-fill algorithm (enabled with Ultra profile, requires Iris)
* Full labPBR resource pack support
* Extensive settings menu allowing you to customize every aspect of the shader
* Screen-space reflections
* Volumetric lighting
* Soft shadows with variable penumbra size
* High quality ambient occlusion (GTAO)
* Camera effects: bloom, depth of field, motion blur
* Much improved image quality with TAA, FXAA and CAS
* Advanced temporal upscaling (disabled by default) for low end devices

## compatibility
* Nvidia, AMD and Intel GPUs
* Iris - version 1.5 and above
* OptiFine - on Minecraft 1.16.5 and above
* Photon is also compatible with [Distant Horizons](https://www.curseforge.com/minecraft/mc-mods/distant-horizons) (as of writing this requires a special version of Iris and Distant Horizons which is available in the Iris installer)

## showcase videos

<div align = "center">
	<a href="http://www.youtube.com/watch?feature=player_embedded&v=vxE_CVeU8Rs" target="_blank"><img src="http://img.youtube.com/vi/vxE_CVeU8Rs/0.jpg" border="0"/></a>
	<p> by iambeen
	<br><br>
</div>

<div align = "center">
	<a href="http://www.youtube.com/watch?feature=player_embedded&v=gMLFZMBK-ZQ" target="_blank"><img src="http://img.youtube.com/vi/gMLFZMBK-ZQ/0.jpg" border="0"/></a>
	<p> by CosmicNexus
	<br><br>
</div>

<div align = "center">
	<a href="http://www.youtube.com/watch?feature=player_embedded&v=_aSmM7jg9Nw" target="_blank"><img src="http://img.youtube.com/vi/_aSmM7jg9Nw/0.jpg" border="0"/></a>
	<p> by VIPUL
	<br><br>
</div>

## community

For questions, suggestions and news regarding this shader pack, head to my channel `#photon-sixthsurge` in the [shaderLABS discord server](https://discord.gg/RpzWN9S).

