#version 450 compatibility

#include "/Settings.glsl"

uniform vec3 cameraPosition;
uniform mat4 shadowModelViewInverse;

uniform int blockEntityId;

#ifndef MC_GL_VENDOR_INTEL
	#define attribute in
#endif

attribute vec4 mc_Entity;

out vec2 texcoord;
out vec3 tint;
out vec3 normal;
out vec4 lmcoord;
out vec3 minecraftPos;

out float isWater;

void main() {
	if (blockEntityId == 10030) {
		gl_Position = vec4(-1.0);
		return;
	}

	normal = gl_NormalMatrix * gl_Normal;
	#ifdef SHADOW_BACKFACE_CULLING
		if (normal.z < 0.0) {
			gl_Position = vec4(-1.0);
			return;
		}
	#endif

	lmcoord = gl_TextureMatrix[1] * gl_MultiTexCoord1;
	texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;

	vec4 viewPos = gl_ModelViewMatrix * gl_Vertex;
	minecraftPos = (shadowModelViewInverse * viewPos).xyz + cameraPosition;

	gl_Position.xyz = (gl_ProjectionMatrix * viewPos).xyz;

	tint = gl_Color.rgb;

	float distortFactor = 1.0 - SHADOW_MAP_BIAS + length(gl_Position.xy) * SHADOW_MAP_BIAS;
	gl_Position.xy *= 0.95 / distortFactor;
    //gl_Position.xyz = FinalShadowProjectionTransformation(gl_Position.xyz);

	isWater = float(mc_Entity.x == 10017);

	gl_Position.z = mix(gl_Position.z, 0.5, 0.8);
	gl_Position.w = 1.0;
}
