#version 450 compatibility


#define IS_OVERWORLD

layout(location = 0) out vec3 sceneData;
layout(location = 1) out float fogTransmittance;


in vec2 texcoord;

flat in vec3 colorSunlight;
flat in vec3 colorSkylight;

//in vec3 worldSunVector;
//in vec3 worldLightVector;

#include "/lib/Head/Common.inc"
#include "/lib/Head/Uniforms.inc"
#include "/lib/Atmosphere/Atmosphere.glsl"

/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "/lib/Head/Functions.inc"

#include "/lib/Head/Material.inc"

#include "/lib/Head/Mask.inc"

#include "/lib/Water/WaterRefraction.glsl"

#include "/lib/Surface/ReflectionFilter.glsl"

#include "/lib/Atmosphere/Fogs.glsl"

#include "/lib/Water/WaterFog.glsl"
/*
//#define RAIN_SPARKLE

void Rain(inout vec3 color, in vec3 worldDir, in float rainAlpha) {
	//color = mix(color, (colorSkylight + colorSunlight) * (0.02 + 2.0 * weatherSnowySmooth), saturate(rainAlpha * (0.2 + 0.3 * weatherSnowySmooth)));

	//#ifdef RAIN_SPARKLE
		//if (weatherSnowySmooth < 1e-2) {
			float LdotV = dot(worldDir, worldLightVector);

			float sparkliness = 5.0 + LdotV;
			float sparkleNoise = Get3DNoise((worldDir + frameTimeCounter) * vec3(2e2, 20.0, 2e2));
			float rainSparkleSunlight = rainAlpha / (pow(sparkleNoise, sparkliness) * 40.0 + 1e-3);
			color += rainSparkleSunlight * colorSunlight * (HenyeyGreensteinPhase(LdotV, 0.8) + 0.2);
		//}
	//#endif
}

float GetLinearDepth(in float x) {
    return rcp(far + near - x * (far - near));
}
*/
vec4 BilateralUpscale(in sampler2D datatex, in vec2 coord, in float linearDepth, in ivec2 minCoord, in ivec2 maxCoord) {
    ivec2 offset = (ivec2(gl_FragCoord.xy + frameCounter) % 2) * 2;

    ivec2 uvDepth = ivec2(gl_FragCoord.xy * 0.5 - 0.25) * 2 + offset * 2;
    ivec2 uvData = ivec2(coord * 0.5) + offset;

	const float depthConst0 = rcp(far * near);

    float depth = GetDepthLinear(texelFetch(depthtex0, uvDepth + ivec2(-4, -4), 0).x);
    float weight = step(abs(depth - linearDepth), depthConst0) * 0.99999 + 0.00001;
    vec4 data = texelFetch(datatex, clamp(uvData + ivec2(-2, -2), minCoord, maxCoord), 0) * weight;
    float sumWeight = weight;

    depth = GetDepthLinear(texelFetch(depthtex0, uvDepth + ivec2(-4, 0), 0).x);
    weight = step(abs(depth - linearDepth), depthConst0) * 0.99999 + 0.00001;
    data += texelFetch(datatex, clamp(uvData + ivec2(-2, 0), minCoord, maxCoord), 0) * weight;
    sumWeight += weight;

    depth = GetDepthLinear(texelFetch(depthtex0, uvDepth + ivec2(0, 0), 0).x);
    weight = step(abs(depth - linearDepth), depthConst0) * 0.99999 + 0.00001;
    data += texelFetch(datatex, clamp(uvData + ivec2(0, 0), minCoord, maxCoord), 0) * weight;
    sumWeight += weight;

    depth = GetDepthLinear(texelFetch(depthtex0, uvDepth + ivec2(0, -4), 0).x);
    weight = step(abs(depth - linearDepth), depthConst0) * 0.99999 + 0.00001;
    data += texelFetch(datatex, clamp(uvData + ivec2(0, -2), minCoord, maxCoord), 0) * weight;
    sumWeight += weight;

    return clamp16F(data * rcp(sumWeight));
}

/////////////////////////MAIN///////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////MAIN///////////////////////////////////////////////////////////////////////////////////////////
void main() {
	ivec2 texel 		= ivec2(gl_FragCoord.xy);

	vec4 gbuffer3 		= texelFetch(colortex3, texel, 0);
	vec4 albedoT 		= vec4(UnpackUnorm2x8(gbuffer3.z), UnpackUnorm2x8(gbuffer3.w));

	//vec2 mcLightmapT = texelFetch(colortex2, texel, 0).rg;
	//GetBlocklightFalloff(mcLightmapT);

	vec3 normal 		= DecodeNormal(gbuffer3.xy);

	int materialIDT 	= int(texelFetch(colortex7, texel, 0).z * 255.0);
	TranslucentMask materialMaskT = CalculateMasksT(materialIDT);

	float depth 		= GetDepth(texel);
	depth += 0.38 * step(depth, 0.56);
	float depthT 		= GetDepthT(texel);

	vec3 viewPos 		= ScreenToViewSpace(vec3(texcoord, depthT));
	vec3 viewDir 		= normalize(viewPos);
	vec3 worldPos 		= mat3(gbufferModelViewInverse) * viewPos;
	vec3 worldDir 		= normalize(worldPos);
	worldPos 			+= gbufferModelViewInverse[3].xyz;

	if (depthT < 1.0) {
		vec2 refractCoord  = CalculateRefractCoord(materialMaskT, normal, worldPos, viewPos, depth, depthT);
		ivec2 refractTexel = ivec2(refractCoord * screenSize);

		sceneData 			= texelFetch(colortex4, refractTexel, 0).rgb;

		vec3 albedoRaw 		= texelFetch(colortex6, refractTexel, 0).rgb;
		vec3 albedo 		= SRGBtoLinear(albedoRaw);

		Material material 	= GetMaterialData(texelFetch(colortex0, refractTexel, 0).xy);

		//float materialID 	= floor(texture(colortex3, refractCoord).b * 255.0);
		//MaterialMask materialMask = CalculateMasks(materialID);
		/*
		if ((materialMaskT.water || materialMaskT.ice) && isEyeInWater < 0.5) {
			float skyLightmap = texelFetch(colortex7, refractTexel, 0).g;
			GetSkylightFalloff(skyLightmap);
			vec3 viewPos0 = ScreenToViewSpace(refractCoord, GetDepthT(refractTexel));
			vec3 viewPos1 = ScreenToViewSpace(refractCoord, refractDepth);
			vec3 worldDir0 = mat3(gbufferModelViewInverse) * normalize(viewPos0);
			float LdotV = dot(worldLightVector, worldDir0);
			WaterFog(sceneData, materialMaskT, skyLightmap, LdotV, distance(viewPos0, viewPos1));
		}
		*/

		if (materialMaskT.stainedGlass) TransparentAbsorption(sceneData, albedoT);
		if (materialMaskT.ice) sceneData *= sqr(albedoT.rgb);

		if (materialMaskT.translucent) {
			vec4 reflectionData = texelFetch(colortex2, texel, 0);
			sceneData = sceneData * reflectionData.a + reflectionData.rgb;
		} else if (material.hasReflections) {
			vec4 reflectionData = texelFetch(colortex2, texel, 0);
			#ifdef REFLECTION_FILTER
				if (material.isRough) reflectionData.rgb = ReflectionFilter(texel, reflectionData, material.roughness, normal, viewDir, 1.0, NoiseRotated(BlueNoiseTemporal())).rgb;
			#endif
			sceneData += reflectionData.rgb * mix(vec3(1.0), albedo, material.isMetal);
		}
	} else {
		sceneData = texelFetch(colortex4, texel, 0).rgb;
	}

	//if (materialMask.basic) sceneData = albedo * 4.0;

	float fogDist = length(viewPos);
	//float fogDist = length(ScreenToViewSpace(vec3(refractCoord, GetDepthT(refractTexel))));

	if (isEyeInWater == 1) UnderwaterFog(sceneData, materialMaskT, fogDist);
	if (isEyeInWater == 0 && depthT < 1.0) {
		#ifdef LAND_ATMOSPHERIC_SCATTERING
			LandAtmosphericScattering(sceneData, fogDist * eyeSkylightFix, worldDir);
		#elif !defined BORDER_FOG
			float density = fogDist * eyeSkylightFix * mix(0.0015, 0.004, wetness);

			sceneData *= expf(-density);
			sceneData += colorSkylight * (1.6 - wetness) * density;
		#endif

		#ifdef BORDER_FOG
			float dist = fogDist * eyeSkylightFix / far;
			float density = 1.0 - exp2(-pow5(dist) * 5.0);
			density *= oneMinus(saturate(worldDir.y * 3.0));

			sceneData = mix(sceneData, SkyShading(worldDir), saturate(density));
			//sceneData = mix(sceneData, Atmosphere(worldDir, worldSunVector, 1.0, AtmosphereExtent), saturate(density));
		#endif
	}

	#if defined VOLUMETRIC_FOG || defined VOLUMETRIC_LIGHT || defined UW_VOLUMETRIC_LIGHT
		vec4 VFData = BilateralUpscale(colortex1, gl_FragCoord.xy, GetDepthLinear(depthT), ivec2(1), ivec2(screenSize * 0.5) - 1);

		sceneData *= VFData.a;
		sceneData += VFData.rgb;

		fogTransmittance = saturate(VFData.a + timeMidnight * 0.2);
		#if FOG_TYPE == 3
			fogTransmittance = fogTransmittance * 0.3 + 0.7;
		#endif
	#endif
	/*
	#ifdef RAIN_SPARKLE
		float rainAlpha = texelFetch(colortex1, texel, 0).b * wetnessCustom;
		if (isEyeInWater == 0 && rainAlpha - weatherSnowySmooth > 5e-3) Rain(sceneData, worldDir, rainAlpha);
	#endif
	*/
	CommonFog(sceneData, fogDist);

	#if DEBUG_NORMAL == 0
		sceneData = clamp16F(sceneData);
	#elif DEBUG_NORMAL == 1
		sceneData = normal;
	#else
		sceneData = mat3(gbufferModelViewInverse) * normal;
	#endif
}

/* DRAWBUFFERS:46 */
