// AgX Minimal from https://www.shadertoy.com/view/lsSXW1

// Mean error^2: 3.6705141e-06
vec3 agxDefaultContrastApprox(vec3 x) {
    vec3 x2 = x * x;
    vec3 x4 = x2 * x2;

    return  + 15.5     * x4 * x2
            - 40.14    * x4 * x
            + 31.96    * x4
            - 6.868    * x2 * x
            + 0.4298   * x2
            + 0.1191   * x
            - 0.00232;
}

// vec3 agx(vec3 val) {
//     const mat3 agx_mat = mat3(
//         0.842479062253094, 0.0423282422610123, 0.0423756549057051,
//         0.0784335999999992,  0.878468636469772,  0.0784336,
//         0.0792237451477643, 0.0791661274605434, 0.879142973793104);
        
//     //const float min_ev = -12.47393f;
//     //const float max_ev = 4.026069f;
//     const float min_ev = -8.0;
//     const float max_ev = 6.0;

//     // Input transform
//     val = agx_mat * val * 7.0;

//     // Log2 space encoding
//     val = clamp(log2(val), min_ev, max_ev);
//     val = (val - min_ev) / (max_ev - min_ev);

//     // Apply sigmoid function approximation
//     val = agxDefaultContrastApprox(val);

//     return val;
// }

// vec3 agxEotf(vec3 val) {
//     const mat3 agx_mat_inv = mat3(
//         1.19687900512017, -0.0528968517574562, -0.0529716355144438,
//         -0.0980208811401368, 1.15190312990417, -0.0980434501171241,
//         -0.0990297440797205, -0.0989611768448433, 1.15107367264116);
        
//     // Undo input transform
//     val = agx_mat_inv * val;

//     // sRGB IEC 61966-2-1 2.2 Exponent Reference EOTF Display
//     //val = pow(val, vec3(2.2));
//     //val = SRGBtoLinear(val);

//     return val;
// }

// vec3 agxLook(vec3 val) {
//     float luma = GetLuminance(val);

//     // Default
//     vec3 offset = vec3(0.0);
 
//     #if AGX_LOOK == 1
//         // Golden
//         vec3 slope = vec3(1.0, 0.9, 0.5);
//         vec3 power = vec3(0.8);
//         float sat = 0.8;
//     #elif AGX_LOOK == 2
//     // Punchy
//         vec3 slope = vec3(1.0);
//         vec3 power = vec3(1.35, 1.35, 1.35);
//         float sat = 1.4;
//     #else
//     // Default
//         vec3 slope = vec3(1.0);
//         vec3 power = vec3(1.0);
//         float sat = 1.0;
//     #endif

//     // ASC CDL
//     val = pow(val * slope + offset, power);
//     val = luma + sat * (val - luma);
// }

vec3 AgX_Minimal(vec3 val) {
    const mat3 agx_mat = mat3(
        0.842479062253094, 0.0423282422610123, 0.0423756549057051,
        0.0784335999999992,  0.878468636469772,  0.0784336,
        0.0792237451477643, 0.0791661274605434, 0.879142973793104);

    //const float min_ev = -12.47393f;
    //const float max_ev = 4.026069f;
    const float min_ev = -8.0;
    const float max_ev = 6.0;

    // Input transform
    val = agx_mat * val * 7.0;

    // Log2 space encoding
    val = clamp(log2(val), min_ev, max_ev);
    val = (val - min_ev) / (max_ev - min_ev);

    // Apply sigmoid function approximation
    val = agxDefaultContrastApprox(val);

    //const vec3 lw = vec3(0.2126, 0.7152, 0.0722);
    //float luma = dot(val, lw);
    //float luma = GetLuminance(val);

	#ifdef COLOR_GRADING
		val = saturate(CONTRAST * (val * BRIGHTNESS - 0.5) + 0.5);
		val = pow(val, vec3(rcp(GAMMA)));
		val = ColorSaturation(val, SATURATION);
		#if WHITE_BALANCE != 6500
			val *= WhiteBalanceMatrix();
		#endif
	#endif

    const mat3 agx_mat_inv = mat3(
        1.19687900512017, -0.0528968517574562, -0.0529716355144438,
        -0.0980208811401368, 1.15190312990417, -0.0980434501171241,
        -0.0990297440797205, -0.0989611768448433, 1.15107367264116
    );

    // Undo input transform
    return agx_mat_inv * val;
}
